/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventory;

import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.DefaultDataHandler;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.services.interfaces.weeklyplan.WeeklyPlanServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.UnitToolkit;
import ch.icit.pegasus.server.core.calculator.IBasicArticle;
import ch.icit.pegasus.server.core.calculator.UnitCalculator;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCheckinRemarkComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryRemarkComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.CurrencyComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.ProductChargeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.charges.RecipeChargeComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductCountTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.ProductionTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.RecipeCountTransactionComplete_;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.ProductCountTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.production_new.transactions.corrections.RecipeCountTransactionCorrectionComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeComplete;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeLight;
import ch.icit.pegasus.server.core.dtos.store.ArticleChargeReference;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.transaction.StockInventoryComplete_;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InventoryModuleDataHandler
extends DefaultDataHandler<InventoryReference, InventoryComplete> {
    public InventoryModuleDataHandler(long id, ScreenTableView tableView) {
        super(id, tableView);
    }

    @Override
    public String getRemoteValidationText() {
        return null;
    }

    @Override
    public void updateData(final Node<InventoryReference> node, final RemoteLoader model, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryComplete nDto;
                ProductCountTransactionCorrectionComplete icc;
                ProductChargeComplete productCharge;
                ProductComplete product;
                StoreQuantityComplete newa;
                Node oldAmount;
                Object n;
                Iterator it;
                ArrayList<Object> s;
                InventoryComplete dto = (InventoryComplete)node.getValue(InventoryComplete.class);
                Node cc = node.getChildNamed(new String[]{"changedCounts"});
                if (cc != null) {
                    s = new ArrayList<Object>();
                    it = cc.getChilds();
                    while (it.hasNext()) {
                        n = (Node)it.next();
                        Node node2 = n.getChildNamed(new String[]{"newAmount"});
                        oldAmount = n.getChildNamed(StockInventoryComplete_.amount);
                        if (node2 == null) continue;
                        BasicArticleComplete artC = (BasicArticleComplete)n.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class);
                        StoreQuantityComplete olda = (StoreQuantityComplete)oldAmount.getValue();
                        newa = (StoreQuantityComplete)node2.getValue();
                        ArticleChargeLight charge = (ArticleChargeLight)n.getChildNamed(new String[]{"charge"}).getValue(ArticleChargeLight.class);
                        List conversion = UnitCalculator.getArticlePackagingQuantities((IBasicArticle)artC, (Timestamp)charge.getCreationDate());
                        StoreQuantityComplete diff = (StoreQuantityComplete)UnitCalculator.subtractQuantitiesNormal((IBasicArticle)artC, (Object)newa, (List)conversion, (Object)olda, (List)conversion);
                        InventoryCorrectionComplete icc2 = new InventoryCorrectionComplete();
                        icc2.setInventory((InventoryReference)dto);
                        icc2.setAmount((StoreQuantityComplete)node2.getValue());
                        icc2.setArticle((BasicArticleLight)artC);
                        icc2.setCharge(charge);
                        icc2.setDelta(diff);
                        icc2.setClientOId(Long.valueOf(ADTO.getNextId()));
                        icc2.setCorrectStock((Boolean)n.getChildNamed(new String[]{"changeStore"}).getValue());
                        icc2.setRemark((InventoryRemarkComplete)n.getChildNamed(new String[]{"nremark"}).getValue());
                        icc2.setStorePosition((StorePositionLight)n.getChildNamed(new String[]{"storePosition"}).getValue());
                        s.add(icc2);
                    }
                    n = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).correct(s, true, true);
                }
                if ((cc = node.getChildNamed(new String[]{"changedPrices"})) != null) {
                    Iterator it2 = cc.getChilds();
                    while (it2.hasNext()) {
                        Node n2 = (Node)it2.next();
                        Node np = n2.getChildNamed(new String[]{"newprice"});
                        Node node3 = n2.getChildNamed(new String[]{"newpriceunit"});
                        Node cop = n2.getChildNamed(new String[]{"changeorder"});
                        if (np != null) {
                            n2.getChildNamed(new String[]{"charge-price"}).setValue(np.getValue(), 0L);
                        }
                        if (node3 != null) {
                            n2.getChildNamed(new String[]{"charge-priceUnit"}).setValue(node3.getValue(), 0L);
                        }
                        n2.getChildNamed(new String[]{"charge"}).commit(ArticleChargeLight.class);
                        ArticleChargeLight chargeL = (ArticleChargeLight)n2.getChildNamed(new String[]{"charge"}).getValue(ArticleChargeLight.class);
                        if (np != null) {
                            chargeL.setPrice((PriceComplete)np.getValue());
                        }
                        if (node3 != null) {
                            chargeL.setPriceUnit((UnitComplete)node3.getValue());
                        }
                        boolean updateOrderPosition = false;
                        if (cop != null && ((Boolean)cop.getValue()).booleanValue()) {
                            updateOrderPosition = true;
                        }
                        ArticleChargeComplete chargeC = (ArticleChargeComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getCharge(new ArticleChargeReference(chargeL.getId())).getValue();
                        chargeC.setPrice(chargeL.getPrice());
                        chargeC.setPriceUnit(chargeL.getPriceUnit());
                        ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateCharge(chargeC, updateOrderPosition);
                    }
                }
                if ((cc = node.getChildNamed(DtoFieldConstants.CHANGED_COUNTS_PRODUCT)) != null) {
                    s = new ArrayList();
                    it = cc.getChilds();
                    while (it.hasNext()) {
                        n = (Node)it.next();
                        Node node4 = n.getChildNamed(new String[]{"newAmount"});
                        oldAmount = n.getChildNamed(ProductCountTransactionComplete_.quantity);
                        if (node4 == null) continue;
                        product = (ProductComplete)n.getChildNamed(ProductCountTransactionComplete_.product).getValue(ProductComplete.class);
                        StoreQuantityComplete olda = (StoreQuantityComplete)oldAmount.getValue();
                        newa = (StoreQuantityComplete)node4.getValue();
                        productCharge = (ProductChargeComplete)n.getChildNamed(ProductCountTransactionComplete_.productCharge).getValue(ProductChargeComplete.class);
                        icc = new ProductCountTransactionCorrectionComplete();
                        icc.setInventory((InventoryReference)dto);
                        icc.setQuantity(new StoreQuantityComplete(newa));
                        icc.setProduct(product);
                        icc.setProductCharge(productCharge);
                        icc.setDeltaQty(Long.valueOf(newa.getAmount() - olda.getAmount()));
                        icc.setDeltaUnit(newa.getUnit());
                        icc.setClientOId(Long.valueOf(ADTO.getNextId()));
                        icc.setReferencedTransaction((ProductionTransactionComplete)n.getValue(ProductCountTransactionComplete.class));
                        icc.setCorrectStock((Boolean)n.getChildNamed(DtoFieldConstants.CHANGE_STORE).getValue());
                        icc.setOriginStore((StorePositionLight)n.getChildNamed(ProductCountTransactionComplete_.originStore).getValue());
                        s.add(icc);
                    }
                    for (ProductCountTransactionCorrectionComplete productCountTransactionCorrectionComplete : s) {
                        ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).correctCountProductChargeBased(productCountTransactionCorrectionComplete);
                    }
                }
                if ((cc = node.getChildNamed(DtoFieldConstants.CHANGED_COUNTS_RECIPE)) != null) {
                    s = new ArrayList();
                    it = cc.getChilds();
                    while (it.hasNext()) {
                        n = (Node)it.next();
                        Node node5 = n.getChildNamed(new String[]{"newAmount"});
                        oldAmount = n.getChildNamed(RecipeCountTransactionComplete_.quantity);
                        if (node5 == null) continue;
                        product = (RecipeComplete)n.getChildNamed(RecipeCountTransactionComplete_.recipe).getValue(RecipeComplete.class);
                        StoreQuantityComplete olda = (StoreQuantityComplete)oldAmount.getValue();
                        newa = (StoreQuantityComplete)node5.getValue();
                        productCharge = (RecipeChargeComplete)n.getChildNamed(RecipeCountTransactionComplete_.recipeCharge).getValue(RecipeChargeComplete.class);
                        icc = new RecipeCountTransactionCorrectionComplete();
                        icc.setInventory((InventoryReference)dto);
                        icc.setQuantity(new StoreQuantityComplete(newa));
                        icc.setRecipe((RecipeComplete)product);
                        icc.setRecipeCharge((RecipeChargeComplete)productCharge);
                        icc.setDeltaQty(Long.valueOf(newa.getAmount() - olda.getAmount()));
                        icc.setDeltaUnit(newa.getUnit());
                        icc.setClientOId(Long.valueOf(ADTO.getNextId()));
                        icc.setCorrectStock((Boolean)n.getChildNamed(DtoFieldConstants.CHANGE_STORE).getValue());
                        icc.setReferencedTransaction((ProductionTransactionComplete)n.getValue(RecipeCountTransactionComplete.class));
                        icc.setOriginStore((StorePositionLight)n.getChildNamed(RecipeCountTransactionComplete_.originStore).getValue());
                        s.add(icc);
                    }
                    for (RecipeCountTransactionCorrectionComplete recipeCountTransactionCorrectionComplete : s) {
                        ((WeeklyPlanServiceManager)ServiceManagerRegistry.getService(WeeklyPlanServiceManager.class)).correctCountRecipeChargeBased(recipeCountTransactionCorrectionComplete);
                    }
                }
                if ((nDto = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).updateInventory(dto).getValue()) != null) {
                    node.removeExistingValues();
                    node.setValue((Object)nDto, System.currentTimeMillis());
                    node.updateNode();
                }
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void createNewData(final Node<InventoryComplete> node, final RemoteLoader model, boolean sameNode, ProgressListener l) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryComplete dto = (InventoryComplete)node.getValue();
                if (dto.getEligibleLocations().isEmpty()) {
                    dto.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                }
                InventoryComplete nDto = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).createInventory(dto).getValue();
                node.removeExistingValues();
                node.setValue((Object)nDto, System.currentTimeMillis());
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void loadMasterData(final long id, RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryModuleDataHandler.this.setCurrentLoadMaximum(7);
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InventoryCheckinRemarkComplete.class);
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InventoryRemarkComplete.class);
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CurrencyComplete.class);
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllSuperArticleCategoriesCached();
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                StaticEnumServiceManager.getAllBondedStates();
                InventoryModuleDataHandler.this.showNextMessage(progressListener);
                UnitToolkit.loadUnits();
                return new Node();
            }

            @Override
            public RemoteLoader getInvoker() {
                return InventoryModuleDataHandler.this.model;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node<InventoryComplete> resetData(Node<InventoryComplete> node) {
        return this.createEmptyNode();
    }

    @Override
    public Node<InventoryComplete> createEmptyNode() {
        InventoryComplete dto = new InventoryComplete();
        dto.setClientOId(Long.valueOf(ADTO.getNextId()));
        dto.setInventoryDate(new Date(System.currentTimeMillis()));
        dto.setInventoryTime(new Time(System.currentTimeMillis()));
        Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)dto, false, false);
        return n;
    }

    @Override
    public boolean reloadDataBeforeOpening(final Node node, final RemoteLoader listener, ProgressListener pListener) {
        this.showMessage(pListener, Words.LOAD_DATA);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                InventoryLight inven = (InventoryLight)node.getValue(InventoryLight.class);
                InventoryComplete ninven = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(new InventoryReference(inven.getId())).getValue();
                node.removeExistingValues();
                node.setValue((Object)ninven, 0L);
                node.updateNode();
                return node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
        return true;
    }

    @Override
    public Class<InventoryComplete> getCommittingClass() {
        return InventoryComplete.class;
    }

    @Override
    public void doRemoteValidation(Node<InventoryReference> node, RemoteLoader listener, ProgressListener l, boolean validateAll) {
    }
}

