/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.inventorytransition;

import ch.icit.pegasus.client.converter.DateAndTimeConverter;
import ch.icit.pegasus.client.converter.IntegerConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.inventorytransition.InventoryTransitionModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.inventorytransition.details.BoundsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventorytransition.details.FileBrowserDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventorytransition.details.FilterSpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.modules.inventorytransition.details.SpecificationDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.InventoryTransitionSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight_;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.SubModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryTransitionAccess;
import ch.icit.pegasus.server.core.dtos.search.InventorySearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.InventoryTransitionSearchConfiguration;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class InventoryTransitionModule
extends ScreenTableView<InventoryTransitionLight, InventoryTransitionSearchConfiguration.INVENTORY_TRANSITION_COLUMN> {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_NAME_NO = "name_no";
    private static final String FILTER_PERIOD = "period";
    private TitledPeriodEditor periodChooser;
    private String filterCriteria1 = null;
    private TitledPeriodEditor filterCriteria3 = null;

    public InventoryTransitionModule() {
        super(InventoryTransitionLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.periodChooser != null) {
            this.periodChooser.kill();
        }
        if (this.filterCriteria3 != null) {
            this.filterCriteria3.kill();
        }
        this.periodChooser = null;
        this.filterCriteria3 = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return InventoryTransitionAccess.MODULE_INVENTORY_TRANSITION;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", InventorySearchConfiguration.INVENTORY_COLUMN.NO + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.filterChain.addSearchField(FILTER_NAME_NO, Words.NUMBER_OR_NAME, "");
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodChooser = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), Words.PERIOD, false);
        this.periodChooser.setCheckBoxEnabled();
        this.filterChain.addResetButton();
    }

    @Override
    public ASearchConfiguration<InventoryTransitionLight, InventoryTransitionSearchConfiguration.INVENTORY_TRANSITION_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria3 = null;
            this.periodChooser.setCheckBoxChecked(false);
        } else if (name == FILTER_NAME_NO) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_PERIOD) {
            TitledPeriodEditor p;
            this.filterCriteria3 = p = (TitledPeriodEditor)value;
        }
        InventoryTransitionSearchConfiguration c = new InventoryTransitionSearchConfiguration();
        if (this.filterCriteria3 != null) {
            c.setPeriod(new PeriodComplete(this.filterCriteria3.getStartDate(), this.filterCriteria3.getEndDate()));
        }
        try {
            int a = Integer.valueOf(this.filterCriteria1);
            c.setNumber(Integer.valueOf(a));
            c.setName(this.filterCriteria1);
        }
        catch (NumberFormatException e) {
            c.setName(this.filterCriteria1);
            c.setNumber(null);
        }
        c.setNumResults(this.numberOfShownResults);
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        return c;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<InventoryTransitionLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(InventoryTransitionSearchAlgorithm.class);
    }

    @Override
    public boolean isAnalysisModuleAllowed(SubModuleAccessRightComplete subModule) {
        return super.isAnalysisModuleAllowed(subModule);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<InventoryTransitionLight> model) {
        return model != null;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<InventoryTransitionLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<InventoryTransitionLight> rowEditor = new MessageProvidedRowEditor<InventoryTransitionLight>(model, "");
            RDProvider p = this.createProvider(model.isAddRow());
            CombinedDetailsParagraph c1 = new CombinedDetailsParagraph();
            SpecificationDetailsPanel d1 = new SpecificationDetailsPanel((RowEditor<InventoryTransitionLight>)rowEditor, p);
            FilterSpecificationDetailsPanel d11 = new FilterSpecificationDetailsPanel((RowEditor<InventoryTransitionLight>)rowEditor, p);
            FileBrowserDetailsPanel d2 = new FileBrowserDetailsPanel((RowEditor<InventoryTransitionLight>)rowEditor, p);
            CombinedDetailsParagraph c2 = new CombinedDetailsParagraph();
            BoundsDetailsPanel d3 = new BoundsDetailsPanel(rowEditor, p, InventoryTransitionComplete_.startInventories, "Start Inventories");
            BoundsDetailsPanel d4 = new BoundsDetailsPanel(rowEditor, p, InventoryTransitionComplete_.endInventories, "End Inventories");
            c1.add((Component)d1, new TableLayoutConstraint(0, 0, 0.4, 1.0));
            c1.add((Component)d11, new TableLayoutConstraint(1, 0, 0.3, 1.0));
            c1.add((Component)d2, new TableLayoutConstraint(2, 0, 0.3, 1.0));
            c2.add((Component)d3, new TableLayoutConstraint(0, 0, 0.5, 1.0));
            c2.add((Component)d4, new TableLayoutConstraint(1, 0, 0.5, 1.0));
            rowEditor.add(c1, (Object)new TableLayoutConstraint(0, 0, 1.0, 0.0));
            rowEditor.add(c2, (Object)new TableLayoutConstraint(0, 1, 1.0, 0.0));
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d11);
            rowEditor.addToFocusQueue(d2);
            rowEditor.addToFocusQueue(d3);
            rowEditor.addToFocusQueue(d4);
            rowEditor.allInstalled();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new InventoryTransitionModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.NO_NUMBER, "", (Class)IntegerConverter.class, (Enum<?>)InventoryTransitionSearchConfiguration.INVENTORY_TRANSITION_COLUMN.NO, InventoryTransitionLight_.number, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth, TableColumnInfo.numberColumnWidth));
        columns.add(new TableColumnInfo(Words.NAME, "", (Class)StringConverter.class, (Enum<?>)InventoryTransitionSearchConfiguration.INVENTORY_TRANSITION_COLUMN.NAME, InventoryTransitionLight_.name, 35, Integer.MAX_VALUE, 55));
        int tw = TableColumnInfo.dateTimeColumnWidth + 35;
        columns.add(new TableColumnInfo(Words.DATE, "", (Class)DateAndTimeConverter.class, (Enum<?>)InventoryTransitionSearchConfiguration.INVENTORY_TRANSITION_COLUMN.DATE, InventoryTransitionLight_.date, tw, tw, tw));
        columns.add(new TableColumnInfo(Words.DESCRIPTION, "", DateAndTimeConverter.class, null, InventoryTransitionLight_.description, 80, Integer.MAX_VALUE, 80));
        return columns;
    }
}

