/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.invoice.creator.details;

import ch.icit.pegasus.client.gui.breadcrumb.BreadCrumbPanel;
import ch.icit.pegasus.client.gui.modules.invoice.creator.details.utils.InvoiceBreadCrumpPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitScreenView;
import ch.icit.pegasus.client.gui.screentemplates.splitscreen.SplitView;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.ListNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceComplete;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceLight_;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.Iterator;
import java.util.List;

public class InvoiceDetailsPanel
extends SplitView {
    private static final long serialVersionUID = 1L;
    private BreadCrumbPanel breadCrumb;
    private SplitScreenView view;

    public InvoiceDetailsPanel(SplitScreenView view, IDataHandler dataHandler) {
        this.view = view;
        this.breadCrumb = new InvoiceBreadCrumpPanel(dataHandler, view);
        this.breadCrumb.setNode(view.getSplitView2List());
        this.setLayout(new Layout());
        this.add(this.breadCrumb);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.breadCrumb.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.breadCrumb.kill();
        this.breadCrumb = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        return this.breadCrumb.getFocusComponents();
    }

    @Override
    public void resetData() {
        this.breadCrumb.getNode().removeAllChilds();
    }

    public void addInvoiceItems(Node node, CustomerLight customer, PeriodComplete periodComplete) {
        CustomerLight cl = customer;
        Node gn = this.getInvoiceNode(cl);
        if (gn == null) {
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            Date invoiceDate = Boolean.TRUE.equals(settings.getUseToadyForDefaultInvoiceDate()) ? new Date(System.currentTimeMillis()) : new Date(periodComplete.getEndDate().getTime());
            InvoiceComplete i = new InvoiceComplete();
            i.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
            i.setClientOId(Long.valueOf(ADTO.getNextId()));
            i.setCustomer(cl);
            i.setExcludeVAT(cl.getExcludeVAT());
            i.setInvoiceDate(invoiceDate);
            i.setPeriod(periodComplete);
            i.setState(InvoiceStateE.PLANNED);
            gn = INodeCreator.getDefaultImpl().getNode4DTO((Object)i, true, false);
            this.view.getSplitView2List().addChild(gn, 0L);
        }
        if (gn.getChildNamed(new String[]{"invoiceItems"}) == null) {
            ListNode nii = new ListNode();
            nii.setName("invoiceItems");
            gn.addChild((Node)nii, 0L);
        }
        gn.getChildNamed(new String[]{"invoiceItems"}).addChild(node, 0L);
    }

    private Node getInvoiceNode(CustomerLight cl) {
        Iterator it = this.view.getSplitView2List().getFailSafeChildIterator();
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (!cl.equals(n.getChildNamed(InvoiceLight_.customer).getValue())) continue;
            return n;
        }
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 350);
        }

        @Override
        public void layoutContainer(Container parent) {
            InvoiceDetailsPanel.this.breadCrumb.setLocation(1, 1);
            InvoiceDetailsPanel.this.breadCrumb.setSize(parent.getWidth() - 2, parent.getHeight() - 2);
        }
    }
}

