/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.login.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.panels.LoadingAnimation;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.textfield.PasswordTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.InfoBox;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionType;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PasswordSecurityLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.PasswordSecurityToolkit;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.List;

public class PasswordPromptInsert
extends PopUpInsert
implements RemoteLoader {
    private static final long serialVersionUID = 1L;
    private MultiLineTextLabel text;
    private TitledItem<TextField> oldPassword;
    private TitledItem<TextField> newPassword1;
    private TitledItem<TextField> newPassword2;
    private UserComplete user;
    private boolean useBack;
    private LoadingAnimation animation;
    private boolean isLogin;
    private boolean isChanged = false;
    private boolean wasError = false;
    private String errorMSG;

    public PasswordPromptInsert(final UserComplete user, final boolean isLogin) {
        this.border = 10;
        this.isLogin = isLogin;
        if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) != null) {
            this.insertComponents(user, isLogin);
        } else {
            this.ensureAnimation();
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                    return null;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            PasswordPromptInsert.this.hideAnimation(null);
                            PasswordPromptInsert.this.insertComponents(user, isLogin);
                        }

                        public void errorOccurred(ClientException exception) {
                            PasswordPromptInsert.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        }
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        if (this.popup != null) {
            this.popup.rebuildFocusCycle();
        }
    }

    private void insertComponents(UserComplete user, boolean isLogin) {
        this.text = new MultiLineTextLabel();
        this.text.setText(this.createString(user, isLogin));
        this.user = user;
        String pw = Words.OLD_PASSWORD;
        if (!user.equals((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser())) {
            pw = Words.YOUR_PASSWORD;
        }
        this.oldPassword = new TitledItem<PasswordTextField>(new PasswordTextField(), pw, TitledItem.TitledItemOrientation.WEST);
        this.newPassword1 = new TitledItem<PasswordTextField>(new PasswordTextField(), Words.NEW_PASSWORD, TitledItem.TitledItemOrientation.WEST);
        this.newPassword2 = new TitledItem<PasswordTextField>(new PasswordTextField(), Words.NEW_PASSWORD, TitledItem.TitledItemOrientation.WEST);
        this.oldPassword.setIgnorePrefWidth(true);
        this.newPassword1.setIgnorePrefWidth(true);
        this.newPassword2.setIgnorePrefWidth(true);
        this.newPassword1.getElement().setText("");
        this.newPassword2.getElement().setText("");
        this.setLayout(new Layout());
        this.add(this.text);
        this.add(this.oldPassword);
        this.add(this.newPassword1);
        this.add(this.newPassword2);
        if (this.popup != null) {
            this.popup.rebuildFocusCycle();
        }
    }

    private void showMessage(String t) {
        this.text.setText(t);
        this.text.setVisible(true);
        this.oldPassword.setVisible(false);
        this.newPassword1.setVisible(false);
        this.newPassword2.setVisible(false);
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    private void ensureAnimation() {
        if (this.animation == null) {
            this.animation = new LoadingAnimation();
            this.animation.stateChanged(Words.CHANGE_PASSWORD);
            this.add(this.animation);
            this.animation.start();
            this.animation.fadeIn();
        }
        if (this.oldPassword != null) {
            this.oldPassword.setVisible(false);
            this.text.setVisible(false);
            this.newPassword1.setVisible(false);
            this.newPassword2.setVisible(false);
        }
    }

    private void hideAnimation(String textToShow) {
        if (this.animation != null) {
            this.animation.fadeOut(false);
            this.animation = null;
        }
        if (textToShow != null) {
            this.text.setText(textToShow);
            this.text.setVisible(true);
        }
    }

    private String createString(UserComplete user, boolean isLogin) {
        if (isLogin) {
            String t = "<html><b>Welcome ";
            if (user.getContact().getFirstName() != null && user.getContact().getLastName() != null) {
                t = t + user.getContact().getFirstName() + " " + user.getContact().getLastName();
            }
            t = t + "</b><br/>";
            t = t + "Your password has been expired. Please choose a new one.<html>";
            return t;
        }
        String t = "<html>Please enter your current password and choose a new one.<html>";
        return t;
    }

    @Override
    public void enterPressed(PopupAction isOK) {
        if (this.useBack) {
            this.useBack = false;
            this.popup.setOkButtonText(Words.OK);
            this.popup.enableCancelButton(true);
            this.text.setText(this.createString(this.user, this.isLogin));
            this.oldPassword.setVisible(true);
            this.newPassword1.setVisible(true);
            this.newPassword2.setVisible(true);
            this.oldPassword.setEnabled(true);
            this.newPassword1.setEnabled(true);
            this.newPassword2.setEnabled(true);
        } else if (this.isChanged) {
            super.enterPressed(isOK);
        } else if (this.validateContent()) {
            this.ensureAnimation();
            this.changePassword();
        } else {
            this.showMessage(this.createPasswordErrorText());
            this.useBack = true;
            this.popup.setOkButtonText(Words.BACK);
        }
    }

    private String createPasswordErrorText() {
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        PasswordSecurityLevelComplete l = s.getSecurityLevel();
        String t = "<html>";
        t = t + this.errorMSG;
        t = t + "</html>";
        return t;
    }

    private void changePassword() {
        this.popup.enableOKButton(false);
        this.popup.enableCancelButton(false);
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).changePassword((UserReference)PasswordPromptInsert.this.user, ((TextField)PasswordPromptInsert.this.oldPassword.getElement()).getText(), ((TextField)PasswordPromptInsert.this.newPassword1.getElement()).getText());
                if (PasswordPromptInsert.this.user.equals((Object)((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser())) {
                    try {
                        ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).logout();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    InfoBox infobox = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).authenticateUser(PasswordPromptInsert.this.user.getUserName(), ((TextField)PasswordPromptInsert.this.newPassword1.getElement()).getText());
                    PasswordPromptInsert.this.user = infobox.getUser();
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PasswordPromptInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.oldPassword != null) {
            this.text.kill();
            this.oldPassword.kill();
            this.newPassword1.kill();
            this.newPassword2.kill();
        }
        this.text = null;
        this.oldPassword = null;
        this.newPassword1 = null;
        this.newPassword2 = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        if (this.oldPassword == null) {
            return null;
        }
        List<Component> a = this.oldPassword.getFocusComponents();
        a.addAll(this.newPassword1.getFocusComponents());
        a.addAll(this.newPassword2.getFocusComponents());
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return true;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        Object[] o = new Object[]{this.user, this.oldPassword.getElement().getText(), this.newPassword1.getElement().getText(), this.newPassword2.getElement().getText()};
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean validateContent() {
        if (this.newPassword1.getElement().getText().equals(this.newPassword2.getElement().getText())) {
            if (NodeToolkit.getAffixClass(SystemSettingsComplete.class) == null) return false;
            SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (PasswordSecurityToolkit.validatePasswordRules((String)this.newPassword1.getElement().getText(), (SystemSettingsComplete)s)) {
                if (!this.oldPassword.getElement().getText().equals(this.newPassword1.getElement().getText())) {
                    return true;
                }
                this.errorMSG = Words.NEW_PASSWORD_MUST_DIFFER_FROM_OLD_PASSWORD;
                return false;
            } else {
                String t;
                if (Boolean.TRUE.equals(this.user.getMobileUser()) || Boolean.TRUE.equals(this.user.getDriverUser())) return true;
                this.errorMSG = t = Phrase.getPhrase((String)Words.YOUR_PASSWORD_IS_NOT_STRONG_ENOUGHT, (Object[])new Object[]{s.getSecurityLevel().getMinChars()});
            }
            return false;
        } else {
            this.errorMSG = Words.PLEASE_ENSURE_PASSWORDS_ARE_EQUALS;
        }
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        String textToShow = Words.PASSWORD_SUCCESSFULLY_CHANGED;
        this.isChanged = true;
        this.popup.enableCancelButton(true);
        this.popup.enableOKButton(true);
        this.hideAnimation(textToShow);
    }

    @Override
    public void errorOccurred(ClientException exception) {
        String textToShow = Words.PASSWORD_IS_WRONG;
        if (exception.getSate() == ClientExceptionType.INVALID_LOGIN) {
            textToShow = Words.PASSWORD_IS_WRONG;
        }
        if (exception.getSate() == ClientExceptionType.INVALID_CERTIFICATE) {
            textToShow = Words.PASSWORD_IS_WRONG;
        }
        this.popup.setOkButtonText(Words.BACK);
        this.useBack = true;
        this.popup.enableCancelButton(true);
        this.popup.enableOKButton(true);
        this.hideAnimation(textToShow);
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PasswordPromptInsert.this.border;
            h = (int)((double)h + PasswordPromptInsert.this.text.getPreferredSize().getHeight());
            h += PasswordPromptInsert.this.border;
            h = (int)((double)h + PasswordPromptInsert.this.oldPassword.getPreferredSize().getHeight());
            h += PasswordPromptInsert.this.border;
            h = (int)((double)h + PasswordPromptInsert.this.newPassword1.getPreferredSize().getHeight());
            h += PasswordPromptInsert.this.border;
            h = (int)((double)h + PasswordPromptInsert.this.newPassword2.getPreferredSize().getHeight());
            return new Dimension(250, h += PasswordPromptInsert.this.border);
        }

        @Override
        public void layoutContainer(Container parent) {
            if (PasswordPromptInsert.this.animation != null) {
                PasswordPromptInsert.this.animation.setLocation((int)(((double)parent.getWidth() - PasswordPromptInsert.this.animation.getPreferredSize().getWidth()) / 2.0), (int)((double)parent.getHeight() - PasswordPromptInsert.this.animation.getPreferredSize().getHeight()) / 2);
                PasswordPromptInsert.this.animation.setSize(PasswordPromptInsert.this.animation.getPreferredSize());
            }
            PasswordPromptInsert.this.text.setLocation(PasswordPromptInsert.this.border, PasswordPromptInsert.this.border);
            PasswordPromptInsert.this.text.setSize(parent.getWidth() - 2 * PasswordPromptInsert.this.border, (int)PasswordPromptInsert.this.text.getPreferredSize().getHeight());
            PasswordPromptInsert.this.oldPassword.setLocation(PasswordPromptInsert.this.border, PasswordPromptInsert.this.text.getY() + PasswordPromptInsert.this.text.getHeight() + PasswordPromptInsert.this.border);
            PasswordPromptInsert.this.oldPassword.setSize(parent.getWidth() - 2 * PasswordPromptInsert.this.border, (int)PasswordPromptInsert.this.oldPassword.getPreferredSize().getHeight());
            PasswordPromptInsert.this.newPassword1.setLocation(PasswordPromptInsert.this.border, PasswordPromptInsert.this.oldPassword.getY() + PasswordPromptInsert.this.oldPassword.getHeight() + PasswordPromptInsert.this.border);
            PasswordPromptInsert.this.newPassword1.setSize(parent.getWidth() - 2 * PasswordPromptInsert.this.border, (int)PasswordPromptInsert.this.newPassword1.getPreferredSize().getHeight());
            PasswordPromptInsert.this.newPassword2.setLocation(PasswordPromptInsert.this.border, PasswordPromptInsert.this.newPassword1.getY() + PasswordPromptInsert.this.newPassword1.getHeight() + PasswordPromptInsert.this.border);
            PasswordPromptInsert.this.newPassword2.setSize(parent.getWidth() - 2 * PasswordPromptInsert.this.border, (int)PasswordPromptInsert.this.newPassword2.getPreferredSize().getHeight());
        }
    }
}

