/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.tables.ManMinutesOverflowTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete_;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete_;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class ExternalCostCenterConfig
extends MasterDataInsert<ExternalCostCenterComplete> {
    private static final long serialVersionUID = 1L;

    public ExternalCostCenterConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new CostCenterConfigPanel();
    }

    @Override
    public ExternalCostCenterComplete getNewObject() {
        ExternalCostCenterComplete a = new ExternalCostCenterComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends ExternalCostCenterComplete> getMasterDataClass() {
        return ExternalCostCenterComplete.class;
    }

    @Override
    public String getInsertName() {
        return "External Departments";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        boolean customerSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ExternalCostCenterComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(ExternalCostCenterComplete_.customer).getValue() == null) {
                customerSet = false;
            }
            if (n.getChildNamed(ExternalCostCenterComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ExternalCostCenterComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(ExternalCostCenterComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(ExternalCostCenterComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!descriptionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Descriptions are set"));
        }
        if (!customerSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Customers are set"));
        }
        return a;
    }

    private class CostCenterConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<SearchTextField2> customer;
        private TitledItem<TextField> notificationEMail;
        private ManMinutesOverflowTable manMinutesOverflow;

        public CostCenterConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.customer = new TitledItem<SearchTextField2<CustomerLight>>(SearchTextField2Factory.getCustomerSearchField(true, new DTOProxyNode()), "Customer", TitledItem.TitledItemOrientation.NORTH);
            this.notificationEMail = new TitledItem<TextField>(new TextField(null), "Notification EMail", TitledItem.TitledItemOrientation.NORTH);
            this.manMinutesOverflow = new ManMinutesOverflowTable();
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.customer);
            this.add(this.notificationEMail);
            this.add(this.manMinutesOverflow);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.customer.getFocusComponents());
            CheckedListAdder.addToList(a, this.notificationEMail);
            CheckedListAdder.addToList(a, this.manMinutesOverflow);
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.customer.setVisibleContainer(pane);
            this.manMinutesOverflow.setVisibleContainer(pane);
            this.notificationEMail.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.customer.kill();
            this.manMinutesOverflow.kill();
            this.notificationEMail.kill();
            this.notificationEMail = null;
            this.code = null;
            this.description = null;
            this.customer = null;
            this.manMinutesOverflow = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.customer.setEnabled(b);
            this.manMinutesOverflow.setEnabled(b);
            this.notificationEMail.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(ExternalCostCenterComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(ExternalCostCenterComplete_.description));
            this.customer.getElement().setNode(node.getChildNamed(ExternalCostCenterComplete_.customer));
            this.manMinutesOverflow.getModel().setNode(node.getChildNamed(CostCenterComplete_.manMinutesOverFlow));
            this.notificationEMail.getElement().setNode(node.getChildNamed(ExternalCostCenterComplete_.defaultMailAddress));
            this.setEnabled(true);
            ExternalCostCenterConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return ExternalCostCenterComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                CostCenterConfigPanel.this.code.setLocation(ExternalCostCenterConfig.this.masterDataTable.getCellPadding(), ExternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.code.setSize(200, (int)CostCenterConfigPanel.this.code.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.description.setLocation(ExternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.code.getY() + CostCenterConfigPanel.this.code.getHeight() + ExternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.description.setSize(200, (int)CostCenterConfigPanel.this.description.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.customer.setLocation(ExternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.description.getY() + CostCenterConfigPanel.this.description.getHeight() + ExternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.customer.setSize(200, (int)CostCenterConfigPanel.this.customer.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.notificationEMail.setLocation(ExternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.customer.getY() + CostCenterConfigPanel.this.customer.getHeight() + ExternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.notificationEMail.setSize(200, (int)CostCenterConfigPanel.this.notificationEMail.getPreferredSize().getHeight());
                CostCenterConfigPanel.this.manMinutesOverflow.setLocation(ExternalCostCenterConfig.this.masterDataTable.getCellPadding(), CostCenterConfigPanel.this.notificationEMail.getY() + CostCenterConfigPanel.this.notificationEMail.getHeight() + ExternalCostCenterConfig.this.masterDataTable.getCellPadding());
                CostCenterConfigPanel.this.manMinutesOverflow.setSize(400, 300);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

