/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightLevelComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.FlightLevelComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FlightLevelConfig
extends MasterDataInsert<FlightLevelComplete> {
    private static final long serialVersionUID = 1L;

    public FlightLevelConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public FlightLevelComplete getNewObject() {
        FlightLevelComplete c = new FlightLevelComplete();
        c.setClientOId(Long.valueOf(ADTO.getNextId()));
        return c;
    }

    @Override
    public Class<FlightLevelComplete> getMasterDataClass() {
        return FlightLevelComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Flight Level";
    }

    @Override
    public DetailsPanel getDetails() {
        return new FlightLevelDetailsPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean descriptionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(FlightLevelComplete_.description).getValue() == null) {
                descriptionSet = false;
            }
            if (n.getChildNamed(FlightLevelComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(FlightLevelComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(FlightLevelComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(FlightLevelComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Desciptions are set"));
        }
        return a;
    }

    private class FlightLevelDetailsPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;

        public FlightLevelDetailsPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.CODE), TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(), WordsToolkit.toCapitalLetter((String)Words.DESCRIPTION), TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.description);
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.code.getElement().setNode(n.getChildNamed(FlightLevelComplete_.code));
            this.description.getElement().setNode(n.getChildNamed(FlightLevelComplete_.description));
            this.setEnabled(true);
            FlightLevelConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return HaulTypeComplete_.code;
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.code = null;
            this.description = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                FlightLevelDetailsPanel.this.code.setLocation(FlightLevelConfig.this.masterDataTable.getCellPadding(), FlightLevelConfig.this.masterDataTable.getCellPadding());
                FlightLevelDetailsPanel.this.code.setSize(200, (int)FlightLevelDetailsPanel.this.code.getPreferredSize().getHeight());
                FlightLevelDetailsPanel.this.description.setLocation(FlightLevelConfig.this.masterDataTable.getCellPadding(), FlightLevelDetailsPanel.this.code.getY() + FlightLevelDetailsPanel.this.code.getHeight() + FlightLevelConfig.this.masterDataTable.getCellPadding());
                FlightLevelDetailsPanel.this.description.setSize(200, (int)FlightLevelDetailsPanel.this.description.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

