/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.color.ColorChooser;
import ch.icit.pegasus.client.gui.utils.color.ColorPreview;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Color3DComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.Dimension3dComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.GalleyEquipmentInsertTypeComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import ch.icit.utils.NumberUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class GalleyEquipmentInsertTypeConfig
extends MasterDataInsert<GalleyEquipmentInsertTypeComplete> {
    private static final long serialVersionUID = 1L;

    public GalleyEquipmentInsertTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public GalleyEquipmentInsertTypeComplete getNewObject() {
        GalleyEquipmentInsertTypeComplete t = new GalleyEquipmentInsertTypeComplete();
        t.setDimension(new Dimension3dComplete(Double.valueOf(1.0), Double.valueOf(1.0), Double.valueOf(1.0)));
        t.setClientOId(Long.valueOf(ADTO.getNextId()));
        t.setDishwashFactor(Float.valueOf(0.0f));
        t.setDisplayColor(new Color3DComplete(Double.valueOf(0.0), Double.valueOf(0.0), Double.valueOf(0.0)));
        return t;
    }

    @Override
    public Class<? extends GalleyEquipmentInsertTypeComplete> getMasterDataClass() {
        return GalleyEquipmentInsertTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Inserts";
    }

    @Override
    public DetailsPanel getDetails() {
        return new GalleyEquipmentInsertTypeDetailsPanel();
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        boolean dimensionSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.width}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.height}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.depth}).getValue() == null) {
                dimensionSet = false;
            }
            if (n.getChildNamed(GalleyEquipmentInsertTypeComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(GalleyEquipmentInsertTypeComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(GalleyEquipmentInsertTypeComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(GalleyEquipmentInsertTypeComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!dimensionSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Dimensions are set"));
        }
        return a;
    }

    class GalleyEquipmentInsertTypeDetailsPanel
    extends DetailsPanel
    implements NodeListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> name;
        private ColorChooser color;
        private TitledItem<TextField> xSize;
        private TitledItem<TextField> ySize;
        private TitledItem<TextField> zSize;
        private ColorPreview preview;
        private Node node;

        public GalleyEquipmentInsertTypeDetailsPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.color = new ColorChooser();
            this.xSize = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.WIDTH, TitledItem.TitledItemOrientation.NORTH);
            this.ySize = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.HEIGHT, TitledItem.TitledItemOrientation.NORTH);
            this.zSize = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.DOUBLE), Words.DEPTH, TitledItem.TitledItemOrientation.NORTH);
            this.preview = new ColorPreview();
            this.setLayout(new AALayout());
            this.name.setProgress(1.0f);
            this.color.setProgress(1.0f);
            this.xSize.setProgress(1.0f);
            this.ySize.setProgress(1.0f);
            this.zSize.setProgress(1.0f);
            this.add(this.name);
            this.add(this.color);
            this.add(this.xSize);
            this.add(this.ySize);
            this.add(this.zSize);
            this.add(this.preview);
        }

        @Override
        public DtoField getAttributeName() {
            return GalleyEquipmentInsertTypeComplete_.name;
        }

        private void updatePreview() {
            double r = NumberUtils.getDoubleValue((Object)this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.red}).getValue());
            double g = NumberUtils.getDoubleValue((Object)this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.green}).getValue());
            double b = NumberUtils.getDoubleValue((Object)this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.blue}).getValue());
            int ri = (int)(255.0 * r);
            int gi = (int)(255.0 * g);
            int bi = (int)(255.0 * b);
            if (ri > 255) {
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.red}).setValue((Object)255, 0L);
            }
            if (gi > 255) {
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.green}).setValue((Object)255, 0L);
            }
            if (bi > 255) {
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.blue}).setValue((Object)255, 0L);
            }
            ri = Math.min(255, ri);
            gi = Math.min(255, gi);
            bi = Math.min(255, bi);
            Color c = new Color(ri, gi, bi);
            this.preview.setColor(c);
            this.preview.repaint(32L);
            this.preview.setColor(c);
            this.preview.repaint(32L);
        }

        @Override
        public void setNode(Node<?> n) {
            super.setNode(n);
            this.node = n;
            this.name.getElement().setNode(n.getChildNamed(GalleyEquipmentInsertTypeComplete_.name));
            this.xSize.getElement().setNode(n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.width}));
            this.ySize.getElement().setNode(n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.height}));
            this.zSize.getElement().setNode(n.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.dimension, Dimension3dComplete_.depth}));
            this.color.setNode(n.getChildNamed(GalleyEquipmentInsertTypeComplete_.displayColor));
            this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.red}).addNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.blue}).addNodeListener((NodeListener)this);
            this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.green}).addNodeListener((NodeListener)this);
            this.updatePreview();
            this.validate();
            this.setEnabled(true);
            GalleyEquipmentInsertTypeConfig.this.setEnabled(true);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.name.getFocusComponents();
            a.addAll(this.color.getFocusComponents());
            a.addAll(this.xSize.getFocusComponents());
            a.addAll(this.ySize.getFocusComponents());
            a.addAll(this.zSize.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.name.requestFocusInWindowNow();
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            if (this.node != null && this.node.getChildNamed(GalleyEquipmentInsertTypeComplete_.displayColor) != null) {
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.red}).removeNodeListener((NodeListener)this);
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.blue}).removeNodeListener((NodeListener)this);
                this.node.getChildNamed(new DtoField[]{GalleyEquipmentInsertTypeComplete_.displayColor, Color3DComplete_.green}).removeNodeListener((NodeListener)this);
            }
            this.name.kill();
            this.color.kill();
            this.xSize.kill();
            this.ySize.kill();
            this.zSize.kill();
            this.name = null;
            this.color = null;
            this.xSize = null;
            this.ySize = null;
            this.zSize = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.name.setEnabled(b);
            this.color.setEnabled(b);
            this.xSize.setEnabled(b);
            this.ySize.setEnabled(b);
            this.zSize.setEnabled(b);
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.name.setVisibleContainer(pane);
            this.color.setVisibleContainer(pane);
            this.xSize.setVisibleContainer(pane);
            this.ySize.setVisibleContainer(pane);
            this.zSize.setVisibleContainer(pane);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        public void valueChanged(Node<?> node) {
            this.updatePreview();
        }

        public void childAdded(Node<?> source, Node<?> child) {
        }

        public void childRemoved(Node<?> source, Node<?> child) {
        }

        public void childrenAdded(Node<?> source, Node<?> ... nodes) {
        }

        public boolean isSwingOnly() {
            return true;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                GalleyEquipmentInsertTypeDetailsPanel.this.name.setLocation(GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding(), GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding());
                GalleyEquipmentInsertTypeDetailsPanel.this.name.setSize(parent.getWidth() - GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding() * 2, (int)GalleyEquipmentInsertTypeDetailsPanel.this.name.getPreferredSize().getHeight());
                GalleyEquipmentInsertTypeDetailsPanel.this.color.setLocation(GalleyEquipmentInsertTypeDetailsPanel.this.name.getX(), GalleyEquipmentInsertTypeDetailsPanel.this.name.getY() + GalleyEquipmentInsertTypeDetailsPanel.this.name.getHeight() + GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding());
                GalleyEquipmentInsertTypeDetailsPanel.this.color.setSize(GalleyEquipmentInsertTypeDetailsPanel.this.color.getPreferredSize());
                GalleyEquipmentInsertTypeDetailsPanel.this.xSize.setLocation(GalleyEquipmentInsertTypeDetailsPanel.this.name.getX(), GalleyEquipmentInsertTypeDetailsPanel.this.color.getY() + GalleyEquipmentInsertTypeDetailsPanel.this.color.getHeight() + GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding());
                GalleyEquipmentInsertTypeDetailsPanel.this.xSize.setSize(100, (int)GalleyEquipmentInsertTypeDetailsPanel.this.xSize.getPreferredSize().getHeight());
                GalleyEquipmentInsertTypeDetailsPanel.this.ySize.setLocation(GalleyEquipmentInsertTypeDetailsPanel.this.xSize.getX() + GalleyEquipmentInsertTypeDetailsPanel.this.xSize.getWidth() + GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding(), GalleyEquipmentInsertTypeDetailsPanel.this.xSize.getY());
                GalleyEquipmentInsertTypeDetailsPanel.this.ySize.setSize(100, (int)GalleyEquipmentInsertTypeDetailsPanel.this.ySize.getPreferredSize().getHeight());
                GalleyEquipmentInsertTypeDetailsPanel.this.zSize.setLocation(GalleyEquipmentInsertTypeDetailsPanel.this.ySize.getX() + GalleyEquipmentInsertTypeDetailsPanel.this.ySize.getWidth() + GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding(), GalleyEquipmentInsertTypeDetailsPanel.this.ySize.getY());
                GalleyEquipmentInsertTypeDetailsPanel.this.zSize.setSize(100, (int)GalleyEquipmentInsertTypeDetailsPanel.this.zSize.getPreferredSize().getHeight());
                GalleyEquipmentInsertTypeDetailsPanel.this.preview.setLocation(GalleyEquipmentInsertTypeDetailsPanel.this.color.getX() + GalleyEquipmentInsertTypeDetailsPanel.this.color.getWidth() + 20, GalleyEquipmentInsertTypeDetailsPanel.this.color.getY());
                GalleyEquipmentInsertTypeDetailsPanel.this.preview.setSize(50, 75);
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + GalleyEquipmentInsertTypeDetailsPanel.this.name.getPreferredSize().getHeight());
                h += GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + GalleyEquipmentInsertTypeDetailsPanel.this.color.getPreferredSize().getHeight());
                h += GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding();
                h = (int)((double)h + GalleyEquipmentInsertTypeDetailsPanel.this.xSize.getPreferredSize().getHeight());
                h += GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding();
                return new Dimension(0, h += GalleyEquipmentInsertTypeConfig.this.masterDataTable.getCellPadding());
            }
        }
    }
}

