/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.mealplan.LabelTagComplete;
import ch.icit.pegasus.server.core.dtos.mealplan.LabelTagComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class LabelTagConfig
extends MasterDataInsert<LabelTagComplete> {
    private static final long serialVersionUID = 1L;

    public LabelTagConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new LabelTagConfigPanel();
    }

    @Override
    public String getInsertName() {
        return "Label Tags";
    }

    @Override
    public LabelTagComplete getNewObject() {
        LabelTagComplete a = new LabelTagComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends LabelTagComplete> getMasterDataClass() {
        return LabelTagComplete.class;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(LabelTagComplete_.code).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(LabelTagComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(LabelTagComplete_.code).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(LabelTagComplete_.code).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        return a;
    }

    private class LabelTagConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> description;
        private TitledItem<TextField> priority;

        public LabelTagConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.description = new TitledItem<TextField>(new TextField(null), "Description", TitledItem.TitledItemOrientation.NORTH);
            this.priority = new TitledItem<NumberTextField>(new NumberTextField(null, TextFieldType.INT), "Priority", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new Layout());
            this.add(this.code);
            this.add(this.description);
            this.add(this.priority);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.description.getFocusComponents());
            a.addAll(this.priority.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.description.setVisibleContainer(pane);
            this.priority.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.description.kill();
            this.priority.kill();
            this.code = null;
            this.description = null;
            this.priority = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.description.setEnabled(b);
            this.priority.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(LabelTagComplete_.code));
            this.description.getElement().setNode(node.getChildNamed(LabelTagComplete_.description));
            this.priority.getElement().setNode(node.getChildNamed(LabelTagComplete_.priority));
            this.setEnabled(true);
            LabelTagConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return LabelTagComplete_.code;
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                LabelTagConfigPanel.this.code.setLocation(LabelTagConfig.this.masterDataTable.getCellPadding(), LabelTagConfig.this.masterDataTable.getCellPadding());
                LabelTagConfigPanel.this.code.setSize(200, (int)LabelTagConfigPanel.this.code.getPreferredSize().getHeight());
                LabelTagConfigPanel.this.description.setLocation(LabelTagConfig.this.masterDataTable.getCellPadding(), LabelTagConfigPanel.this.code.getY() + LabelTagConfigPanel.this.code.getHeight() + LabelTagConfig.this.masterDataTable.getCellPadding());
                LabelTagConfigPanel.this.description.setSize(200, (int)LabelTagConfigPanel.this.description.getPreferredSize().getHeight());
                LabelTagConfigPanel.this.priority.setLocation(LabelTagConfig.this.masterDataTable.getCellPadding(), LabelTagConfigPanel.this.description.getY() + LabelTagConfigPanel.this.description.getHeight() + LabelTagConfig.this.masterDataTable.getCellPadding());
                LabelTagConfigPanel.this.priority.setSize(200, (int)LabelTagConfigPanel.this.priority.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

