/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreComplete;
import ch.icit.pegasus.server.core.dtos.dataexchange.migros.MigrosStoreComplete_;
import ch.icit.pegasus.server.core.i18n.Phrase;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MigrosStoreConfig
extends MasterDataInsert<MigrosStoreComplete> {
    private static final long serialVersionUID = 1L;

    public MigrosStoreConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new MigrosStoreConfigPanel();
    }

    @Override
    public MigrosStoreComplete getNewObject() {
        MigrosStoreComplete a = new MigrosStoreComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<MigrosStoreComplete> getMasterDataClass() {
        return MigrosStoreComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Migros Stores";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(MigrosStoreComplete_.glnNo).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(MigrosStoreComplete_.glnNo).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Phrase.getPhrase((String)Phrase.GLN_IS_NOT_UNIQUE, (Object[])new Object[]{n.getChildNamed(MigrosStoreComplete_.glnNo).getValue()})));
                continue;
            }
            codes.add((String)n.getChildNamed(MigrosStoreComplete_.glnNo).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all fields are set"));
        }
        return a;
    }

    private class MigrosStoreConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> genossenschaft;
        private TitledItem<TextField> partnerNo;
        private TitledItem<TextField> glnNo;
        private TitledItem<TextField> sapNo;
        private TitledItem<TextField> shortAddress;
        private TitledItem<TextField> addressLine1;
        private TitledItem<TextField> addressLine2;
        private TitledItem<TextField> street;
        private TitledItem<TextField> country;
        private TitledItem<TextField> plz;
        private TitledItem<TextField> city;
        private TitledItem<TextField> vatNo;

        public MigrosStoreConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.genossenschaft = new TitledItem<TextField>(new TextField(null), "Genossenschaft", TitledItem.TitledItemOrientation.NORTH);
            this.partnerNo = new TitledItem<TextField>(new TextField(null), "Partner No", TitledItem.TitledItemOrientation.NORTH);
            this.glnNo = new TitledItem<TextField>(new TextField(null), "GLN No", TitledItem.TitledItemOrientation.NORTH);
            this.sapNo = new TitledItem<TextField>(new TextField(null), "SAP No", TitledItem.TitledItemOrientation.NORTH);
            this.shortAddress = new TitledItem<TextField>(new TextField(null), "Short Address", TitledItem.TitledItemOrientation.NORTH);
            this.addressLine1 = new TitledItem<TextField>(new TextField(null), "Address Line 1", TitledItem.TitledItemOrientation.NORTH);
            this.addressLine2 = new TitledItem<TextField>(new TextField(null), "Address Line 2", TitledItem.TitledItemOrientation.NORTH);
            this.street = new TitledItem<TextField>(new TextField(null), "Street", TitledItem.TitledItemOrientation.NORTH);
            this.country = new TitledItem<TextField>(new TextField(null), "Country", TitledItem.TitledItemOrientation.NORTH);
            this.plz = new TitledItem<TextField>(new TextField(null), "PLZ", TitledItem.TitledItemOrientation.NORTH);
            this.city = new TitledItem<TextField>(new TextField(null), "City", TitledItem.TitledItemOrientation.NORTH);
            this.vatNo = new TitledItem<TextField>(new TextField(null), "Vat No", TitledItem.TitledItemOrientation.NORTH);
            this.setLayout(new AALayout());
            this.add(this.genossenschaft);
            this.add(this.partnerNo);
            this.add(this.glnNo);
            this.add(this.sapNo);
            this.add(this.shortAddress);
            this.add(this.addressLine1);
            this.add(this.addressLine2);
            this.add(this.street);
            this.add(this.country);
            this.add(this.plz);
            this.add(this.city);
            this.add(this.vatNo);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.genossenschaft.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.genossenschaft.setVisibleContainer(pane);
            this.partnerNo.setVisibleContainer(pane);
            this.glnNo.setVisibleContainer(pane);
            this.sapNo.setVisibleContainer(pane);
            this.shortAddress.setVisibleContainer(pane);
            this.addressLine1.setVisibleContainer(pane);
            this.addressLine2.setVisibleContainer(pane);
            this.street.setVisibleContainer(pane);
            this.country.setVisibleContainer(pane);
            this.plz.setVisibleContainer(pane);
            this.city.setVisibleContainer(pane);
            this.vatNo.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.genossenschaft.kill();
            this.partnerNo.kill();
            this.glnNo.kill();
            this.sapNo.kill();
            this.shortAddress.kill();
            this.addressLine1.kill();
            this.addressLine2.kill();
            this.street.kill();
            this.country.kill();
            this.plz.kill();
            this.city.kill();
            this.vatNo.kill();
            this.genossenschaft = null;
            this.partnerNo = null;
            this.glnNo = null;
            this.sapNo = null;
            this.shortAddress = null;
            this.addressLine1 = null;
            this.addressLine2 = null;
            this.street = null;
            this.country = null;
            this.plz = null;
            this.city = null;
            this.vatNo = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.genossenschaft.setEnabled(b);
            this.partnerNo.setEnabled(b);
            this.glnNo.setEnabled(b);
            this.sapNo.setEnabled(b);
            this.shortAddress.setEnabled(b);
            this.addressLine1.setEnabled(b);
            this.addressLine2.setEnabled(b);
            this.street.setEnabled(b);
            this.country.setEnabled(b);
            this.plz.setEnabled(b);
            this.city.setEnabled(b);
            this.vatNo.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.genossenschaft.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.genossenschaft));
            this.partnerNo.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.partnerNo));
            this.glnNo.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.glnNo));
            this.sapNo.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.sapNo));
            this.shortAddress.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.shortAddress));
            this.addressLine1.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.addressLine1));
            this.addressLine2.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.addressLine2));
            this.street.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.street));
            this.country.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.country));
            this.plz.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.plz));
            this.city.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.city));
            this.vatNo.getElement().setNode(node.getChildNamed(MigrosStoreComplete_.vatNo));
            this.setEnabled(true);
            MigrosStoreConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return MigrosStoreComplete_.glnNo;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                MigrosStoreConfigPanel.this.genossenschaft.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.genossenschaft.setSize(200, (int)MigrosStoreConfigPanel.this.genossenschaft.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.partnerNo.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.genossenschaft.getY() + MigrosStoreConfigPanel.this.genossenschaft.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.partnerNo.setSize(200, (int)MigrosStoreConfigPanel.this.partnerNo.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.glnNo.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.partnerNo.getY() + MigrosStoreConfigPanel.this.partnerNo.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.glnNo.setSize(200, (int)MigrosStoreConfigPanel.this.glnNo.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.sapNo.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.glnNo.getY() + MigrosStoreConfigPanel.this.glnNo.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.sapNo.setSize(200, (int)MigrosStoreConfigPanel.this.sapNo.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.shortAddress.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.sapNo.getY() + MigrosStoreConfigPanel.this.sapNo.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.shortAddress.setSize(200, (int)MigrosStoreConfigPanel.this.shortAddress.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.addressLine1.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.shortAddress.getY() + MigrosStoreConfigPanel.this.shortAddress.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.addressLine1.setSize(200, (int)MigrosStoreConfigPanel.this.addressLine1.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.addressLine2.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.addressLine1.getY() + MigrosStoreConfigPanel.this.addressLine1.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.addressLine2.setSize(200, (int)MigrosStoreConfigPanel.this.addressLine2.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.street.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.addressLine2.getY() + MigrosStoreConfigPanel.this.addressLine2.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.street.setSize(200, (int)MigrosStoreConfigPanel.this.street.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.country.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.street.getY() + MigrosStoreConfigPanel.this.street.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.country.setSize(200, (int)MigrosStoreConfigPanel.this.country.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.plz.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.country.getY() + MigrosStoreConfigPanel.this.country.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.plz.setSize(200, (int)MigrosStoreConfigPanel.this.plz.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.city.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.plz.getY() + MigrosStoreConfigPanel.this.plz.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.city.setSize(200, (int)MigrosStoreConfigPanel.this.city.getPreferredSize().getHeight());
                MigrosStoreConfigPanel.this.vatNo.setLocation(MigrosStoreConfig.this.masterDataTable.getCellPadding(), MigrosStoreConfigPanel.this.city.getY() + MigrosStoreConfigPanel.this.city.getHeight() + MigrosStoreConfig.this.masterDataTable.getCellPadding());
                MigrosStoreConfigPanel.this.vatNo.setSize(200, (int)MigrosStoreConfigPanel.this.vatNo.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

