/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.MasterDataInsert;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete_;
import ch.icit.pegasus.server.core.dtos.masterdata.SageAccountTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SageAccountTypeComplete_;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SageAccountTypeConfig
extends MasterDataInsert<SageAccountTypeComplete> {
    private static final long serialVersionUID = 1L;

    public SageAccountTypeConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public DetailsPanel getDetails() {
        return new ColorConfigPanel();
    }

    @Override
    public SageAccountTypeComplete getNewObject() {
        SageAccountTypeComplete a = new SageAccountTypeComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public Class<? extends SageAccountTypeComplete> getMasterDataClass() {
        return SageAccountTypeComplete.class;
    }

    @Override
    public String getInsertName() {
        return "Sage Account Types";
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getChildNamed(ColorComplete_.name).getValue() == null) {
                codeSet = false;
                continue;
            }
            if (codes.contains(n.getChildNamed(ColorComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(ColorComplete_.name).getValue() + " is not unique."));
                continue;
            }
            codes.add((String)n.getChildNamed(ColorComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        return a;
    }

    private class ColorConfigPanel
    extends DetailsPanel {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<CheckBox> income;
        private Node node;

        public ColorConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), "Code", TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), "Name", TitledItem.TitledItemOrientation.NORTH);
            this.income = new TitledItem<CheckBox>(new CheckBox(null), "Income", TitledItem.TitledItemOrientation.EAST);
            this.setLayout(new AALayout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.income);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> a = this.code.getFocusComponents();
            a.addAll(this.name.getFocusComponents());
            a.addAll(this.income.getFocusComponents());
            return a;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.income.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.income.kill();
            this.code = null;
            this.name = null;
            this.income = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = isEnabled;
            b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
            this.income.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            this.node = node;
            super.setNode(node);
            this.code.getElement().setNode(node.getChildNamed(SageAccountTypeComplete_.code));
            this.name.getElement().setNode(node.getChildNamed(SageAccountTypeComplete_.name));
            this.income.getElement().setNode(node.getChildNamed(SageAccountTypeComplete_.income));
            this.setEnabled(true);
            SageAccountTypeConfig.this.setEnabled(true);
        }

        @Override
        public DtoField getAttributeName() {
            return SageAccountTypeComplete_.code;
        }

        private class AALayout
        extends DefaultLayout {
            private AALayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                ColorConfigPanel.this.code.setLocation(SageAccountTypeConfig.this.masterDataTable.getCellPadding(), SageAccountTypeConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.code.setSize(200, (int)ColorConfigPanel.this.code.getPreferredSize().getHeight());
                ColorConfigPanel.this.name.setLocation(SageAccountTypeConfig.this.masterDataTable.getCellPadding(), ColorConfigPanel.this.code.getY() + ColorConfigPanel.this.code.getHeight() + SageAccountTypeConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.name.setSize(200, (int)ColorConfigPanel.this.name.getPreferredSize().getHeight());
                ColorConfigPanel.this.income.setLocation(SageAccountTypeConfig.this.masterDataTable.getCellPadding(), ColorConfigPanel.this.name.getY() + ColorConfigPanel.this.name.getHeight() + SageAccountTypeConfig.this.masterDataTable.getCellPadding());
                ColorConfigPanel.this.income.setSize(200, (int)ColorConfigPanel.this.income.getPreferredSize().getHeight());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

