/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.masterdata.panels;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.StoreEntryTypeConverter;
import ch.icit.pegasus.client.converter.StoreTypeConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.masterdata.MasterDataModule;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DTODataInsert;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DetailsPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.tables.CustomerSearchTable;
import ch.icit.pegasus.client.gui.utils.tables.StorePositionEditTable;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.StaticEnumServiceManager;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.search.SearchServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.StoreServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.exception.ClientExceptionCollection;
import ch.icit.pegasus.client.util.exception.ClientGetFromServerException;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.search.ADtoSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.StoreSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreComplete_;
import ch.icit.pegasus.server.core.dtos.store.StoreEntryTypeE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreLight_;
import ch.icit.pegasus.server.core.dtos.store.StorePositionComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.store.StoreTypeE;
import ch.icit.pegasus.server.core.dtos.util.SearchResult;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.OptionalWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class StoreConfig
extends DTODataInsert<StoreComplete> {
    private static final long serialVersionUID = 1L;

    public StoreConfig(MasterDataModule p) {
        super(p);
    }

    @Override
    public void insertElements() {
    }

    @Override
    public DetailsPanel getDetails() {
        return new StoreConfigPanel();
    }

    @Override
    protected void updateNode(Node n, ADTO dto) {
        if (dto != null) {
            StoreComplete s;
            n.removeExistingValues();
            n.setValue((Object)dto, 0L);
            n.updateNode();
            if (dto instanceof StoreComplete && (s = (StoreComplete)dto).getDefaultStorePosition() != null && s.getDefaultStorePosition().getClientOId() == null) {
                StorePositionLight storePositionLight = s.getDefaultStorePosition();
                s.getDefaultStorePosition();
                storePositionLight.setClientOId(Long.valueOf(StorePositionLight.getNextId()));
            }
            if (this.panel != null && (this.panel.getNode() == null || this.panel.getNode().equals(n))) {
                this.panel.setNode(n);
            }
        }
    }

    @Override
    public Class<? extends StoreComplete> getMasterDataClass() {
        return StoreComplete.class;
    }

    @Override
    public StoreComplete getNewObject() {
        StoreComplete a = new StoreComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        return a;
    }

    @Override
    public String getInsertName() {
        return "Stores";
    }

    @Override
    public void loadData() {
        super.loadData();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                StaticEnumServiceManager.getAllStoreTypes();
                StaticEnumServiceManager.getAllStoreRequisitionTypes();
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                StoreSearchConfiguration config = new StoreSearchConfiguration();
                config.setNumResults(Integer.MAX_VALUE);
                config.setStoreType(null);
                SearchResult stores = ((SearchServiceManager)ServiceManagerRegistry.getService(SearchServiceManager.class)).search((ADtoSearchConfiguration)config);
                for (StoreLight store : stores.getResults()) {
                    if (store.getDefaultStorePosition() != null || store.getDefaultStorePositionId() == null) continue;
                    OptionalWrapper positionForId = ((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getPositionForId(store.getDefaultStorePositionId());
                    store.setDefaultStorePosition((StorePositionLight)positionForId.getValue());
                    store.getDefaultStorePosition().setStore(store);
                }
                return INodeCreator.getDefaultImpl().createNodes(stores.getResults(), false);
            }

            @Override
            public RemoteLoader getInvoker() {
                return StoreConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void saveIt() {
        super.saveIt();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<Exception> errors = new ArrayList<Exception>();
                Iterator it = StoreConfig.this.masterDataTable.getModel().getNode().getChilds();
                while (it.hasNext()) {
                    StoreComplete a;
                    Node n = (Node)it.next();
                    if (n.getValue(StoreComplete.class) != null) {
                        n.commitThis(StoreComplete.class);
                        a = (StoreComplete)n.getValue(StoreComplete.class);
                        try {
                            a = a.getId() == null ? (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).createStore(a).getValue() : (a.getIsDeleted() != false && a.getDeleteUser() == null ? (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).deleteStore((StoreLight)a).getValue() : (a.getIsDeleted() == false && a.getDeleteUser() != null ? (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).restoreStore((StoreLight)a).getValue() : (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStore((StoreLight)a).getValue()));
                            StoreConfig.this.updateNode(n, (ADTO)a);
                        }
                        catch (Exception e) {
                            errors.add(e);
                        }
                        continue;
                    }
                    if (n.getValue(StoreLight.class) == null) continue;
                    n.commitThis(StoreLight.class);
                    a = (StoreLight)n.getValue(StoreLight.class);
                    try {
                        a = a.getIsDeleted() != false && a.getDeleteUser() == null ? (StoreLight)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).deleteStore((StoreLight)a).getValue() : (a.getIsDeleted() == false && a.getDeleteUser() != null ? (StoreLight)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).restoreStore((StoreLight)a).getValue() : (StoreLight)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).updateStore((StoreLight)a).getValue());
                        StoreConfig.this.updateNode(n, (ADTO)a);
                    }
                    catch (Exception e) {
                        errors.add(e);
                    }
                }
                if (!errors.isEmpty()) {
                    throw new ClientExceptionCollection("<b>Error on updating Stores", errors);
                }
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return StoreConfig.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        Iterator it = this.masterDataTable.getModel().getNode().getChilds();
        HashSet<String> codes = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        boolean nameSet = true;
        boolean codeSet = true;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            if (n.getValue(StoreComplete.class) != null) {
                Node pos;
                boolean found;
                Iterator it2;
                Node dsp = n.getChildNamed(StoreComplete_.defaultStorePosition);
                boolean hasDefaultPosition = true;
                if (dsp.getValue() == null) {
                    hasDefaultPosition = false;
                } else {
                    it2 = n.getChildNamed(StoreComplete_.positions).getChilds();
                    found = false;
                    while (it2.hasNext() && !found) {
                        pos = (Node)it2.next();
                        if (!pos.getValue().equals(dsp.getValue())) continue;
                        found = true;
                    }
                    if (!found) {
                        hasDefaultPosition = false;
                    }
                }
                if (!hasDefaultPosition) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Stores have a Default Position"));
                }
                it2 = n.getChildNamed(StoreComplete_.autoCheckoutCustomers).getChilds();
                found = false;
                while (it2.hasNext() && !found) {
                    pos = (Node)it2.next();
                    if (pos.getValue() != null) continue;
                    found = true;
                }
                if (found) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Customer selected! Ensure all entries have a Customer set"));
                }
            }
            if (n.getChildNamed(StoreComplete_.code).getValue() == null) {
                codeSet = false;
            } else if (codes.contains(n.getChildNamed(StoreComplete_.code).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Code " + n.getChildNamed(StoreComplete_.code).getValue() + " is not unique."));
            } else {
                codes.add((String)n.getChildNamed(StoreComplete_.code).getValue());
            }
            if (n.getChildNamed(StoreComplete_.name).getValue() == null) {
                nameSet = false;
                continue;
            }
            if (names.contains(n.getChildNamed(StoreComplete_.name).getValue())) {
                a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Name " + n.getChildNamed(StoreComplete_.name).getValue() + " is not unique."));
                continue;
            }
            names.add((String)n.getChildNamed(StoreComplete_.name).getValue());
        }
        if (!codeSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Codes are set"));
        }
        if (!nameSet) {
            a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Names are set"));
        }
        return a;
    }

    private class StoreConfigPanel
    extends DetailsPanel
    implements RemoteLoader {
        private static final long serialVersionUID = 1L;
        private TitledItem<TextField> code;
        private TitledItem<TextField> name;
        private TitledItem<ComboBox> consumption;
        private TitledItem<ComboBox> costCenter;
        private TitledItem<MultiLocationComboBox> locations;
        private TitledItem<CheckBox> isAutoCheckoutStore;
        private TitledItem<TextField> notificationEMail;
        private TitledItem<CheckBox> excludeFromStock;
        private TitledItem<CheckBox> mainStore;
        private TitledItem<CheckBox> autoReceiveStore;
        private TitledItem<CheckBox> ignoreBarcodeRestrictions;
        private TitledItem<CheckBox> offlineInventory;
        private TitledItem<CheckBox> partlyStore;
        private TitledItem<CheckBox> excludeFromKonterProbe;
        private TitledItem<CheckBox> autoReceiveFromPurchaseRedirect;
        private CustomerSearchTable customerTable;
        private TitledItem<ComboBox> type;
        private TitledItem<CheckBox> requisitionAllowed;
        private StorePositionEditTable positions;
        private TitledItem<TextField> storeGroup;
        private Node<?> node;

        public StoreConfigPanel() {
            this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("inner_panel_background_color")));
            this.code = new TitledItem<TextField>(new TextField(null), Words.CODE, TitledItem.TitledItemOrientation.NORTH);
            this.name = new TitledItem<TextField>(new TextField(null), Words.NAME, TitledItem.TitledItemOrientation.NORTH);
            this.consumption = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(StoreTypeE.class), ConverterRegistry.getConverter(StoreTypeConverter.class)), Words.STORE_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.costCenter = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
            this.storeGroup = new TitledItem<TextField>(new TextField(null), "Requisition Deliver Sort Name", TitledItem.TitledItemOrientation.NORTH);
            this.notificationEMail = new TitledItem<TextField>(new TextField(null), "Notification eMail", TitledItem.TitledItemOrientation.NORTH);
            this.locations = new TitledItem<MultiLocationComboBox>(new MultiLocationComboBox(null), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
            this.type = new TitledItem<ComboBox>(new ComboBox(null, NodeToolkit.getAffixList(StoreEntryTypeE.class), ConverterRegistry.getConverter(StoreEntryTypeConverter.class)), Words.STORE_REQISITION_TYPE, TitledItem.TitledItemOrientation.NORTH);
            this.offlineInventory = new TitledItem<CheckBox>(new CheckBox(), "Offline Inventory", TitledItem.TitledItemOrientation.EAST);
            this.partlyStore = new TitledItem<CheckBox>(new CheckBox(), "Partly Store", TitledItem.TitledItemOrientation.EAST);
            this.excludeFromKonterProbe = new TitledItem<CheckBox>(new CheckBox(), "Exclude from Konter Probe", TitledItem.TitledItemOrientation.EAST);
            this.autoReceiveFromPurchaseRedirect = new TitledItem<CheckBox>(new CheckBox(), "Auto Receive from Purchase Redirect", TitledItem.TitledItemOrientation.EAST);
            this.isAutoCheckoutStore = new TitledItem<CheckBox>(new CheckBox(), Words.AUTO_CHECKOUT_STORE, TitledItem.TitledItemOrientation.EAST);
            this.excludeFromStock = new TitledItem<CheckBox>(new CheckBox(), Words.EXCLUDE_FROM_STOCK, TitledItem.TitledItemOrientation.EAST);
            this.mainStore = new TitledItem<CheckBox>(new CheckBox(), Words.MAIN_STORE, TitledItem.TitledItemOrientation.EAST);
            this.requisitionAllowed = new TitledItem<CheckBox>(new CheckBox(), Words.REQUISITION_ALLOWED, TitledItem.TitledItemOrientation.EAST);
            this.autoReceiveStore = new TitledItem<CheckBox>(new CheckBox(), "Auto Receive with Barcode Reader", TitledItem.TitledItemOrientation.EAST);
            this.ignoreBarcodeRestrictions = new TitledItem<CheckBox>(new CheckBox(), "Ignore Barcode Restrictions", TitledItem.TitledItemOrientation.EAST);
            this.positions = new StorePositionEditTable();
            this.customerTable = new CustomerSearchTable(Words.NAME);
            this.setLayout(new Layout());
            this.add(this.code);
            this.add(this.name);
            this.add(this.notificationEMail);
            this.add(this.consumption);
            this.add(this.costCenter);
            this.add(this.positions);
            this.add(this.type);
            this.add(this.locations);
            this.add(this.isAutoCheckoutStore);
            this.add(this.excludeFromStock);
            this.add(this.mainStore);
            this.add(this.customerTable);
            this.add(this.requisitionAllowed);
            this.add(this.storeGroup);
            this.add(this.autoReceiveStore);
            this.add(this.ignoreBarcodeRestrictions);
            this.add(this.offlineInventory);
            this.add(this.partlyStore);
            this.add(this.excludeFromKonterProbe);
            this.add(this.autoReceiveFromPurchaseRedirect);
        }

        @Override
        public List<Component> getFocusComponents() {
            List<Component> focusList = this.code.getFocusComponents();
            focusList.addAll(this.code.getFocusComponents());
            focusList.addAll(this.name.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.storeGroup);
            CheckedListAdder.addToList(focusList, this.notificationEMail);
            focusList.addAll(this.locations.getFocusComponents());
            focusList.addAll(this.costCenter.getFocusComponents());
            focusList.addAll(this.consumption.getFocusComponents());
            focusList.addAll(this.type.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.isAutoCheckoutStore);
            focusList.addAll(this.excludeFromStock.getFocusComponents());
            focusList.addAll(this.mainStore.getFocusComponents());
            focusList.addAll(this.autoReceiveStore.getFocusComponents());
            CheckedListAdder.addToList(focusList, this.requisitionAllowed);
            CheckedListAdder.addToList(focusList, this.ignoreBarcodeRestrictions);
            CheckedListAdder.addToList(focusList, this.offlineInventory);
            CheckedListAdder.addToList(focusList, this.partlyStore);
            CheckedListAdder.addToList(focusList, this.excludeFromKonterProbe);
            CheckedListAdder.addToList(focusList, this.autoReceiveFromPurchaseRedirect);
            focusList.addAll(this.positions.getFocusComponents());
            focusList.addAll(this.customerTable.getFocusComponents());
            return focusList;
        }

        @Override
        public void requestFocusInWindowNow() {
            this.code.requestFocusInWindowNow();
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
            this.code.setVisibleContainer(pane);
            this.name.setVisibleContainer(pane);
            this.storeGroup.setVisibleContainer(pane);
            this.consumption.setVisibleContainer(pane);
            this.positions.setVisibleContainer(pane);
            this.costCenter.setVisibleContainer(pane);
            this.type.setVisibleContainer(pane);
            this.isAutoCheckoutStore.setVisibleContainer(pane);
            this.excludeFromStock.setVisibleContainer(pane);
            this.mainStore.setVisibleContainer(pane);
            this.autoReceiveStore.setVisibleContainer(pane);
            this.customerTable.setVisibleContainer(pane);
            this.requisitionAllowed.setVisibleContainer(pane);
            this.notificationEMail.setVisibleContainer(pane);
            this.ignoreBarcodeRestrictions.setVisibleContainer(pane);
            this.offlineInventory.setVisibleContainer(pane);
            this.partlyStore.setVisibleContainer(pane);
            this.excludeFromKonterProbe.setVisibleContainer(pane);
            this.autoReceiveFromPurchaseRedirect.setVisibleContainer(pane);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.code.kill();
            this.name.kill();
            this.storeGroup.kill();
            this.notificationEMail.kill();
            this.consumption.kill();
            this.positions.kill();
            this.costCenter.kill();
            this.type.kill();
            this.isAutoCheckoutStore.kill();
            this.locations.kill();
            this.customerTable.kill();
            this.excludeFromStock.kill();
            this.mainStore.kill();
            this.requisitionAllowed.kill();
            this.autoReceiveStore.kill();
            this.ignoreBarcodeRestrictions.kill();
            this.offlineInventory.kill();
            this.partlyStore.kill();
            this.excludeFromKonterProbe.kill();
            this.autoReceiveFromPurchaseRedirect.kill();
            this.code = null;
            this.name = null;
            this.storeGroup = null;
            this.notificationEMail = null;
            this.consumption = null;
            this.positions = null;
            this.costCenter = null;
            this.type = null;
            this.locations = null;
            this.isAutoCheckoutStore = null;
            this.customerTable = null;
            this.excludeFromStock = null;
            this.mainStore = null;
            this.requisitionAllowed = null;
            this.autoReceiveStore = null;
            this.ignoreBarcodeRestrictions = null;
            this.offlineInventory = null;
            this.partlyStore = null;
            this.excludeFromKonterProbe = null;
            this.autoReceiveFromPurchaseRedirect = null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            boolean b = this.isNodeSet() ? isEnabled : false;
            super.setEnabled(b);
            this.code.setEnabled(b);
            this.name.setEnabled(b);
            this.storeGroup.setEnabled(b);
            this.notificationEMail.setEnabled(b);
            this.consumption.setEnabled(b);
            this.positions.setEnabled(b);
            this.costCenter.setEnabled(b);
            this.type.setEnabled(b);
            this.locations.setEnabled(b);
            this.isAutoCheckoutStore.setEnabled(b);
            this.customerTable.setEnabled(b);
            this.excludeFromStock.setEnabled(b);
            this.mainStore.setEnabled(b);
            this.requisitionAllowed.setEnabled(b);
            this.autoReceiveStore.setEnabled(b);
            this.ignoreBarcodeRestrictions.setEnabled(b);
            this.offlineInventory.setEnabled(b);
            this.autoReceiveFromPurchaseRedirect.setEnabled(b);
        }

        public Converter getConverter() {
            return ConverterRegistry.getConverter(StringConverter.class);
        }

        @Override
        public void setNode(Node<?> node) {
            super.setNode(node);
            this.node = node;
            if (this.node.getValue(StoreComplete.class) == null) {
                StoreConfig.this.editPanel.setLoading(true);
                StoreConfig.this.startAnimation("Load Data");
                ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                    @Override
                    public Node<?> loadData() throws Exception {
                        StoreLight store = (StoreLight)StoreConfigPanel.this.node.getValue(StoreLight.class);
                        try {
                            StoreComplete storeC = (StoreComplete)((StoreServiceManager)ServiceManagerRegistry.getService(StoreServiceManager.class)).getStoreByReference((StoreReference)store).getValue();
                            if (storeC.getDefaultStorePosition() == null && storeC.getDefaultStorePositionId() != null) {
                                for (StorePositionComplete position : storeC.getPositions()) {
                                    if (!position.getId().equals(storeC.getDefaultStorePositionId())) continue;
                                    storeC.setDefaultStorePosition((StorePositionLight)position);
                                }
                            }
                            Node n = StoreConfigPanel.this.node;
                            n.removeExistingValues();
                            n.setValue((Object)storeC, 0L);
                            n.updateNode();
                            return n;
                        }
                        catch (ClientGetFromServerException e) {
                            ViewNode r = new ViewNode("Error");
                            r.setValue((Object)e, 0L);
                            return r;
                        }
                    }

                    @Override
                    public RemoteLoader getInvoker() {
                        return StoreConfigPanel.this;
                    }

                    @Override
                    public long getID() {
                        return 0L;
                    }
                };
                ThreadSafeLoader.run(run);
            } else {
                this.remoteObjectLoaded(node);
            }
        }

        @Override
        public DtoField getAttributeName() {
            return StoreLight_.code;
        }

        public void remoteObjectLoaded(Node<?> node) {
            if (node != null && node.getValue() instanceof ClientServerCallException) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)((ClientServerCallException)((Object)node.getValue()))), (Component)this);
                StoreConfig.this.editPanel.setLoading(false);
                StoreConfig.this.stopAnimation();
                this.setEnabled(true);
                StoreConfig.this.setEnabled(true);
                return;
            }
            this.node = node;
            this.code.getElement().setNode(node.getChildNamed(StoreLight_.code));
            this.name.getElement().setNode(node.getChildNamed(StoreLight_.name));
            this.consumption.getElement().setNode(node.getChildNamed(StoreLight_.storeType));
            this.consumption.getElement().refreshPossibleValues(NodeToolkit.getAffixList(StoreTypeE.class));
            this.type.getElement().setNode(node.getChildNamed(StoreLight_.storeEntryType));
            this.type.getElement().refreshPossibleValues(NodeToolkit.getAffixList(StoreEntryTypeE.class));
            this.positions.getModel().setNode(node.getChildNamed(StoreComplete_.positions));
            this.costCenter.getElement().setNode(node.getChildNamed(StoreLight_.consumptionCostCenter));
            this.costCenter.getElement().refreshPossibleValues(NodeToolkit.getAffixList(CostCenterComplete.class));
            this.locations.getElement().setNode(node.getChildNamed(StoreComplete_.eligibleLocations));
            this.isAutoCheckoutStore.getElement().setNode(node.getChildNamed(StoreLight_.autoCheckoutStore));
            this.customerTable.getModel().setNode(node.getChildNamed(StoreComplete_.autoCheckoutCustomers));
            this.excludeFromStock.getElement().setNode(node.getChildNamed(StoreComplete_.excludeFromStock));
            this.notificationEMail.getElement().setNode(node.getChildNamed(StoreComplete_.defaultMailAddress));
            this.requisitionAllowed.getElement().setNode(node.getChildNamed(StoreLight_.requisitionAllowed));
            this.storeGroup.getElement().setNode(node.getChildNamed(StoreLight_.storeGroup));
            this.autoReceiveStore.getElement().setNode(node.getChildNamed(StoreLight_.autoReceiveStore));
            this.ignoreBarcodeRestrictions.getElement().setNode(node.getChildNamed(StoreComplete_.ignoreBarcodeRestrictions));
            this.autoReceiveFromPurchaseRedirect.getElement().setNode(node.getChildNamed(StoreLight_.autoReceiveFromPurchaseRedirect));
            this.mainStore.getElement().setNode(node.getChildNamed(StoreComplete_.mainStore));
            this.offlineInventory.getElement().setNode(node.getChildNamed(StoreLight_.offlineInventory));
            this.partlyStore.getElement().setNode(node.getChildNamed(StoreLight_.partlyStore));
            this.excludeFromKonterProbe.getElement().setNode(node.getChildNamed(StoreComplete_.excludeFromKonterProbe));
            this.positions.setStoreNode(node);
            StoreConfig.this.editPanel.setLoading(false);
            StoreConfig.this.stopAnimation();
            this.setEnabled(true);
            StoreConfig.this.setEnabled(true);
        }

        public void errorOccurred(ClientException exception) {
            InnerPopupFactory.showErrorDialog((Exception)exception, (Component)StoreConfig.this);
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                StoreConfigPanel.this.code.setLocation(StoreConfig.this.masterDataTable.getCellPadding(), StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.code.setSize(200, (int)StoreConfigPanel.this.code.getPreferredSize().getHeight());
                StoreConfigPanel.this.name.setLocation(StoreConfigPanel.this.code.getX() + StoreConfigPanel.this.code.getWidth() + StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.code.getY());
                StoreConfigPanel.this.name.setSize(200, (int)StoreConfigPanel.this.name.getPreferredSize().getHeight());
                StoreConfigPanel.this.storeGroup.setLocation(StoreConfigPanel.this.name.getX() + StoreConfigPanel.this.name.getWidth() + StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.code.getY());
                StoreConfigPanel.this.storeGroup.setSize(200, (int)StoreConfigPanel.this.storeGroup.getPreferredSize().getHeight());
                StoreConfigPanel.this.notificationEMail.setLocation(StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.name.getY() + StoreConfigPanel.this.name.getHeight() + StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.notificationEMail.setSize(250, (int)StoreConfigPanel.this.notificationEMail.getPreferredSize().getHeight());
                StoreConfigPanel.this.costCenter.setLocation(StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.notificationEMail.getY() + StoreConfigPanel.this.notificationEMail.getHeight() + StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.costCenter.setSize(250, (int)StoreConfigPanel.this.costCenter.getPreferredSize().getHeight());
                StoreConfigPanel.this.locations.setLocation(StoreConfigPanel.this.costCenter.getX() + StoreConfigPanel.this.costCenter.getWidth() + StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.costCenter.getY());
                StoreConfigPanel.this.locations.setSize(StoreConfigPanel.this.locations.getPreferredSize());
                StoreConfigPanel.this.consumption.setLocation(StoreConfigPanel.this.code.getX(), StoreConfigPanel.this.locations.getY() + StoreConfigPanel.this.locations.getHeight() + StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.consumption.setSize(200, (int)StoreConfigPanel.this.consumption.getPreferredSize().getHeight());
                StoreConfigPanel.this.type.setLocation(StoreConfigPanel.this.consumption.getX() + StoreConfigPanel.this.consumption.getWidth() + 10, StoreConfigPanel.this.consumption.getY());
                StoreConfigPanel.this.type.setSize(200, (int)StoreConfigPanel.this.type.getPreferredSize().getHeight());
                StoreConfigPanel.this.isAutoCheckoutStore.setLocation(StoreConfig.this.masterDataTable.getCellPadding(), StoreConfigPanel.this.type.getY() + StoreConfigPanel.this.type.getHeight() + StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.isAutoCheckoutStore.setSize(200, (int)StoreConfigPanel.this.isAutoCheckoutStore.getPreferredSize().getHeight());
                StoreConfigPanel.this.excludeFromStock.setLocation(StoreConfigPanel.this.isAutoCheckoutStore.getX() + StoreConfigPanel.this.isAutoCheckoutStore.getWidth() - 40, StoreConfigPanel.this.isAutoCheckoutStore.getY());
                StoreConfigPanel.this.excludeFromStock.setSize(StoreConfigPanel.this.excludeFromStock.getPreferredSize());
                StoreConfigPanel.this.mainStore.setLocation(StoreConfigPanel.this.isAutoCheckoutStore.getX() + StoreConfigPanel.this.isAutoCheckoutStore.getWidth() + StoreConfigPanel.this.excludeFromStock.getWidth() - 10, StoreConfigPanel.this.excludeFromStock.getY());
                StoreConfigPanel.this.mainStore.setSize(StoreConfigPanel.this.mainStore.getPreferredSize());
                StoreConfigPanel.this.autoReceiveStore.setLocation(StoreConfigPanel.this.mainStore.getX() + StoreConfigPanel.this.mainStore.getWidth() + 10, StoreConfigPanel.this.excludeFromStock.getY());
                StoreConfigPanel.this.autoReceiveStore.setSize(StoreConfigPanel.this.autoReceiveStore.getPreferredSize());
                StoreConfigPanel.this.requisitionAllowed.setLocation(StoreConfigPanel.this.autoReceiveStore.getX() + StoreConfigPanel.this.autoReceiveStore.getWidth() + 10, StoreConfigPanel.this.excludeFromStock.getY());
                StoreConfigPanel.this.requisitionAllowed.setSize(StoreConfigPanel.this.requisitionAllowed.getPreferredSize());
                StoreConfigPanel.this.ignoreBarcodeRestrictions.setLocation(StoreConfigPanel.this.requisitionAllowed.getX() + StoreConfigPanel.this.requisitionAllowed.getWidth() + 10, StoreConfigPanel.this.excludeFromStock.getY());
                StoreConfigPanel.this.ignoreBarcodeRestrictions.setSize(StoreConfigPanel.this.ignoreBarcodeRestrictions.getPreferredSize());
                StoreConfigPanel.this.offlineInventory.setLocation(StoreConfigPanel.this.isAutoCheckoutStore.getX(), StoreConfigPanel.this.isAutoCheckoutStore.getY() + StoreConfigPanel.this.isAutoCheckoutStore.getHeight() + 10);
                StoreConfigPanel.this.offlineInventory.setSize(StoreConfigPanel.this.offlineInventory.getPreferredSize());
                StoreConfigPanel.this.partlyStore.setLocation(StoreConfigPanel.this.excludeFromStock.getX(), StoreConfigPanel.this.offlineInventory.getY());
                StoreConfigPanel.this.partlyStore.setSize(StoreConfigPanel.this.partlyStore.getPreferredSize());
                StoreConfigPanel.this.excludeFromKonterProbe.setLocation(StoreConfigPanel.this.mainStore.getX(), StoreConfigPanel.this.offlineInventory.getY());
                StoreConfigPanel.this.excludeFromKonterProbe.setSize(StoreConfigPanel.this.excludeFromKonterProbe.getPreferredSize());
                StoreConfigPanel.this.autoReceiveFromPurchaseRedirect.setLocation(StoreConfigPanel.this.requisitionAllowed.getX(), StoreConfigPanel.this.offlineInventory.getY());
                StoreConfigPanel.this.autoReceiveFromPurchaseRedirect.setSize(StoreConfigPanel.this.autoReceiveFromPurchaseRedirect.getPreferredSize());
                StoreConfigPanel.this.positions.setLocation(StoreConfigPanel.this.isAutoCheckoutStore.getX(), StoreConfigPanel.this.offlineInventory.getY() + StoreConfigPanel.this.offlineInventory.getHeight() + StoreConfig.this.masterDataTable.getCellPadding());
                StoreConfigPanel.this.positions.setSize((parent.getWidth() - 3 * StoreConfigPanel.this.positions.getX()) / 2, parent.getHeight() - (StoreConfigPanel.this.positions.getY() + StoreConfig.this.masterDataTable.getCellPadding()));
                StoreConfigPanel.this.customerTable.setLocation(StoreConfigPanel.this.positions.getX() + StoreConfigPanel.this.positions.getWidth() + StoreConfigPanel.this.positions.getX(), StoreConfigPanel.this.positions.getY());
                StoreConfigPanel.this.customerTable.setSize(StoreConfigPanel.this.positions.getSize());
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension();
            }
        }
    }
}

