/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.DeliveryTermConverter;
import ch.icit.pegasus.client.converter.OrderDeliveryWindowConverter;
import ch.icit.pegasus.client.converter.StandaloneContactConverter;
import ch.icit.pegasus.client.converter.TaxZoneConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.details.OrderPositionsDetailsPanel;
import ch.icit.pegasus.client.gui.table.DefaultDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDCheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDMultiLocationComboBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.server.core.dtos.company.ExternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.DeliveryTermComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.TaxZoneComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.PurchaseOrderAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete_;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class ConfigurationDetailsPanel
extends DefaultDetailsPanel<PurchaseOrderLight> {
    private static final long serialVersionUID = 1L;
    private TitledItem<RDComboBox> department;
    private TitledItem<RDComboBox> customer;
    private TitledItem<RDComboBox> deliveryWindow;
    private TitledItem<RDDateChooser> deliveryDate;
    private TitledItem<RDDateChooser> orderDate;
    private TitledItem<RDComboBox> deliveryAddress;
    private TitledItem<RDComboBox> incoTerms;
    private TitledItem<RDMultiLocationComboBox> locations;
    private TitledItem<RDCheckBox> useTaxZone;
    private TitledItem<RDComboBox> taxZone;
    private TitledItem<TextButton> reactivateAmountChange;
    private final OrderPositionsDetailsPanel panel;
    private TitledItem<TextLabel> customerOwnedOnly;
    private TitledItem<TextLabel> halalOnly;
    private TitledItem<RDCheckBox> reorder;

    public ConfigurationDetailsPanel(RowEditor<PurchaseOrderLight> editor, RDProvider provider, OrderPositionsDetailsPanel panel) {
        super(editor, provider);
        this.panel = panel;
        this.setTitleText(Words.CONFIGURATION);
        this.department = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.department.getElement().refreshPossibleValues(ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), null, ComboBoxFactory.DepartmentType.PURCHASE_ORDER));
        this.customer = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(CostCenterConverter.class), true), Words.CUSTOMER, TitledItem.TitledItemOrientation.NORTH);
        this.customer.getElement().refreshPossibleValues(NodeToolkit.getAffixList(ExternalCostCenterComplete.class));
        this.deliveryAddress = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(StandaloneContactConverter.class)), Words.DELIVERY_ADDRESS, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryAddress.getElement().refreshPossibleValues(NodeToolkit.getAffixClass(SystemSettingsComplete.class).getChildNamed(SystemSettingsComplete_.deliveryAddresses));
        this.deliveryDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.SCHEDULED_DELIVERY_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(OrderDeliveryWindowConverter.class)), Words.DELIVERY_TIME_WINDOW, TitledItem.TitledItemOrientation.NORTH);
        this.deliveryWindow.getElement().refreshPossibleValues(NodeToolkit.getAffixList(OrderDeliveryWindowComplete.class));
        this.incoTerms = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(DeliveryTermConverter.class)), Words.INCO_TERMS, TitledItem.TitledItemOrientation.NORTH);
        this.incoTerms.getElement().refreshPossibleValues(NodeToolkit.getAffixList(DeliveryTermComplete.class));
        this.reactivateAmountChange = new TitledItem<TextButton>(new TextButton(Words.ENABLE), Words.ENABLE_QUANTITY_CHANGE, TitledItem.TitledItemOrientation.EAST);
        this.customerOwnedOnly = new TitledItem<TextLabel>(new TextLabel(), Words.CUSTOMER_OWNED_ONLY, TitledItem.TitledItemOrientation.NORTH);
        this.halalOnly = new TitledItem<TextLabel>(new TextLabel(), Words.HALAL_ORDER, TitledItem.TitledItemOrientation.NORTH);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations = new TitledItem<RDMultiLocationComboBox>(new RDMultiLocationComboBox(provider), Words.LOCATIONS, TitledItem.TitledItemOrientation.NORTH);
        }
        this.reorder = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.REORDER, TitledItem.TitledItemOrientation.EAST);
        this.orderDate = new TitledItem<RDDateChooser>(new RDDateChooser(provider), Words.ORDER_DATE, TitledItem.TitledItemOrientation.NORTH);
        if (this.showTaxZone()) {
            this.useTaxZone = new TitledItem<RDCheckBox>(new RDCheckBox(provider), Words.USE_TAX_ZONE, TitledItem.TitledItemOrientation.EAST);
            this.taxZone = new TitledItem<RDComboBox>(new RDComboBox(provider, ConverterRegistry.getConverter(TaxZoneConverter.class), true), Words.TAX_ZONE, TitledItem.TitledItemOrientation.NORTH);
            this.useTaxZone.getElement().addButtonListener((source, x, y) -> this.setEnabled(this.isEnabled()));
        }
        this.reactivateAmountChange.getElement().addButtonListener(this);
        this.setCustomLayouter(new Layout());
        this.addToView(this.department);
        this.addToView(this.customer);
        this.addToView(this.deliveryAddress);
        this.addToView(this.deliveryDate);
        this.addToView(this.deliveryWindow);
        this.addToView(this.incoTerms);
        this.addToView(this.reactivateAmountChange);
        this.addToView(this.orderDate);
        this.addToView(this.customerOwnedOnly);
        this.addToView(this.halalOnly);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.addToView(this.locations);
        }
        this.addToView(this.reorder);
        if (this.showTaxZone()) {
            this.addToView(this.useTaxZone);
            this.addToView(this.taxZone);
        }
    }

    private boolean showTaxZone() {
        return Boolean.TRUE.equals(this.settings.getAllowTaxZoneRelatedSupplierCondition());
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusList = new ArrayList<Component>();
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.customer);
        CheckedListAdder.addToList(focusList, this.deliveryAddress);
        CheckedListAdder.addToList(focusList, this.deliveryDate);
        CheckedListAdder.addToList(focusList, this.deliveryWindow);
        CheckedListAdder.addToList(focusList, this.incoTerms);
        CheckedListAdder.addToList(focusList, this.reactivateAmountChange);
        CheckedListAdder.addToList(focusList, this.orderDate);
        CheckedListAdder.addToList(focusList, this.locations);
        CheckedListAdder.addToList(focusList, this.customerOwnedOnly);
        CheckedListAdder.addToList(focusList, this.halalOnly);
        CheckedListAdder.addToList(focusList, this.reorder);
        CheckedListAdder.addToList(focusList, this.useTaxZone);
        CheckedListAdder.addToList(focusList, this.taxZone);
        return focusList;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        super.buttonPressed(source, x, y);
        if (source == this.reactivateAmountChange.getElement()) {
            this.panel.enableAmountChange();
            this.panel.setEnabled(this.panel.isEnabled());
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        OrderStateE e = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean canEdit = e.equals((Object)OrderStateE.PLACED);
        boolean canEditClosedOrder = this.provider.isWritable(PurchaseOrderAccess.EDIT_CLOSED_ORDER);
        if (!canEdit && canEditClosedOrder) {
            canEdit = true;
        }
        OrderReviewStateE o = (OrderReviewStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.reviewState).getValue();
        OrderStateE s = (OrderStateE)this.editor.getModel().getNode().getChildNamed(PurchaseOrderComplete_.state).getValue();
        boolean isApproved = o != null && o.equals((Object)OrderReviewStateE.APPROVED);
        if (isApproved && canEditClosedOrder) {
            isApproved = false;
        }
        this.department.setEnabled(isEnabled && canEdit && !isApproved);
        this.customer.setEnabled(isEnabled && canEdit && !isApproved);
        this.deliveryAddress.setEnabled(isEnabled && canEdit && !isApproved);
        this.deliveryDate.setEnabled(isEnabled && canEdit && !isApproved);
        this.deliveryWindow.setEnabled(isEnabled && canEdit && !isApproved);
        this.incoTerms.setEnabled(isEnabled && canEdit && !isApproved);
        this.orderDate.setEnabled(isEnabled && canEdit && !isApproved);
        this.reorder.setEnabled(isEnabled && canEdit && !isApproved);
        this.customerOwnedOnly.setEnabled(isEnabled);
        this.halalOnly.setEnabled(isEnabled);
        if (this.showTaxZone()) {
            this.useTaxZone.setEnabled(isEnabled && canEdit && !isApproved);
            this.taxZone.setEnabled(isEnabled & canEdit && !isApproved && this.useTaxZone.getElement().isChecked());
        }
        boolean canChangeAmountAnyway = this.provider.isWritable(PurchaseOrderAccess.CHANGE_AMOUNT_ANYWAY);
        this.reactivateAmountChange.setEnabled(isEnabled && canChangeAmountAnyway && e != OrderStateE.CANCELLED);
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.setEnabled(isEnabled && canEdit);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.deliveryAddress.kill();
        this.department.kill();
        this.customer.kill();
        this.deliveryDate.kill();
        this.deliveryWindow.kill();
        this.incoTerms.kill();
        this.reactivateAmountChange.kill();
        this.orderDate.kill();
        this.customerOwnedOnly.kill();
        this.halalOnly.kill();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.kill();
        }
        this.reorder.kill();
        if (this.showTaxZone()) {
            this.useTaxZone.kill();
            this.taxZone.kill();
        }
        this.customerOwnedOnly = null;
        this.halalOnly = null;
        this.deliveryAddress = null;
        this.deliveryDate = null;
        this.deliveryWindow = null;
        this.department = null;
        this.customer = null;
        this.incoTerms = null;
        this.reactivateAmountChange = null;
        this.orderDate = null;
        this.locations = null;
        this.reorder = null;
        this.useTaxZone = null;
        this.taxZone = null;
    }

    @Override
    public void setNode(Node<?> node) {
        super.setNode(node);
        this.deliveryAddress.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.deliveryAddress));
        this.deliveryDate.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.deliveryDate));
        this.deliveryWindow.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.orderDeliveryWindow));
        this.department.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.costCenter));
        this.customer.getElement().setNode(node.getChildNamed(PurchaseOrderLight_.customer));
        this.incoTerms.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.deliveryTerm));
        this.orderDate.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.orderDate));
        if (Boolean.TRUE.equals(node.getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue())) {
            this.customerOwnedOnly.getElement().setText(Words.CUSTOMER_OWNED_ONLY);
        } else if (Boolean.FALSE.equals(node.getChildNamed(PurchaseOrderLight_.customerOwnedOnly).getValue())) {
            this.customerOwnedOnly.getElement().setText(Words.NOT_CUSTOMER_OWNED);
        } else {
            this.customerOwnedOnly.getElement().setText(Words.ALL);
        }
        if (Boolean.TRUE.equals(node.getChildNamed(PurchaseOrderLight_.halalOrder).getValue())) {
            this.halalOnly.getElement().setText(Words.HALAL_ONLY);
        } else if (Boolean.FALSE.equals(node.getChildNamed(PurchaseOrderLight_.halalOrder).getValue())) {
            this.halalOnly.getElement().setText(Words.NOT_HALAL_ONLY);
        } else {
            this.halalOnly.getElement().setText(Words.ALL);
        }
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation())) {
            this.locations.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.eligibleLocations));
        }
        this.reorder.getElement().setNode(node.getChildNamed(PurchaseOrderLight_.reorder));
        if (this.showTaxZone()) {
            this.useTaxZone.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.useTaxZone));
            this.taxZone.getElement().refreshPossibleValues(NodeToolkit.getAffixList(TaxZoneComplete.class));
            this.taxZone.getElement().setNode(node.getChildNamed(PurchaseOrderComplete_.taxZone));
        }
    }

    @Override
    public void requestFocusInWindowNow() {
        this.deliveryDate.requestFocusInWindowNow();
    }

    @Override
    public void switchState(Button.ButtonState newState) {
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        List<ScreenValidationObject> validationObjects = super.validateParagraph();
        if (Boolean.TRUE.equals(this.viewSettings.getShowLocation()) && this.locations != null && this.locations.getElement().isWritable()) {
            if (this.locations.getElement().getNode().getChildCount() == 0) {
                this.locations.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
            } else if (this.locations.getElement().getNode().getChildCount() > 1) {
                this.locations.getElement().setInvalid();
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_EXCALTY_ONE_LOCATION_IS_SET));
            }
        }
        return validationObjects;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryDate.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.orderDate.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.department.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                h = (int)((double)h + ConfigurationDetailsPanel.this.locations.getPreferredSize().getHeight());
                h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            }
            h = (int)((double)h + ConfigurationDetailsPanel.this.incoTerms.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.customerOwnedOnly.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.halalOnly.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.inner_verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.reorder.getPreferredSize().getHeight());
            h += ConfigurationDetailsPanel.this.verticalBorder;
            h = (int)((double)h + ConfigurationDetailsPanel.this.reactivateAmountChange.getPreferredSize().getHeight());
            return new Dimension(0, h += ConfigurationDetailsPanel.this.verticalBorder);
        }

        @Override
        public void layoutContainer(Container parent) {
            int w2tl = (parent.getWidth() - 3 * ConfigurationDetailsPanel.this.horizontalBorder) / 2;
            ConfigurationDetailsPanel.this.deliveryDate.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.deliveryDate.setSize(ConfigurationDetailsPanel.this.deliveryDate.getPreferredSize());
            ConfigurationDetailsPanel.this.orderDate.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.deliveryDate.getY() + ConfigurationDetailsPanel.this.deliveryDate.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.orderDate.setSize(ConfigurationDetailsPanel.this.orderDate.getPreferredSize());
            ConfigurationDetailsPanel.this.department.setLocation(w2tl + ConfigurationDetailsPanel.this.horizontalBorder * 2, ConfigurationDetailsPanel.this.verticalBorder);
            ConfigurationDetailsPanel.this.department.setSize(w2tl, (int)ConfigurationDetailsPanel.this.department.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.customer.setLocation(ConfigurationDetailsPanel.this.department.getX(), ConfigurationDetailsPanel.this.department.getY() + ConfigurationDetailsPanel.this.department.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.customer.setSize(w2tl, (int)ConfigurationDetailsPanel.this.customer.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.deliveryWindow.setLocation(ConfigurationDetailsPanel.this.department.getX(), ConfigurationDetailsPanel.this.customer.getY() + ConfigurationDetailsPanel.this.customer.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryWindow.setSize(w2tl, (int)ConfigurationDetailsPanel.this.deliveryWindow.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.deliveryAddress.setLocation(ConfigurationDetailsPanel.this.department.getX(), ConfigurationDetailsPanel.this.deliveryWindow.getY() + ConfigurationDetailsPanel.this.deliveryWindow.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.deliveryAddress.setSize(w2tl, (int)ConfigurationDetailsPanel.this.deliveryAddress.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.incoTerms.setLocation(ConfigurationDetailsPanel.this.horizontalBorder * 2 + w2tl, ConfigurationDetailsPanel.this.deliveryAddress.getY() + ConfigurationDetailsPanel.this.deliveryAddress.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.incoTerms.setSize(w2tl, (int)ConfigurationDetailsPanel.this.incoTerms.getPreferredSize().getHeight());
            ConfigurationDetailsPanel.this.customerOwnedOnly.setLocation(ConfigurationDetailsPanel.this.horizontalBorder * 2 + w2tl, ConfigurationDetailsPanel.this.incoTerms.getY() + ConfigurationDetailsPanel.this.incoTerms.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.customerOwnedOnly.setSize(w2tl, (int)ConfigurationDetailsPanel.this.customerOwnedOnly.getPreferredSize().getHeight());
            int cy = ConfigurationDetailsPanel.this.customerOwnedOnly.getY() + ConfigurationDetailsPanel.this.customerOwnedOnly.getHeight();
            ConfigurationDetailsPanel.this.halalOnly.setLocation(ConfigurationDetailsPanel.this.horizontalBorder * 2 + w2tl, ConfigurationDetailsPanel.this.customerOwnedOnly.getY() + ConfigurationDetailsPanel.this.customerOwnedOnly.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.halalOnly.setSize(w2tl, (int)ConfigurationDetailsPanel.this.halalOnly.getPreferredSize().getHeight());
            cy = ConfigurationDetailsPanel.this.halalOnly.getY() + ConfigurationDetailsPanel.this.halalOnly.getHeight();
            if (Boolean.TRUE.equals(ConfigurationDetailsPanel.this.viewSettings.getShowLocation())) {
                ConfigurationDetailsPanel.this.locations.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.deliveryAddress.getY());
                ConfigurationDetailsPanel.this.locations.setSize(ConfigurationDetailsPanel.this.locations.getPreferredSize());
                cy = ConfigurationDetailsPanel.this.locations.getY() + ConfigurationDetailsPanel.this.locations.getHeight();
            }
            int ny = cy + ConfigurationDetailsPanel.this.verticalBorder * 3;
            if (ConfigurationDetailsPanel.this.showTaxZone()) {
                ConfigurationDetailsPanel.this.useTaxZone.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, cy + ConfigurationDetailsPanel.this.verticalBorder * 2);
                ConfigurationDetailsPanel.this.useTaxZone.setSize(ConfigurationDetailsPanel.this.useTaxZone.getPreferredSize());
                ConfigurationDetailsPanel.this.taxZone.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ConfigurationDetailsPanel.this.useTaxZone.getY() + ConfigurationDetailsPanel.this.useTaxZone.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
                ConfigurationDetailsPanel.this.taxZone.setSize(w2tl, (int)ConfigurationDetailsPanel.this.taxZone.getPreferredSize().getHeight());
                ny = ConfigurationDetailsPanel.this.taxZone.getY() + ConfigurationDetailsPanel.this.taxZone.getHeight() + ConfigurationDetailsPanel.this.verticalBorder * 3;
            }
            ConfigurationDetailsPanel.this.reorder.setLocation(ConfigurationDetailsPanel.this.halalOnly.getX(), ConfigurationDetailsPanel.this.halalOnly.getY() + ConfigurationDetailsPanel.this.halalOnly.getHeight() + ConfigurationDetailsPanel.this.inner_verticalBorder);
            ConfigurationDetailsPanel.this.reorder.setSize(ConfigurationDetailsPanel.this.reorder.getPreferredSize());
            ConfigurationDetailsPanel.this.reactivateAmountChange.setLocation(ConfigurationDetailsPanel.this.horizontalBorder, ny);
            ConfigurationDetailsPanel.this.reactivateAmountChange.setSize(parent.getWidth() - 2 * ConfigurationDetailsPanel.this.horizontalBorder, (int)ConfigurationDetailsPanel.this.reactivateAmountChange.getPreferredSize().getHeight());
        }
    }
}

