/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.recipe.details;

import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.PriceConverter1;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.CopyRecipeVariantPopup;
import ch.icit.pegasus.client.gui.modules.recipe.RecipeModuleDataHandler;
import ch.icit.pegasus.client.gui.screentemplates.details.AVariantDetailsPanel;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.commiter.FileCommitter;
import ch.icit.pegasus.client.gui.table.commiter.RemoteCommitter;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.AddButton;
import ch.icit.pegasus.client.gui.utils.buttons.ArrowButton;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.DeleteButton;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDDateChooser;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDTextField;
import ch.icit.pegasus.client.gui.utils.skins.SizedSkin1Field;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.recipe.RecipeServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.validator.ValidationUtil;
import ch.icit.pegasus.server.core.dtos.ADTO_;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.IngredientComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantLight_;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantReference;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.RecipeAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class VariantDetailsPanel
extends AVariantDetailsPanel<RecipeComplete> {
    private static final long serialVersionUID = 1L;

    public VariantDetailsPanel(RowEditor<RecipeComplete> editor, RDProvider provider) {
        super((RowEditor)editor, provider);
    }

    @Override
    public Class getCommittingClass(Node<?> node) {
        return RecipeVariantComplete.class;
    }

    @Override
    public List<RemoteCommitter> commitParagraph() {
        ArrayList<RemoteCommitter> a = new ArrayList<RemoteCommitter>();
        Iterator it = this.editor.getModel().getNode().getChildNamed(RecipeComplete_.variants).getFailSafeChildIterator();
        while (it.hasNext()) {
            PegasusFileComplete r;
            Node n = (Node)it.next();
            RecipeVariantLight recipeVariantLight = (RecipeVariantLight)n.getValue(RecipeVariantLight.class);
            Node imageNode = n.getChildNamed(RecipeVariantLight_.imageReference);
            if (imageNode == null || (r = (PegasusFileComplete)imageNode.getValue()) == null || r.getId() != null) continue;
            FileCommitter c = new FileCommitter(r.getLocalFile());
            c.setWriteBackAlgorithm(reference -> {
                imageNode.setValue((Object)reference, 0L);
                recipeVariantLight.setImageReference(reference);
            });
            a.add(c);
        }
        return a;
    }

    @Override
    public List<TableColumnInfo> getColumns() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        int tw = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, false);
        int tw2 = 2 * this.table.getCellPadding() + DateChooser.getPreferredWidth(this, true);
        columns.add(new TableColumnInfo(Words.FROM, null, null, null, "", tw, tw, tw));
        columns.add(new TableColumnInfo(Words.TO, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.COMMENT, null, null, null, "", tw2, tw2, tw2));
        columns.add(new TableColumnInfo(Words.PRICE, null, null, null, "", 100, 100, 100));
        columns.add(new TableColumnInfo(Words.STATE, null, null, null, "", 100, 100, 100));
        tw = 3 * this.table.getCellPadding() + ArrowButton.getPreferredWidth() + DeleteButton.getPreferredWidth(SizedSkin1Field.SkinSize.SMALL);
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(2)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(3)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(4)).setxExpand(0.0);
        ((TableColumnInfo)columns.get(5)).setxExpand(0.0);
        return columns;
    }

    @Override
    public List<ScreenValidationObject> validateParagraph() {
        this.table.updateOrder();
        ArrayList<ScreenValidationObject> validationObjects = new ArrayList<ScreenValidationObject>();
        Date t = new PeriodComplete((Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.startDate}).getValue(), null).getStartDate();
        long toDay = new PeriodComplete(null, new Date(System.currentTimeMillis())).getEndDate().getTime();
        long lastDate = t.getTime();
        --lastDate;
        boolean invalid = false;
        for (Table2RowPanel p : this.table.getRows()) {
            PeriodComplete periodComplete;
            Date date;
            validationObjects.addAll(((TableRowImpl)p).validateRow());
            RecipeVariantLight v = (RecipeVariantLight)p.getModel().getNode().getValue(RecipeVariantLight.class);
            Date s = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.startDate}).getValue();
            Date e = (Date)p.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.endDate}).getValue();
            if (v.getValidityPeriod().getEndDate().getTime() > toDay && e.getTime() < toDay && p.getModel().getNode().getChildNamed(RecipeVariantLight_.state).getValue() == ModificationStateE.ACCEPTED && !this.provider.isWritable(RecipeAccess.EDIT_OLD_VARIANT)) {
                validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.THE_END_DATE_ACCEPTED_VARIANT_MUST_BE_AFTER_TODAY));
            }
            if (lastDate + 1L != (date = (periodComplete = new PeriodComplete(s, e)).getStartDate()).getTime()) {
                invalid = true;
            }
            date = periodComplete.getEndDate();
            lastDate = date.getTime();
        }
        Date d = (Date)this.editor.getModel().getNode().getChildNamed(new DtoField[]{RecipeComplete_.period, PeriodComplete_.endDate}).getValue();
        long endDate = new PeriodComplete(null, d).getEndDate().getTime();
        if (lastDate != endDate) {
            invalid = true;
        }
        if (invalid) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.ENSURE_THE_GIVEN_VARIANTS_AREN_T_OVERLAPPING_AVOID_GABS));
        }
        if (this.table.getRowCount() == 0) {
            validationObjects.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, Words.EVERY_RECIPE_NEEDS_AT_LEAST_ONE_VARIANT));
        }
        return validationObjects;
    }

    @Override
    public Table2RowPanel getTableRow(Table2RowModel model) {
        return new TableRowImpl(model);
    }

    @Override
    public void reloadVariant(final Node n, final Table2RowPanel panel) {
        this.editor.showCommittingAnimation(Words.LOAD_DATA);
        this.editor.setEnabled(false);
        RecipeVariantComplete c = (RecipeVariantComplete)n.getValue(RecipeVariantComplete.class);
        if (c == null) {
            ThreadSafeExecutable run = new ThreadSafeExecutable(this){

                @Override
                public Node<?> loadData() throws Exception {
                    Node node = n;
                    SystemSettingsComplete s = (SystemSettingsComplete)((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached().getValue();
                    RecipeVariantComplete cc = (RecipeVariantComplete)((RecipeServiceManager)ServiceManagerRegistry.getService(RecipeServiceManager.class)).getRecipeVariant((RecipeVariantReference)((RecipeVariantLight)n.getValue(RecipeVariantLight.class))).getValue();
                    n.removeExistingValues();
                    n.setValue((Object)cc, 0L);
                    Iterator it = node.getChildNamed(RecipeVariantComplete_.ingredients).getChilds();
                    while (it.hasNext()) {
                        Node n2 = (Node)it.next();
                        RecipeModuleDataHandler.processIt((Node<IngredientComplete>)n2);
                    }
                    return n;
                }

                @Override
                public RemoteLoader getInvoker() {
                    return new RemoteLoader(){

                        public void remoteObjectLoaded(Node<?> node) {
                            VariantDetailsPanel.this.updatePanels(node, panel);
                            VariantDetailsPanel.this.editor.createFocusCycle();
                        }

                        public void errorOccurred(ClientException exception) {
                            VariantDetailsPanel.this.errorOccurred(exception);
                        }
                    };
                }

                @Override
                public long getID() {
                    return 0L;
                }
            };
            ThreadSafeLoader.run(run);
        } else {
            RecipeVariantComplete variant = (RecipeVariantComplete)n.getValue(RecipeVariantComplete.class);
            n.removeExistingValues();
            n.setValue((Object)variant, 0L);
            this.updatePanels(n, panel);
            this.editor.createFocusCycle();
        }
    }

    @Override
    public boolean isVariantParent(Node<?> node) {
        return node.getValue() instanceof RecipeComplete;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private RDDateChooser startDate;
        private RDDateChooser endDate;
        private TextLabel price;
        private TextLabel state;
        private RDTextField comment;
        private AddButton cloneButton;
        private DeleteButton delete;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.setSelectable(true);
            boolean isAccepted = m.getNode().getChildNamed(RecipeVariantLight_.state).getValue() == ModificationStateE.ACCEPTED;
            this.startDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.startDate.setOverrideName(RecipeAccess.EDIT_VARIANT);
            this.startDate.setNode(m.getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.startDate}));
            this.endDate = new RDDateChooser(VariantDetailsPanel.this.provider);
            this.endDate.setOverrideName(RecipeAccess.EDIT_VARIANT);
            this.endDate.setCheckBoxEnabled();
            this.endDate.setNode(m.getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.endDate}));
            this.state = new TextLabel(m.getNode().getChildNamed(RecipeVariantLight_.state), ConverterRegistry.getConverter(ModificationStateEConverter.class));
            this.price = new TextLabel(m.getNode().getChildNamed(RecipeVariantLight_.price), ConverterRegistry.getConverter(PriceConverter1.class));
            this.comment = new RDTextField(VariantDetailsPanel.this.provider, TextFieldType.NORMAL);
            this.comment.setNode(m.getNode().getChildNamed(RecipeVariantLight_.internalVariantComment));
            boolean isDeletable = VariantDetailsPanel.this.provider.isWritable(RecipeAccess.REMOVE_VARIANT) && m.getNode().getChildNamed(RecipeVariantLight_.state).getValue() != ModificationStateE.ACCEPTED;
            boolean isAddable = VariantDetailsPanel.this.provider.isWritable(RecipeAccess.ADD_VARIANT);
            if (isDeletable && !isAccepted) {
                this.delete = new DeleteButton();
            }
            if (isAddable && m.getNode().getChildNamed(ADTO_.id).getValue() != null) {
                this.cloneButton = new AddButton();
            }
            if (this.delete != null) {
                this.delete.addButtonListener(this);
            }
            if (this.cloneButton != null) {
                this.cloneButton.addButtonListener(this);
            }
            this.setLayout(new Layout());
            this.add(this.startDate);
            this.add(this.endDate);
            this.add(this.price);
            this.add(this.state);
            this.add(this.comment);
            if (this.cloneButton != null) {
                this.add(this.cloneButton);
            }
            if (this.delete != null) {
                this.add(this.delete);
            }
        }

        @Override
        public Color getRowColor(Table2RowPanel p) {
            boolean isNew;
            boolean bl = isNew = this.model.getNode().getChildNamed(DtoFieldConstants.NEW_ONE) != null;
            if (isNew) {
                Color background = new Color(100, 100, 100);
                return background;
            }
            return this.model.getParentModel().getTable().getColor4Index(this.colorIndex);
        }

        @Override
        public void updateRow(Node<?> node) {
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.startDate.kill();
            this.endDate.kill();
            this.price.kill();
            this.state.kill();
            if (this.delete != null) {
                this.delete.kill();
            }
            if (this.cloneButton != null) {
                this.cloneButton.kill();
            }
            this.comment.kill();
            this.startDate = null;
            this.endDate = null;
            this.price = null;
            this.state = null;
            this.delete = null;
            this.cloneButton = null;
            this.comment = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.startDate);
            CheckedListAdder.addToList(focusList, this.endDate);
            CheckedListAdder.addToList(focusList, this.comment);
            CheckedListAdder.addToList(focusList, this.cloneButton);
            CheckedListAdder.addToList(focusList, this.delete);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.startDate.getNode().getValue();
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.startDate.setEnabled(isEnabled);
            this.endDate.setEnabled(isEnabled);
            this.price.setEnabled(isEnabled);
            this.state.setEnabled(isEnabled);
            this.comment.setEnabled(isEnabled);
            if (this.delete != null) {
                this.delete.setEnabled(isEnabled);
            }
            if (this.cloneButton != null) {
                this.cloneButton.setEnabled(isEnabled);
            }
        }

        protected List<ScreenValidationObject> validateRow() {
            return ValidationUtil.validatePeriod((Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.startDate}), (Node<Date>)this.getModel().getNode().getChildNamed(new DtoField[]{RecipeVariantLight_.validityPeriod, PeriodComplete_.endDate}), this.startDate, this.endDate);
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.delete) {
                this.model.getNode().getParent().removeChild(this.model.getNode(), System.currentTimeMillis());
            } else if (source == this.cloneButton) {
                InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
                popUp.setAttributes(this.cloneButton, true, true, Words.COPY_VARIANT);
                popUp.setView(new CopyRecipeVariantPopup(this.model.getNode()));
                popUp.showPopUp(x, y, -1, -1, (source1, xargs) -> {
                    if (xargs == null) {
                        return;
                    }
                    Node nNode = (Node)xargs[0];
                    VariantDetailsPanel.this.table.getModel().getNode().addChild(nNode, 0L);
                    for (Table2RowPanel p : VariantDetailsPanel.this.table.getRows()) {
                        TableRowImpl i = (TableRowImpl)p;
                        i.enableVariantEdit();
                    }
                }, this.cloneButton);
            }
        }

        protected void enableVariantEdit() {
            this.startDate.showEditorAnyWay();
            this.endDate.showEditorAnyWay();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int currentX = 0;
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                TableRowImpl.this.startDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.startDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.startDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.startDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.endDate.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.endDate.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.endDate.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.endDate.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(2);
                TableRowImpl.this.comment.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.comment.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.comment.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.comment.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(3);
                TableRowImpl.this.price.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.price.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.price.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.price.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(4);
                TableRowImpl.this.state.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.state.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.state.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.state.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(5);
                TableRowImpl.this.setControlsX(currentX);
                int ax = currentX + TableRowImpl.this.getCellPadding();
                if (TableRowImpl.this.cloneButton != null) {
                    TableRowImpl.this.cloneButton.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cloneButton.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.cloneButton.setSize(TableRowImpl.this.cloneButton.getPreferredSize());
                    ax = TableRowImpl.this.cloneButton.getX() + TableRowImpl.this.cloneButton.getWidth() + TableRowImpl.this.getCellPadding();
                }
                if (TableRowImpl.this.delete != null) {
                    TableRowImpl.this.delete.setLocation(ax, (int)(((double)parent.getHeight() - TableRowImpl.this.delete.getPreferredSize().getHeight()) / 2.0));
                    TableRowImpl.this.delete.setSize(TableRowImpl.this.delete.getPreferredSize());
                }
            }
        }
    }
}

