/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.reporting.insert;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.gui.modules.masterdata.panels.DefaultDataInsert;
import ch.icit.pegasus.client.gui.modules.reporting.ReportingModule;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.buttons.TablePanelAddSaveButton;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.file.FileChooserUtil;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.analysis.KPIAnalysisReportConfiguration;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ReportingAccess;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.util.List;

public class SCMKPIInsert
extends DefaultDataInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledPeriodEditor period;
    private TitledItem<CheckBox> detailed;
    private TitledItem<CheckBox> receive;
    private TitledItem<CheckBox> hl1;
    private TitledItem<CheckBox> hl2;
    private TablePanelAddSaveButton printButton;
    private ReportingModule module;
    private boolean accesshl1;
    private boolean accesshl2;
    private boolean accessreceive;

    public SCMKPIInsert(ReportingModule module) {
        super(module);
        this.module = module;
        this.startAnimation("Load Data");
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return SCMKPIInsert.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void insertElements() {
        RDProvider p = new RDProvider(HUDToolkit.getCurrentAccessRight(ReportingAccess.MODULE_REPORTING, ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser()), false);
        this.accesshl1 = p.isWritable(ReportingAccess.SCM_KPI_HL1);
        this.accesshl2 = p.isWritable(ReportingAccess.SCM_KPI_HL1);
        this.accessreceive = p.isWritable(ReportingAccess.SCM_KPI_HL1);
        Node periodNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)new PeriodComplete(new Date(System.currentTimeMillis()), new Date(System.currentTimeMillis())), false, false);
        this.period = new TitledPeriodEditor((Node<PeriodComplete>)periodNode, true, null);
        this.detailed = new TitledItem<CheckBox>(new CheckBox(), Words.DETAILED, TitledItem.TitledItemOrientation.EAST);
        if (this.accesshl1) {
            this.hl1 = new TitledItem<CheckBox>(new CheckBox(), "Include HL 1", TitledItem.TitledItemOrientation.EAST);
            this.hl1.getElement().setChecked(true);
        }
        if (this.accesshl2) {
            this.hl2 = new TitledItem<CheckBox>(new CheckBox(), "Include HL 2", TitledItem.TitledItemOrientation.EAST);
            this.hl2.getElement().setChecked(true);
        }
        if (this.accessreceive) {
            this.receive = new TitledItem<CheckBox>(new CheckBox(), "Include Receive", TitledItem.TitledItemOrientation.EAST);
            this.receive.getElement().setChecked(true);
        }
        this.printButton = new TablePanelAddSaveButton();
        this.printButton.setText("Start");
        this.printButton.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.period);
        this.add(this.detailed);
        this.add(this.printButton);
        if (this.accesshl1) {
            this.add(this.hl1);
        }
        if (this.accesshl2) {
            this.add(this.hl2);
        }
        if (this.accessreceive) {
            this.add(this.receive);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        if (this.isInserted) {
            this.period.setEnabled(isEnabled);
            this.detailed.setEnabled(isEnabled);
            this.printButton.setEnabled(isEnabled);
            if (this.accesshl1) {
                this.hl1.setEnabled(isEnabled);
            }
            if (this.accesshl2) {
                this.hl2.setEnabled(isEnabled);
            }
            if (this.accessreceive) {
                this.receive.setEnabled(isEnabled);
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.isInserted) {
            this.period.kill();
            this.printButton.kill();
            this.detailed.kill();
            if (this.accesshl1) {
                this.hl1.kill();
            }
            if (this.accesshl2) {
                this.hl2.kill();
            }
            if (this.accessreceive) {
                this.receive.kill();
            }
        }
        this.period = null;
        this.printButton = null;
        this.detailed = null;
        this.hl1 = null;
        this.hl2 = null;
        this.receive = null;
    }

    @Override
    public Node getNode() {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateInsert() {
        return null;
    }

    @Override
    public String getInsertName() {
        return "SCM KPI";
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        List<ScreenValidationObject> a = this.period.validateContent();
        if (a != null && !a.isEmpty()) {
            InnerPopupFactory.showErrorDialog(a, "Unable to start Analysis", (Component)this);
            return;
        }
        this.module.started();
        this.startAnimation("Create SCM KPI Report");
        this.setEnabled(false);
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Node n = new Node();
                try {
                    PegasusFileComplete ret;
                    PeriodComplete selectedPeriod = SCMKPIInsert.this.period.getPeriod();
                    KPIAnalysisReportConfiguration configuration = new KPIAnalysisReportConfiguration();
                    configuration.setPeriod(selectedPeriod);
                    configuration.setShowDetails(Boolean.valueOf(((CheckBox)SCMKPIInsert.this.detailed.getElement()).isChecked()));
                    if (SCMKPIInsert.this.accesshl1) {
                        configuration.setIncludeHL1(Boolean.valueOf(((CheckBox)SCMKPIInsert.this.hl1.getElement()).isChecked()));
                    }
                    if (SCMKPIInsert.this.accesshl2) {
                        configuration.setIncludeHL2(Boolean.valueOf(((CheckBox)SCMKPIInsert.this.hl2.getElement()).isChecked()));
                    }
                    if (SCMKPIInsert.this.accessreceive) {
                        configuration.setIncludeReceive(Boolean.valueOf(((CheckBox)SCMKPIInsert.this.receive.getElement()).isChecked()));
                    }
                    if ((ret = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createSCMKPI(configuration).getValue()) != null) {
                        PegasusFileComplete frc = ret;
                        try {
                            File rfile = FileTransferUtil.download((PegasusFileComplete)frc, (FileTransferListener[])new FileTransferListener[0]);
                            n.setValue((Object)rfile, 0L);
                            return n;
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (Exception e) {
                    n.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage()), 0L);
                }
                return n;
            }

            @Override
            public RemoteLoader getInvoker() {
                return new RemoteLoader(){

                    public void remoteObjectLoaded(Node<?> node) {
                        SCMKPIInsert.this.stopAnimation();
                        SCMKPIInsert.this.module.ended();
                        File file = (File)node.getValue(File.class);
                        SCMKPIInsert.this.showSaveDialog(file);
                    }

                    public void errorOccurred(ClientException exception) {
                        SCMKPIInsert.this.errorOccurred(exception);
                    }
                };
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    private File showSaveDialog(final File file) {
        File selectedFile = null;
        try {
            MainFrame.isTempRelease = true;
            File fileName = FileChooserUtil.saveFile(".xlsx");
            if (fileName != null) {
                final File ssF = selectedFile = fileName;
                if (selectedFile.exists()) {
                    InnerPopupFactory.showDesicionPopup("File already exists", "File already exists. Do you want to override it?", this.printButton, new InnerPopUpListener2(){

                        @Override
                        public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
                            if (xargs != null) {
                                SCMKPIInsert.this.saveFileTo(file, ssF);
                            } else {
                                SCMKPIInsert.this.module.ended();
                                SCMKPIInsert.this.setEnabled(true);
                            }
                        }
                    }, 150, 100);
                } else {
                    this.saveFileTo(file, selectedFile);
                }
            } else {
                this.module.ended();
                this.setEnabled(true);
            }
            MainFrame.isTempRelease = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return selectedFile;
    }

    private void saveFileTo(File file, File path) {
        try {
            String p = path.getPath();
            p = FileChooserUtil.ensureFilePath(p, ReportingOutputFormatE.XLSX);
            if (file != null) {
                file.renameTo(new File(p));
            }
            this.setEnabled(true);
            InnerPopupFactory.showMessageDialog("SCM KPI successfully exported!", this);
        }
        catch (Exception e) {
            e.printStackTrace();
            InnerPopupFactory.showErrorDialog("Unable to export SCM KPI!", (Component)this);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension();
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 10;
            if (SCMKPIInsert.this.animation != null) {
                SCMKPIInsert.this.animation.setLocation((int)((double)parent.getWidth() - SCMKPIInsert.this.animation.getPreferredSize().getWidth()) / 2, (int)((double)parent.getHeight() - SCMKPIInsert.this.animation.getPreferredSize().getHeight()) / 2);
                SCMKPIInsert.this.animation.setSize(SCMKPIInsert.this.animation.getPreferredSize());
            }
            if (SCMKPIInsert.this.isInserted) {
                SCMKPIInsert.this.period.setLocation(border, border);
                SCMKPIInsert.this.period.setSize(SCMKPIInsert.this.period.getPreferredSize());
                int currentY = SCMKPIInsert.this.period.getY() + SCMKPIInsert.this.period.getHeight();
                if (SCMKPIInsert.this.accesshl1) {
                    SCMKPIInsert.this.hl1.setLocation(border, currentY + border);
                    SCMKPIInsert.this.hl1.setSize(SCMKPIInsert.this.hl1.getPreferredSize());
                    currentY = SCMKPIInsert.this.hl1.getY() + SCMKPIInsert.this.hl1.getHeight();
                }
                if (SCMKPIInsert.this.accesshl2) {
                    SCMKPIInsert.this.hl2.setLocation(border, currentY + border);
                    SCMKPIInsert.this.hl2.setSize(SCMKPIInsert.this.hl2.getPreferredSize());
                    currentY = SCMKPIInsert.this.hl2.getY() + SCMKPIInsert.this.hl2.getHeight();
                }
                if (SCMKPIInsert.this.accessreceive) {
                    SCMKPIInsert.this.receive.setLocation(border, currentY + border);
                    SCMKPIInsert.this.receive.setSize(SCMKPIInsert.this.receive.getPreferredSize());
                    currentY = SCMKPIInsert.this.receive.getY() + SCMKPIInsert.this.receive.getHeight();
                }
                SCMKPIInsert.this.detailed.setLocation(border, currentY + border);
                SCMKPIInsert.this.detailed.setSize(SCMKPIInsert.this.detailed.getPreferredSize());
                SCMKPIInsert.this.printButton.setLocation((int)((double)parent.getWidth() - ((double)border + SCMKPIInsert.this.printButton.getPreferredSize().getWidth())), (int)((double)parent.getHeight() - ((double)border + SCMKPIInsert.this.printButton.getPreferredSize().getHeight())));
                SCMKPIInsert.this.printButton.setSize(SCMKPIInsert.this.printButton.getPreferredSize());
            }
        }
    }
}

