/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.requisitionorder.manualcreator;

import ch.icit.pegasus.client.actions.impl.PrintRequisitionOrderForDeliver;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.TableModel;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ProxyNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.supply.OrderServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.SystemSettingsServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.ProgressListener;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationList;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.ordering.RequisitionOrderPositionComplete_;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionMutationRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionReceivingRemarkComplete;
import ch.icit.pegasus.server.core.dtos.ordering.transaction.remark.OrderPositionRejectionRemarkComplete;
import ch.icit.pegasus.server.core.dtos.store.StorePositionLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.sql.Date;
import java.sql.Time;
import java.util.ArrayList;
import java.util.Iterator;

public class ManualRequisitionOrderCreatorDataHandler
implements IDataHandler {
    private UserComplete currentUser;

    public ManualRequisitionOrderCreatorDataHandler(UserComplete currentUser) {
        this.currentUser = currentUser;
    }

    @Override
    public String getRemoteValidationText() {
        return "Load Article Prices";
    }

    public void doRemoteValidation(final Node readNode, final RemoteLoader listener, ProgressListener l, boolean validateAll) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
                Node oldNode = readNode;
                Iterator it2 = readNode.getFailSafeChildIterator();
                boolean deliverDepartmentMissing = false;
                boolean orderDepartmentMissing = false;
                boolean requiredOnMissing = false;
                boolean requiredTimeMissing = false;
                boolean receiveStoreMissing = false;
                boolean articleMissing = false;
                boolean quantityMissing = false;
                while (it2.hasNext()) {
                    Node node = (Node)it2.next();
                    CostCenterComplete deliveredBy = (CostCenterComplete)node.getChildNamed(RequisitionOrderComplete_.deliveredBy).getValue();
                    CostCenterComplete orderedBy = (CostCenterComplete)node.getChildNamed(RequisitionOrderComplete_.requiredBy).getValue();
                    if (deliveredBy == null) {
                        deliverDepartmentMissing = true;
                    }
                    if (orderedBy == null) {
                        orderDepartmentMissing = true;
                    }
                    Date requiredOn = (Date)node.getChildNamed(RequisitionOrderComplete_.requiredOn).getValue();
                    Time requiredTime = (Time)node.getChildNamed(RequisitionOrderComplete_.requiredTime).getValue();
                    if (requiredOn == null) {
                        requiredOnMissing = true;
                    }
                    if (requiredTime == null) {
                        requiredTimeMissing = true;
                    }
                    Iterator it3 = node.getChildNamed(RequisitionOrderComplete_.orderPositions).getFailSafeChildIterator();
                    while (it3.hasNext()) {
                        Node position = (Node)it3.next();
                        StorePositionLight receivePosition = (StorePositionLight)position.getChildNamed(RequisitionOrderPositionComplete_.receivingStore).getValue();
                        BasicArticleLight article = (BasicArticleLight)position.getChildNamed(RequisitionOrderPositionComplete_.article).getValue();
                        StoreQuantityComplete qty = (StoreQuantityComplete)position.getChildNamed(RequisitionOrderPositionComplete_.quantity).getValue();
                        if (receivePosition == null) {
                            receiveStoreMissing = true;
                        }
                        if (article == null) {
                            articleMissing = true;
                        }
                        if (qty == null) {
                            quantityMissing = true;
                        }
                        while (position instanceof ProxyNode) {
                            position = ((ProxyNode)position).getRefNode();
                        }
                        position.commitThis(RequisitionOrderPositionComplete.class);
                    }
                    node.commit(RequisitionOrderComplete.class);
                }
                if (deliverDepartmentMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Deliver Departments are set"));
                }
                if (orderDepartmentMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Order Departments are set"));
                }
                if (requiredOnMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Delivery Date is set"));
                }
                if (requiredTimeMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure Delivery Time is set"));
                }
                if (receiveStoreMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all receiveing Stores are set"));
                }
                if (articleMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all Articles are set"));
                }
                if (quantityMissing) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Ensure all quantities are set"));
                }
                Node retNode = new Node();
                if (!a.isEmpty()) {
                    retNode.setValue(a, 0L);
                }
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return listener;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void updateData(Node node, RemoteLoader model, ProgressListener l) {
    }

    @Override
    public long getLoadingID() {
        return 0L;
    }

    public Class<?> getCommittingClass() {
        return null;
    }

    public void createOrders(final Component source, final Node orderList, final RemoteLoader model, final ProgressListener l, final boolean send) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Iterator it = orderList.getFailSafeChildIterator();
                ScreenValidationList messages = new ScreenValidationList();
                while (it.hasNext()) {
                    String orderName;
                    Node n = (Node)it.next();
                    n.commit(RequisitionOrderComplete.class, true);
                    l.stateChanged(Words.CREATE_ORDERS);
                    RequisitionOrderComplete order = (RequisitionOrderComplete)n.getValue(RequisitionOrderComplete.class);
                    int c = 0;
                    for (RequisitionOrderPositionComplete p : order.getOrderPositions()) {
                        p.setOrder(order);
                        p.setSequenceNumber(Integer.valueOf(c));
                        ++c;
                    }
                    Iterator it23 = order.getOrderPositions().iterator();
                    boolean emptyPositions = false;
                    while (it23.hasNext()) {
                        RequisitionOrderPositionComplete pos = (RequisitionOrderPositionComplete)it23.next();
                        if (pos.getQuantity().getAmount() > 0L) continue;
                        it23.remove();
                        emptyPositions = true;
                    }
                    String string = orderName = order.getRequiredBy() != null ? order.getRequiredBy().getCode() : "no order department";
                    if (order.getOrderPositions().isEmpty()) {
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Order to " + orderName + " was removed, because the order has no positions."));
                    } else if (emptyPositions) {
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, "Some positions from Order to " + orderName + " were removed, because the order amount was 0."));
                    }
                    if (order.getOrderPositions().size() <= 0) continue;
                    SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                    if (order.getEligibleLocations().isEmpty()) {
                        order.getEligibleLocations().add(((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentLocation().getValue());
                    }
                    try {
                        RequisitionOrderComplete nO = (RequisitionOrderComplete)((OrderServiceManager)ServiceManagerRegistry.getService(OrderServiceManager.class)).createRequisitionOrder(order).getValue();
                        if (send) {
                            try {
                                PrintRequisitionOrderForDeliver printer = new PrintRequisitionOrderForDeliver();
                                printer.performAction(source, l, nO, settings);
                            }
                            catch (Exception e) {
                                InnerPopupFactory.showErrorDialog(e, source);
                            }
                        }
                        messages.add((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.MESSAGE, "Order to " + orderName + " successfully placed"));
                    }
                    catch (Exception e) {
                        ScreenValidationObject v = new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, e.getMessage());
                        messages.add((Object)v);
                    }
                }
                Node retNode = new Node();
                retNode.setValue((Object)messages, 0L);
                return retNode;
            }

            @Override
            public RemoteLoader getInvoker() {
                return model;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    public void createNewData(Node node, RemoteLoader model, boolean sameNode, ProgressListener l) {
    }

    public Node resetData(Node node) {
        return null;
    }

    @Override
    public void loadMasterData(final long id, final RemoteLoader loader, final ProgressListener progressListener) {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                progressListener.stateChanged("Load Module 1/7");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionReceivingRemarkComplete.class);
                progressListener.stateChanged("Load Module 2/7");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionRejectionRemarkComplete.class);
                progressListener.stateChanged("Load Module 3/7");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(OrderPositionMutationRemarkComplete.class);
                progressListener.stateChanged("Load Module 4/7");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getSettingsCached();
                progressListener.stateChanged("Load Module 5/7");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                progressListener.stateChanged("Load Module 6/7");
                ((SystemSettingsServiceManager)ServiceManagerRegistry.getService(SystemSettingsServiceManager.class)).getAllLocationsCached();
                progressListener.stateChanged("Load Module 7/7");
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(InternalCostCenterComplete.class);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return loader;
            }

            @Override
            public long getID() {
                return id;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public void setModel(TableModel model) {
    }

    public Node createEmptyNode() {
        return null;
    }

    public boolean reloadDataBeforeOpening(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return false;
    }

    public boolean reloadDataAfterClosing(Node node, RemoteLoader listener, ProgressListener progressListener) {
        return this.reloadDataBeforeOpening(node, listener, progressListener);
    }
}

