/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.sob;

import ch.icit.pegasus.client.converter.CustomerCodeConverter;
import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightReturnsCountStateConverter;
import ch.icit.pegasus.client.converter.FlightStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.LegFromAirportConverter;
import ch.icit.pegasus.client.converter.LegToAirportConverter;
import ch.icit.pegasus.client.converter.SOBIrregularityConverter;
import ch.icit.pegasus.client.converter.SOBStateConverter;
import ch.icit.pegasus.client.converter.StowingListNameConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.gui.modules.Module;
import ch.icit.pegasus.client.gui.modules.flight.details.BondedEquipmentSealsDetailsPanel;
import ch.icit.pegasus.client.gui.modules.flight.details.SealDefinitionDetailsPanel;
import ch.icit.pegasus.client.gui.modules.sob.SalesOnBoardModuleDataHandler;
import ch.icit.pegasus.client.gui.modules.sob.details.SOBDetailsPanel;
import ch.icit.pegasus.client.gui.screentemplates.overview.ScreenTableView;
import ch.icit.pegasus.client.gui.screentemplates.overview.data.IDataHandler;
import ch.icit.pegasus.client.gui.table.CombinedDetailsParagraph;
import ch.icit.pegasus.client.gui.table.MessageProvidedRowEditor;
import ch.icit.pegasus.client.gui.table.RowEditor;
import ch.icit.pegasus.client.gui.table.RowEditorFactory;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.Table;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiHaulTypeSelectionComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiSelectionPanel;
import ch.icit.pegasus.client.gui.utils.datechooser.TitledPeriodEditor;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.search.SearchAlgorithm;
import ch.icit.pegasus.client.search.controller.SearchAlgorithmRegistry;
import ch.icit.pegasus.client.search.impls.remote.FlightSearchAlgorithm;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.dataexchange.RetailInMotionSettingsComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight_;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.IStowingListLight;
import ch.icit.pegasus.server.core.dtos.masterdata.HaulTypeComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.AccessDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.AFlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.SalesOnBoardAccess;
import ch.icit.pegasus.server.core.dtos.search.FlightScheduleSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.search.FlightSearchConfiguration;
import ch.icit.pegasus.server.core.dtos.sob.SalesOnBoardStateE;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.general.ASearchConfiguration;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import ch.icit.pegasus.server.core.search.SortDirection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class SalesOnBoardModule
extends ScreenTableView<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN>
implements Module {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_SEARCH_FLIGHT_NUMBER = "flight_number";
    private static final String FILTER_STATE = "flight_state";
    private static final String FILTER_PERIOD = "flight_period";
    private static final String FILTER_CARRIER = "flight_carrier";
    private static final String FILTER_SOB_STATE = "flightSobState";
    private static final String FILTER_HAUL_TYPE = "flightHaulType";
    private static final String FILTER_RC_STATE = "rcState";
    private static final String FILTER_IRREGULARITY = "irState";
    private String filterCriteria1;
    private FlightStateE filterCriteria2;
    private PeriodComplete filterCriteria3;
    private CustomerLight filterCriteria4;
    private TitledPeriodEditor periodeditor;
    private SalesOnBoardStateE sobState;
    private ReturnsCountStateE rcState;
    private List<HaulTypeComplete> haulType;
    private Boolean irregularity;
    public static IStowingListLight currentStowingList;
    private ComboBox irCombo;
    private ComboBox stateCombo;
    private ComboBox sobstateCombo;
    private ComboBox rcStateCombo;
    private MultiSelectionPanel<MultiHaulTypeSelectionComboBox> haulPanel;
    private ComboBox periodSearchMode;
    private Boolean haultypeActivated = Boolean.FALSE;
    private boolean ignoreCancelledFlights;

    public SalesOnBoardModule() {
        super(FlightLight.class);
        this.isSynchronSearch = false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.periodeditor.kill();
        this.stateCombo.kill();
        this.sobstateCombo.kill();
        this.rcStateCombo.kill();
        this.haulPanel.kill();
        this.periodSearchMode.kill();
        this.irCombo.kill();
        this.periodeditor = null;
        this.stateCombo = null;
        this.sobstateCombo = null;
        this.rcStateCombo = null;
        this.haulPanel = null;
        this.periodSearchMode = null;
        this.irCombo = null;
    }

    @Override
    public AccessDefinitionComplete getInvoker() {
        return SalesOnBoardAccess.MODULE_SALES_ON_BOARD;
    }

    @Override
    public FilterChainConfiguration getDefaultConfiguration() {
        FilterChainConfiguration c = new FilterChainConfiguration();
        c.addProperty("sortedColumn", FlightScheduleSearchConfiguration.FLIGHT_SCHEDULE_COLUMN.OUTBOUND_CODE + "<>" + true);
        c.addProperty(FILTER_PERIOD, FilterChainConfiguration.getDefaultSearchPeriodString());
        return c;
    }

    @Override
    protected void createFilterChain(long id) {
        this.stateCombo = ComboBoxFactory.getFlightStateComboBox(true);
        this.filterChain.addSearchField(FILTER_SEARCH_FLIGHT_NUMBER, Words.FLIGHT_NUMBER, "");
        this.filterChain.addSelectionComboBox(this.stateCombo, FILTER_STATE, Words.STATE, Words.ALL);
        this.periodSearchMode = new ComboBox();
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.stdOnly);
        this.periodSearchMode.addItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        this.periodSearchMode.setSelectedItem(FlightSearchConfiguration.FLIGHT_STD_STA.staStd);
        PeriodComplete p = FilterChainConfiguration.getDefaultSearchPeriod();
        this.periodeditor = this.filterChain.addPeriodSelection(FILTER_PERIOD, p.getStartDate(), p.getEndDate(), "", true);
        this.periodeditor.setCommitOnFocusLost(true);
        this.periodeditor.setComboBox(this.periodSearchMode);
        this.periodeditor.setComboBoxWidth(100);
        this.filterChain.addCustomerSearchField(FILTER_CARRIER);
        this.sobstateCombo = new ComboBox();
        this.sobstateCombo.addItem(Words.ALL);
        this.sobstateCombo.addItem(WordsToolkit.toCapitalLetter((String)Words.NONE));
        this.sobstateCombo.addItem(Words.SENT);
        this.sobstateCombo.addItem(Words.RECEIVED);
        this.sobstateCombo.setSelectedItem(Words.ALL);
        this.filterChain.addSelectionComboBox(this.sobstateCombo, 90, FILTER_SOB_STATE, Words.SOB_STATE, FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.ALL);
        this.irCombo = ComboBoxFactory.getSobIRStateComboBox(true);
        this.filterChain.addSelectionComboBox(this.irCombo, 120, FILTER_IRREGULARITY, Words.IRREGULARITY, Words.ALL);
        this.rcStateCombo = ComboBoxFactory.getReturnCountStateComboBox(true);
        this.filterChain.addSelectionComboBox(this.rcStateCombo, FILTER_RC_STATE, Words.RC_STATE, Words.ALL);
        MultiHaulTypeSelectionComboBox haulCombo = new MultiHaulTypeSelectionComboBox(INodeCreator.getDefaultImpl().createNodes(new ArrayList(), false));
        this.haulPanel = new MultiSelectionPanel<MultiHaulTypeSelectionComboBox>(haulCombo);
        this.haulPanel.setShouldPersist(true);
        this.filterChain.addMultiSelection(this.haulPanel, FILTER_HAUL_TYPE, Words.HAUL_TYPE);
        this.filterChain.addResetButton();
        this.filterChain.overrideDefaultComboBoxWidth(140);
        this.filterChain.overrideDefaultSearchBoxWidth(140);
        this.filterChain.overrideDefaultSearchField2Width(130);
    }

    @Override
    public ASearchConfiguration<FlightLight, FlightSearchConfiguration.FLIGHT_COLUMN> getModuleSearchParameters(Object name, Object value, boolean isReset, boolean getEmptyConfig, Component source) {
        if (isReset) {
            this.filterCriteria1 = null;
            this.filterCriteria2 = null;
            this.filterCriteria4 = null;
            this.sobState = null;
            this.periodeditor.setCheckBoxChecked(false);
            this.haultypeActivated = Boolean.FALSE;
            this.rcState = null;
            this.irregularity = null;
            this.ignoreCancelledFlights = false;
        } else if (name == FILTER_SEARCH_FLIGHT_NUMBER) {
            this.filterCriteria1 = (String)value;
        } else if (name == FILTER_STATE) {
            if (value instanceof FlightStateE) {
                this.filterCriteria2 = (FlightStateE)value;
                this.ignoreCancelledFlights = false;
            } else if (value instanceof String) {
                if (value.equals(Words.ALL)) {
                    this.filterCriteria2 = null;
                    this.ignoreCancelledFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED)) {
                    this.filterCriteria2 = null;
                    this.ignoreCancelledFlights = false;
                } else if (value.equals(Words.ALL_EXCEPT_PLANNED_AND_CANCELLED)) {
                    this.filterCriteria2 = null;
                    this.ignoreCancelledFlights = true;
                } else {
                    this.ignoreCancelledFlights = true;
                }
            } else {
                this.filterCriteria2 = null;
            }
        } else if (name == FILTER_PERIOD) {
            Object[] ed = (Object[])value;
            PeriodComplete per = new PeriodComplete();
            per.setStartDate(ed.getStartDate());
            per.setEndDate(ed.getEndDate());
            this.filterCriteria3 = per;
        } else if (name == FILTER_HAUL_TYPE) {
            if (value instanceof Object[]) {
                this.haulType = new ArrayList<HaulTypeComplete>();
                for (Object a : (Object[])value) {
                    this.haulType.add((HaulTypeComplete)a);
                }
            } else if (value instanceof Boolean) {
                this.haultypeActivated = (Boolean)value;
            } else {
                this.haulType = null;
            }
        } else if (name == FILTER_CARRIER) {
            this.filterCriteria4 = value == Words.ALL ? null : (CustomerLight)value;
        } else if (name == FILTER_SOB_STATE) {
            if (value.equals(Words.SENT)) {
                this.sobState = SalesOnBoardStateE.SENT;
            } else if (value.equals(Words.RECEIVED)) {
                this.sobState = SalesOnBoardStateE.RECEIVED;
            } else if (value.equals(WordsToolkit.toCapitalLetter((String)Words.NONE))) {
                this.sobState = SalesOnBoardStateE.NONE;
            } else if (value.equals(Words.ALL)) {
                this.sobState = null;
            }
        } else if (name == FILTER_RC_STATE) {
            this.rcState = value instanceof ReturnsCountStateE ? (ReturnsCountStateE)value : null;
        } else if (name == FILTER_IRREGULARITY) {
            this.irregularity = value instanceof String ? (value.equals(Words.IRREGULARITY_ONLY) ? Boolean.valueOf(true) : (value.equals(Words.NO_IRREGULARITY) ? Boolean.valueOf(false) : null)) : null;
        }
        FlightSearchConfiguration c = new FlightSearchConfiguration();
        c.setNumResults(this.numberOfShownResults);
        c.setCustomer(this.filterCriteria4);
        c.setFlightNumber(this.filterCriteria1);
        c.setFlightState(this.filterCriteria2);
        c.setHaulTypeList(this.haulType);
        c.setShowNullHaulTypes(this.haultypeActivated);
        c.setDayPeriod(this.filterCriteria3);
        c.setFlightStdSta((FlightSearchConfiguration.FLIGHT_STD_STA)this.periodSearchMode.getSelectedItem());
        c.setHasSobIrregularity(this.irregularity);
        c.setSobState(this.sobState);
        c.setOnlyOpenFlights(Boolean.valueOf(true));
        c.setIgnoreCancelledFlights(Boolean.valueOf(this.ignoreCancelledFlights));
        c.setRcState(this.rcState);
        c.setStowageType(FlightSearchConfiguration.STOWAGE_TYPE_COLUMN.SALES_ON_BOARD);
        if (this.currentColumnAttribute != null) {
            c.setSortColumn(this.currentColumnAttribute);
        }
        if (this.isAsc) {
            c.setSortDirection(SortDirection.ASCENDING);
        } else {
            c.setSortDirection(SortDirection.DESCENDING);
        }
        if (source == this.pagination) {
            c.setPageNumber(this.pagination.getCurrentPage() - 1);
        } else {
            c.setPageNumber(0);
        }
        if (c.getPageNumber() < 0) {
            c.setPageNumber(0);
        }
        return c;
    }

    @Override
    public boolean hasAddAccess() {
        return false;
    }

    @Override
    public void remoteObjectLoaded(Node<?> node) {
        super.remoteObjectLoaded(node);
    }

    @Override
    public SearchAlgorithm<FlightLight> getSearchAlgorithm() {
        return SearchAlgorithmRegistry.getSearchAlgorithm(FlightSearchAlgorithm.class);
    }

    @Override
    public boolean isSmartScreenAllowed(SubModuleDefinitionComplete screen, RowModel<FlightLight> model) {
        if (model.getNode().getValue() != null && ((ADTO)model.getNode().getValue()).getId() != null) {
            if (screen.getInvokingName().equals(SalesOnBoardAccess.ACTION_SEND_SOB_DATA.getIdentifier())) {
                return ((FlightLight)model.getNode().getValue()).getSobState() == SalesOnBoardStateE.NONE;
            }
            if (screen.getInvokingName().equals(SalesOnBoardAccess.ACTION_RECEIVE_SOB_DATA.getIdentifier())) {
                return ((FlightLight)model.getNode().getValue()).getSobState() == SalesOnBoardStateE.SENT;
            }
            if (screen.getInvokingName().equals(FlightAccess.EXPORT_RETAIL_IN_MOTION.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.TOOL_EDIT_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(FlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier())) {
                SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
                RetailInMotionSettingsComplete rimSettings = (RetailInMotionSettingsComplete)NodeToolkit.getAffixClass(RetailInMotionSettingsComplete.class).getValue();
                boolean showCheckout = true;
                if (settings != null && Boolean.TRUE.equals(rimSettings.getUseRetailInMotionInterface())) {
                    FlightLight flight;
                    if ((screen.getInvokingName().equals(AFlightAccess.ACTION_SWITCH_RIM_PRODUCT_CUSTOMER.getIdentifier()) || screen.getInvokingName().equals(AFlightAccess.ACTION_MOVE_RIM_TRANSACTIONS.getIdentifier())) && !Boolean.TRUE.equals((flight = model.getDTO()).getHasRetailInMotionTransactions())) {
                        showCheckout = false;
                    }
                    if (screen.getInvokingName().equals(AFlightAccess.ACTION_CHECKOUT_SOB_DATA.getIdentifier()) && Boolean.TRUE.equals((flight = model.getDTO()).getRetailInMotionCheckoutDone())) {
                        showCheckout = false;
                    }
                } else {
                    showCheckout = false;
                }
                if (showCheckout) {
                    return true;
                }
                return settings.getChangeFlightStateToEnRouteWhenRcCheckout() != false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isDeletable(RowModel<FlightLight> model) {
        return false;
    }

    @Override
    protected Table.SmartIconConfiguration getPossibleSmartIcons() {
        return Table.SmartIconConfiguration.TWO;
    }

    @Override
    protected RowEditorFactory<FlightLight> getRowEditorFactory() {
        return model -> {
            MessageProvidedRowEditor<FlightLight> rowEditor = new MessageProvidedRowEditor<FlightLight>(model, Words.ARE_YOU_SURE_TO_SAVE_CURRENT_FLIGHT);
            RDProvider p = this.createProvider(model.isAddRow());
            SOBDetailsPanel d0 = new SOBDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            SealDefinitionDetailsPanel d1 = new SealDefinitionDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            BondedEquipmentSealsDetailsPanel d13 = new BondedEquipmentSealsDetailsPanel((RowEditor<FlightLight>)rowEditor, p);
            CombinedDetailsParagraph h0 = new CombinedDetailsParagraph();
            h0.add((Component)d0, new TableLayoutConstraint(0, 0, 0.3f, 1.0));
            h0.add((Component)d1, new TableLayoutConstraint(1, 0, 0.7f, 1.0));
            rowEditor.add(h0, (Object)new TableLayoutConstraint(0, 0, 1.0, 1.0));
            rowEditor.add(d13, (Object)new TableLayoutConstraint(0, 1, 1.0, 1.0));
            rowEditor.addToFocusQueue(d0);
            rowEditor.addToFocusQueue(d1);
            rowEditor.addToFocusQueue(d13);
            rowEditor.allInstalled();
            rowEditor.updateEnableStateToDetailsPanel();
            rowEditor.setVisibleContainer(this.getTable());
            return rowEditor;
        };
    }

    @Override
    protected IDataHandler getModuleDataHandler() {
        return new SalesOnBoardModuleDataHandler(this.loadingId, this);
    }

    @Override
    protected List<TableColumnInfo> getTableColumnInfo() {
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.STATE, "", (Class)FlightStateEWithWarningConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STATE, "", 131, 131, 131));
        columns.add(new TableColumnInfo(Words.IRREGULARITY, "", SOBIrregularityConverter.class, null, "", 30, 30, 30));
        SystemSettingsComplete s = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        boolean isSCK = CompanyUtil.isSCK((SystemSettingsComplete)s);
        if (isSCK) {
            columns.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.sta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            columns.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            columns.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.std, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            columns.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        } else {
            columns.add(new TableColumnInfo(Words.OUTBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.OUTBOUND_CODE, FlightLight_.outboundCode, 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo(Words.STD, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_DEPARTURE, FlightLight_.std, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            columns.add(new TableColumnInfo(Words.TO, "", LegToAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
            columns.add(new TableColumnInfo(Words.INBOUND, "", (Class)StringConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.INBOUND_CODE, FlightLight_.inboundCode, 30, Integer.MAX_VALUE, 30));
            columns.add(new TableColumnInfo(Words.STA, "", (Class)DateTimeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.PLANNED_ARRIVAL, FlightLight_.sta, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth, TableColumnInfo.dateTimeColumnWidth));
            columns.add(new TableColumnInfo(Words.FROM, "", LegFromAirportConverter.class, null, FlightLight_.legs, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth, TableColumnInfo.airportColumnWidth));
        }
        columns.add(new TableColumnInfo(Words.CUSTOMER, "", (Class)CustomerCodeConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.CARRIER, FlightLight_.customer, 30, 30, 30));
        columns.add(new TableColumnInfo(Words.STOWING, "", (Class)StowingListNameConverter.class, (Enum<?>)FlightSearchConfiguration.FLIGHT_COLUMN.STOWINGLIST, FlightLight_.activeStowingList, 85, Integer.MAX_VALUE, 85));
        columns.add(new TableColumnInfo(Words.SOB_STATE, "", SOBStateConverter.class, null, FlightLight_.sobState, 48, 48, 48));
        columns.add(new TableColumnInfo(Words.RETURNSCOUNT, "", FlightReturnsCountStateConverter.class, null, "", 48, 48, 48));
        return columns;
    }
}

