/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details.utils;

import ch.icit.pegasus.client.converter.DataAccessRightConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataRightDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.ModuleDefinitionComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.UserManagementAccess;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataRightDefinition
extends Table2 {
    private static final long serialVersionUID = 1L;
    private Node userNode;

    public DataRightDefinition(RDProvider provider) {
        super(false, "", true, true, "Access Rights");
        this.setProvider(provider);
        this.setOverrideName("modules");
        this.setUseWriteAccessRight(true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo("RIGHT", null, null, null, "", 40, 40, 40));
        int tw = 2 * this.getCellPadding() + CheckBox.getPreferredWidth();
        columns.add(new TableColumnInfo("", null, null, null, "", tw, tw, tw));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
    }

    public void setMasterNode(Node<?> node) {
        this.userNode = node;
        if (node == null) {
            this.getModel().setNode(null);
        } else {
            ModuleAccessRightComplete ar = (ModuleAccessRightComplete)node.getValue();
            if (ar.getModule().getInvokingName().equals(UserManagementAccess.MODULE_USER_MANAGEMENT.getIdentifier())) {
                this.getModel().setNode(null);
            } else {
                this.getModel().setNode(node.getChildNamed(new DtoField[]{ModuleAccessRightComplete_.module, ModuleDefinitionComplete_.dataRights}));
            }
        }
    }

    public void selectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(true);
        }
    }

    public void deselectAll() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            pp.selectRow(false);
        }
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public boolean isChecked() {
        for (Table2RowPanel p : this.getRows()) {
            TableRowImpl pp = (TableRowImpl)p;
            if (pp.isChecked()) continue;
            return false;
        }
        return true;
    }

    private class TableRowImpl
    extends Table2RowPanel
    implements ButtonListener {
        private static final long serialVersionUID = 1L;
        private TextLabel name;
        private CheckBox right;
        private boolean isEditable;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.isEditable = true;
            this.setUseControlSkin(Table2RowPanel.TableControlsType.ONE);
            this.name = new TextLabel(m.getNode().getChildNamed(DataRightDefinitionComplete_.accessRight), ConverterRegistry.getConverter(DataAccessRightConverter.class));
            this.right = new CheckBox();
            this.isEditable = DataRightDefinition.this.isWritable();
            this.right.addButtonListener(this);
            this.setLayout(new Layout());
            this.ensureSelectionState();
            this.setEnabled(true);
            this.add(this.name);
            this.add(this.right);
        }

        private void ensureSelectionState() {
            Iterator it = DataRightDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.accessRights).getFailSafeChildIterator();
            boolean found = false;
            while (it.hasNext() && !found) {
                Node n = (Node)it.next();
                if (!((DataAccessRightComplete)n.getValue()).getDataAccessRight().equals(this.model.getNode().getValue())) continue;
                found = true;
                this.right.setChecked(true);
            }
            if (!found) {
                this.right.setChecked(false);
            }
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            if (source == this.right) {
                if (this.right.isChecked()) {
                    DataAccessRightComplete a = new DataAccessRightComplete();
                    a.setClientOId(Long.valueOf(ADTO.getNextId()));
                    a.setDataAccessRight((DataRightDefinitionComplete)this.model.getNode().getValue());
                    Node n = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, true, false);
                    DataRightDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.accessRights).addChild(n, System.currentTimeMillis());
                } else {
                    Iterator it = DataRightDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.accessRights).getFailSafeChildIterator();
                    while (it.hasNext()) {
                        Node n = (Node)it.next();
                        if (!((DataAccessRightComplete)n.getValue()).getDataAccessRight().equals(this.model.getNode().getValue())) continue;
                        DataRightDefinition.this.userNode.getChildNamed(ModuleAccessRightComplete_.accessRights).removeChild(n, System.currentTimeMillis());
                    }
                }
            }
        }

        @Override
        public List<Component> getFocusComponents() {
            return this.right.getFocusComponents();
        }

        @Override
        public Object getObject4Column(int column) {
            switch (column) {
                case 0: {
                    return this.name.getText();
                }
                case 1: {
                    return this.right.isChecked();
                }
            }
            return null;
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            this.name.setEnabled(isEnabled);
            this.right.setEnabled(isEnabled & this.isEditable);
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.name.kill();
            this.right.kill();
            this.name = null;
            this.right = null;
        }

        public void selectRow(boolean b) {
            this.right.setChecked(b);
            this.buttonPressed(this.right, 0, 0);
        }

        public boolean isChecked() {
            return this.right.isChecked();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.getModel().getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.name.setLocation(TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.name.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.name.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.name.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.setControlsX(currentX);
                TableRowImpl.this.right.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.right.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.right.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.right.getPreferredSize().getHeight());
            }
        }
    }
}

