/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.modules.useradmin.details.utils;

import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.DataFieldRightsE;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.Iterator;
import java.util.List;

public class RightsEditPopup
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private final TextLabel write = new TextLabel("WRITE");
    private final TextLabel add = new TextLabel("ADD");
    private final TextLabel remove = new TextLabel("REMOVE");
    private final TextLabel changeOrder = new TextLabel("CHANGE ORDER");
    private final CheckBox wc;
    private final CheckBox ac;
    private final CheckBox rc;
    private final CheckBox cc;
    private final Node<ModuleAccessRightComplete> currentRight;
    private final Node<DataFieldDefinitionComplete> currentField;

    public RightsEditPopup(Node currentModuleRight, Node field) {
        this.currentRight = currentModuleRight;
        this.currentField = field;
        this.wc = new CheckBox();
        this.ac = new CheckBox();
        this.rc = new CheckBox();
        this.cc = new CheckBox();
        this.wc.addButtonListener(this);
        this.ac.addButtonListener(this);
        this.rc.addButtonListener(this);
        this.cc.addButtonListener(this);
        this.setLayout(new Layout());
        this.ensureSelection();
        this.add(this.write);
        this.add(this.wc);
        this.add(this.add);
        this.add(this.ac);
        this.add(this.remove);
        this.add(this.rc);
        this.add(this.changeOrder);
        this.add(this.cc);
    }

    private void ensureSelection() {
        DataFieldDefinitionComplete d = (DataFieldDefinitionComplete)this.currentField.getValue();
        if (d.getIsList().booleanValue()) {
            this.ac.setChecked(false);
            this.cc.setChecked(false);
            this.rc.setChecked(false);
            this.wc.setChecked(false);
            Iterator it = this.currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getChilds();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!n.getChildNamed(DataFieldAccessRightComplete_.field).getValue().equals(d)) continue;
                DataFieldRightsE r = (DataFieldRightsE)n.getChildNamed(DataFieldAccessRightComplete_.accessRight).getValue();
                switch (r) {
                    case ADD: {
                        this.ac.setChecked(true);
                        break;
                    }
                    case CHANGEORDER: {
                        this.cc.setChecked(true);
                        break;
                    }
                    case READ: {
                        break;
                    }
                    case REMOVE: {
                        this.rc.setChecked(true);
                        break;
                    }
                    case WRITE: {
                        this.wc.setChecked(true);
                    }
                }
            }
        }
    }

    @Override
    public boolean tryToGrabFocus() {
        return true;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.wc.getFocusComponents();
        a.addAll(this.ac.getFocusComponents());
        a.addAll(this.rc.getFocusComponents());
        a.addAll(this.rc.getFocusComponents());
        a.addAll(this.cc.getFocusComponents());
        return a;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return false;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        DataFieldDefinitionComplete d = (DataFieldDefinitionComplete)this.currentField.getValue();
        DataFieldRightsE currentRightE = null;
        boolean isCheck = false;
        if (source == this.wc) {
            currentRightE = DataFieldRightsE.WRITE;
            isCheck = this.wc.isChecked();
        } else if (source == this.ac) {
            currentRightE = DataFieldRightsE.ADD;
            isCheck = this.ac.isChecked();
        } else if (source == this.rc) {
            currentRightE = DataFieldRightsE.REMOVE;
            isCheck = this.rc.isChecked();
        } else if (source == this.cc) {
            currentRightE = DataFieldRightsE.CHANGEORDER;
            isCheck = this.cc.isChecked();
        }
        if (isCheck) {
            DataFieldAccessRightComplete r = new DataFieldAccessRightComplete();
            r.setClientOId(Long.valueOf(ADTO.getNextId()));
            r.setAccessRight(currentRightE);
            r.setField(d);
            this.currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).addChild(INodeCreator.getDefaultImpl().getNode4DTO((Object)r, true, false), System.currentTimeMillis());
        } else {
            Iterator it = this.currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).getFailSafeChildIterator();
            while (it.hasNext()) {
                Node n = (Node)it.next();
                if (!n.getChildNamed(DataFieldAccessRightComplete_.field).getValue().equals(d) || !n.getChildNamed(DataFieldAccessRightComplete_.field).getValue().equals(currentRightE)) continue;
                this.currentRight.getChildNamed(ModuleAccessRightComplete_.fieldAccessRights).removeChild(n, System.currentTimeMillis());
            }
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.write.kill();
        this.add.kill();
        this.remove.kill();
        this.changeOrder.kill();
        this.wc.kill();
        this.ac.kill();
        this.rc.kill();
        this.cc.kill();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int border = 3;
            h = (int)((double)h + RightsEditPopup.this.write.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + RightsEditPopup.this.add.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + RightsEditPopup.this.remove.getPreferredSize().getHeight());
            h += border;
            h = (int)((double)h + RightsEditPopup.this.changeOrder.getPreferredSize().getHeight());
            return new Dimension(250, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 3;
            int tw = (int)(RightsEditPopup.this.wc.getPreferredSize().getWidth() + (double)(2 * border));
            RightsEditPopup.this.write.setLocation(0, 0);
            RightsEditPopup.this.write.setSize(parent.getWidth() - tw, (int)RightsEditPopup.this.write.getPreferredSize().getHeight());
            RightsEditPopup.this.add.setLocation(0, RightsEditPopup.this.write.getY() + RightsEditPopup.this.write.getHeight() + border);
            RightsEditPopup.this.add.setSize(parent.getWidth() - tw, (int)RightsEditPopup.this.add.getPreferredSize().getHeight());
            RightsEditPopup.this.remove.setLocation(0, RightsEditPopup.this.add.getY() + RightsEditPopup.this.add.getHeight() + border);
            RightsEditPopup.this.remove.setSize(parent.getWidth() - tw, (int)RightsEditPopup.this.remove.getPreferredSize().getHeight());
            RightsEditPopup.this.changeOrder.setLocation(0, RightsEditPopup.this.remove.getY() + RightsEditPopup.this.remove.getHeight() + border);
            RightsEditPopup.this.changeOrder.setSize(parent.getWidth() - tw, (int)RightsEditPopup.this.changeOrder.getPreferredSize().getHeight());
            RightsEditPopup.this.wc.setLocation((int)((double)parent.getWidth() - (RightsEditPopup.this.wc.getPreferredSize().getWidth() + (double)border)), (int)((double)RightsEditPopup.this.write.getY() + ((double)RightsEditPopup.this.write.getHeight() - RightsEditPopup.this.wc.getPreferredSize().getHeight()) / 2.0));
            RightsEditPopup.this.wc.setSize(RightsEditPopup.this.wc.getPreferredSize());
            RightsEditPopup.this.ac.setLocation((int)((double)parent.getWidth() - (RightsEditPopup.this.ac.getPreferredSize().getWidth() + (double)border)), (int)((double)RightsEditPopup.this.add.getY() + ((double)RightsEditPopup.this.add.getHeight() - RightsEditPopup.this.ac.getPreferredSize().getHeight()) / 2.0));
            RightsEditPopup.this.ac.setSize(RightsEditPopup.this.ac.getPreferredSize());
            RightsEditPopup.this.rc.setLocation((int)((double)parent.getWidth() - (RightsEditPopup.this.rc.getPreferredSize().getWidth() + (double)border)), (int)((double)RightsEditPopup.this.remove.getY() + ((double)RightsEditPopup.this.remove.getHeight() - RightsEditPopup.this.rc.getPreferredSize().getHeight()) / 2.0));
            RightsEditPopup.this.rc.setSize(RightsEditPopup.this.rc.getPreferredSize());
            RightsEditPopup.this.cc.setLocation((int)((double)parent.getWidth() - (RightsEditPopup.this.cc.getPreferredSize().getWidth() + (double)border)), (int)((double)RightsEditPopup.this.changeOrder.getY() + ((double)RightsEditPopup.this.changeOrder.getHeight() - RightsEditPopup.this.cc.getPreferredSize().getHeight()) / 2.0));
            RightsEditPopup.this.cc.setSize(RightsEditPopup.this.cc.getPreferredSize());
        }
    }
}

