/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.action.stowinglist.legfix;

import ch.icit.pegasus.client.gui.modules.stowinglist.StowingListModuleDataHandler;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.MultiLineTextLabel;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.popup.inserts.DefaultScrollablePrintPopupInsert;
import ch.icit.pegasus.client.gui.utils.print.APrintConfigurationComplete;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.StowingListServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.toolkits.LegToolkit;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.stowing.StowingListTemplateVariantReference;
import ch.icit.pegasus.server.core.dtos.masterdata.UserReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;

public class ActionFixStwComponent
extends DefaultScrollablePrintPopupInsert {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private JComponent viewPort;
    private MultiLineTextLabel label;
    protected Node<StowingListTemplateComplete> node;
    private Color defaultBackground;
    protected UserReference currentUser;
    private RowModel currentModel;
    protected boolean emptyPositionShown;

    public ActionFixStwComponent(Node<StowingListTemplateComplete> node, RowModel model) {
        super(false, false);
        this.currentModel = model;
        this.node = node;
        this.defaultBackground = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background"));
        this.installPort();
    }

    @Override
    public APrintConfigurationComplete<?> getPrintConfiguration() {
        return null;
    }

    protected void installPort() {
        this.scrollPane = new ScrollPane();
        this.scrollPane.setScrollPaneBackground(this.defaultBackground);
        this.viewPort = new Port();
        this.label = new MultiLineTextLabel();
        this.viewPort.setLayout(new InnerLayout());
        this.viewPort.add(this.label);
        this.label.setText("Fix Stowing List");
        this.scrollPane.setViewportView(this.viewPort);
        this.getViewContainer().setLayout(new Layout());
        this.getViewContainer().add(this.scrollPane);
        this.emptyPositionShown = true;
    }

    @Override
    public String getTitleString() {
        return Words.RETAIL_INMOTION;
    }

    @Override
    public String getTitleValue() {
        return null;
    }

    @Override
    public boolean withSecondSeparator() {
        return false;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        return null;
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.scrollPane != null) {
            this.scrollPane.setVisible(false);
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.label.kill();
        this.label = null;
        if (this.viewPort.getParent() != null) {
            this.viewPort.getParent().remove(this.viewPort);
        }
        this.viewPort = null;
        this.scrollPane.kill();
        this.scrollPane = null;
        this.currentModel.getView().revalidate();
        this.currentModel = null;
    }

    @Override
    protected void startPrinting() {
        super.startPrinting();
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                StowingListTemplateComplete o = (StowingListTemplateComplete)ActionFixStwComponent.this.node.getValue(StowingListTemplateComplete.class);
                List l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(o.getVariants())).getList();
                boolean synced = true;
                ArrayList<StowingListTemplateVariantLight> variantsToRemoveAgain = new ArrayList<StowingListTemplateVariantLight>();
                ArrayList<StowingListTemplateVariantComplete> variantsToAddAgain = new ArrayList<StowingListTemplateVariantComplete>();
                for (StowingListTemplateVariantLight variant : l) {
                    if (!LegToolkit.areLegsSynced((StowingListTemplateComplete)o, (StowingListTemplateVariantLight)variant)) {
                        variantsToRemoveAgain.add(variant);
                        StowingListTemplateVariantComplete complete = (StowingListTemplateVariantComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariant(new StowingListTemplateVariantReference(variant.getId())).getValue();
                        variantsToAddAgain.add(complete);
                        synced = false;
                        LegToolkit.syncLegs((StowingListTemplateComplete)o, (StowingListTemplateVariantLight)complete, (boolean)true);
                        StowingListModuleDataHandler.ensureMealPlanForWS((StowingListTemplateVariantLight)complete);
                    }
                    StowingListModuleDataHandler.ensureMealPlanForWS(variant);
                }
                l.removeAll(variantsToRemoveAgain);
                l.addAll(variantsToAddAgain);
                o.getVariants().clear();
                o.getVariants().addAll(l);
                if (!synced) {
                    o = (StowingListTemplateComplete)((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).updateTemplate(o).getValue();
                    l = ((StowingListServiceManager)ServiceManagerRegistry.getService(StowingListServiceManager.class)).getVariants(new ListWrapper(o.getVariants())).getList();
                    for (StowingListTemplateVariantLight variant : l) {
                        StowingListModuleDataHandler.ensureMealPlanForWS(variant);
                    }
                    o.getVariants().clear();
                    o.getVariants().addAll(l);
                }
                ActionFixStwComponent.this.node.removeExistingValues();
                ActionFixStwComponent.this.node.setValue((Object)o, 0L);
                ActionFixStwComponent.this.node.updateNode();
                return ActionFixStwComponent.this.node;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ActionFixStwComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    protected String getProgressText() {
        return "Fix Stowing List";
    }

    @Override
    protected String getFinishedText() {
        return "Update done";
    }

    private class InnerLayout
    extends DefaultLayout {
        private InnerLayout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)ActionFixStwComponent.this.scrollPane.getWidth() - ActionFixStwComponent.this.scrollPane.getVerticalScrollBar().getPreferredSize().getWidth());
            int h = (int)ActionFixStwComponent.this.label.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionFixStwComponent.this.label.setLocation(0, 0);
            ActionFixStwComponent.this.label.setSize(parent.getWidth(), (int)ActionFixStwComponent.this.label.getPreferredSize().getHeight());
        }
    }

    private class Port
    extends JComponent {
        private static final long serialVersionUID = 1L;

        private Port() {
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(ActionFixStwComponent.this.defaultBackground);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            this.paintChildren(g2);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            ActionFixStwComponent.this.layoutInheritedComponents(parent);
            ActionFixStwComponent.this.scrollPane.setLocation(ActionFixStwComponent.this.border, ActionFixStwComponent.this.border);
            ActionFixStwComponent.this.scrollPane.setSize(parent.getWidth() - ActionFixStwComponent.this.border, parent.getHeight() - ActionFixStwComponent.this.border);
        }
    }
}

