/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.local.update.utils;

import ch.icit.pegasus.client.converter.CabinClassConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table2.Table2;
import ch.icit.pegasus.client.gui.table2.Table2Model;
import ch.icit.pegasus.client.gui.table2.Table2RowModel;
import ch.icit.pegasus.client.gui.table2.Table2RowPanel;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.Nodable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.DtoFieldConstants;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class PercentagePerClassTable
extends Table2
implements Nodable {
    private static final long serialVersionUID = 1L;

    public PercentagePerClassTable() {
        super(false, "", true);
        ArrayList<TableColumnInfo> columns = new ArrayList<TableColumnInfo>();
        columns.add(new TableColumnInfo(Words.CABIN_CLASS, null, null, null, "", 70, 70, 70));
        columns.add(new TableColumnInfo(Words.PERCENTAGE, null, null, null, "", TableColumnInfo.dateTimeColumnWidth + 5, TableColumnInfo.dateTimeColumnWidth + 5, TableColumnInfo.dateTimeColumnWidth + 5));
        ((TableColumnInfo)columns.get(0)).setxExpand(1.0);
        ((TableColumnInfo)columns.get(1)).setxExpand(0.0);
        this.setModel(new Table2Model(columns, model1 -> new TableRowImpl(model1)));
        this.setProgress(1.0f);
    }

    @Override
    public Node<?> getNode() {
        return this.getModel().getNode();
    }

    @Override
    public void setNode(Node<?> node) {
        this.getModel().setNode(node);
    }

    private class TableRowImpl
    extends Table2RowPanel {
        private static final long serialVersionUID = 1L;
        private TextLabel cabinClass;
        private TextField percentage;

        public TableRowImpl(Table2RowModel m) {
            super(m);
            this.cabinClass = new TextLabel(m.getNode().getChildNamed(DtoFieldConstants.FC_CABIN_CLASS), ConverterRegistry.getConverter(CabinClassConverter.class));
            this.percentage = new TextField(m.getNode().getChildNamed(DtoFieldConstants.FC_CABIN_CLASS_PERCENTAGE), TextFieldType.DOUBLE);
            this.setLayout(new Layout());
            this.add(this.cabinClass);
            this.add(this.percentage);
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> focusList = new ArrayList<Component>();
            CheckedListAdder.addToList(focusList, this.percentage);
            return focusList;
        }

        @Override
        public Object getObject4Column(int column) {
            return this.cabinClass.getText();
        }

        private class Layout
        extends DefaultLayout {
            private Layout() {
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(0, TableRowImpl.this.getDefaultRowHeight());
            }

            @Override
            public void layoutContainer(Container parent) {
                int w = TableRowImpl.this.model.getParentModel().getColumnWidth(0);
                int currentX = 0;
                TableRowImpl.this.cabinClass.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.cabinClass.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.cabinClass.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.cabinClass.getPreferredSize().getHeight());
                currentX += w;
                w = TableRowImpl.this.model.getParentModel().getColumnWidth(1);
                TableRowImpl.this.percentage.setLocation(currentX + TableRowImpl.this.getCellPadding(), (int)(((double)parent.getHeight() - TableRowImpl.this.percentage.getPreferredSize().getHeight()) / 2.0));
                TableRowImpl.this.percentage.setSize(w - 2 * TableRowImpl.this.getCellPadding(), (int)TableRowImpl.this.percentage.getPreferredSize().getHeight());
            }
        }
    }
}

