/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printalldeliveryslips;

import ch.icit.pegasus.client.gui.hud.externopentool.AnalysisSmartExternalOpenTool;
import ch.icit.pegasus.client.gui.submodules.analysis.flight.remote.printall.AnalysisPrintAllSheetsComponent;
import ch.icit.pegasus.client.gui.utils.panels.DeliverySlipConfigPanel;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ConfigPanelAnalysisItem;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.report.AGenericReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.DeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.FlightDeliverySlipReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.generic.FlightAnalysisDeliverySlipsConfiguration;
import ch.icit.pegasus.server.core.dtos.report.generic.GenericAnalysisReportType;
import ch.icit.pegasus.server.core.dtos.util.SalesOnBoardReportStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.util.Collections;
import java.util.List;

public class AnalysisPrintFlightDeliverySlipComponent
extends AnalysisPrintAllSheetsComponent {
    private static final long serialVersionUID = 1L;
    private DeliverySlipConfigPanel configPanel;
    private ReportTypeE reportType;
    private ReportingOutputFormatE outputFormat;

    public AnalysisPrintFlightDeliverySlipComponent(AnalysisSmartExternalOpenTool<FlightLight> defaultAnalysis, ReportTypeE reportType) {
        super(defaultAnalysis, reportType);
        this.reportType = reportType;
        this.outputFormat = ReportingOutputFormatE.PDF;
    }

    @Override
    public List<PegasusFileComplete> processSingleFile(FlightLight flight, AGenericReportConfiguration flightConfig) throws ClientServerCallException {
        FlightAnalysisDeliverySlipsConfiguration aconfig = (FlightAnalysisDeliverySlipsConfiguration)flightConfig;
        ReportFileComplete reportFileComplete = this.getSelectedReport();
        FlightDeliverySlipReportConfiguration config = aconfig.getSingleConfiguration();
        switch (aconfig.getSobState()) {
            case ALL: {
                config.setSobState(SalesOnBoardReportStateE.ALL);
                break;
            }
            case ONLY_SOB_PRODUCTS: {
                config.setSobState(SalesOnBoardReportStateE.ONLY_SOB_PRODUCTS);
                break;
            }
            case NO_SOB_PRODUCTS: {
                config.setSobState(SalesOnBoardReportStateE.NO_SOB_PRODUCTS);
            }
        }
        config.setStylesheet(reportFileComplete);
        config.setDto((IDTO)new FlightReference(flight.getId()));
        PegasusFileComplete fileComplete = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightDeliverySlipReport((DeliverySlipReportConfiguration)config, new ListWrapper()).getValue();
        return Collections.singletonList(fileComplete);
    }

    @Override
    public boolean canExportAll() {
        return false;
    }

    @Override
    public void addOptionItems() {
        super.addOptionItems();
        this.configPanel = new DeliverySlipConfigPanel();
        this.addOptionsItem(new ConfigPanelAnalysisItem(this.configPanel, "deliverySlipConfigPanel"));
    }

    @Override
    public String getTitleValue() {
        return Words.ALL + " " + Words.SELECTED;
    }

    @Override
    protected AGenericReportConfiguration getReportConfiguration() {
        FlightAnalysisDeliverySlipsConfiguration config = new FlightAnalysisDeliverySlipsConfiguration();
        config.setReportType(this.getReportType());
        ReportingOutputFormatE format = ReportingOutputFormatE.PDF;
        config.setReportFormatType(format);
        this.configPanel.fillReportConfiguration(config);
        return config;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> screenValidationObjects = this.configPanel.validateBeforePrint();
        return screenValidationObjects;
    }

    @Override
    public GenericAnalysisReportType getReportType() {
        return GenericAnalysisReportType.AnalysisDeliverySlips;
    }
}

