/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.orderedreceived;

import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.gui.submodules.analysis.purchaseorder.orderedreceived.OrderedReceivedAnalysis;
import ch.icit.pegasus.client.gui.submodules.analysis.util.DefaultServerSideAnalysisComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.popup.inserts.export.itemimpl.ComboBoxAnalysisItem;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.OrderReportServiceManager;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderReference;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;

public class OrderedReceivedAnalysisComponent
extends DefaultServerSideAnalysisComponent<PurchaseOrderLight, PurchaseOrderReference> {
    private static final long serialVersionUID = 1L;
    private TitledItem<ComboBox> filterBonded;

    public OrderedReceivedAnalysisComponent(OrderedReceivedAnalysis orderedReceivedAnalysis) {
        super(orderedReceivedAnalysis);
    }

    @Override
    public void addOptionItems() {
        this.filterBonded = new TitledItem<ComboBox>(new ComboBox(new Node(), NodeToolkit.getAffixList(BondedStateE.class), (Converter)new Converter<BondedStateE, String>(){

            public String convert(BondedStateE o, Node<BondedStateE> currentNode, Object ... param) {
                switch (o) {
                    case ALL: {
                        return Words.ALL_ORDERS;
                    }
                    case ONLY_BONDED: {
                        return Words.ORDERS_WITH_BONDED;
                    }
                    case NOT_BONDED: {
                        return Words.ORDERS_WITHOUT_BONDED;
                    }
                }
                return "";
            }

            public Class<? extends BondedStateE> getParameterClass() {
                return BondedStateE.class;
            }
        }), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
        this.addOptionsItem(new ComboBoxAnalysisItem(this.filterBonded, "bonded"));
    }

    @Override
    public PurchaseOrderReference createReference(PurchaseOrderLight item) {
        return new PurchaseOrderReference(item.getId());
    }

    @Override
    public PegasusFileComplete createReport() throws Exception {
        return (PegasusFileComplete)((OrderReportServiceManager)ServiceManagerRegistry.getService(OrderReportServiceManager.class)).createReceiveReport(new ListWrapper(this.loadItemReferences()), (BondedStateE)this.filterBonded.getElement().getNode().getValue()).getValue();
    }
}

