/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.kanban;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.StoreReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.report.ArticleKanbanCardConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.store.StoreReference;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class PrintKanbanCardComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private BasicArticleLight dto;
    private TitledItem<DateChooser> dueDate;
    private TitledItem<SearchTextField2<StoreLight>> storeSearchField;

    public PrintKanbanCardComponent(BasicArticleLight dto) {
        super(false, false, ReportTypeE.ARTICLE_KANBAN_CARD);
        this.dto = dto;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        SearchTextField2<StoreLight> searchField = SearchTextField2Factory.getStoreSearchField(true, new DTOProxyNode());
        searchField.setName("Store");
        this.storeSearchField = new TitledItem<SearchTextField2<StoreLight>>(searchField, Words.STORE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.storeSearchField);
        this.getViewContainer().add(this.dueDate);
        this.createComponents();
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        this.storeSearchField.setVisible(false);
        this.dueDate.setVisible(false);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        this.storeSearchField.setVisible(true);
        this.dueDate.setVisible(true);
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return this.dto.getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ArticleKanbanCardConfiguration config = new ArticleKanbanCardConfiguration();
                ReportFileComplete file = PrintKanbanCardComponent.this.getSelectedReport();
                BasicArticleReference basicArticleReference = new BasicArticleReference(PrintKanbanCardComponent.this.dto.getId());
                ArrayList<BasicArticleReference> articles = new ArrayList<BasicArticleReference>();
                articles.add(basicArticleReference);
                config.setArticles(articles);
                config.setStore((StoreReference)((SearchTextField2)PrintKanbanCardComponent.this.storeSearchField.getElement()).getNode().getValue());
                config.setDueDate((Date)((DateChooser)PrintKanbanCardComponent.this.dueDate.getElement()).getNode().getValue());
                config.setStylesheet(file);
                config.setFormat(ReportingOutputFormatE.PDF);
                PegasusFileComplete t = (PegasusFileComplete)((StoreReportServiceManager)ServiceManagerRegistry.getService(StoreReportServiceManager.class)).createKanbanCards(config).getValue();
                PrintKanbanCardComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintKanbanCardComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        List<ScreenValidationObject> a;
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        if (this.storeSearchField.getElement().getNode().getValue() == null) {
            l.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.WARNING, Words.ENSURE_STORE_IS_SET));
        }
        if ((a = super.validateBeforePrint()) != null) {
            l.addAll(a);
        }
        return l;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintKanbanCardComponent.this.layoutInheritedComponents(parent) + PrintKanbanCardComponent.this.border;
            PrintKanbanCardComponent.this.dueDate.setLocation(PrintKanbanCardComponent.this.border, y);
            PrintKanbanCardComponent.this.dueDate.setSize(parent.getWidth() - 2 * PrintKanbanCardComponent.this.border, ((PrintKanbanCardComponent)PrintKanbanCardComponent.this).dueDate.getPreferredSize().height);
            y = PrintKanbanCardComponent.this.dueDate.getY() + PrintKanbanCardComponent.this.dueDate.getHeight() + PrintKanbanCardComponent.this.border;
            PrintKanbanCardComponent.this.storeSearchField.setLocation(PrintKanbanCardComponent.this.border, y);
            PrintKanbanCardComponent.this.storeSearchField.setSize(parent.getWidth() - 2 * PrintKanbanCardComponent.this.border, ((PrintKanbanCardComponent)PrintKanbanCardComponent.this).storeSearchField.getPreferredSize().height);
            y = PrintKanbanCardComponent.this.storeSearchField.getY() + PrintKanbanCardComponent.this.storeSearchField.getHeight() + PrintKanbanCardComponent.this.border;
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintKanbanCardComponent.this.getInheritedComponentsHeight();
            h += PrintKanbanCardComponent.this.border;
            h = (int)((double)h + PrintKanbanCardComponent.this.dueDate.getPreferredSize().getHeight());
            h += PrintKanbanCardComponent.this.border;
            h = (int)((double)h + PrintKanbanCardComponent.this.storeSearchField.getPreferredSize().getHeight());
            int w = 250;
            return new Dimension(w, h += PrintKanbanCardComponent.this.border);
        }
    }
}

