/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.article.prices;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.product.TenderTypeE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.DateWrapper;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

public class PrintArticlePricesComponent
extends DefaultScrollablePrintPopup2<BasicArticleLight> {
    private static final long serialVersionUID = 1L;
    private Node<BasicArticleLight> node;
    private TitledItem<DateChooser> validityDate;
    private TitledItem<CheckBox> includeAllVariants;
    private TitledItem<ComboBox> includedTypes;

    public PrintArticlePricesComponent(Node<BasicArticleLight> flightNode) {
        super(false, false, false, false, false, ReportTypeE.IRREGULARITY);
        this.node = flightNode;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = super.getFocusComponents();
        CheckedListAdder.addToList(a, this.validityDate);
        CheckedListAdder.addToList(a, this.includeAllVariants);
        CheckedListAdder.addToList(a, this.includedTypes);
        return a;
    }

    @Override
    public String getTitleString() {
        return Words.ARTICLE;
    }

    @Override
    public String getTitleValue() {
        return ((BasicArticleLight)this.node.getValue()).getName();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[12];
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.validityDate != null) {
            this.validityDate.kill();
            this.validityDate = null;
            this.includeAllVariants.kill();
            this.includeAllVariants = null;
            this.includedTypes.kill();
            this.includedTypes = null;
        }
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        this.validityDate = new TitledItem<DateChooser>(new DateChooser(INodeCreator.getDefaultImpl().getNode4DTO((Object)new Date(System.currentTimeMillis()), false, false)), Words.VALIDITY, TitledItem.TitledItemOrientation.NORTH);
        this.includeAllVariants = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_ALL_VARIANTS, TitledItem.TitledItemOrientation.EAST);
        this.includedTypes = new TitledItem<ComboBox>(new ComboBox(), Words.TENDER, TitledItem.TitledItemOrientation.NORTH);
        this.includedTypes.getElement().addItem(Words.ALL);
        this.includedTypes.getElement().addItem(Words.TENDER);
        this.includedTypes.getElement().addItem(Words.PRODUCTIVE);
        this.getViewContainer().add(this.validityDate);
        this.getViewContainer().add(this.includeAllVariants);
        this.getViewContainer().add(this.includedTypes);
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.validityDate != null) {
            this.validityDate.setVisible(true);
            this.includeAllVariants.setVisible(true);
            this.includedTypes.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.validityDate != null) {
            this.validityDate.setVisible(false);
            this.includeAllVariants.setVisible(false);
            this.includedTypes.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                Date date = (Date)((DateChooser)PrintArticlePricesComponent.this.validityDate.getElement()).getNode().getValue();
                ArrayList<BasicArticleReference> arts = new ArrayList<BasicArticleReference>();
                arts.add(new BasicArticleReference(((BasicArticleLight)PrintArticlePricesComponent.this.node.getValue()).getId()));
                boolean allV = ((CheckBox)PrintArticlePricesComponent.this.includeAllVariants.getElement()).isChecked();
                TenderTypeE tender = null;
                tender = ((ComboBox)PrintArticlePricesComponent.this.includedTypes.getElement()).getSelectedItem().equals(Words.PRODUCTIVE) ? TenderTypeE.Productive : (((ComboBox)PrintArticlePricesComponent.this.includedTypes.getElement()).getSelectedItem().equals(Words.TENDER) ? TenderTypeE.Tender : TenderTypeE.Both);
                PegasusFileComplete t = (PegasusFileComplete)((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).createArticlePriceReport(new ListWrapper(arts), new DateWrapper(date), tender, Boolean.valueOf(allV)).getValue();
                PrintArticlePricesComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintArticlePricesComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    @Override
    public Node<BasicArticleLight> getCurrentNode() {
        return null;
    }

    @Override
    public BatchJob<BasicArticleLight> createBatchJob(Node<BasicArticleLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintArticlePricesComponent.this.layoutInheritedComponents(parent);
            if (PrintArticlePricesComponent.this.validityDate != null) {
                PrintArticlePricesComponent.this.validityDate.setLocation(PrintArticlePricesComponent.this.border, y);
                PrintArticlePricesComponent.this.validityDate.setSize(PrintArticlePricesComponent.this.validityDate.getPreferredSize());
                PrintArticlePricesComponent.this.includeAllVariants.setLocation(PrintArticlePricesComponent.this.border, PrintArticlePricesComponent.this.validityDate.getY() + PrintArticlePricesComponent.this.validityDate.getHeight() + PrintArticlePricesComponent.this.border);
                PrintArticlePricesComponent.this.includeAllVariants.setSize(PrintArticlePricesComponent.this.includeAllVariants.getPreferredSize());
                PrintArticlePricesComponent.this.includedTypes.setLocation(PrintArticlePricesComponent.this.border, PrintArticlePricesComponent.this.includeAllVariants.getY() + PrintArticlePricesComponent.this.includeAllVariants.getHeight() + PrintArticlePricesComponent.this.border);
                PrintArticlePricesComponent.this.includedTypes.setSize(180, (int)PrintArticlePricesComponent.this.includedTypes.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintArticlePricesComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintArticlePricesComponent.this.border;
            if (PrintArticlePricesComponent.this.validityDate != null) {
                h = (int)((double)h + PrintArticlePricesComponent.this.validityDate.getPreferredSize().getHeight());
                h += PrintArticlePricesComponent.this.border;
                h = (int)((double)h + PrintArticlePricesComponent.this.includeAllVariants.getPreferredSize().getHeight());
                h += PrintArticlePricesComponent.this.border;
                h = (int)((double)h + PrintArticlePricesComponent.this.includedTypes.getPreferredSize().getHeight());
                h += PrintArticlePricesComponent.this.border;
            }
            return new Dimension(w, h);
        }
    }
}

