/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.allergenindex;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.masterdata.LanguageCodeComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PrintAllergenIndexComponent
extends DefaultScrollablePrintPopup2<FlightLight> {
    private static final long serialVersionUID = 1L;
    private Node<FlightLight> currentFlight;
    private List<TitledItem<CheckBox>> languages = new ArrayList<TitledItem<CheckBox>>();

    public PrintAllergenIndexComponent(Node<FlightLight> node) {
        super(false, false, ReportTypeE.ALLERGEN_INDEX_SHEET);
        this.currentFlight = node;
        this.loadBeforeShowing(() -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(LanguageCodeComplete.class, false);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        });
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        List l = (List)NodeToolkit.getAffixList(LanguageCodeComplete.class).getValue();
        Collections.sort(l);
        for (LanguageCodeComplete code : l) {
            TitledItem<CheckBox> includeCode = new TitledItem<CheckBox>(new CheckBox(), code.getDescription(), TitledItem.TitledItemOrientation.EAST);
            includeCode.setUserObject(code);
            includeCode.getElement().setChecked(true);
            this.languages.add(includeCode);
            this.getViewContainer().add(includeCode);
        }
    }

    @Override
    public String getTitleString() {
        return Words.FLIGHT;
    }

    @Override
    public String getTitleValue() {
        if (this.currentFlight.getValue() != null) {
            return ((FlightLight)this.currentFlight.getValue()).getOutboundCode();
        }
        return "-";
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        for (TitledItem<CheckBox> item : this.languages) {
            item.setEnabled(isEnabled);
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        for (TitledItem<CheckBox> item : this.languages) {
            CheckedListAdder.addToList(focusList, item);
        }
        return focusList;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (TitledItem<CheckBox> item : this.languages) {
            item.kill();
        }
        this.languages.clear();
        this.languages = null;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        for (TitledItem<CheckBox> item : this.languages) {
            item.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        for (TitledItem<CheckBox> item : this.languages) {
            item.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintAllergenIndexComponent.this.getSelectedReport();
                ReportingOutputFormatE f = ReportingOutputFormatE.PDF;
                ArrayList<LanguageCodeComplete> codes = new ArrayList<LanguageCodeComplete>();
                for (TitledItem item : PrintAllergenIndexComponent.this.languages) {
                    if (!((CheckBox)item.getElement()).isChecked()) continue;
                    codes.add((LanguageCodeComplete)item.getUserObject());
                }
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateAllergenIndexReport(f, file, new ListWrapper(codes)).getValue();
                PrintAllergenIndexComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintAllergenIndexComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.currentFlight;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintAllergenIndexComponent.this.layoutInheritedComponents(parent);
            y += PrintAllergenIndexComponent.this.border / 2;
            for (TitledItem item : PrintAllergenIndexComponent.this.languages) {
                item.setLocation(PrintAllergenIndexComponent.this.border, y + PrintAllergenIndexComponent.this.border / 2);
                item.setSize(item.getPreferredSize());
                y = item.getY() + item.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintAllergenIndexComponent.this.getInheritedComponentsHeight();
            int w = 250;
            h += PrintAllergenIndexComponent.this.border / 2;
            for (TitledItem item : PrintAllergenIndexComponent.this.languages) {
                h = (int)((double)h + (item.getPreferredSize().getHeight() + (double)(PrintAllergenIndexComponent.this.border / 2)));
            }
            return new Dimension(w, h += PrintAllergenIndexComponent.this.border);
        }
    }
}

