/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flight.loading;

import ch.icit.pegasus.client.converter.ColorConverter;
import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.DTOProxyNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.masterdata.MasterDataServiceManager;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ColorComplete;
import ch.icit.pegasus.server.core.dtos.report.FlightDataReportConfig;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;

public class PrintLoadingSheetComponent
extends DefaultScrollablePrintPopup2<FlightLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    protected TextLabel printOptionTitle;
    private TitledItem<ComboBox> department;
    private TitledItem<ComboBox> colors;
    private Node<FlightLight> node;

    public PrintLoadingSheetComponent(TransferObject<FlightLight> transferObject) {
        super(true, false, false, false, ReportTypeE.STOWINGLIST_REPORT);
        this.node = transferObject.getNode();
        Runnable r = () -> {
            try {
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(CostCenterComplete.class);
                ((MasterDataServiceManager)ServiceManagerRegistry.getService(MasterDataServiceManager.class)).getAllCached(ColorComplete.class);
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        this.loadBeforeShowing(r);
    }

    public boolean showCustomerSearch() {
        return false;
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.printOptionTitle = new TextLabel(Words.OPTIONS);
        this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
        this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
        this.getViewContainer().add(this.printOptionTitle);
        this.department = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(CostCenterComplete.class), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.DEPARTMENT), TitledItem.TitledItemOrientation.NORTH);
        this.colors = new TitledItem<ComboBox>(new ComboBox((Node)new DTOProxyNode(), NodeToolkit.getAffixList(ColorComplete.class), ConverterRegistry.getConverter(ColorConverter.class), true, true), WordsToolkit.toCapitalLetter((String)Words.LABEL_COLOR, (boolean)true), TitledItem.TitledItemOrientation.NORTH);
        this.department.getTitle().setForeground(fb);
        this.department.getTitle().setFont(f);
        this.colors.getTitle().setForeground(fb);
        this.colors.getTitle().setFont(f);
        this.getViewContainer().add(this.department);
        this.getViewContainer().add(this.colors);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.printOptionTitle.setEnabled(isEnabled);
        this.department.setEnabled(isEnabled);
        this.colors.setEnabled(isEnabled);
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.LOADING_SHEET;
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[2];
        return o;
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> focusList = super.getFocusComponents();
        CheckedListAdder.addToList(focusList, this.department);
        CheckedListAdder.addToList(focusList, this.colors);
        return focusList;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        boolean b = super.isInnerComponent(c);
        if (b) {
            return b;
        }
        if (this.department != null && this.department.isInnerComponent(c)) {
            return true;
        }
        return this.colors != null && this.colors.isInnerComponent(c);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.department != null) {
            this.department.kill();
        }
        if (this.colors != null) {
            this.colors.kill();
        }
        this.department = null;
        this.colors = null;
        this.printOptionTitle = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.department != null) {
            this.department.setVisible(true);
        }
        if (this.colors != null) {
            this.colors.setVisible(true);
        }
        if (this.popup != null) {
            this.popup.createFocusCycle();
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.department != null) {
            this.department.setVisible(false);
        }
        if (this.colors != null) {
            this.colors.setVisible(false);
        }
    }

    @Override
    public List<ScreenValidationObject> validateBeforePrint() {
        ArrayList<ScreenValidationObject> l = new ArrayList<ScreenValidationObject>();
        List<ScreenValidationObject> a = super.validateBeforePrint();
        if (a != null) {
            l.addAll(a);
        }
        return l;
    }

    @Override
    public BatchJob<FlightLight> createBatchJob(Node<FlightLight> value, ThreadSafeExecutable job) {
        return null;
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(){

            @Override
            public Node<?> loadData() throws Exception {
                CostCenterComplete costCenter = null;
                if (((ComboBox)PrintLoadingSheetComponent.this.department.getElement()).getSelectedItem() instanceof Node) {
                    Node d = (Node)((ComboBox)PrintLoadingSheetComponent.this.department.getElement()).getSelectedItem();
                    costCenter = (CostCenterComplete)d.getValue();
                }
                ColorComplete color = null;
                if (((ComboBox)PrintLoadingSheetComponent.this.colors.getElement()).getSelectedItem() instanceof Node) {
                    Node c = (Node)((ComboBox)PrintLoadingSheetComponent.this.colors.getElement()).getSelectedItem();
                    color = (ColorComplete)c.getValue();
                }
                FlightDataReportConfig config = new FlightDataReportConfig();
                config.setDepartment(costCenter);
                config.setColor(color);
                config.setFlightReference(new FlightReference(((FlightLight)PrintLoadingSheetComponent.this.node.getValue()).getId()));
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).generateLoadingSheet(config).getValue();
                PrintLoadingSheetComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintLoadingSheetComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public String getTitleValue() {
        return ((FlightLight)this.node.getValue()).getOutboundCode();
    }

    @Override
    public Node<FlightLight> getCurrentNode() {
        return this.node;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintLoadingSheetComponent.this.layoutInheritedComponents(parent);
            if (PrintLoadingSheetComponent.this.printOptionTitle != null) {
                PrintLoadingSheetComponent.this.printOptionTitle.setLocation(PrintLoadingSheetComponent.this.border, y + PrintLoadingSheetComponent.this.border);
                PrintLoadingSheetComponent.this.printOptionTitle.setSize(parent.getWidth() - 2 * PrintLoadingSheetComponent.this.border, (int)PrintLoadingSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                y = PrintLoadingSheetComponent.this.printOptionTitle.getY() + PrintLoadingSheetComponent.this.printOptionTitle.getHeight() + PrintLoadingSheetComponent.this.border / 2;
            }
            if (PrintLoadingSheetComponent.this.department != null) {
                PrintLoadingSheetComponent.this.department.setLocation(PrintLoadingSheetComponent.this.border, y + PrintLoadingSheetComponent.this.border);
                PrintLoadingSheetComponent.this.department.setSize(parent.getWidth() - 2 * PrintLoadingSheetComponent.this.border, (int)PrintLoadingSheetComponent.this.department.getPreferredSize().getHeight());
                PrintLoadingSheetComponent.this.colors.setLocation(PrintLoadingSheetComponent.this.border, PrintLoadingSheetComponent.this.department.getY() + PrintLoadingSheetComponent.this.department.getHeight() + PrintLoadingSheetComponent.this.border / 2);
                PrintLoadingSheetComponent.this.colors.setSize(parent.getWidth() - 2 * PrintLoadingSheetComponent.this.border, (int)PrintLoadingSheetComponent.this.colors.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintLoadingSheetComponent.this.getInheritedComponentsHeight();
            h += PrintLoadingSheetComponent.this.border;
            if (PrintLoadingSheetComponent.this.printOptionTitle != null) {
                h = (int)((double)h + PrintLoadingSheetComponent.this.printOptionTitle.getPreferredSize().getHeight());
                h += PrintLoadingSheetComponent.this.border / 2;
            }
            if (PrintLoadingSheetComponent.this.department != null) {
                h = (int)((double)h + PrintLoadingSheetComponent.this.department.getPreferredSize().getHeight());
                h += PrintLoadingSheetComponent.this.border / 2;
            }
            if (PrintLoadingSheetComponent.this.colors != null) {
                h = (int)((double)h + PrintLoadingSheetComponent.this.colors.getPreferredSize().getHeight());
                h += PrintLoadingSheetComponent.this.border;
            }
            int w = 2 * PrintLoadingSheetComponent.this.border;
            return new Dimension(w, h += PrintLoadingSheetComponent.this.border);
        }
    }
}

