/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.flightschedule.stowingreport;

import ch.icit.pegasus.client.converter.CustomerConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.print.shared.stowinglistreport.PrintStowingListComponent;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.TransferObject;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooserPopup;
import ch.icit.pegasus.client.gui.utils.panels.PaxLegTable;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.FlightReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ALegComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightScheduleReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.SeatConfigurationComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.report.StowingListReportConfiguration;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.IDTO;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class PrintFlightScheduleStowingListComponent
extends PrintStowingListComponent<FlightScheduleLight> {
    private static final long serialVersionUID = 7192372218977982673L;
    TransferObject<FlightScheduleLight> flightSchedule;

    public PrintFlightScheduleStowingListComponent(TransferObject<FlightScheduleLight> transferObject, PeriodComplete p) {
        super(p, false);
        this.flightSchedule = transferObject;
    }

    @Override
    public boolean showPaxFinalize() {
        return false;
    }

    @Override
    public void insertElements() {
        super.insertElements();
        this.dateChooser = new TitledItem<DateChooserPopup>(new DateChooserPopup(new Date(this.p.getStartDate().getTime())), Words.DATE, TitledItem.TitledItemOrientation.NORTH);
        ((DateChooserPopup)this.dateChooser.getElement()).enableSkin(true);
        this.getViewContainer().add(this.dateChooser);
        ArrayList<Node<SeatConfigurationComplete>> cabinClasses = new ArrayList<Node<SeatConfigurationComplete>>();
        ArrayList<Node<? extends ALegComplete>> legs = new ArrayList<Node<? extends ALegComplete>>();
        for (SeatConfigurationComplete scc : this.flightSchedule.getDto().getDefaultStowingList().getStowingList().getCurrentVariant().getSeatConfigurations()) {
            Node cc = INodeCreator.getDefaultImpl().getNode4DTO((Object)scc, false, false);
            cabinClasses.add(cc);
        }
        for (ALegComplete leg : this.flightSchedule.getDto().getLegs()) {
            Node ln = INodeCreator.getDefaultImpl().getNode4DTO((Object)leg, false, false);
            legs.add((Node<? extends ALegComplete>)ln);
        }
        this.paxCount = new TitledItem<PaxLegTable>(new PaxLegTable(cabinClasses, legs, null), Words.PAX_COUNT, TitledItem.TitledItemOrientation.NORTH);
        this.getViewContainer().add(this.paxCount);
    }

    @Override
    public ThreadSafeExecutable getJob() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintFlightScheduleStowingListComponent.this.getSelectedReport();
                StowingListReportConfiguration config = new StowingListReportConfiguration(ReportTypeE.STOWINGLIST_REPORT, ReportingOutputFormatE.PDF, file);
                PrintFlightScheduleStowingListComponent.this.getConfig(config);
                config.setValidityDate(new Timestamp(((DateChooserPopup)PrintFlightScheduleStowingListComponent.this.dateChooser.getElement()).getSelectedDate().getTimeInMillis()));
                config.setDto((IDTO)new FlightScheduleReference(PrintFlightScheduleStowingListComponent.this.flightSchedule.getDto().getId()));
                PegasusFileComplete t = (PegasusFileComplete)((FlightReportServiceManager)ServiceManagerRegistry.getService(FlightReportServiceManager.class)).createFlightScheduleStowingListReport(config, new ListWrapper()).getValue();
                PrintFlightScheduleStowingListComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintFlightScheduleStowingListComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        return run;
    }

    @Override
    public Node<FlightScheduleLight> getCurrentNode() {
        return this.flightSchedule.getNode();
    }

    @Override
    public String getTitleValue() {
        CustomerConverter c1 = (CustomerConverter)ConverterRegistry.getConverter(CustomerConverter.class);
        return c1.convert(this.flightSchedule.getDto().getCustomer(), null, new Object[0]) + " " + this.flightSchedule.getDto().getOutboundCode();
    }
}

