/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventory.store.details;

import ch.icit.pegasus.client.gui.batch.BatchJob;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButton;
import ch.icit.pegasus.client.gui.utils.buttons.RadioButtonBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.print.DefaultScrollablePrintPopup2;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.report.InventoryReportServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportTypeE;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryLight_;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.report.InventoryReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.BondedStateE;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Container;
import java.awt.Dimension;

public class PrintInventoryStoreDetailsComponent
extends DefaultScrollablePrintPopup2<InventoryLight>
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private Node<InventoryLight> currentInventory;
    private Node<InventoryReportConfiguration> configNode;
    private TextLabel optionTitle;
    private RadioButtonBox box;
    private TitledItem<RadioButton> chargePrice;
    private TitledItem<RadioButton> standardPrice;
    private TitledItem<ComboBox> bondedState;
    private TitledItem<ComboBox> inventoryData;

    public PrintInventoryStoreDetailsComponent(Node<InventoryLight> node) {
        super(false, true, ReportTypeE.INVENTORY_STORE_DETAILS);
        this.currentInventory = node;
        InventoryReportConfiguration config = new InventoryReportConfiguration(null, ReportTypeE.INVENTORY_STORE_DETAILS);
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    @Override
    public void insertElements() {
        this.getViewContainer().setLayout(new Layout());
        this.createComponents();
        boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        if (!isNoPro) {
            this.box = new RadioButtonBox();
            this.box.setOrientation(0);
            this.optionTitle = new TextLabel(Words.OPTIONS);
            this.chargePrice = new TitledItem<RadioButton>(new RadioButton(), Words.CHARGE_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.standardPrice = new TitledItem<RadioButton>(new RadioButton(), Words.STANDARD_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.standardPrice.getElement().setChecked(true);
            this.bondedState = new TitledItem<ComboBox>(new ComboBox(), Words.BONDED, TitledItem.TitledItemOrientation.NORTH);
            this.bondedState.getElement().addItem(BondedStateE.ALL);
            this.bondedState.getElement().addItem(BondedStateE.NOT_BONDED);
            this.bondedState.getElement().addItem(BondedStateE.ONLY_BONDED);
            this.inventoryData = new TitledItem<ComboBox>(new ComboBox(), Words.DATA, TitledItem.TitledItemOrientation.NORTH);
            this.inventoryData.getElement().addItem(DataType.ALL);
            this.inventoryData.getElement().addItem(DataType.FROM_ZERO);
            this.inventoryData.getElement().addItem(DataType.TO_ZERO);
            this.box.addBox(this.chargePrice, this.chargePrice.getElement());
            this.box.addBox(this.standardPrice, this.standardPrice.getElement());
            this.getViewContainer().add(this.optionTitle);
            this.getViewContainer().add(this.box);
            this.getViewContainer().add(this.bondedState);
            this.getViewContainer().add(this.inventoryData);
        }
    }

    @Override
    public void updateConfiguration(FilterChainConfiguration conf) {
    }

    @Override
    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        return conf;
    }

    @Override
    public String getTitleString() {
        return Words.INVENTORY;
    }

    @Override
    public String getTitleValue() {
        if (this.currentInventory.getChildNamed(InventoryLight_.number).getValue() == null) {
            return "-";
        }
        return "" + this.currentInventory.getChildNamed(InventoryLight_.number).getValue();
    }

    @Override
    public void setInnerPopUp(InnerPopUp2 ip) {
        super.setInnerPopUp(ip);
        ip.enablePreviewButton();
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        Object[] o = new Object[]{};
        return o;
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.optionTitle != null) {
            this.optionTitle.kill();
            this.box.kill();
            this.bondedState.kill();
            this.inventoryData.kill();
        }
        this.optionTitle = null;
        this.box = null;
        this.bondedState = null;
        this.inventoryData = null;
    }

    @Override
    public void addInheritedComponents() {
        super.addInheritedComponents();
        if (this.optionTitle != null) {
            this.optionTitle.setVisible(true);
            this.chargePrice.setVisible(true);
            this.standardPrice.setVisible(true);
            this.bondedState.setVisible(true);
            this.inventoryData.setVisible(true);
        }
    }

    @Override
    public void removeInheritedComponents() {
        super.removeInheritedComponents();
        if (this.optionTitle != null) {
            this.optionTitle.setVisible(false);
            this.chargePrice.setVisible(false);
            this.standardPrice.setVisible(false);
            this.bondedState.setVisible(false);
            this.inventoryData.setVisible(false);
        }
    }

    @Override
    public ThreadSafeExecutable getJob() {
        return new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReportFileComplete file = PrintInventoryStoreDetailsComponent.this.getSelectedReport();
                PrintInventoryStoreDetailsComponent.this.configNode.commit();
                InventoryReportConfiguration config = (InventoryReportConfiguration)PrintInventoryStoreDetailsComponent.this.configNode.getValue();
                config.setStylesheet(file);
                if (PrintInventoryStoreDetailsComponent.this.asPDF != null && ((RadioButton)PrintInventoryStoreDetailsComponent.this.asPDF.getElement()).isChecked()) {
                    config.setFormat(ReportingOutputFormatE.PDF);
                } else {
                    config.setFormat(ReportingOutputFormatE.XLSX);
                }
                boolean wasClosing = false;
                config.setInventory((InventoryReference)PrintInventoryStoreDetailsComponent.this.currentInventory.getValue());
                boolean isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
                if (!isNoPro) {
                    if (((ComboBox)PrintInventoryStoreDetailsComponent.this.inventoryData.getElement()).getSelectedItem() == DataType.ALL) {
                        config.setRemovedCharges(null);
                        config.setCheckins(null);
                    } else if (((ComboBox)PrintInventoryStoreDetailsComponent.this.inventoryData.getElement()).getSelectedItem() == DataType.FROM_ZERO) {
                        config.setRemovedCharges(Boolean.valueOf(false));
                        config.setCheckins(Boolean.valueOf(true));
                    } else if (((ComboBox)PrintInventoryStoreDetailsComponent.this.inventoryData.getElement()).getSelectedItem() == DataType.TO_ZERO) {
                        config.setRemovedCharges(Boolean.valueOf(true));
                        config.setCheckins(Boolean.valueOf(false));
                    }
                    config.setUseStandardPrice(Boolean.valueOf(((RadioButton)PrintInventoryStoreDetailsComponent.this.standardPrice.getElement()).isChecked()));
                } else {
                    config.setRemovedCharges(null);
                    config.setCheckins(null);
                    config.setUseStandardPrice(Boolean.valueOf(false));
                }
                PegasusFileComplete t = null;
                t = (PegasusFileComplete)((InventoryReportServiceManager)ServiceManagerRegistry.getService(InventoryReportServiceManager.class)).getInventoryStoreDetailsReport(config).getValue();
                PrintInventoryStoreDetailsComponent.this.processFile(t);
                Node b = new Node();
                b.setValue((Object)true, 0L);
                return b;
            }

            @Override
            public RemoteLoader getInvoker() {
                return PrintInventoryStoreDetailsComponent.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
    }

    @Override
    public Node<InventoryLight> getCurrentNode() {
        return this.currentInventory;
    }

    @Override
    public BatchJob<InventoryLight> createBatchJob(Node<InventoryLight> value, ThreadSafeExecutable job) {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = PrintInventoryStoreDetailsComponent.this.layoutInheritedComponents(parent);
            if (PrintInventoryStoreDetailsComponent.this.optionTitle != null) {
                PrintInventoryStoreDetailsComponent.this.box.setColumn((parent.getWidth() - 2 * PrintInventoryStoreDetailsComponent.this.border) / 2);
                PrintInventoryStoreDetailsComponent.this.optionTitle.setLocation(PrintInventoryStoreDetailsComponent.this.border, y);
                PrintInventoryStoreDetailsComponent.this.optionTitle.setSize(PrintInventoryStoreDetailsComponent.this.optionTitle.getPreferredSize());
                PrintInventoryStoreDetailsComponent.this.box.setLocation(PrintInventoryStoreDetailsComponent.this.border, PrintInventoryStoreDetailsComponent.this.optionTitle.getY() + PrintInventoryStoreDetailsComponent.this.optionTitle.getHeight() + PrintInventoryStoreDetailsComponent.this.border / 2);
                PrintInventoryStoreDetailsComponent.this.box.setSize(parent.getWidth() - 2 * PrintInventoryStoreDetailsComponent.this.border, (int)PrintInventoryStoreDetailsComponent.this.box.getPreferredSize().getHeight());
                PrintInventoryStoreDetailsComponent.this.bondedState.setLocation(PrintInventoryStoreDetailsComponent.this.border, PrintInventoryStoreDetailsComponent.this.box.getY() + PrintInventoryStoreDetailsComponent.this.box.getHeight() + PrintInventoryStoreDetailsComponent.this.border);
                PrintInventoryStoreDetailsComponent.this.bondedState.setSize(120, (int)PrintInventoryStoreDetailsComponent.this.bondedState.getPreferredSize().getHeight());
                PrintInventoryStoreDetailsComponent.this.inventoryData.setLocation(PrintInventoryStoreDetailsComponent.this.border, PrintInventoryStoreDetailsComponent.this.bondedState.getY() + PrintInventoryStoreDetailsComponent.this.bondedState.getHeight() + PrintInventoryStoreDetailsComponent.this.border);
                PrintInventoryStoreDetailsComponent.this.inventoryData.setSize(120, (int)PrintInventoryStoreDetailsComponent.this.inventoryData.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = PrintInventoryStoreDetailsComponent.this.getInheritedComponentsHeight();
            h += PrintInventoryStoreDetailsComponent.this.border;
            if (PrintInventoryStoreDetailsComponent.this.animation != null) {
                h = (int)((double)h + PrintInventoryStoreDetailsComponent.this.animation.getPreferredSize().getHeight());
                return new Dimension((int)((double)(PrintInventoryStoreDetailsComponent.this.border * 2) + PrintInventoryStoreDetailsComponent.this.animation.getPreferredSize().getWidth()), h += PrintInventoryStoreDetailsComponent.this.border);
            }
            if (PrintInventoryStoreDetailsComponent.this.optionTitle != null) {
                h = (int)((double)h + PrintInventoryStoreDetailsComponent.this.optionTitle.getPreferredSize().getHeight());
                h += PrintInventoryStoreDetailsComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryStoreDetailsComponent.this.box.getPreferredSize().getHeight());
                h += PrintInventoryStoreDetailsComponent.this.border;
                h = (int)((double)h + PrintInventoryStoreDetailsComponent.this.bondedState.getPreferredSize().getHeight());
                h += PrintInventoryStoreDetailsComponent.this.border / 2;
                h = (int)((double)h + PrintInventoryStoreDetailsComponent.this.inventoryData.getPreferredSize().getHeight());
                h += PrintInventoryStoreDetailsComponent.this.border;
            }
            return new Dimension(0, h);
        }
    }

    private static enum DataType {
        ALL,
        FROM_ZERO,
        TO_ZERO;


        public String toString() {
            switch (this) {
                case ALL: {
                    return Words.ALL;
                }
                case FROM_ZERO: {
                    return Words.FROM_ZERO;
                }
                case TO_ZERO: {
                    return Words.TO_ZERO;
                }
            }
            return "";
        }
    }
}

