/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.inventorytransition.detailed;

import ch.icit.pegasus.client.converter.DateTimeConverter;
import ch.icit.pegasus.client.converter.FlightNoConverter;
import ch.icit.pegasus.client.converter.SingleCategoryConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.hud.externopentool.RowSmartExternOpenTool;
import ch.icit.pegasus.client.gui.modules.AppModulesUtils;
import ch.icit.pegasus.client.gui.submodules.print.inventorytransition.detailed.PrintInventoryTransitionComponent;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.InventoryServiceManager;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryReference;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryStoreComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionEntryComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionFlightComplete;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionLight;
import ch.icit.pegasus.server.core.dtos.inventory.InventoryTransitionReference;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleCategoryReference;
import ch.icit.pegasus.server.core.dtos.report.InventoryDetailsReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.InventoryTransitionAccess;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.util.CustomerOwnedStateE;
import ch.icit.pegasus.server.core.dtos.util.DeletedStateE;
import ch.icit.pegasus.server.core.dtos.util.InUseStateE;
import ch.icit.pegasus.server.core.dtos.util.IncludeArticleFromStartInventoryStateE;
import ch.icit.pegasus.server.core.dtos.util.NominatedStateE;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class PrintInventoryTransitionReport
extends RowSmartExternOpenTool<InventoryTransitionLight> {
    @Override
    public void execute(Component comp) {
        if (comp != null) {
            InnerPopUp2 pop = InnerPopUp2.getInnerPopUp();
            pop.setAttributes(comp, true, true, AppModulesUtils.getSubModuleName(InventoryTransitionAccess.PRINT_INVENTORY_TRANSITION));
            PrintInventoryTransitionComponent r = new PrintInventoryTransitionComponent(this.rowTransferObject.getNode());
            this.setView(r, pop);
            pop.showPopUpWithinScreenMiddle(PrintInventoryTransitionReport.preferredSmartScreenPopupSize.width, PrintInventoryTransitionReport.preferredSmartScreenPopupSize.height, this, comp, PopupType.NORMAL);
            r.loadReportTypes();
        }
    }

    public static String getParameterString(InventoryTransitionComplete i) {
        String t = "<html>";
        DateTimeConverter dtc = (DateTimeConverter)ConverterRegistry.getConverter(DateTimeConverter.class);
        SingleCategoryConverter catCon = (SingleCategoryConverter)ConverterRegistry.getConverter(SingleCategoryConverter.class);
        t = t + "<b>Global Bounds:</b> ";
        t = t + dtc.convert((Object)i.getBoundary().getStartTime(), null, new Object[0]);
        t = t + " - " + dtc.convert((Object)i.getBoundary().getEndTime(), null, new Object[0]) + "<br/>";
        t = t + "<b>Bonded:</b> " + i.getBonded() + "<br/>";
        t = t + "<b>Customer Owned:</b> " + i.getCustomerOwned() + "<br/>";
        t = t + "<b>Deleted:</b> " + i.getDeleted() + "<br/>";
        t = t + "<b>From start:</b> " + i.getIncludeArticleFromStartInventory() + "<br/>";
        t = t + "<b>Comment:</b> " + i.getIncludeComment() + "<br/>";
        t = t + "<b>All Comments:</b> " + i.getIncludeAllComments() + "<br/>";
        t = t + "<b>Customer Data:</b> " + i.getIncludeCustomerData() + "<br/>";
        t = t + "<b>Customs Docs:</b> " + i.getIncludeCustomsDocs() + "<br/>";
        t = t + "<b>Irregularity:</b> " + i.getIncludeIrregularity() + "<br/>";
        t = t + "<b>Nominated:</b> " + i.getNominated() + "<br/>";
        t = t + "<b>Uncounted in Sum:</b> " + i.getShowUninventorizedItemsInSum() + "<br/>";
        t = t + "<b>Store based:</b> " + i.getStoreBased() + "<br/>";
        t = t + "<b>TransactionSheets:</b> " + i.getIncludeTransactionSheets() + "<br/>";
        t = t + "<b>Matdispo:</b> " + i.getIncludeMatDispo() + "<br/>";
        t = t + "<b>MatdispoData:</b> " + i.getIncludeMatDispoData() + "<br/>";
        t = t + "<b>Include rejected Data:</b> " + i.getIncludeRejectedData() + "<br/>";
        t = t + "<b>Include Grammage Amount:</b> " + i.getIncludeGrammageAmount() + "<br/>";
        t = t + "<b>Include Supplier Info:</b> " + i.getIncludeSupplierInfo() + "<br/>";
        t = t + "<b>Include Flight Info:</b> " + i.getIncludeFlights() + "<br/>";
        t = t + "<b>Include Inventory Transactions:>/b> " + i.getIncludeInventoryTransactions() + "<br/>";
        t = t + "<b>Category:</b> " + catCon.convert((Object)i.getCategory(), null, new Object[0]) + "<br/>";
        t = t + "<b>Group:</b> " + catCon.convert((Object)i.getGroup(), null, new Object[0]) + "<br/>";
        t = t + "<b>Subgroup:</b> " + catCon.convert((Object)i.getSubGroup(), null, new Object[0]) + "<br/>";
        FlightNoConverter fc = (FlightNoConverter)ConverterRegistry.getConverter(FlightNoConverter.class);
        HashSet<FlightLight> excludeInFlightsS = new HashSet<FlightLight>();
        HashSet<FlightLight> includeInFlightsS = new HashSet<FlightLight>();
        HashSet<FlightLight> excludeOutFlightsS = new HashSet<FlightLight>();
        HashSet<FlightLight> includeOutFlightsS = new HashSet<FlightLight>();
        for (InventoryTransitionEntryComplete e : i.getStartInventories()) {
            for (InventoryTransitionFlightComplete f : e.getExcludedOutFlights()) {
                excludeOutFlightsS.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getExcludedReturnFlights()) {
                excludeInFlightsS.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getIncludedOutFlights()) {
                includeOutFlightsS.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getIncludedReturnFlights()) {
                includeInFlightsS.add(f.getFlight());
            }
        }
        if (!excludeInFlightsS.isEmpty()) {
            t = t + "<b>Exclude In Start Flights</b><br/>";
            for (FlightLight f : excludeInFlightsS) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!excludeOutFlightsS.isEmpty()) {
            t = t + "<b>Exclude Out Start Flights</b><br/>";
            for (FlightLight f : excludeOutFlightsS) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!includeOutFlightsS.isEmpty()) {
            t = t + "<b>Include Out Start Flights</b><br/>";
            for (FlightLight f : includeOutFlightsS) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!includeInFlightsS.isEmpty()) {
            t = t + "<b>Include In Start Flights</b><br/>";
            for (FlightLight f : includeInFlightsS) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        HashSet<FlightLight> excludeInFlightsE = new HashSet<FlightLight>();
        HashSet<FlightLight> includeInFlightsE = new HashSet<FlightLight>();
        HashSet<FlightLight> excludeOutFlightsE = new HashSet<FlightLight>();
        HashSet<FlightLight> includeOutFlightsE = new HashSet<FlightLight>();
        for (InventoryTransitionEntryComplete e : i.getEndInventories()) {
            for (InventoryTransitionFlightComplete f : e.getExcludedOutFlights()) {
                excludeOutFlightsE.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getExcludedReturnFlights()) {
                excludeInFlightsE.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getIncludedOutFlights()) {
                includeOutFlightsE.add(f.getFlight());
            }
            for (InventoryTransitionFlightComplete f : e.getIncludedReturnFlights()) {
                includeInFlightsE.add(f.getFlight());
            }
        }
        if (!excludeInFlightsE.isEmpty()) {
            t = t + "<b>Exclude In End Flights</b><br/>";
            for (FlightLight f : excludeInFlightsE) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!excludeOutFlightsE.isEmpty()) {
            t = t + "<b>Exclude Out End Flights</b><br/>";
            for (FlightLight f : excludeOutFlightsE) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!includeOutFlightsE.isEmpty()) {
            t = t + "<b>Include Out End Flights</b><br/>";
            for (FlightLight f : includeOutFlightsE) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        if (!includeInFlightsE.isEmpty()) {
            t = t + "<b>Include In End Flights</b><br/>";
            for (FlightLight f : includeInFlightsE) {
                t = t + fc.convert(f, null, new Object[0]) + "<br/>";
            }
        }
        t = t + "</html>";
        return t;
    }

    public static List<ScreenValidationObject> fillInventoryTransitionReportConfiguration(InventoryTransitionComplete ic, InventoryDetailsReportConfiguration config) throws ClientServerCallException {
        config.setFormat(ReportingOutputFormatE.XLSX);
        config.setInventoryTransition((InventoryTransitionReference)ic);
        config.setAutoBoundary(Boolean.valueOf(false));
        config.setBonded(ic.getBonded());
        config.setCategory((ArticleCategoryReference)ic.getCategory());
        config.setGroup((ArticleCategoryReference)ic.getGroup());
        config.setShowUninventorizedItemsInSum(ic.getShowUninventorizedItemsInSum());
        config.setIncludeTransactionSheets(ic.getIncludeTransactionSheets());
        config.setIncludeMatDispo(ic.getIncludeMatDispo());
        config.setIncludeMatDispoData(ic.getIncludeMatDispoData());
        config.setIncludeRejectedData(ic.getIncludeRejectedData());
        config.setIncludeGrammage(ic.getIncludeGrammageAmount());
        config.setShowIrregularityAsStore(ic.getShowIrregularityAsStore());
        config.setIncludeComment(ic.getIncludeComment());
        config.setIncludeAllComents(ic.getIncludeAllComments());
        config.setIncludeSupplierInfo(ic.getIncludeSupplierInfo());
        config.setShowFlightsInExport(ic.getIncludeFlights());
        config.setIncludeTradeGoods(ic.getIncludeTradeGoodsAsCheckout());
        Boolean includeArticleFromStartI = null;
        if (ic.getIncludeArticleFromStartInventory() == IncludeArticleFromStartInventoryStateE.START_INVENTORY_ONLY) {
            includeArticleFromStartI = true;
        } else if (ic.getIncludeArticleFromStartInventory() == IncludeArticleFromStartInventoryStateE.END_INVENTORY_ONLY) {
            includeArticleFromStartI = false;
        }
        config.setIncludeArticleFromStartInventory(includeArticleFromStartI);
        config.setIncludeCustomerData(ic.getIncludeCustomerData());
        Boolean includeCustomerOwned = null;
        if (ic.getCustomerOwned() == CustomerOwnedStateE.ONLY_CUSTOMER_OWNED) {
            includeCustomerOwned = true;
        } else if (ic.getCustomerOwned() == CustomerOwnedStateE.NOT_CUSTOMER_OWNED) {
            includeCustomerOwned = false;
        }
        config.setIncludeCustomerOwned(includeCustomerOwned);
        config.setIncludeCustomsDocuments(ic.getIncludeCustomsDocs());
        Boolean includeNominated = null;
        if (ic.getNominated() == NominatedStateE.ONLY_NOMINATED) {
            includeNominated = true;
        } else if (ic.getNominated() == NominatedStateE.NOT_NOMINATED) {
            includeNominated = false;
        }
        config.setIncludeNominated(includeNominated);
        Boolean includeDeleted = null;
        if (ic.getDeleted() == DeletedStateE.ONLY_DELETED) {
            includeDeleted = true;
        } else if (ic.getDeleted() == DeletedStateE.NOT_DELETED) {
            includeDeleted = false;
        }
        config.setIncludeDeleted(includeDeleted);
        config.setIncludeIrregularity(ic.getIncludeIrregularity());
        config.setIncludePrices(ic.getIncludePrices());
        config.setIncludeStoreBasedInfo(ic.getStoreBased());
        config.setIncludeUnCountedArticles(ic.getExpandWithAllArticles());
        config.setIncludePurchaseWaste(ic.getIncludePurchaseWaste());
        Boolean includeUsed = null;
        if (ic.getIncludeUnused() == InUseStateE.ONLY_USED) {
            includeUsed = true;
        } else if (ic.getIncludeUnused() == InUseStateE.NOT_USED) {
            includeUsed = false;
        }
        config.setIncludeUnused(includeUsed);
        config.setPeriod(ic.getBoundary());
        config.setSubGroup((ArticleCategoryReference)ic.getSubGroup());
        config.setUseInternalConsumptionDateForMovements(ic.getUseInternalConsumptionDateForMovements());
        config.setInternalConsumptionStart(ic.getInternalConsumptionStart());
        config.setInternalConsumptionEnd(ic.getInternalConsumptionEnd());
        config.getStartData().addAll(ic.getStartInventories());
        config.getEndData().addAll(ic.getEndInventories());
        List<ScreenValidationObject> v = PrintInventoryTransitionReport.validateStores(config.getStartInventories(), config.getEndInventories());
        return v;
    }

    public static List<ScreenValidationObject> validateStores(List<InventoryReference> start, List<InventoryReference> end) throws ClientServerCallException {
        InventoryComplete sc;
        ArrayList<ScreenValidationObject> a = new ArrayList<ScreenValidationObject>();
        HashSet<StoreLight> stores = new HashSet<StoreLight>();
        for (InventoryReference s : start) {
            sc = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(s).getValue();
            for (InventoryStoreComplete is : sc.getStores()) {
                if (stores.contains(is.getStore())) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Store " + ((StoreLight)is.getStore()).getCode() + " has more than one start Inventory"));
                    continue;
                }
                stores.add((StoreLight)is.getStore());
            }
        }
        stores.clear();
        for (InventoryReference s : end) {
            sc = (InventoryComplete)((InventoryServiceManager)ServiceManagerRegistry.getService(InventoryServiceManager.class)).get(s).getValue();
            for (InventoryStoreComplete is : sc.getStores()) {
                if (stores.contains(is.getStore())) {
                    a.add(new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "Store " + ((StoreLight)is.getStore()).getCode() + " has more than one end Inventory"));
                    continue;
                }
                stores.add((StoreLight)is.getStore());
            }
        }
        return a;
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return InventoryTransitionAccess.getSubModuleDefinition((SubModuleAccessDefinition)InventoryTransitionAccess.PRINT_INVENTORY_TRANSITION);
    }
}

