/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.print.product.factsheet.pdf;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.submodules.print.product.factsheet.pdf.PrintProductFactSheetComponent;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.datechooser.DateChooser;
import ch.icit.pegasus.client.gui.utils.filterchain.FilterChainConfiguration;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.icons.ArrowConnectorIcon;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.supply.SupplyServiceManager;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.HUDToolkit;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.file.ReportFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantReference;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration;
import ch.icit.pegasus.server.core.dtos.report.ProductFactSheetReportConfiguration_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.DataFieldAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.access.ModuleAccessRightComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.util.XMLWrapper.ListWrapper;
import ch.icit.pegasus.server.core.dtos.utils.CompanyUtil;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.core.i18n.WordsToolkit;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class ProductFactSheetConfigurationPanel
extends DefaultPanel
implements ButtonListener {
    private boolean isNoPro;
    private PrintProductFactSheetComponent component;
    private final Node<ProductComplete> currentProduct;
    private final Node configNode;
    private TitledItem<DateChooser> dueDate;
    private HorizontalSeparator sep1;
    private CostOption processCostOption;
    private CostOption processCostTotalOption;
    private CostOption groupProcessCostOption;
    private CostOption groupShowTotalCostOption;
    private TextLabel printOptionTitle;
    private TitledItem<CheckBox> includeCosts;
    private final List<CostOption> optionsList = new ArrayList<CostOption>();
    private TitledItem<CheckBox> includeHandlingCostInProductGrossPrice;
    private TitledItem<CheckBox> includeAllergens;
    private TitledItem<CheckBox> includeAdditives;
    private TitledItem<CheckBox> includeTraces;
    private TitledItem<CheckBox> includeOthers;
    private HorizontalSeparator sep2;
    private TextLabel extrasTitle;
    private TitledItem<CheckBox> includeImage;
    private TitledItem<CheckBox> includePurchaseWaste;
    private TitledItem<CheckBox> includeCookingWaste;
    private TitledItem<CheckBox> includeComponentComments;
    private TitledItem<CheckBox> includeProductComments;
    private TitledItem<CheckBox> includeBruttoQuantity;
    private TitledItem<CheckBox> useExternalCosts;
    private boolean showProductionCosts = false;
    private boolean printExternalCostFactSheet = false;
    private boolean restaurantUser = false;
    private int border = 10;

    public ProductFactSheetConfigurationPanel(PrintProductFactSheetComponent component, Node<ProductComplete> node) {
        this.component = component;
        this.currentProduct = node;
        this.isNoPro = CompanyUtil.isNoPro((SystemSettingsComplete)((SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue()));
        Runnable r = () -> {
            UserComplete user = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
            ModuleAccessRightComplete r1 = HUDToolkit.getCurrentAccessRight(ProductAccess.MODULE_PRODUCT, user);
            for (DataFieldAccessRightComplete a : r1.getFieldAccessRights()) {
                if (a.getField().getName().equals("showProductionCosts")) {
                    this.showProductionCosts = true;
                    continue;
                }
                if (!a.getField().getName().equals("printExternalCostFactSheet")) continue;
                this.printExternalCostFactSheet = true;
            }
            if (Boolean.TRUE.equals(user.getRestaurantUser())) {
                this.restaurantUser = true;
            }
            ProductComplete p = (ProductComplete)this.currentProduct.getValue();
            try {
                List ret = ((SupplyServiceManager)ServiceManagerRegistry.getService(SupplyServiceManager.class)).getProductVariantsByReferences(new ListWrapper(p.getVariants())).getList();
                ArrayList refs = new ArrayList();
                refs.addAll(ret);
                this.currentProduct.getChildNamed(ProductComplete_.variants).removeExistingValues();
                this.currentProduct.getChildNamed(ProductComplete_.variants).setValue(refs, 0L);
                this.currentProduct.getChildNamed(ProductComplete_.variants).updateNode();
                this.currentProduct.getChildNamed(ProductComplete_.currentVariant).removeExistingValues();
                this.currentProduct.getChildNamed(ProductComplete_.currentVariant).setValue((Object)p.getCurrentVariant(), 0L);
                this.currentProduct.getChildNamed(ProductComplete_.currentVariant).updateNode();
            }
            catch (ClientServerCallException e) {
                InnerPopupFactory.showErrorDialog((Exception)((Object)e), (Component)this);
            }
        };
        component.loadBeforeShowing(r);
        ProductFactSheetReportConfiguration config = new ProductFactSheetReportConfiguration(null);
        config.setDueDate(new Timestamp(System.currentTimeMillis()));
        this.configNode = INodeCreator.getDefaultImpl().getNode4DTO((Object)config, false, false);
    }

    public void createComponents() {
        this.setLayout(new Layout());
        Font f = AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type"));
        Color fb = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color"));
        this.dueDate = new TitledItem<DateChooser>(new DateChooser(this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.dueDate)), Words.DUE_DATE, TitledItem.TitledItemOrientation.NORTH);
        this.dueDate.getElement().setIsTimestamp(true);
        if (!this.restaurantUser && !this.isNoPro) {
            this.sep1 = new HorizontalSeparator();
            this.printOptionTitle = new TextLabel(WordsToolkit.toUpperCase((String)Words.OPTIONS));
            this.printOptionTitle.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_titled_item_font_type")));
            this.printOptionTitle.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_titled_item_foreground")));
            this.includeCosts = new TitledItem<CheckBox>(new CheckBox(), "Include Costs (Sales Price)", TitledItem.TitledItemOrientation.EAST);
            this.includeCosts.setTitleFont(f);
            this.includeCosts.setTitleForeground(fb);
            this.includeCosts.getElement().setChecked(this.showProductionCosts);
            this.includeCosts.getElement().addButtonListener(this);
            this.optionsList.add(new CostOption(Words.MATERIAL_PRICE, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.materialCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.materialCostDetails), fb, f, 5));
            this.processCostOption = new CostOption(Words.PRODUCT_PROCESS_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.productProcessCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.productProcessCostDetails), fb, f, 5);
            this.optionsList.add(this.processCostOption);
            this.processCostTotalOption = new CostOption(Words.PRODUCT_PROCESS_COSTS_TOTAL, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.includeProcessTotalTime), null, fb, f, 5);
            this.optionsList.add(this.processCostTotalOption);
            this.groupProcessCostOption = new CostOption(Words.GROUP_PROCESS_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCostDetails), fb, f, 5);
            this.optionsList.add(this.groupProcessCostOption);
            this.groupShowTotalCostOption = new CostOption(Words.GROUP_PROCESS_COSTS_TOTAL, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCostTotal), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.groupProcessCostDetails), fb, f, 5);
            this.optionsList.add(this.groupShowTotalCostOption);
            this.optionsList.add(new CostOption(Words.ADDITIONAL_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.additionalCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.additionalCostDetails), fb, f, 5));
            this.optionsList.add(new CostOption(Words.HANDLING_COSTS, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.handlingCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.handlingCostDetails), fb, f, 5));
            this.optionsList.add(new CostOption(Words.DISCOUNT, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.discountCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.discountDetails), fb, f, 5));
            this.optionsList.add(new CostOption(Words.TAXES, Words.DETAILED_VIEW, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.taxCost), this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.taxCostDetails), fb, f, 5));
            this.optionsList.add(new CostOption(Words.NET_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.nettoCost), null, fb, f, 5));
            this.optionsList.add(new CostOption(Words.CALCULATED_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.calculatedSalesPrice), null, fb, f, 5));
            this.optionsList.add(new CostOption(Words.FIX_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.fixedSalesPrice), null, fb, f, 5));
            this.optionsList.add(new CostOption(Words.GROSS_SALES_PRICE, null, this.configNode.getChildNamed(ProductFactSheetReportConfiguration_.bruttoPrice), null, fb, f, 5));
            this.includeHandlingCostInProductGrossPrice = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_HANDLING_IN_PRODUCT_PRICE, TitledItem.TitledItemOrientation.EAST);
            this.includeHandlingCostInProductGrossPrice.setTitleFont(f);
            this.includeHandlingCostInProductGrossPrice.setTitleForeground(fb);
            this.includeHandlingCostInProductGrossPrice.getElement().setChecked(this.showProductionCosts);
            this.sep2 = new HorizontalSeparator();
            this.includeAllergens = new TitledItem<CheckBox>(new CheckBox(), "Include Allergens", TitledItem.TitledItemOrientation.EAST);
            this.includeAllergens.setTitleFont(f);
            this.includeAllergens.setTitleForeground(fb);
            this.includeAdditives = new TitledItem<CheckBox>(new CheckBox(), "Include Additive", TitledItem.TitledItemOrientation.EAST);
            this.includeAdditives.setTitleFont(f);
            this.includeAdditives.setTitleForeground(fb);
            this.includeTraces = new TitledItem<CheckBox>(new CheckBox(), "Include Traces", TitledItem.TitledItemOrientation.EAST);
            this.includeTraces.setTitleFont(f);
            this.includeTraces.setTitleForeground(fb);
            this.includeOthers = new TitledItem<CheckBox>(new CheckBox(), "Include Others", TitledItem.TitledItemOrientation.EAST);
            this.includeOthers.setTitleFont(f);
            this.includeOthers.setTitleForeground(fb);
            this.includePurchaseWaste = new TitledItem<CheckBox>(new CheckBox(), "Include Purchase Waste", TitledItem.TitledItemOrientation.EAST);
            this.includePurchaseWaste.setTitleFont(f);
            this.includePurchaseWaste.setTitleForeground(fb);
            this.includeCookingWaste = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COOKING_WASTE, TitledItem.TitledItemOrientation.EAST);
            this.includeCookingWaste.setTitleFont(f);
            this.includeCookingWaste.setTitleForeground(fb);
            this.includeImage = new TitledItem<CheckBox>(new CheckBox(), "Include Image", TitledItem.TitledItemOrientation.EAST);
            this.includeImage.setTitleFont(f);
            this.includeImage.setTitleForeground(fb);
            this.includeComponentComments = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMPONENT_COMMENT, TitledItem.TitledItemOrientation.EAST);
            this.includeComponentComments.setTitleFont(f);
            this.includeComponentComments.setTitleForeground(fb);
            this.includeProductComments = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_COMMENT, TitledItem.TitledItemOrientation.EAST);
            this.includeProductComments.setTitleFont(f);
            this.includeProductComments.setTitleForeground(fb);
            this.includeBruttoQuantity = new TitledItem<CheckBox>(new CheckBox(), Words.INCLUDE_GROSS_QUANTITY, TitledItem.TitledItemOrientation.EAST);
            this.includeBruttoQuantity.setTitleFont(f);
            this.includeBruttoQuantity.setTitleForeground(fb);
            SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
            if (settings.getUseProductTenderScenario().booleanValue()) {
                this.useExternalCosts = new TitledItem<CheckBox>(new CheckBox(), Words.USE_TENDER_DATA, TitledItem.TitledItemOrientation.EAST);
                this.useExternalCosts.setTitleFont(f);
                this.useExternalCosts.setTitleForeground(fb);
                this.useExternalCosts.getElement().addButtonListener(this);
                if (!this.printExternalCostFactSheet) {
                    this.useExternalCosts.getElement().setChecked(false);
                }
            }
        }
        this.add(this.dueDate);
        if (!this.restaurantUser && !this.isNoPro) {
            this.add(this.sep1);
            this.add(this.printOptionTitle);
            this.add(this.includeCosts);
            for (CostOption o : this.optionsList) {
                this.add(o);
            }
            this.add(this.includeHandlingCostInProductGrossPrice);
            this.add(this.sep2);
            this.add(this.includeAllergens);
            this.add(this.includeAdditives);
            this.add(this.includeTraces);
            this.add(this.includeOthers);
            this.add(this.includePurchaseWaste);
            this.add(this.includeCookingWaste);
            this.add(this.includeImage);
            this.add(this.includeComponentComments);
            this.add(this.includeProductComments);
            this.add(this.includeBruttoQuantity);
            if (this.useExternalCosts != null) {
                this.add(this.useExternalCosts);
            }
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.dueDate.setEnabled(isEnabled);
        if (!this.restaurantUser && !this.isNoPro) {
            this.sep1.setEnabled(isEnabled);
            this.printOptionTitle.setEnabled(isEnabled);
            this.includeCosts.setEnabled(isEnabled && this.showProductionCosts);
            this.includeHandlingCostInProductGrossPrice.setEnabled(isEnabled && this.showProductionCosts);
            for (CostOption o : this.optionsList) {
                o.setEnabled(isEnabled && this.showProductionCosts);
            }
            boolean productProcess = this.processCostOption.isChecked();
            this.groupProcessCostOption.setEnabled(isEnabled && productProcess);
            this.processCostTotalOption.setEnabled(isEnabled && productProcess);
            this.sep2.setEnabled(isEnabled);
            if (this.extrasTitle != null) {
                this.extrasTitle.setEnabled(isEnabled);
            }
            this.includeImage.setEnabled(isEnabled);
            this.includeAllergens.setEnabled(isEnabled);
            this.includeAdditives.setEnabled(isEnabled);
            this.includeTraces.setEnabled(isEnabled);
            this.includeOthers.setEnabled(isEnabled);
            this.includePurchaseWaste.setEnabled(isEnabled);
            this.includeCookingWaste.setEnabled(isEnabled);
            this.includeComponentComments.setEnabled(isEnabled);
            this.includeProductComments.setEnabled(isEnabled);
            this.includeBruttoQuantity.setEnabled(isEnabled);
            if (this.useExternalCosts != null) {
                this.useExternalCosts.setEnabled(isEnabled && this.printExternalCostFactSheet);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        return null;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public void requestFocusInWindowNow() {
    }

    public ProductFactSheetReportConfiguration<ProductVariantReference> createPrintConfiguration(ReportFileComplete file) {
        this.configNode.commit();
        ProductFactSheetReportConfiguration config = (ProductFactSheetReportConfiguration)this.configNode.getValue();
        config.setStylesheet(file);
        if (!this.restaurantUser && !this.isNoPro) {
            if (this.showProductionCosts) {
                config.setIncludeCosts(Boolean.valueOf(this.includeCosts.getElement().isChecked()));
                config.setIncludeHandlingCostToProductPrice(Boolean.valueOf(this.includeHandlingCostInProductGrossPrice.getElement().isChecked()));
                if (this.useExternalCosts != null) {
                    config.setUseExternalCosts(Boolean.valueOf(this.useExternalCosts.getElement().isChecked() && this.printExternalCostFactSheet));
                    config.setUseLinkedTender(Boolean.valueOf(false));
                } else {
                    config.setUseExternalCosts(Boolean.valueOf(false));
                    config.setUseLinkedTender(Boolean.valueOf(false));
                }
            } else {
                config.setIncludeCosts(Boolean.valueOf(false));
                config.setBruttoPrice(Boolean.valueOf(false));
                config.setCalculatedSalesPrice(Boolean.valueOf(false));
                config.setFixedSalesPrice(Boolean.valueOf(false));
                config.setMaterialCost(Boolean.valueOf(false));
                config.setHandlingCost(Boolean.valueOf(false));
                config.setHandlingCostDetails(Boolean.valueOf(false));
                config.setMaterialCostDetails(Boolean.valueOf(false));
                config.setNettoCost(Boolean.valueOf(false));
                config.setProductProcessCost(Boolean.valueOf(false));
                config.setProductProcessCostDetails(Boolean.valueOf(false));
                config.setGroupProcessCost(Boolean.valueOf(false));
                config.setGroupProcessCostDetails(Boolean.valueOf(false));
                config.setTaxCost(Boolean.valueOf(false));
                config.setTaxCostDetails(Boolean.valueOf(false));
            }
            config.setIncludeImage(Boolean.valueOf(this.includeImage.getElement().isChecked()));
            config.setAllergens(Boolean.valueOf(this.includeAllergens.getElement().isChecked()));
            config.setTraces(Boolean.valueOf(this.includeTraces.getElement().isChecked()));
            config.setAdditives(Boolean.valueOf(this.includeAdditives.getElement().isChecked()));
            config.setOthers(Boolean.valueOf(this.includeOthers.getElement().isChecked()));
            config.setIncludePurchaseWaste(Boolean.valueOf(this.includePurchaseWaste.getElement().isChecked()));
            config.setIncludeCookingWaste(Boolean.valueOf(this.includeCookingWaste.getElement().isChecked()));
            config.setIncludeComponentComments(Boolean.valueOf(this.includeComponentComments.getElement().isChecked()));
            config.setIncludeBruttoQuantity(Boolean.valueOf(this.includeBruttoQuantity.getElement().isChecked()));
            config.setIncludeProductComments(Boolean.valueOf(this.includeProductComments.getElement().isChecked()));
            if (!this.processCostOption.isChecked()) {
                config.setGroupProcessCost(Boolean.valueOf(false));
                config.setGroupProcessCostDetails(Boolean.valueOf(false));
                config.setIncludeProcessTotalTime(Boolean.valueOf(false));
            }
        } else if (this.restaurantUser) {
            config.setFixedSalesPrice(Boolean.valueOf(true));
            config.setIncludeImage(Boolean.valueOf(true));
            config.setOthers(Boolean.valueOf(true));
            config.setAllergens(Boolean.valueOf(true));
            config.setAdditives(Boolean.valueOf(true));
            config.setTraces(Boolean.valueOf(true));
            config.setTaxCost(Boolean.valueOf(true));
            config.setTaxCostDetails(Boolean.valueOf(true));
            config.setBruttoPrice(Boolean.valueOf(true));
        } else if (this.isNoPro) {
            config.setFixedSalesPrice(Boolean.valueOf(false));
            config.setIncludeImage(Boolean.valueOf(true));
            config.setOthers(Boolean.valueOf(false));
            config.setAllergens(Boolean.valueOf(false));
            config.setAdditives(Boolean.valueOf(false));
            config.setTraces(Boolean.valueOf(false));
            config.setTaxCost(Boolean.valueOf(false));
            config.setTaxCostDetails(Boolean.valueOf(false));
            config.setBruttoPrice(Boolean.valueOf(false));
        }
        return config;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.includeCosts.getElement()) {
            for (CostOption o : this.optionsList) {
                o.setFirstCheck(this.includeCosts.getElement().isChecked());
                o.setEnabled(this.includeCosts.getElement().isChecked());
            }
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.printOptionTitle != null) {
            this.printOptionTitle.kill();
        }
        if (this.dueDate != null) {
            this.dueDate.kill();
        }
        if (this.sep1 != null) {
            this.sep1.kill();
        }
        if (this.includeCosts != null) {
            this.includeCosts.kill();
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.kill();
        }
        for (CostOption o : this.optionsList) {
            o.kill();
        }
        if (this.sep2 != null) {
            this.sep2.kill();
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.kill();
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.kill();
        }
        if (this.includeOthers != null) {
            this.includeOthers.kill();
        }
        if (this.includeTraces != null) {
            this.includeTraces.kill();
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.kill();
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.kill();
        }
        if (this.includeImage != null) {
            this.includeImage.kill();
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.kill();
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.kill();
        }
        if (this.includeBruttoQuantity != null) {
            this.includeBruttoQuantity.kill();
        }
        if (this.useExternalCosts != null) {
            this.useExternalCosts.kill();
        }
        this.includeBruttoQuantity = null;
        this.includeComponentComments = null;
        this.includeProductComments = null;
        this.printOptionTitle = null;
        this.dueDate = null;
        this.sep1 = null;
        this.includeCosts = null;
        this.includeHandlingCostInProductGrossPrice = null;
        this.optionsList.clear();
        this.sep2 = null;
        this.includeAllergens = null;
        this.includeAdditives = null;
        this.includeOthers = null;
        this.includeTraces = null;
        this.includeImage = null;
        this.includePurchaseWaste = null;
        this.includeCookingWaste = null;
        this.useExternalCosts = null;
        this.processCostOption = null;
        this.processCostTotalOption = null;
        this.groupProcessCostOption = null;
    }

    public FilterChainConfiguration createFilterChainConfig() {
        FilterChainConfiguration conf = new FilterChainConfiguration();
        if (!this.restaurantUser && !this.isNoPro) {
            conf.addProperty("costs", "" + this.includeCosts.getElement().isChecked());
            conf.addProperty("includeHandling", "" + this.includeHandlingCostInProductGrossPrice.getElement().isChecked());
            conf.addProperty("purchase", "" + this.includePurchaseWaste.getElement().isChecked());
            conf.addProperty("allergens", "" + this.includeAllergens.getElement().isChecked());
            conf.addProperty("additives", "" + this.includeAdditives.getElement().isChecked());
            conf.addProperty("others", "" + this.includeOthers.getElement().isChecked());
            conf.addProperty("traces", "" + this.includeTraces.getElement().isChecked());
            conf.addProperty("cooking", "" + this.includeCookingWaste.getElement().isChecked());
            conf.addProperty("image", "" + this.includeImage.getElement().isChecked());
            conf.addProperty("matprice", "" + ((CheckBox)this.optionsList.get(0).firstItem.getElement()).isChecked());
            conf.addProperty("matprice_1", "" + ((CheckBox)this.optionsList.get(0).secondItem.getElement()).isChecked());
            conf.addProperty("proprice", "" + ((CheckBox)this.optionsList.get(1).firstItem.getElement()).isChecked());
            conf.addProperty("proprice_1", "" + ((CheckBox)this.optionsList.get(1).secondItem.getElement()).isChecked());
            conf.addProperty("proc_total", "" + ((CheckBox)this.optionsList.get(2).firstItem.getElement()).isChecked());
            conf.addProperty("group_proprice", "" + ((CheckBox)this.optionsList.get(3).firstItem.getElement()).isChecked());
            conf.addProperty("group_proprice_1", "" + ((CheckBox)this.optionsList.get(3).secondItem.getElement()).isChecked());
            conf.addProperty("group_total", "" + ((CheckBox)this.optionsList.get(4).firstItem.getElement()).isChecked());
            conf.addProperty("addprice", "" + ((CheckBox)this.optionsList.get(5).firstItem.getElement()).isChecked());
            conf.addProperty("addprice_1", "" + ((CheckBox)this.optionsList.get(5).secondItem.getElement()).isChecked());
            conf.addProperty("handprice", "" + ((CheckBox)this.optionsList.get(6).firstItem.getElement()).isChecked());
            conf.addProperty("handprice_1", "" + ((CheckBox)this.optionsList.get(6).secondItem.getElement()).isChecked());
            conf.addProperty("discount", "" + ((CheckBox)this.optionsList.get(7).firstItem.getElement()).isChecked());
            conf.addProperty("discount_1", "" + ((CheckBox)this.optionsList.get(7).secondItem.getElement()).isChecked());
            conf.addProperty("taxprice", "" + ((CheckBox)this.optionsList.get(8).firstItem.getElement()).isChecked());
            conf.addProperty("taxprice_1", "" + ((CheckBox)this.optionsList.get(8).secondItem.getElement()).isChecked());
            conf.addProperty("netto", "" + ((CheckBox)this.optionsList.get(9).firstItem.getElement()).isChecked());
            conf.addProperty("calc", "" + ((CheckBox)this.optionsList.get(10).firstItem.getElement()).isChecked());
            conf.addProperty("fix", "" + ((CheckBox)this.optionsList.get(11).firstItem.getElement()).isChecked());
            conf.addProperty("brutto", "" + ((CheckBox)this.optionsList.get(12).firstItem.getElement()).isChecked());
            conf.addProperty("comment", "" + this.includeComponentComments.getElement().isChecked());
            conf.addProperty("brutto_qty", "" + this.includeBruttoQuantity.getElement().isChecked());
            conf.addProperty("product_comments", "" + this.includeProductComments.getElement().isChecked());
            if (this.useExternalCosts != null) {
                conf.addProperty("use_external_costs", "" + this.useExternalCosts.getElement().isChecked());
            }
        }
        return conf;
    }

    public void updateConfiguration(FilterChainConfiguration conf) {
        if (!this.restaurantUser && !this.isNoPro) {
            for (String[] s : conf.getProperties()) {
                String n = s[0];
                String v = s[1];
                Boolean b = Boolean.valueOf(v);
                switch (n) {
                    case "costs": {
                        this.includeCosts.getElement().setChecked(b);
                        break;
                    }
                    case "includeHandling": {
                        this.includeHandlingCostInProductGrossPrice.getElement().setChecked(b);
                        break;
                    }
                    case "allergens": {
                        this.includeAllergens.getElement().setChecked(b);
                        break;
                    }
                    case "additives": {
                        this.includeAdditives.getElement().setChecked(b);
                        break;
                    }
                    case "others": {
                        this.includeOthers.getElement().setChecked(b);
                        break;
                    }
                    case "traces": {
                        this.includeTraces.getElement().setChecked(b);
                        break;
                    }
                    case "purchase": {
                        this.includePurchaseWaste.getElement().setChecked(b);
                        break;
                    }
                    case "cooking": {
                        this.includeCookingWaste.getElement().setChecked(b);
                        break;
                    }
                    case "image": {
                        this.includeImage.getElement().setChecked(b);
                        break;
                    }
                    case "matprice": {
                        ((CheckBox)this.optionsList.get(0).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "matprice_1": {
                        ((CheckBox)this.optionsList.get(0).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "proprice": {
                        ((CheckBox)this.optionsList.get(1).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "proprice_1": {
                        ((CheckBox)this.optionsList.get(1).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "proc_total": {
                        ((CheckBox)this.optionsList.get(2).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "group_proprice": {
                        ((CheckBox)this.optionsList.get(3).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "group_proprice_1": {
                        ((CheckBox)this.optionsList.get(3).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "group_total": {
                        ((CheckBox)this.optionsList.get(4).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "addprice": {
                        ((CheckBox)this.optionsList.get(5).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "addprice_1": {
                        ((CheckBox)this.optionsList.get(5).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "handprice": {
                        ((CheckBox)this.optionsList.get(6).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "handprice_1": {
                        ((CheckBox)this.optionsList.get(6).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "discount": {
                        ((CheckBox)this.optionsList.get(7).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "discount_1": {
                        ((CheckBox)this.optionsList.get(7).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "taxprice": {
                        ((CheckBox)this.optionsList.get(8).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "taxprice_1": {
                        ((CheckBox)this.optionsList.get(8).secondItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "netto": {
                        ((CheckBox)this.optionsList.get(9).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "calc": {
                        ((CheckBox)this.optionsList.get(10).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "fix": {
                        ((CheckBox)this.optionsList.get(11).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "brutto": {
                        ((CheckBox)this.optionsList.get(12).firstItem.getElement()).setChecked(b != false && this.showProductionCosts);
                        break;
                    }
                    case "comment": {
                        this.includeComponentComments.getElement().setChecked(b);
                        break;
                    }
                    case "brutto_qty": {
                        this.includeBruttoQuantity.getElement().setChecked(b);
                        break;
                    }
                    case "product_comments": {
                        this.includeProductComments.getElement().setChecked(b);
                        break;
                    }
                    case "use_external_costs": {
                        if (this.useExternalCosts == null) break;
                        this.useExternalCosts.getElement().setChecked(b != false && this.printExternalCostFactSheet);
                    }
                }
            }
        }
    }

    public void hideComponents() {
        if (this.dueDate != null) {
            this.dueDate.setVisible(false);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(false);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(false);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(false);
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.setVisible(false);
        }
        for (CostOption o : this.optionsList) {
            o.setVisible(false);
        }
        if (this.sep2 != null) {
            this.sep2.setVisible(false);
        }
        if (this.extrasTitle != null) {
            this.extrasTitle.setVisible(false);
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.setVisible(false);
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.setVisible(false);
        }
        if (this.includeTraces != null) {
            this.includeTraces.setVisible(false);
        }
        if (this.includeOthers != null) {
            this.includeOthers.setVisible(false);
        }
        if (this.includeImage != null) {
            this.includeImage.setVisible(false);
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.setVisible(false);
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.setVisible(false);
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.setVisible(false);
        }
        if (this.includeBruttoQuantity != null) {
            this.includeBruttoQuantity.setVisible(false);
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.setVisible(false);
        }
        if (this.useExternalCosts != null) {
            this.useExternalCosts.setVisible(false);
        }
    }

    public void showComponents() {
        if (this.dueDate != null) {
            this.dueDate.setVisible(true);
        }
        if (this.sep1 != null) {
            this.sep1.setVisible(true);
        }
        if (this.printOptionTitle != null) {
            this.printOptionTitle.setVisible(true);
        }
        if (this.includeCosts != null) {
            this.includeCosts.setVisible(true);
        }
        if (this.includeHandlingCostInProductGrossPrice != null) {
            this.includeHandlingCostInProductGrossPrice.setVisible(true);
        }
        for (CostOption o : this.optionsList) {
            o.setVisible(true);
        }
        if (this.sep2 != null) {
            this.sep2.setVisible(true);
        }
        if (this.extrasTitle != null) {
            this.extrasTitle.setVisible(true);
        }
        if (this.includeAllergens != null) {
            this.includeAllergens.setVisible(true);
        }
        if (this.includeAdditives != null) {
            this.includeAdditives.setVisible(true);
        }
        if (this.includeTraces != null) {
            this.includeTraces.setVisible(true);
        }
        if (this.includeOthers != null) {
            this.includeOthers.setVisible(true);
        }
        if (this.includeImage != null) {
            this.includeImage.setVisible(true);
        }
        if (this.includePurchaseWaste != null) {
            this.includePurchaseWaste.setVisible(true);
        }
        if (this.includeCookingWaste != null) {
            this.includeCookingWaste.setVisible(true);
        }
        if (this.includeComponentComments != null) {
            this.includeComponentComments.setVisible(true);
        }
        if (this.includeProductComments != null) {
            this.includeProductComments.setVisible(true);
        }
        if (this.includeBruttoQuantity != null) {
            this.includeBruttoQuantity.setVisible(true);
        }
        if (this.useExternalCosts != null) {
            this.useExternalCosts.setVisible(true);
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int y = 0;
            if (ProductFactSheetConfigurationPanel.this.dueDate != null) {
                ProductFactSheetConfigurationPanel.this.dueDate.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.dueDate.setSize(parent.getWidth() - 2 * ProductFactSheetConfigurationPanel.this.border, (int)ProductFactSheetConfigurationPanel.this.dueDate.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.dueDate.getY() + ProductFactSheetConfigurationPanel.this.dueDate.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.sep1 != null) {
                ProductFactSheetConfigurationPanel.this.sep1.setLocation(0, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.sep1.setSize(parent.getWidth(), (int)ProductFactSheetConfigurationPanel.this.sep1.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.sep1.getY() + ProductFactSheetConfigurationPanel.this.sep1.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.printOptionTitle != null) {
                ProductFactSheetConfigurationPanel.this.printOptionTitle.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border);
                ProductFactSheetConfigurationPanel.this.printOptionTitle.setSize(parent.getWidth() - 2 * ProductFactSheetConfigurationPanel.this.border, (int)ProductFactSheetConfigurationPanel.this.printOptionTitle.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.printOptionTitle.getY() + ProductFactSheetConfigurationPanel.this.printOptionTitle.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeCosts != null) {
                ProductFactSheetConfigurationPanel.this.includeCosts.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeCosts.setSize(parent.getWidth() - 2 * ProductFactSheetConfigurationPanel.this.border, (int)ProductFactSheetConfigurationPanel.this.includeCosts.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeCosts.getY() + ProductFactSheetConfigurationPanel.this.includeCosts.getHeight();
            }
            for (CostOption o : ProductFactSheetConfigurationPanel.this.optionsList) {
                o.setLocation(ProductFactSheetConfigurationPanel.this.border * 2, y + ProductFactSheetConfigurationPanel.this.border / 3);
                o.setSize(parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border, (int)o.getPreferredSize().getHeight());
                y = o.getY() + o.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice != null) {
                ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.setSize(parent.getWidth() - 2 * ProductFactSheetConfigurationPanel.this.border, (int)ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.getY() + ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.sep2 != null) {
                ProductFactSheetConfigurationPanel.this.sep2.setLocation(0, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.sep2.setSize(parent.getWidth(), (int)ProductFactSheetConfigurationPanel.this.sep2.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.sep2.getY() + ProductFactSheetConfigurationPanel.this.sep2.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.extrasTitle != null) {
                ProductFactSheetConfigurationPanel.this.extrasTitle.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border);
                ProductFactSheetConfigurationPanel.this.extrasTitle.setSize(parent.getWidth() - 2 * ProductFactSheetConfigurationPanel.this.border, (int)ProductFactSheetConfigurationPanel.this.extrasTitle.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.extrasTitle.getY() + ProductFactSheetConfigurationPanel.this.extrasTitle.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeAllergens != null) {
                ProductFactSheetConfigurationPanel.this.includeAllergens.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeAllergens.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeAllergens.getPreferredSize().getHeight());
            }
            if (ProductFactSheetConfigurationPanel.this.includeAdditives != null) {
                ProductFactSheetConfigurationPanel.this.includeAdditives.setLocation((parent.getWidth() - ProductFactSheetConfigurationPanel.this.border) / 2 + ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeAdditives.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeAdditives.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeAdditives.getY() + ProductFactSheetConfigurationPanel.this.includeAdditives.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeTraces != null) {
                ProductFactSheetConfigurationPanel.this.includeTraces.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeTraces.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeTraces.getPreferredSize().getHeight());
            }
            if (ProductFactSheetConfigurationPanel.this.includeOthers != null) {
                ProductFactSheetConfigurationPanel.this.includeOthers.setLocation((parent.getWidth() - ProductFactSheetConfigurationPanel.this.border) / 2 + ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeOthers.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeOthers.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeOthers.getY() + ProductFactSheetConfigurationPanel.this.includeOthers.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includePurchaseWaste != null) {
                ProductFactSheetConfigurationPanel.this.includePurchaseWaste.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includePurchaseWaste.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includePurchaseWaste.getPreferredSize().getHeight());
            }
            if (ProductFactSheetConfigurationPanel.this.includeCookingWaste != null) {
                ProductFactSheetConfigurationPanel.this.includeCookingWaste.setLocation((parent.getWidth() - ProductFactSheetConfigurationPanel.this.border) / 2 + ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeCookingWaste.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeCookingWaste.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeCookingWaste.getY() + ProductFactSheetConfigurationPanel.this.includeCookingWaste.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeComponentComments != null) {
                ProductFactSheetConfigurationPanel.this.includeComponentComments.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeComponentComments.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeComponentComments.getPreferredSize().getHeight());
            }
            if (ProductFactSheetConfigurationPanel.this.includeProductComments != null) {
                ProductFactSheetConfigurationPanel.this.includeProductComments.setLocation((parent.getWidth() - ProductFactSheetConfigurationPanel.this.border) / 2 + ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeProductComments.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeProductComments.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeProductComments.getY() + ProductFactSheetConfigurationPanel.this.includeProductComments.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.includeBruttoQuantity != null) {
                ProductFactSheetConfigurationPanel.this.includeBruttoQuantity.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeBruttoQuantity.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeBruttoQuantity.getPreferredSize().getHeight());
            }
            if (ProductFactSheetConfigurationPanel.this.includeImage != null) {
                ProductFactSheetConfigurationPanel.this.includeImage.setLocation((parent.getWidth() - ProductFactSheetConfigurationPanel.this.border) / 2 + ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.includeImage.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.includeImage.getPreferredSize().getHeight());
                y = ProductFactSheetConfigurationPanel.this.includeImage.getY() + ProductFactSheetConfigurationPanel.this.includeImage.getHeight();
            }
            if (ProductFactSheetConfigurationPanel.this.useExternalCosts != null) {
                ProductFactSheetConfigurationPanel.this.useExternalCosts.setLocation(ProductFactSheetConfigurationPanel.this.border, y + ProductFactSheetConfigurationPanel.this.border / 2);
                ProductFactSheetConfigurationPanel.this.useExternalCosts.setSize((parent.getWidth() - 3 * ProductFactSheetConfigurationPanel.this.border) / 2, (int)ProductFactSheetConfigurationPanel.this.useExternalCosts.getPreferredSize().getHeight());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int h = 0;
            int w = 250;
            h += ProductFactSheetConfigurationPanel.this.border;
            if (ProductFactSheetConfigurationPanel.this.dueDate != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.dueDate.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.sep1 != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.sep1.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            if (ProductFactSheetConfigurationPanel.this.printOptionTitle != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.printOptionTitle.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.includeCosts != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeCosts.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            if (ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeHandlingCostInProductGrossPrice.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            for (CostOption o : ProductFactSheetConfigurationPanel.this.optionsList) {
                h = (int)((double)h + o.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 3;
            }
            if (ProductFactSheetConfigurationPanel.this.sep2 != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.sep2.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            if (ProductFactSheetConfigurationPanel.this.extrasTitle != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.extrasTitle.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.includeAllergens != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeAllergens.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.includeTraces != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeTraces.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.includePurchaseWaste != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includePurchaseWaste.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border / 2;
            }
            if (ProductFactSheetConfigurationPanel.this.includeComponentComments != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeComponentComments.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            if (ProductFactSheetConfigurationPanel.this.includeBruttoQuantity != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.includeBruttoQuantity.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            if (ProductFactSheetConfigurationPanel.this.useExternalCosts != null) {
                h = (int)((double)h + ProductFactSheetConfigurationPanel.this.useExternalCosts.getPreferredSize().getHeight());
                h += ProductFactSheetConfigurationPanel.this.border;
            }
            return new Dimension(w, h);
        }
    }

    private class CostOption
    extends JPanelFadable
    implements Focusable,
    ButtonListener {
        private static final long serialVersionUID = 1L;
        private TitledItem<CheckBox> firstItem;
        private ArrowConnectorIcon connector;
        private TitledItem<CheckBox> secondItem;

        public CostOption(String name1, String name2, Node first, Node second, Color fG, Font cF, int innerGap) {
            this.setOpaque(false);
            this.firstItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)first), name1, TitledItem.TitledItemOrientation.EAST);
            this.firstItem.setInnerGap(innerGap);
            this.firstItem.getTitle().setFont(cF);
            this.firstItem.getTitle().setForeground(fG);
            this.firstItem.getElement().addButtonListener(this);
            if (name2 != null) {
                this.connector = new ArrowConnectorIcon();
                this.secondItem = new TitledItem<CheckBox>(new CheckBox((Node<Boolean>)second), name2, TitledItem.TitledItemOrientation.EAST);
                this.secondItem.setInnerGap(innerGap);
                this.secondItem.getTitle().setFont(cF);
                this.secondItem.getTitle().setForeground(fG);
                this.secondItem.getElement().addButtonListener(this);
            }
            this.setLayout(new InnerLayout());
            this.add(this.firstItem);
            if (name2 != null) {
                this.add(this.secondItem);
                this.add(this.connector);
            }
        }

        @Override
        public void setEnabled(boolean isEnabled) {
            super.setEnabled(isEnabled);
            this.firstItem.setEnabled(isEnabled);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(isEnabled);
            }
        }

        protected void checkIt() {
            this.firstItem.getElement().setChecked(true);
            if (this.secondItem != null) {
                this.secondItem.setEnabled(true);
            }
        }

        protected void uncheckIt() {
            this.firstItem.getElement().setChecked(false);
            if (this.secondItem != null) {
                this.secondItem.getElement().setChecked(false);
                this.secondItem.setEnabled(false);
            }
        }

        protected boolean isChecked() {
            return this.firstItem.getElement().isChecked();
        }

        protected boolean isDetailsChecked() {
            if (this.secondItem != null) {
                return this.secondItem.getElement().isChecked();
            }
            return false;
        }

        @Override
        public void kill() {
            if (this.isKilled()) {
                return;
            }
            super.kill();
            this.firstItem.kill();
            this.firstItem = null;
            if (this.connector != null) {
                this.connector.kill();
            }
            this.connector = null;
            if (this.secondItem != null) {
                this.secondItem.kill();
            }
            this.secondItem = null;
        }

        @Override
        public List<Component> getFocusComponents() {
            ArrayList<Component> a = new ArrayList<Component>();
            CheckedListAdder.addToList(a, this.firstItem);
            CheckedListAdder.addToList(a, this.secondItem);
            return a;
        }

        @Override
        public Selectable getSelectDelegationComponent() {
            return null;
        }

        @Override
        public void setVisibleContainer(VisibleContainer pane) {
        }

        @Override
        public void buttonPressed(Button source, int x, int y) {
            ProductFactSheetConfigurationPanel.this.component.setEnabled(ProductFactSheetConfigurationPanel.this.component.isEnabled());
            if (source == this.firstItem.getElement()) {
                this.validateSecond();
            } else if (source == this.secondItem.getElement() && this.secondItem.getElement().isChecked()) {
                this.firstItem.getElement().setChecked(true);
            }
        }

        @Override
        public void requestFocusInWindowNow() {
            this.firstItem.requestFocusInWindowNow();
        }

        public void setFirstCheck(boolean checked) {
            this.firstItem.getElement().setChecked(checked);
            this.validateSecond();
        }

        private void validateSecond() {
            if (this.secondItem != null) {
                this.secondItem.setEnabled(this.firstItem.getElement().isChecked());
            }
        }

        private class InnerLayout
        extends DefaultLayout {
            private InnerLayout() {
            }

            @Override
            public void layoutContainer(Container parent) {
                int innerGap = AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_details_inner_horizontal_border"));
                CostOption.this.firstItem.setLocation(0, (int)(((double)parent.getHeight() - CostOption.this.firstItem.getPreferredSize().getHeight()) / 2.0));
                CostOption.this.firstItem.setSize(CostOption.this.firstItem.getPreferredSize());
                int cx = (parent.getWidth() - ArrowConnectorIcon.getPreferredWidth()) / 2;
                if (CostOption.this.connector != null) {
                    CostOption.this.connector.setLocation(cx, (int)(((double)parent.getHeight() - CostOption.this.connector.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.connector.setSize(CostOption.this.connector.getPreferredSize());
                    CostOption.this.secondItem.setLocation(CostOption.this.connector.getX() + CostOption.this.connector.getWidth() + 20, (int)(((double)parent.getHeight() - CostOption.this.secondItem.getPreferredSize().getHeight()) / 2.0));
                    CostOption.this.secondItem.setSize(CostOption.this.secondItem.getPreferredSize());
                }
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                int h = (int)(CostOption.this.firstItem.getPreferredSize().getHeight() + 2.0);
                return new Dimension(0, h);
            }
        }
    }
}

