/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.flight.combinded;

import ch.icit.pegasus.client.gui.submodules.tool.flight.rcdrawerbased.ReturnsCountDrawerBasedSubModule;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.flight.FlightServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.ScreenValidationObject;
import ch.icit.pegasus.client.util.async.ThreadSafeExecutable;
import ch.icit.pegasus.client.util.async.ThreadSafeLoader;
import ch.icit.pegasus.client.util.exception.ClientServerCallException;
import ch.icit.pegasus.client.util.toolkits.StowingToolkit;
import ch.icit.pegasus.server.core.dtos.company.CostCenterComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightReference;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountDeliverySpaceComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountEquipmentComplete_;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountFlightComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.returnscount.ReturnsCountParameterConfig;
import ch.icit.pegasus.server.core.dtos.rightmanagement.definition.SubModuleDefinitionComplete;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.SubModuleAccessDefinition;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.FlightAccess;
import java.util.Iterator;

public class ReturnsCountAndManualSalesSubModule
extends ReturnsCountDrawerBasedSubModule {
    private static final long serialVersionUID = 1L;
    private ViewNode n;

    @Override
    public ReturnsCountDrawerBasedSubModule.EditorType isManualSales() {
        return ReturnsCountDrawerBasedSubModule.EditorType.RC_AND_MANUAL_SALES;
    }

    @Override
    public SubModuleDefinitionComplete getSubModuleDefinition() {
        return FlightAccess.getSubModuleDefinition((SubModuleAccessDefinition)FlightAccess.TOOL_RC_AND_MANUAL_SALES);
    }

    @Override
    public ReturnsCountFlightComplete updateReturnsCountFlight(ReturnsCountFlightComplete r) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).updateCountAndManualSalesItem(r, true).getValue();
    }

    @Override
    public String getScreenTitle() {
        return FlightAccess.TOOL_RC_AND_MANUAL_SALES.getDisplayName();
    }

    @Override
    public ReturnsCountFlightComplete getReturnsCountFlight(Node<CostCenterComplete> cc) throws ClientServerCallException {
        return (ReturnsCountFlightComplete)((FlightServiceManager)ServiceManagerRegistry.getService(FlightServiceManager.class)).getCountAndManualSalesItems(new FlightReference(this.getFlight().getId()), new ReturnsCountParameterConfig(cc != null ? (CostCenterComplete)cc.getValue() : null, this.getFlight().getUpliftCount())).getValue();
    }

    @Override
    public void doSaveDocument() {
        ThreadSafeExecutable run = new ThreadSafeExecutable(this){

            @Override
            public Node<?> loadData() throws Exception {
                ReturnsCountAndManualSalesSubModule.this.flightNode.commit();
                ReturnsCountFlightComplete r = (ReturnsCountFlightComplete)ReturnsCountAndManualSalesSubModule.this.flightNode.getValue();
                if (r.getEquipments().isEmpty()) {
                    ViewNode rt = new ViewNode("Error");
                    rt.setValue((Object)new ScreenValidationObject(ScreenValidationObject.ValidationStateE.FATAL, "No Equipments found in current Flight."), 0L);
                    return rt;
                }
                boolean updateSeals = false;
                switch (ReturnsCountAndManualSalesSubModule.this.getFlight().getFlightState()) {
                    case CANCELLED: 
                    case CLOSED: 
                    case DISPATCHED: {
                        updateSeals = true;
                        break;
                    }
                    case EN_ROUTE: 
                    case OPEN: 
                    case PLANNED: {
                        updateSeals = false;
                        break;
                    }
                }
                if (updateSeals) {
                    StowingToolkit.ensureSeals((ReturnsCountFlightComplete)r);
                }
                ReturnsCountAndManualSalesSubModule.this.currentFlight = ReturnsCountAndManualSalesSubModule.this.updateReturnsCountFlight(r);
                return null;
            }

            @Override
            public RemoteLoader getInvoker() {
                return ReturnsCountAndManualSalesSubModule.this;
            }

            @Override
            public long getID() {
                return 0L;
            }
        };
        ThreadSafeLoader.run(run);
    }

    @Override
    public Node createView(Node node) {
        ViewNode n = new ViewNode("");
        ViewNode all = new ViewNode("");
        n.addChild((Node)all, 0L);
        Iterator it = node.getFailSafeChildIterator();
        while (it.hasNext()) {
            Node nn = (Node)it.next();
            ViewNode n2 = new ViewNode("");
            n2.setValue(nn.getValue(), 0L);
            n.addChild((Node)n2, 0L);
            Iterator it2 = nn.getChildNamed(ReturnsCountEquipmentComplete_.deliverySpaces).getFailSafeChildIterator();
            while (it2.hasNext()) {
                Node d = (Node)it2.next();
                Iterator it3 = d.getChildNamed(ReturnsCountDeliverySpaceComplete_.products).getFailSafeChildIterator();
                while (it3.hasNext()) {
                    Node p = (Node)it3.next();
                    all.addChild(p, 0L);
                    n2.addChild(p, 0L);
                }
            }
        }
        return n;
    }
}

