/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley;

import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyBox;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyGridPanel;
import ch.icit.pegasus.client.gui.submodules.tool.galleyconfigurator.gui.galley.GalleyModel;
import ch.icit.pegasus.client.node.impls.CommitNode;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import ch.icit.pegasus.server.core.i18n.Words;

public abstract class DefaultGalleyModel
implements GalleyModel {
    protected Node theNode;
    protected GalleyGridPanel theView;
    protected boolean isInitialisation;
    private boolean needsSubgalley;
    protected boolean isKilled;

    @Override
    public int getPegasusState() {
        return 0;
    }

    @Override
    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        this.theNode = null;
        this.theView = null;
    }

    public boolean setNode(Node node) {
        if (node == this.theNode && node != null) {
            return false;
        }
        this.theView.getGrid().removeAll();
        if (this.theNode != null) {
            this.theNode.removeNodeListener((NodeListener)this);
        }
        this.theNode = node;
        if (this.theNode == null) {
            this.theView.setTitleString(Words.NO_GALLEY_SELECTED);
        } else {
            this.theView.setTitleString(this.theView.getDragController().getSelectedGalleyName() + " " + Words.CONNECTION_TOKEN + " " + this.theNode.getFormattedValue());
        }
        if (this.theNode == null) {
            return true;
        }
        this.theNode.addNodeListener((NodeListener)this);
        this.theNode.getAllChildAddEventsFor((NodeListener)this, new String[]{"Item"});
        return true;
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public Node getNode() {
        return this.theNode;
    }

    @Override
    public void setView(GalleyGridPanel panel) {
        this.theView = panel;
    }

    @Override
    public void setState(int i) {
    }

    public void childAdded(Node parent, Node child) {
        if (child instanceof CommitNode && child.getName().equals("Item")) {
            this.theView.insertBox((Node<String>)child);
        }
    }

    public void childRemoved(Node parent, Node child) {
        GalleyBox box = this.theView.getBox4Node(child.getParent().getParent());
        child.removeNodeListener((NodeListener)this);
        this.theView.getGrid().removeBox(box);
        box.fadeOut(true);
        this.theView.deactivateEditorIfDeleted(box);
    }

    public void valueChanged(Node node) {
    }

    @Override
    public boolean isInitialisation() {
        return this.isInitialisation;
    }

    @Override
    public boolean needsSubgalley() {
        return this.needsSubgalley;
    }

    @Override
    public void setNeedsSubgalley(boolean b) {
        this.needsSubgalley = b;
    }
}

