/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.product.spec.utils;

import ch.icit.pegasus.client.converter.CostCenterConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.product.details.utils.InternalExternalCateringCostTable;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.HorizontalSeparator;
import ch.icit.pegasus.client.gui.utils.ScrollableTextArea;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.TitledItem;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CheckBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBoxFactory;
import ch.icit.pegasus.client.gui.utils.image.ImageChooser;
import ch.icit.pegasus.client.gui.utils.popup.PopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.PopupAction;
import ch.icit.pegasus.client.gui.utils.priceanimation.ReloadablePriceView;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.server.core.dtos.company.InternalCostCenterComplete;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.product.ProductComplete_;
import ch.icit.pegasus.server.core.dtos.product.ProductVariantLight_;
import ch.icit.pegasus.server.core.dtos.product.SimpleProductComponentGroupComplete_;
import ch.icit.pegasus.server.core.dtos.rightmanagement.template.def.ProductAccess;
import ch.icit.pegasus.server.core.dtos.supply.CustomerLight;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.i18n.Words;
import ch.icit.pegasus.server.dtos.metamodel.DtoField;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class GroupConfigPopupInsert
extends PopUpInsert
implements ButtonListener {
    private static final long serialVersionUID = 1L;
    private TitledItem<ScrollableTextArea> comment;
    private TitledItem<CheckBox> showInCatalog;
    private HorizontalSeparator sep1;
    private TitledItem<CheckBox> useImage;
    private ImageChooser image;
    private TitledItem<CheckBox> labeled;
    private TitledItem<CheckBox> showAllergens;
    private TitledItem<ComboBox> department;
    private HorizontalSeparator sep2;
    private TextLabel cateringTitle;
    private InternalExternalCateringCostTable cateringTable;
    private TitledItem<TextField> productionGroupName;
    private boolean isClosed;
    private boolean changeShowAllergenInfoSheet;

    public GroupConfigPopupInsert(RDProvider provider, Node groupNode, Node<Boolean> node, Node<String> commentNode, Node<Boolean> useImage, Node<PegasusFileComplete> image, Node<Boolean> isLabeled, Node<Boolean> showAllergen, boolean isClosed) {
        this.isClosed = isClosed;
        SystemSettingsComplete settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        SystemViewSettingsComplete viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.changeShowAllergenInfoSheet = provider.isWritable(ProductAccess.CHANGE_SHOW_ALLERGEN_INFO_SHEET);
        this.showInCatalog = new TitledItem<CheckBox>(new CheckBox(node), Words.SHOW_IN_PRODUCT_CATALOG, TitledItem.TitledItemOrientation.EAST);
        if (Boolean.TRUE.equals(viewSettings.getShowProductComponentGroupComment())) {
            this.comment = new TitledItem<ScrollableTextArea>(new ScrollableTextArea(commentNode), Words.COMMENT, TitledItem.TitledItemOrientation.NORTH);
            this.comment.setIgnorePrefHeight(true);
        }
        this.sep1 = new HorizontalSeparator();
        this.useImage = new TitledItem<CheckBox>(new CheckBox(useImage), Words.IMAGE, TitledItem.TitledItemOrientation.EAST);
        this.image = new ImageChooser(image, !isClosed);
        this.image.enablePreviewAnyWay(true);
        this.useImage.getElement().addButtonListener(this);
        this.image.setProgress(1.0f);
        this.image.setEnabled(this.useImage.getElement().isChecked());
        this.labeled = new TitledItem<CheckBox>(new CheckBox(isLabeled), Words.LABELED, TitledItem.TitledItemOrientation.EAST);
        this.showAllergens = new TitledItem<CheckBox>(new CheckBox(showAllergen), Words.SHOW_IN_AIS, TitledItem.TitledItemOrientation.EAST);
        this.department = new TitledItem<ComboBox>(new ComboBox(groupNode.getChildNamed(SimpleProductComponentGroupComplete_.costCenter), ComboBoxFactory.filterDepartments((Node<List<InternalCostCenterComplete>>)NodeToolkit.getAffixList(InternalCostCenterComplete.class), (Node<InternalCostCenterComplete>)groupNode.getChildNamed(SimpleProductComponentGroupComplete_.costCenter), ComboBoxFactory.DepartmentType.PRODUCT_GROUP_UNIT), ConverterRegistry.getConverter(CostCenterConverter.class), true, true), Words.DEPARTMENT, TitledItem.TitledItemOrientation.NORTH);
        this.productionGroupName = new TitledItem<TextField>(new TextField(), "Production Name", TitledItem.TitledItemOrientation.NORTH);
        this.productionGroupName.getElement().setMaxChar(Integer.MAX_VALUE);
        this.productionGroupName.getElement().setNode(groupNode.getChildNamed(SimpleProductComponentGroupComplete_.productionGroupName));
        this.sep2 = new HorizontalSeparator();
        if (Boolean.TRUE.equals(viewSettings.getShowProductComponentGroupManMinutes())) {
            this.cateringTable = new InternalExternalCateringCostTable(this, null, true, null, ComboBoxFactory.DepartmentType.PRODUCT_GROUP_UNIT, true){
                private static final long serialVersionUID = 1L;

                @Override
                public void removeProcessCost(ReloadablePriceView costs) {
                }

                @Override
                public void load(boolean b) {
                }

                @Override
                public void addProcessCost(ReloadablePriceView costs) {
                }
            };
            this.cateringTable.setCustomerNode((Node<CustomerLight>)groupNode.getParent().getParent().getChildNamed(new DtoField[]{ProductVariantLight_.product, ProductComplete_.customer}));
            this.cateringTitle = new TextLabel(Words.MAN_MINUTES);
            this.cateringTable.setNode(groupNode);
        }
        this.setLayout(new Layout());
        this.setEnabled(true);
        this.add(this.showInCatalog);
        if (this.comment != null) {
            this.add(this.comment);
        }
        this.add(this.sep1);
        this.add(this.useImage);
        this.add(this.image);
        this.add(this.labeled);
        this.add(this.showAllergens);
        this.add(this.sep2);
        this.add(this.department);
        if (this.cateringTable != null) {
            this.add(this.cateringTable);
            this.add(this.cateringTitle);
        }
        this.add(this.productionGroupName);
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean imageSet = this.useImage.getElement().isChecked();
        this.department.setEnabled(isEnabled && !this.isClosed);
        this.showInCatalog.setEnabled(isEnabled && !this.isClosed);
        if (this.comment != null) {
            this.comment.setEnabled(isEnabled && !this.isClosed);
        }
        this.useImage.setEnabled(isEnabled && !this.isClosed);
        this.image.setEnabled(imageSet);
        this.labeled.setEnabled(isEnabled && !this.isClosed);
        this.showAllergens.setEnabled(isEnabled && !this.isClosed && this.changeShowAllergenInfoSheet);
        if (this.cateringTable != null) {
            this.cateringTable.setEnabled(isEnabled && !this.isClosed);
        }
        this.productionGroupName.setEnabled(isEnabled && !this.isClosed);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> focusComponents = new ArrayList<Component>();
        CheckedListAdder.addToList(focusComponents, this.comment);
        CheckedListAdder.addToList(focusComponents, this.showInCatalog);
        CheckedListAdder.addToList(focusComponents, this.labeled);
        CheckedListAdder.addToList(focusComponents, this.showAllergens);
        CheckedListAdder.addToList(focusComponents, this.useImage);
        if (this.useImage.getElement().isChecked()) {
            CheckedListAdder.addToList(focusComponents, this.image);
        }
        CheckedListAdder.addToList(focusComponents, this.productionGroupName);
        CheckedListAdder.addToList(focusComponents, this.department);
        CheckedListAdder.addToList(focusComponents, this.cateringTable);
        return focusComponents;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.comment != null) {
            this.comment.kill();
        }
        this.comment = null;
        this.showInCatalog.kill();
        this.showInCatalog = null;
        this.labeled.kill();
        this.labeled = null;
        this.department.kill();
        this.department = null;
        this.showAllergens.kill();
        this.showAllergens = null;
        this.sep1.kill();
        this.sep1 = null;
        this.useImage.kill();
        this.useImage = null;
        this.image.kill();
        this.image = null;
        this.productionGroupName.kill();
        this.productionGroupName = null;
        this.sep2.kill();
        this.sep2 = null;
        if (this.cateringTable != null) {
            this.cateringTable.kill();
            this.cateringTitle.kill();
        }
        this.cateringTable = null;
        this.cateringTitle = null;
    }

    @Override
    public Object[] getValues(PopupAction isOK) {
        if (isOK == PopupAction.CANCEL) {
            return null;
        }
        return new Object[1];
    }

    @Override
    public boolean isClosableWithEnter() {
        return false;
    }

    @Override
    public boolean isInnerComponent(Component c) {
        return this.image.isInnerComponent(c);
    }

    @Override
    public boolean tryToGrabFocus() {
        this.showInCatalog.getElement().requestFocusInWindow();
        return true;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.useImage.getElement()) {
            this.image.setEnabled(this.useImage.getElement().isChecked());
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int border = 5;
            int y = 0;
            if (GroupConfigPopupInsert.this.comment != null) {
                GroupConfigPopupInsert.this.comment.setLocation(border, border);
                GroupConfigPopupInsert.this.comment.setSize(parent.getWidth() - 2 * border, 150);
                y = GroupConfigPopupInsert.this.comment.getY() + GroupConfigPopupInsert.this.comment.getHeight();
            }
            GroupConfigPopupInsert.this.showInCatalog.setLocation(border, y + border);
            GroupConfigPopupInsert.this.showInCatalog.setSize(GroupConfigPopupInsert.this.showInCatalog.getPreferredSize());
            GroupConfigPopupInsert.this.labeled.setLocation(border, GroupConfigPopupInsert.this.showInCatalog.getY() + GroupConfigPopupInsert.this.showInCatalog.getHeight() + border);
            GroupConfigPopupInsert.this.labeled.setSize(GroupConfigPopupInsert.this.labeled.getPreferredSize());
            GroupConfigPopupInsert.this.showAllergens.setLocation(border, GroupConfigPopupInsert.this.labeled.getY() + GroupConfigPopupInsert.this.labeled.getHeight() + border);
            GroupConfigPopupInsert.this.showAllergens.setSize(GroupConfigPopupInsert.this.showAllergens.getPreferredSize());
            GroupConfigPopupInsert.this.sep1.setLocation(0, GroupConfigPopupInsert.this.showAllergens.getY() + GroupConfigPopupInsert.this.showAllergens.getHeight() + border / 2);
            GroupConfigPopupInsert.this.sep1.setSize(parent.getWidth(), (int)GroupConfigPopupInsert.this.sep1.getPreferredSize().getHeight());
            GroupConfigPopupInsert.this.useImage.setLocation(border, GroupConfigPopupInsert.this.sep1.getY() + GroupConfigPopupInsert.this.sep1.getHeight() + border);
            GroupConfigPopupInsert.this.useImage.setSize(GroupConfigPopupInsert.this.useImage.getPreferredSize());
            GroupConfigPopupInsert.this.image.setLocation(border, GroupConfigPopupInsert.this.useImage.getY() + GroupConfigPopupInsert.this.useImage.getHeight() + border);
            GroupConfigPopupInsert.this.image.setSize(GroupConfigPopupInsert.this.image.getPreferredSize());
            GroupConfigPopupInsert.this.productionGroupName.setLocation(border, GroupConfigPopupInsert.this.image.getY() + GroupConfigPopupInsert.this.image.getHeight() + border);
            GroupConfigPopupInsert.this.productionGroupName.setSize(parent.getWidth() - 2 * border, (int)GroupConfigPopupInsert.this.productionGroupName.getPreferredSize().getHeight());
            GroupConfigPopupInsert.this.department.setLocation(border, GroupConfigPopupInsert.this.productionGroupName.getY() + GroupConfigPopupInsert.this.productionGroupName.getHeight() + border);
            GroupConfigPopupInsert.this.department.setSize(parent.getWidth() - 2 * border, (int)GroupConfigPopupInsert.this.department.getPreferredSize().getHeight());
            GroupConfigPopupInsert.this.sep2.setLocation(0, GroupConfigPopupInsert.this.department.getY() + GroupConfigPopupInsert.this.department.getHeight() + border / 2);
            GroupConfigPopupInsert.this.sep2.setSize(parent.getWidth(), (int)GroupConfigPopupInsert.this.sep2.getPreferredSize().getHeight());
            if (GroupConfigPopupInsert.this.cateringTable != null) {
                GroupConfigPopupInsert.this.cateringTitle.setLocation(border, GroupConfigPopupInsert.this.sep2.getY() + GroupConfigPopupInsert.this.sep2.getHeight() + border / 2);
                GroupConfigPopupInsert.this.cateringTitle.setSize(parent.getWidth() - 2 * border, (int)GroupConfigPopupInsert.this.cateringTitle.getPreferredSize().getHeight());
                GroupConfigPopupInsert.this.cateringTable.setLocation(0, GroupConfigPopupInsert.this.cateringTitle.getY() + GroupConfigPopupInsert.this.cateringTitle.getHeight() + 2);
                GroupConfigPopupInsert.this.cateringTable.setSize(parent.getWidth(), parent.getHeight() - GroupConfigPopupInsert.this.cateringTable.getY());
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int border = 5;
            int w = (int)((double)border + GroupConfigPopupInsert.this.showInCatalog.getPreferredSize().getWidth() + (double)border);
            int h = (int)((double)border + GroupConfigPopupInsert.this.showInCatalog.getPreferredSize().getHeight());
            h = (int)((double)h + ((double)border + GroupConfigPopupInsert.this.labeled.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)border + GroupConfigPopupInsert.this.showAllergens.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)(border + 150 + border / 2 + border) + GroupConfigPopupInsert.this.useImage.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)border + GroupConfigPopupInsert.this.department.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)(border / 2 + GroupConfigPopupInsert.this.sep1.getHeight()) + GroupConfigPopupInsert.this.image.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)border + GroupConfigPopupInsert.this.productionGroupName.getPreferredSize().getHeight()));
            h = (int)((double)h + ((double)border + GroupConfigPopupInsert.this.sep2.getPreferredSize().getHeight() + 180.0 + (double)border));
            return new Dimension(w, h);
        }
    }
}

