/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.tableui;

import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.submodules.tool.purchase.receive.PurchaseReceivingScreenTableBasedSubModule;
import ch.icit.pegasus.client.gui.table2.FootablePanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.InnerPopUpListener2;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.VerticalSeparator;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.CustomsButton;
import ch.icit.pegasus.client.gui.utils.buttons.TextButton;
import ch.icit.pegasus.client.gui.utils.buttons.TransportCostsButton;
import ch.icit.pegasus.client.gui.utils.combobox.ComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox;
import ch.icit.pegasus.client.gui.utils.combobox.InputComboBox2;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.documentscan.PurchaseDocumentScanSelectionPopup;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopUp2;
import ch.icit.pegasus.client.gui.utils.popup.InnerPopupFactory;
import ch.icit.pegasus.client.gui.utils.popup.PopupType;
import ch.icit.pegasus.client.gui.utils.popup.inserts.HACCPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.popup.inserts.OPRPCheckPopUpInsert;
import ch.icit.pegasus.client.gui.utils.rightdependant.RDProvider;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Factory;
import ch.icit.pegasus.client.gui.utils.searchbox.SearchTextField2Listener;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.BackgroundFadeSkin;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.INodeCreator;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeToolkit;
import ch.icit.pegasus.client.node.impls.ViewNode;
import ch.icit.pegasus.client.services.ServiceManagerRegistry;
import ch.icit.pegasus.client.services.interfaces.system.UserServiceManager;
import ch.icit.pegasus.client.util.RemoteLoader;
import ch.icit.pegasus.client.util.exception.ClientException;
import ch.icit.pegasus.client.util.loaders.BasicArticleLoader;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.client.util.toolkits.TransactionToolkit;
import ch.icit.pegasus.client.util.toolkits.copy.CopyTemplateToolkit;
import ch.icit.pegasus.client.util.toolkits.nodebased.UnitConversionToolkitNodeBased;
import ch.icit.pegasus.server.core.dtos.ADTO;
import ch.icit.pegasus.server.core.dtos.auth.UserComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanComplete;
import ch.icit.pegasus.server.core.dtos.document.DocumentScanTypeE;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.UnitComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderComplete;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderLight;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPositionComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleComplete;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleReference;
import ch.icit.pegasus.server.core.dtos.supply.PriceComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierConditionComplete;
import ch.icit.pegasus.server.core.dtos.supply.SupplierReference;
import ch.icit.pegasus.server.core.dtos.system.SystemSettingsComplete;
import ch.icit.pegasus.server.core.dtos.system.SystemViewSettingsComplete;
import ch.icit.pegasus.server.core.dtos.utils.StoreToolkit;
import ch.icit.pegasus.server.core.dtos.utils.TransactionType;
import ch.icit.pegasus.server.core.i18n.Words;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;

public class NewArticleTableFooter
extends FootablePanel
implements ButtonListener,
SearchTextField2Listener,
RemoteLoader,
InnerPopUpListener2 {
    private static final long serialVersionUID = 1L;
    private final boolean isSolarCompany;
    private TextLabel title;
    private SearchTextField2 articleSearch;
    private InputComboBox2 amountCombo;
    private InputComboBox priceCombo;
    private ComboBox unitCombo;
    private TextButton add;
    private TextButton documentScan;
    private TextButton fillDefaults;
    private TextLabel amountText;
    private TextLabel priceText;
    private TextLabel perText;
    private TextButton attachToExistingCharge;
    private Node<PurchaseOrderLight> currentOrder;
    private TextButton selectAll;
    private BackgroundFadeSkin skin;
    private PurchaseReceivingScreenTableBasedSubModule porcm;
    private Node<PurchaseOrderPositionComplete> node;
    private VerticalSeparator sep1;
    private CustomsButton customs;
    private TransportCostsButton transportCosts;
    private RDProvider provider;
    private SystemSettingsComplete settings;
    private SystemViewSettingsComplete viewSettings;
    private UserComplete currentUser;
    private HACCPCheckPopUpInsert.ParameterObject haccpLog = new HACCPCheckPopUpInsert.ParameterObject("", "", false, null, null, false, 0.0, null, null, false, "", null, false, "");
    private OPRPCheckPopUpInsert.ParameterObject haccpLog2 = new OPRPCheckPopUpInsert.ParameterObject("", "", "", null, null, "Article Condition", -1.0, false, null, false, "", null, true, "", true, "", false, false);

    public NewArticleTableFooter(PurchaseReceivingScreenTableBasedSubModule inv, RDProvider provider, Node<PurchaseOrderLight> order) {
        this.porcm = inv;
        this.currentOrder = order;
        this.provider = provider;
        this.settings = (SystemSettingsComplete)NodeToolkit.getAffixClass(SystemSettingsComplete.class).getValue();
        this.viewSettings = (SystemViewSettingsComplete)NodeToolkit.getAffixClass(SystemViewSettingsComplete.class).getValue();
        this.currentUser = ((UserServiceManager)ServiceManagerRegistry.getService(UserServiceManager.class)).getCurrentUser();
        this.isSolarCompany = Boolean.TRUE.equals(this.settings.getCompany().getSolarCompanyType());
        this.setOpaque(false);
        this.articleSearch = SearchTextField2Factory.getBasicArticleSearchField(true, null);
        this.articleSearch.addSearchTextFieldListener(this);
        this.articleSearch.setAdditionalSearchField(((PurchaseOrderLight)this.currentOrder.getValue()).getSupplier());
        this.title = new TextLabel(Words.ADD_NEW_POINT);
        if (!this.isSolarCompany) {
            if (Boolean.TRUE.equals(this.settings.getPurchaseDocumentScanMandatory())) {
                this.documentScan = new TextButton("Document Scan");
                this.documentScan.addButtonListener(this);
            }
            if (Boolean.TRUE.equals(this.settings.getShowPurchaseFillDefaultHACCP())) {
                String text = Boolean.TRUE.equals(this.settings.getUseGateGourmetQuality()) ? "Fill OPRP Defaults" : "Fill Quality Defaults";
                this.fillDefaults = new TextButton(text);
                this.fillDefaults.addButtonListener(this);
            }
            if (Boolean.TRUE.equals(this.viewSettings.getEnablePurchaseChargeAttach())) {
                this.attachToExistingCharge = new TextButton("Attach");
                this.attachToExistingCharge.addButtonListener(this);
            }
        }
        this.skin = SkinRegistry.getSkin(BackgroundFadeSkin.class);
        this.amountText = new TextLabel("Amount:");
        this.priceText = new TextLabel("Price:");
        this.perText = new TextLabel("/");
        this.amountCombo = new InputComboBox2(null, null, InputComboBox.InputComboBoxType.PRICE_AND_UNIT_LONG);
        this.priceCombo = new InputComboBox(null, null, InputComboBox.InputComboBoxType.PRICE_DOUBLE);
        this.unitCombo = new ComboBox(null, null, ConverterRegistry.getConverter(UnitConverter.class));
        this.add = new TextButton(Words.ADD);
        this.add.addButtonListener(this);
        this.sep1 = new VerticalSeparator();
        if (!this.isSolarCompany) {
            this.customs = new CustomsButton();
            this.customs.setToolTipText(Words.CUSTOMS);
            this.customs.addButtonListener(this);
            this.transportCosts = new TransportCostsButton();
            this.transportCosts.setToolTipText(Words.TRANSPORT_COSTS);
            this.transportCosts.addButtonListener(this);
        }
        this.setLayout(new Layout());
        this.add(this.title);
        this.add(this.articleSearch);
        this.add(this.amountCombo);
        this.add(this.priceCombo);
        this.add(this.unitCombo);
        this.add(this.amountText);
        this.add(this.priceText);
        this.add(this.perText);
        if (!this.isSolarCompany) {
            if (this.documentScan != null) {
                this.add(this.documentScan);
            }
            if (this.fillDefaults != null) {
                this.add(this.fillDefaults);
            }
            this.add(this.customs);
            this.add(this.transportCosts);
        }
        this.add(this.add);
        this.add(this.sep1);
        if (this.attachToExistingCharge != null) {
            this.add(this.attachToExistingCharge);
        }
        this.init();
    }

    private void init() {
        PurchaseOrderPositionComplete a = new PurchaseOrderPositionComplete();
        a.setClientOId(Long.valueOf(ADTO.getNextId()));
        a.setQuantity(new StoreQuantityComplete());
        a.setPreparedAmount(new StoreQuantityComplete());
        a.setDeliveredAmount(new StoreQuantityComplete());
        a.setRejectedAmount(new StoreQuantityComplete());
        a.setSupplierPrice(new PriceComplete());
        this.node = INodeCreator.getDefaultImpl().getNode4DTO((Object)a, false, false);
        this.articleSearch.setNode(this.node.getChildNamed(new String[]{"article"}));
        this.amountCombo.setNode(this.node.getChildNamed(new String[]{"quantity-amount"}), this.node.getChildNamed(new String[]{"quantity-unit"}));
        this.priceCombo.setNode(this.node.getChildNamed(new String[]{"supplierPrice-price"}), this.node.getChildNamed(new String[]{"supplierPrice-currency"}));
        this.unitCombo.setNode(this.node.getChildNamed(new String[]{"priceUnit"}));
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        this.skin.paint(g2, 0, this.getHeight() - this.skin.getImage(11).getHeight(), this.getWidth(), 11);
        g2.setColor(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_textfield_selected_text_color")));
        g2.drawLine(0, 0, this.getWidth(), 0);
        this.paintChildren(g2);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.title.kill();
        this.articleSearch.kill();
        if (this.attachToExistingCharge != null) {
            this.attachToExistingCharge.kill();
        }
        this.attachToExistingCharge = null;
        this.amountCombo.kill();
        this.add.kill();
        if (this.selectAll != null) {
            this.selectAll.kill();
        }
        if (this.documentScan != null) {
            this.documentScan.kill();
        }
        this.documentScan = null;
        if (this.fillDefaults != null) {
            this.fillDefaults.kill();
        }
        this.fillDefaults = null;
        this.sep1.kill();
        if (this.customs != null) {
            this.customs.kill();
        }
        if (this.transportCosts != null) {
            this.transportCosts.kill();
        }
        this.transportCosts = null;
        this.sep1 = null;
        this.customs = null;
        this.title = null;
        this.articleSearch = null;
        this.amountCombo = null;
        this.add = null;
        this.selectAll = null;
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        boolean canAdd = this.provider.isAddable("orderPositions");
        boolean canAddDoc = this.provider.isWritable("customsDocuments");
        boolean canAddTrans = this.provider.isWritable("transportCosts");
        this.articleSearch.setEnabled(isEnabled && canAdd);
        this.amountCombo.setEnabled(this.articleSearch.isItemSelected() && isEnabled && canAdd);
        this.priceCombo.setEnabled(this.articleSearch.isItemSelected() && isEnabled && canAdd);
        this.unitCombo.setEnabled(this.articleSearch.isItemSelected() && isEnabled && canAdd);
        this.add.setEnabled(this.articleSearch.isItemSelected() && isEnabled && canAdd);
        if (this.selectAll != null) {
            this.selectAll.setEnabled(isEnabled);
        }
        this.sep1.setEnabled(isEnabled);
        if (!this.isSolarCompany) {
            this.customs.setEnabled(isEnabled && canAddDoc);
            this.transportCosts.setEnabled(isEnabled && canAddTrans);
            if (this.documentScan != null) {
                if (Boolean.TRUE.equals(this.settings.getPurchaseDocumentScanMandatory())) {
                    this.documentScan.setEnabled(isEnabled);
                } else {
                    this.documentScan.setEnabled(false);
                }
            }
            if (this.fillDefaults != null) {
                this.fillDefaults.setEnabled(isEnabled);
            }
            if (this.attachToExistingCharge != null) {
                this.attachToExistingCharge.setEnabled(isEnabled);
            }
        }
    }

    @Override
    public List<Component> getFocusComponents() {
        List<Component> a = this.articleSearch.getFocusComponents();
        if (this.articleSearch.isItemSelected()) {
            a.addAll(this.amountCombo.getFocusComponents());
            a.addAll(this.priceCombo.getFocusComponents());
            a.add(this.unitCombo);
            a.addAll(this.add.getFocusComponents());
        }
        CheckedListAdder.addToList(a, this.documentScan);
        CheckedListAdder.addToList(a, this.fillDefaults);
        CheckedListAdder.addToList(a, this.attachToExistingCharge);
        if (this.selectAll != null) {
            a.addAll(this.selectAll.getFocusComponents());
        }
        CheckedListAdder.addToList(a, this.customs);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.articleSearch.setVisibleContainer(pane);
        this.amountCombo.setVisibleContainer(pane);
        this.priceCombo.setVisibleContainer(pane);
        this.unitCombo.setVisibleContainer(pane);
        if (this.attachToExistingCharge != null) {
            this.attachToExistingCharge.setVisibleContainer(pane);
        }
        this.add.setVisibleContainer(pane);
        if (this.selectAll != null) {
            this.selectAll.setVisibleContainer(pane);
        }
        if (!this.isSolarCompany) {
            this.customs.setVisibleContainer(pane);
            this.transportCosts.setVisibleContainer(pane);
            if (this.documentScan != null) {
                this.documentScan.setVisibleContainer(pane);
            }
            if (this.fillDefaults != null) {
                this.fillDefaults.setVisibleContainer(pane);
            }
        }
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        this.articleSearch.requestFocusInWindowNow();
    }

    private void clearRow() {
        this.init();
        this.setEnabled(true);
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        if (source == this.add) {
            if (!this.validateLine()) {
                return;
            }
            Node newHint = INodeCreator.getDefaultImpl().getNode4DTO((Object)true, false, false);
            newHint.setName("justAdded");
            this.node.addChild(newHint, 0L);
            Node<PurchaseOrderLight> node4DTO = this.currentOrder;
            PurchaseOrderComplete complete = (PurchaseOrderComplete)node4DTO.getValue(PurchaseOrderComplete.class);
            SupplierConditionComplete sc = ArticleToolkit.getSupplierCondition((BasicArticleComplete)this.node.getChildNamed(new String[]{"article"}).getValue(BasicArticleComplete.class), (SupplierReference)((PurchaseOrderLight)this.currentOrder.getValue()).getSupplier(), complete.getUseTaxZone(), complete.getTaxZone(), new Timestamp(((PurchaseOrderLight)this.currentOrder.getValue()).getOrderDate().getTime()));
            sc = CopyTemplateToolkit.copySupplierCondition(sc);
            this.node.getChildNamed(new String[]{"supplierCondition"}).setValue((Object)sc, 0L);
            this.node.commit();
            this.porcm.addPosition(this.node);
            this.clearRow();
        } else if (source == this.customs) {
            InnerPopupFactory.showCustomsDocumentsEditPopup(source, this.porcm.getCustomsNode(), null, true, x, y);
        } else if (source == this.transportCosts) {
            InnerPopupFactory.showTransportCostsEditPopup(source, this.porcm.getTransportCostsNode(), null, true, x, y);
        } else if (source == this.documentScan) {
            InnerPopUp2 popUp = InnerPopUp2.getInnerPopUp();
            PurchaseDocumentScanSelectionPopup insert = new PurchaseDocumentScanSelectionPopup(DocumentScanTypeE.PURCHASE_ORDER, this.currentOrder);
            popUp.setAttributes(source, true, true, Words.DOCUMENT_SCAN);
            popUp.setView(insert);
            popUp.showPopUpWithinScreenMiddle(800, 600, (source1, xargs) -> {
                if (insert.getDocument() != null) {
                    DocumentScanComplete value = (DocumentScanComplete)insert.getDocument().getValue();
                    this.porcm.getScanNode().setValue((Object)value, 0L);
                } else {
                    this.porcm.getScanNode().setValue(null, 0L);
                }
            }, source, PopupType.NORMAL);
        } else if (source == this.fillDefaults) {
            boolean temperatureCheck = false;
            for (PurchaseOrderPositionComplete position : this.porcm.getCurrentOrder().getOrderPositions()) {
                if (!ArticleToolkit.isTemperatureCheck(position.getArticle())) continue;
                temperatureCheck = true;
            }
            InnerPopupFactory.showHACCPLog(true, this.porcm, source, null, null, null, x, y, this.haccpLog, this.haccpLog2, true, (source1, xargs) -> this.fillDefaults.setState(Button.ButtonState.UP), false, temperatureCheck);
        } else if (source == this.attachToExistingCharge) {
            this.porcm.updateAttachToExistingCharge();
        }
    }

    private boolean validateLine() {
        boolean isValid = true;
        if (TransactionToolkit.getLongValue(this.amountCombo.getValueNode()) <= 0L) {
            isValid = false;
            this.amountCombo.setInvalid();
        }
        return isValid;
    }

    @Override
    public void newValueSelected(SearchTextField2 source, Node<?> n) {
        if (n.getValue(BasicArticleLight.class) != null) {
            BasicArticleComplete artC = (BasicArticleComplete)n.getValue(BasicArticleComplete.class);
            if (artC == null) {
                new BasicArticleLoader((BasicArticleReference)n.getValue(BasicArticleLight.class), this, n, this);
            } else {
                this.remoteObjectLoaded(n);
            }
        } else {
            this.setEnabled(this.isEnabled());
        }
    }

    public void remoteObjectLoaded(Node<?> node) {
        BasicArticleComplete artC = (BasicArticleComplete)node.getValue(BasicArticleComplete.class);
        Timestamp validity = new Timestamp(this.porcm.getOrderDate().getTime());
        List possibleUnits = StoreToolkit.getPossibleUnits((BasicArticleLight)artC, null, (Timestamp)validity, (TransactionType)TransactionType.PURCHASE_RECEIVE, (UserComplete)this.currentUser, null, null, (SystemSettingsComplete)this.settings);
        ViewNode viewNode = UnitConversionToolkitNodeBased.getUnitList(possibleUnits);
        this.amountCombo.setPossibleUnits((Node)viewNode);
        if (possibleUnits.isEmpty()) {
            this.amountCombo.clearSelectedUnit();
        } else {
            this.amountCombo.getUnitNode().setValue(possibleUnits.get(0), 0L);
        }
        this.amountCombo.getValueNode().setValue((Object)0, 0L);
        this.amountCombo.setNode(this.amountCombo.getValueNode(), this.amountCombo.getUnitNode());
        this.priceCombo.getUnitNode().setValue((Object)((PurchaseOrderLight)this.currentOrder.getValue()).getSupplier().getPaymentCurrency(), 0L);
        this.priceCombo.getValueNode().setValue((Object)0.0, 0L);
        this.priceCombo.setNode(this.priceCombo.getValueNode(), this.priceCombo.getUnitNode());
        ArrayList<UnitComplete> priceUnit = new ArrayList<UnitComplete>();
        priceUnit.add(artC.getPriceUnit());
        this.unitCombo.setPossibleValues((Node)UnitConversionToolkitNodeBased.getUnitList(priceUnit));
        this.unitCombo.getNode().setValue((Object)artC.getPriceUnit(), 0L);
        Node<PurchaseOrderPositionComplete> n = this.node;
        n.getChildNamed(new String[]{"article"}).setValue((Object)artC, 0L);
        StoreQuantityComplete q = (StoreQuantityComplete)n.getChildNamed(new String[]{"deliveredAmount"}).getValue();
        q.setAmount(Long.valueOf(0L));
        q.setUnit(artC.getMainStoreUnit());
        this.amountCombo.setEnabled(true);
        this.priceCombo.setEnabled(true);
        this.unitCombo.setEnabled(true);
        this.add.setEnabled(true);
        if (this.documentScan != null) {
            if (Boolean.TRUE.equals(this.settings.getPurchaseDocumentScanMandatory())) {
                this.documentScan.setEnabled(true);
            } else {
                this.documentScan.setEnabled(false);
            }
        }
        if (this.fillDefaults != null) {
            this.fillDefaults.setEnabled(true);
        }
    }

    public void errorOccurred(ClientException exception) {
        InnerPopupFactory.showErrorDialog((Exception)((Object)exception), (Component)this);
    }

    @Override
    public void popUpClosed(InnerPopUp2 source, Object ... xargs) {
    }

    @Override
    public void setNode(Node<?> node) {
    }

    @Override
    public Node<?> getNode() {
        return null;
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(0, NewArticleTableFooter.this.skin.getImage(11).getHeight());
        }

        @Override
        public void layoutContainer(Container parent) {
            int ipw = (int)NewArticleTableFooter.this.amountCombo.getPreferredSize().getWidth();
            ipw += 85;
            ipw = (int)((double)ipw + NewArticleTableFooter.this.add.getPreferredSize().getWidth());
            ipw = (int)((double)ipw + NewArticleTableFooter.this.title.getPreferredSize().getWidth());
            ipw += 10;
            if (NewArticleTableFooter.this.customs != null) {
                ipw = (int)((double)ipw + (NewArticleTableFooter.this.customs.getPreferredSize().getWidth() + 10.0));
            }
            ipw = (int)((double)ipw + (NewArticleTableFooter.this.sep1.getPreferredSize().getWidth() + 10.0));
            ipw = parent.getWidth() - ipw;
            if ((ipw /= 2) > 200) {
                ipw = 200;
            }
            NewArticleTableFooter.this.title.setLocation(10, (int)((double)parent.getHeight() - NewArticleTableFooter.this.title.getPreferredSize().getHeight()) / 2);
            NewArticleTableFooter.this.title.setSize(NewArticleTableFooter.this.title.getPreferredSize());
            NewArticleTableFooter.this.articleSearch.setLocation(NewArticleTableFooter.this.title.getX() + NewArticleTableFooter.this.title.getWidth() + 10, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.articleSearch.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.articleSearch.setSize(ipw, (int)NewArticleTableFooter.this.articleSearch.getPreferredSize().getHeight());
            NewArticleTableFooter.this.amountText.setLocation(NewArticleTableFooter.this.articleSearch.getX() + NewArticleTableFooter.this.articleSearch.getWidth() + 30, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.amountText.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.amountText.setSize(NewArticleTableFooter.this.amountText.getPreferredSize());
            NewArticleTableFooter.this.amountCombo.setLocation(NewArticleTableFooter.this.amountText.getX() + NewArticleTableFooter.this.amountText.getWidth() + 10, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.amountCombo.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.amountCombo.setSize(NewArticleTableFooter.this.amountCombo.getPreferredSize());
            NewArticleTableFooter.this.priceText.setLocation(NewArticleTableFooter.this.amountCombo.getX() + NewArticleTableFooter.this.amountCombo.getWidth() + 30, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.priceText.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.priceText.setSize(NewArticleTableFooter.this.priceText.getPreferredSize());
            NewArticleTableFooter.this.priceCombo.setLocation(NewArticleTableFooter.this.priceText.getX() + NewArticleTableFooter.this.priceText.getWidth() + 10, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.priceCombo.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.priceCombo.setSize(120, (int)NewArticleTableFooter.this.priceCombo.getPreferredSize().getHeight());
            NewArticleTableFooter.this.perText.setLocation(NewArticleTableFooter.this.priceCombo.getX() + NewArticleTableFooter.this.priceCombo.getWidth(), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.perText.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.perText.setSize(NewArticleTableFooter.this.perText.getPreferredSize());
            NewArticleTableFooter.this.unitCombo.setLocation(NewArticleTableFooter.this.perText.getX() + NewArticleTableFooter.this.perText.getWidth() + 20, (int)(((double)parent.getHeight() - NewArticleTableFooter.this.unitCombo.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.unitCombo.setSize(85, (int)NewArticleTableFooter.this.unitCombo.getPreferredSize().getHeight());
            int sepX = parent.getWidth() - 10;
            if (!NewArticleTableFooter.this.isSolarCompany) {
                NewArticleTableFooter.this.customs.setLocation((int)((double)(parent.getWidth() - 10) - NewArticleTableFooter.this.customs.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.customs.getPreferredSize().getHeight()) / 2.0));
                NewArticleTableFooter.this.customs.setSize(NewArticleTableFooter.this.customs.getPreferredSize());
                NewArticleTableFooter.this.transportCosts.setLocation((int)((double)(NewArticleTableFooter.this.customs.getX() - 10) - NewArticleTableFooter.this.customs.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.transportCosts.getPreferredSize().getHeight()) / 2.0));
                NewArticleTableFooter.this.transportCosts.setSize(NewArticleTableFooter.this.transportCosts.getPreferredSize());
                sepX = NewArticleTableFooter.this.transportCosts.getX() - 5;
                if (NewArticleTableFooter.this.documentScan != null) {
                    NewArticleTableFooter.this.documentScan.setLocation((int)((double)(NewArticleTableFooter.this.transportCosts.getX() - 10) - NewArticleTableFooter.this.documentScan.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.documentScan.getPreferredSize().getHeight()) / 2.0));
                    NewArticleTableFooter.this.documentScan.setSize(NewArticleTableFooter.this.documentScan.getPreferredSize());
                    sepX = NewArticleTableFooter.this.documentScan.getX() - 5;
                }
                if (NewArticleTableFooter.this.fillDefaults != null) {
                    NewArticleTableFooter.this.fillDefaults.setLocation((int)((double)(sepX - 5) - NewArticleTableFooter.this.fillDefaults.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.fillDefaults.getPreferredSize().getHeight()) / 2.0));
                    NewArticleTableFooter.this.fillDefaults.setSize(NewArticleTableFooter.this.fillDefaults.getPreferredSize());
                    sepX = NewArticleTableFooter.this.fillDefaults.getX() - 5;
                }
                if (NewArticleTableFooter.this.attachToExistingCharge != null) {
                    NewArticleTableFooter.this.attachToExistingCharge.setLocation((int)((double)(sepX - 5) - NewArticleTableFooter.this.attachToExistingCharge.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.attachToExistingCharge.getPreferredSize().getHeight()) / 2.0));
                    NewArticleTableFooter.this.attachToExistingCharge.setSize(NewArticleTableFooter.this.attachToExistingCharge.getPreferredSize());
                    sepX = NewArticleTableFooter.this.attachToExistingCharge.getX() - 5;
                }
            }
            NewArticleTableFooter.this.sep1.setLocation(sepX, 1);
            NewArticleTableFooter.this.sep1.setSize((int)NewArticleTableFooter.this.sep1.getPreferredSize().getWidth(), parent.getHeight() - 2);
            NewArticleTableFooter.this.add.setLocation((int)((double)(NewArticleTableFooter.this.sep1.getX() - 10) - NewArticleTableFooter.this.add.getPreferredSize().getWidth()), (int)(((double)parent.getHeight() - NewArticleTableFooter.this.add.getPreferredSize().getHeight()) / 2.0));
            NewArticleTableFooter.this.add.setSize(NewArticleTableFooter.this.add.getPreferredSize());
        }
    }
}

