/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table;

import ch.icit.pegasus.client.converter.AllergenRelevanceArticleAllergenStateConverter;
import ch.icit.pegasus.client.converter.ArticleStdPriceConverter;
import ch.icit.pegasus.client.converter.BasicArticleUsageConverter;
import ch.icit.pegasus.client.converter.BooleanConverter;
import ch.icit.pegasus.client.converter.Converter;
import ch.icit.pegasus.client.converter.CustomsDocumentListConverter;
import ch.icit.pegasus.client.converter.DateConverter;
import ch.icit.pegasus.client.converter.FileReferenceConverter;
import ch.icit.pegasus.client.converter.FlightReturnsCountStateConverter;
import ch.icit.pegasus.client.converter.FlightStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.FlightTypeConverter;
import ch.icit.pegasus.client.converter.HandlingCostPriceConverter;
import ch.icit.pegasus.client.converter.InventoryPeriodConverter;
import ch.icit.pegasus.client.converter.InventoryProgressConverter;
import ch.icit.pegasus.client.converter.InverseBooleanConverter;
import ch.icit.pegasus.client.converter.LegInfoListConverter;
import ch.icit.pegasus.client.converter.MigrosDataTypeEConverter;
import ch.icit.pegasus.client.converter.ModificationStateEConverter;
import ch.icit.pegasus.client.converter.NutritionRelevanceArticleNutritionStateConverter;
import ch.icit.pegasus.client.converter.OrderPricingStateConverter;
import ch.icit.pegasus.client.converter.OrderReviewStateConverter;
import ch.icit.pegasus.client.converter.PaxConfigConverter;
import ch.icit.pegasus.client.converter.PreparationGroupConverter;
import ch.icit.pegasus.client.converter.PurchaseProposalStateConverter;
import ch.icit.pegasus.client.converter.RecipeStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.RecipeVariantPriceConverter;
import ch.icit.pegasus.client.converter.RetailInMotionHasTransactionsBooleanConverter;
import ch.icit.pegasus.client.converter.RetailInMotionImportStateConverter;
import ch.icit.pegasus.client.converter.RetailInMotionTransactionStateConverter;
import ch.icit.pegasus.client.converter.RetailStateEWithWarningConverter;
import ch.icit.pegasus.client.converter.SOBIrregularityConverter;
import ch.icit.pegasus.client.converter.SOBStateConverter;
import ch.icit.pegasus.client.converter.StockIrregularityConverter;
import ch.icit.pegasus.client.converter.StringConverter;
import ch.icit.pegasus.client.converter.WAGStateEConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.modules.purchaseorder.manager.utils.DeliveryDateWindowConverter;
import ch.icit.pegasus.client.gui.table.CellModel;
import ch.icit.pegasus.client.gui.table.renderer.CellViewArticleCalculationStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewArticleContractStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewBooleanRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewCabinClassRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewChangeNotificationStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewDateTimeWindowRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewDoubleViewRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewFlightTypeRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewHandlingCostTypeRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewImageChooser;
import ch.icit.pegasus.client.gui.table.renderer.CellViewInternalConsumptionStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewInventoryStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewInvoiceStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewMatDispoStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewModificationStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderPricingStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderReviewStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewOrderStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewPeriodRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewProductTypeRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewRecipeStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewRetailStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewSeasonsRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewStringRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewTimeStampRenderer;
import ch.icit.pegasus.client.gui.table.renderer.CellViewWAGStateERenderer;
import ch.icit.pegasus.client.gui.table.renderer.ComaSeparatedStringRenderer;
import ch.icit.pegasus.client.gui.table.renderer.DeliveryDateWindowRenderer;
import ch.icit.pegasus.client.gui.table.renderer.FlightSubstitutionStateRenderer;
import ch.icit.pegasus.client.gui.table.renderer.HyphenSeparatedStringRenderer;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorThreeRenderer;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorThreeRenderer2;
import ch.icit.pegasus.client.gui.table.renderer.StateIndicatorTwoRenderer;
import ch.icit.pegasus.client.gui.table.renderer.custom.CellViewReturnsCountStateERenderer;
import ch.icit.pegasus.client.gui.utils.datechooser.DateRenderer;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.util.toolkits.ArticleToolkit;
import ch.icit.pegasus.server.core.dtos.cantine.InternalConsumptionStateE;
import ch.icit.pegasus.server.core.dtos.changenotification.ChangeNotificationStateE;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightLight;
import ch.icit.pegasus.server.core.dtos.flightschedule.FlightStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.ReturnsCountStateE;
import ch.icit.pegasus.server.core.dtos.flightschedule.importer.FlightImportStateE;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostComplete;
import ch.icit.pegasus.server.core.dtos.handlingcost.HandlingCostTypeE;
import ch.icit.pegasus.server.core.dtos.invoice.InvoiceStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticleModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ArticlePriceModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.InventoryStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.ModificationStateE;
import ch.icit.pegasus.server.core.dtos.masterdata.PeriodComplete;
import ch.icit.pegasus.server.core.dtos.masterdata.SeasonComplete;
import ch.icit.pegasus.server.core.dtos.matdispo.MatDispoCalculationStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderDeliveryWindowComplete;
import ch.icit.pegasus.server.core.dtos.ordering.OrderPricingStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderReviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.OrderStateE;
import ch.icit.pegasus.server.core.dtos.ordering.PurchaseOrderPreviewStateE;
import ch.icit.pegasus.server.core.dtos.ordering.approval.PurchaseApprovalStateE;
import ch.icit.pegasus.server.core.dtos.ordering.purchaseproposal.PurchaseProposalStateE;
import ch.icit.pegasus.server.core.dtos.product.ProductType;
import ch.icit.pegasus.server.core.dtos.production_new.WeeklyPlanStateE;
import ch.icit.pegasus.server.core.dtos.quality.ccp0102.CCP0102MeasurementStateE;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeComplete;
import ch.icit.pegasus.server.core.dtos.recipe.RecipeVariantComplete;
import ch.icit.pegasus.server.core.dtos.store.StoreLight;
import ch.icit.pegasus.server.core.dtos.supply.ArticlePriceContractStateE;
import ch.icit.pegasus.server.core.dtos.supply.BasicArticleLight;
import ch.icit.pegasus.server.core.dtos.threewaymatch.TWMModificationStateE;
import ch.icit.pegasus.server.core.util.StringUtil;
import java.awt.Component;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import javax.swing.JPanel;

public class CellViewFactory {
    private static CellViewFactory f;

    public static CellViewFactory getViewFactory() {
        if (f == null) {
            f = new CellViewFactory();
        }
        return f;
    }

    private CellViewFactory() {
    }

    public JPanel getCellView(int state, Class<?> selectedClass, Object value, CellModel model, Component delegate) {
        switch (state) {
            case 4: {
                if (selectedClass.equals(StockIrregularityConverter.class)) {
                    return new CellViewBooleanRenderer((Boolean)value, true);
                }
                if (value instanceof PurchaseApprovalStateE) {
                    return new StateIndicatorThreeRenderer2<PurchaseApprovalStateE>((PurchaseApprovalStateE)value);
                }
                if (value instanceof PurchaseOrderPreviewStateE) {
                    return new StateIndicatorTwoRenderer<PurchaseOrderPreviewStateE>((PurchaseOrderPreviewStateE)value);
                }
                if (selectedClass.equals(ArticleStdPriceConverter.class)) {
                    String t = ((ArticleStdPriceConverter)ConverterRegistry.getConverter(ArticleStdPriceConverter.class)).convert((BasicArticleLight)value, null, new Object[0]);
                    return new CellViewStringRenderer(t, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass.equals(SOBStateConverter.class)) {
                    return new CellViewStringRenderer((String)value, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass.equals(FlightSubstitutionStateRenderer.class)) {
                    return new FlightSubstitutionStateRenderer((FlightLight)value);
                }
                if (selectedClass.equals(SOBIrregularityConverter.class)) {
                    FlightLight conf = (FlightLight)model.getParentModel().getNode().getValue(FlightLight.class);
                    return new CellViewBooleanRenderer(conf.getSobFIrregularity() == false, true);
                }
                if (selectedClass.equals(CustomsDocumentListConverter.class)) {
                    return new CellViewStringRenderer((String)value, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass.equals(PaxConfigConverter.class)) {
                    String t = ((PaxConfigConverter)ConverterRegistry.getConverter(PaxConfigConverter.class)).convert((FlightLight)value, null, new Object[0]);
                    return new CellViewStringRenderer(t, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass.equals(FlightStateEWithWarningConverter.class) && value instanceof FlightLight) {
                    return new CellViewFlightStateERenderer((FlightLight)value);
                }
                if (selectedClass.equals(WAGStateEConverter.class) && value instanceof FlightLight) {
                    return new CellViewWAGStateERenderer((FlightLight)value);
                }
                if (selectedClass.equals(RetailStateEWithWarningConverter.class) && value instanceof FlightLight) {
                    return new CellViewRetailStateERenderer((FlightLight)value);
                }
                if (selectedClass.equals(RecipeStateEWithWarningConverter.class) && value instanceof RecipeComplete) {
                    return new CellViewRecipeStateERenderer(((RecipeComplete)value).getCurrentVariant());
                }
                if (value instanceof ArticlePriceModificationStateE) {
                    return new CellViewArticleCalculationStateRenderer((ArticlePriceModificationStateE)value);
                }
                if (value instanceof InternalConsumptionStateE) {
                    return new CellViewInternalConsumptionStateRenderer((InternalConsumptionStateE)value);
                }
                if (selectedClass.equals(BasicArticleUsageConverter.class)) {
                    return new CellViewBooleanRenderer((Boolean)value, false);
                }
                if (selectedClass.equals(RetailInMotionImportStateConverter.class)) {
                    FlightLight f = null;
                    if (value instanceof FlightLight) {
                        f = (FlightLight)value;
                    }
                    if (f != null && Boolean.TRUE.equals(f.getHasRetailInMotionTransactions())) {
                        return new CellViewBooleanRenderer(f.getRetailInMotionImportState(), true);
                    }
                    return new CellViewStringRenderer("", false, null);
                }
                if (selectedClass.equals(RetailInMotionHasTransactionsBooleanConverter.class)) {
                    FlightLight f = null;
                    if (value instanceof FlightLight) {
                        f = (FlightLight)value;
                    }
                    if (f != null && (Boolean.TRUE.equals(f.getHasRetailInMotionTransactions()) || Boolean.TRUE.equals(f.getHasGroTransactions()))) {
                        return new CellViewBooleanRenderer(true, true);
                    }
                    return new CellViewStringRenderer("", false, null);
                }
                if (selectedClass.equals(RetailInMotionTransactionStateConverter.class)) {
                    FlightLight f = null;
                    if (value instanceof FlightLight) {
                        f = (FlightLight)value;
                    }
                    if (f != null && Boolean.TRUE.equals(f.getHasRetailInMotionTransactions())) {
                        return new CellViewBooleanRenderer(f.getRetailInMotionTransactionValidity(), true);
                    }
                    return new CellViewStringRenderer("", false, null);
                }
                if (selectedClass.equals(PreparationGroupConverter.class)) {
                    return new CellViewStringRenderer(value != null ? value.toString() : "", false, null);
                }
                if (value instanceof Boolean || selectedClass.equals(InverseBooleanConverter.class)) {
                    Boolean b = null;
                    if (value instanceof Boolean) {
                        b = (Boolean)value;
                    } else if (value instanceof String) {
                        b = Boolean.valueOf((String)value);
                    }
                    if (b == null) {
                        b = false;
                    }
                    return new CellViewBooleanRenderer(b == false, true);
                }
                if (value instanceof Boolean || selectedClass.equals(BooleanConverter.class)) {
                    Boolean b = null;
                    if (value instanceof Boolean) {
                        b = (Boolean)value;
                    } else if (value instanceof String) {
                        b = Boolean.valueOf((String)value);
                    }
                    return new CellViewBooleanRenderer(b, true);
                }
                if (selectedClass.equals(AllergenRelevanceArticleAllergenStateConverter.class)) {
                    BasicArticleLight a = (BasicArticleLight)value;
                    Boolean b = ArticleToolkit.isArticleAllergenRelevant(a) ? a.getAllergensApproved() : Boolean.valueOf(true);
                    return new CellViewBooleanRenderer(b, true);
                }
                if (selectedClass.equals(NutritionRelevanceArticleNutritionStateConverter.class)) {
                    BasicArticleLight a = (BasicArticleLight)value;
                    return new CellViewBooleanRenderer(a.getNutritionApproved(), true);
                }
                if (value instanceof RecipeVariantComplete) {
                    Converter c = ConverterRegistry.getConverter(RecipeVariantPriceConverter.class);
                    String t = (String)c.convert(value, null, new Object[0]);
                    return new CellViewStringRenderer(t, false, delegate);
                }
                if (value instanceof ArticlePriceContractStateE) {
                    return new CellViewArticleContractStateERenderer((ArticlePriceContractStateE)value);
                }
                if (value instanceof InvoiceStateE) {
                    return new CellViewInvoiceStateERenderer((InvoiceStateE)value);
                }
                if (value instanceof ChangeNotificationStateE) {
                    return new CellViewChangeNotificationStateERenderer((ChangeNotificationStateE)value);
                }
                if (value instanceof MatDispoCalculationStateE) {
                    return new CellViewMatDispoStateERenderer((MatDispoCalculationStateE)value);
                }
                if (value instanceof InventoryStateE) {
                    return new CellViewInventoryStateERenderer((InventoryStateE)value);
                }
                if (selectedClass.equals(InventoryPeriodConverter.class)) {
                    StoreLight sl = (StoreLight)model.getParentModel().getNode().getValue(StoreLight.class);
                    if (sl.getInventoryInProgress() == null) {
                        return this.getCellView(state, PeriodComplete.class, sl.getInventoryPeriod(), model, delegate);
                    }
                    Converter c = ConverterRegistry.getConverter(InventoryProgressConverter.class);
                    String t = (String)c.convert((Object)sl, null, new Object[0]);
                    c = ConverterRegistry.getConverter(StringConverter.class);
                    return this.getCellView(state, c.getClass(), t, model, delegate);
                }
                if (selectedClass.equals(DeliveryDateWindowConverter.class)) {
                    Object[] o = (Object[])value;
                    return new DeliveryDateWindowRenderer((Date)o[0], (OrderDeliveryWindowComplete)o[1]);
                }
                if (value instanceof String[]) {
                    if (selectedClass == DateConverter.class || selectedClass == LegInfoListConverter.class) {
                        return new HyphenSeparatedStringRenderer((String[])value, model.getParentModel().isHeader(), delegate);
                    }
                    return new ComaSeparatedStringRenderer((String[])value, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == OrderReviewStateConverter.class) {
                    if (value != null && !value.equals("")) {
                        if (value.equals(OrderReviewStateE.APPROVED.toString())) {
                            return new CellViewOrderReviewStateRenderer(OrderReviewStateE.APPROVED);
                        }
                        if (value.equals(OrderReviewStateE.UNCHECKED.toString())) {
                            return new CellViewOrderReviewStateRenderer(OrderReviewStateE.UNCHECKED);
                        }
                        if (value.equals(OrderReviewStateE.NOT_APPROVED.toString())) {
                            return new CellViewOrderReviewStateRenderer(OrderReviewStateE.NOT_APPROVED);
                        }
                    }
                    return new CellViewOrderReviewStateRenderer(OrderReviewStateE.UNCHECKED);
                }
                if (selectedClass == OrderPricingStateConverter.class) {
                    if (StringUtil.isNotNullAndNotEmpty((String)((String)value))) {
                        if (value.equals(OrderPricingStateE.UNCHECKED.toString())) {
                            return new CellViewOrderPricingStateRenderer(OrderPricingStateE.UNCHECKED);
                        }
                        if (value.equals(OrderPricingStateE.IN_REVIEW.toString())) {
                            return new CellViewOrderPricingStateRenderer(OrderPricingStateE.IN_REVIEW);
                        }
                        if (value.equals(OrderPricingStateE.OK_WITH_SAVE.toString())) {
                            return new CellViewOrderPricingStateRenderer(OrderPricingStateE.OK_WITH_SAVE);
                        }
                        if (value.equals(OrderPricingStateE.OK_WITH_MORE.toString())) {
                            return new CellViewOrderPricingStateRenderer(OrderPricingStateE.OK_WITH_MORE);
                        }
                    }
                    return new CellViewOrderPricingStateRenderer(OrderPricingStateE.UNCHECKED);
                }
                if (selectedClass == Double.class) {
                    Double d = 0.0;
                    if (value != null) {
                        d = (Double)value;
                    }
                    return new CellViewDoubleViewRenderer(d, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == MigrosDataTypeEConverter.class) {
                    return new CellViewStringRenderer(value != null ? value.toString() : "-", model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == PeriodComplete.class) {
                    return new CellViewPeriodRenderer((PeriodComplete)value, model, delegate);
                }
                if (selectedClass == HandlingCostPriceConverter.class) {
                    String t = ((HandlingCostPriceConverter)ConverterRegistry.getConverter(HandlingCostPriceConverter.class)).convert((HandlingCostComplete)value, null, new Object[0]);
                    return new CellViewStringRenderer(t, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == SeasonComplete.class) {
                    return new CellViewSeasonsRenderer((SeasonComplete)value, delegate);
                }
                if (value instanceof List && selectedClass == CabinClassComplete.class) {
                    return new CellViewCabinClassRenderer((List)model.getParentModel().getNode().getValueForNamed("cabinClasses"), delegate);
                }
                if (selectedClass == Node.class) {
                    String a = (String)model.getParentModel().getParentModel().getConverter().convert(null, (Node)value, new Object[0]);
                    return new CellViewStringRenderer(a, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == CabinClassComplete.class) {
                    return new CellViewCabinClassRenderer((List)model.getParentModel().getNode().getValueForNamed("cabinClasses"), delegate);
                }
                if (value instanceof OrderStateE) {
                    return new CellViewOrderStateRenderer((OrderStateE)value);
                }
                if (selectedClass == Date.class) {
                    return new DateRenderer((Date)value);
                }
                if (selectedClass == Timestamp.class) {
                    return new CellViewTimeStampRenderer((Timestamp)value, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == CellViewDateTimeWindowRenderer.class) {
                    return new CellViewDateTimeWindowRenderer((Object[])value, model.getParentModel().isHeader(), delegate);
                }
                if (selectedClass == FileReferenceConverter.class) {
                    return new CellViewImageChooser(model, model.getColumnInfo().getAttributeName());
                }
                if (value instanceof FlightImportStateE) {
                    return new StateIndicatorThreeRenderer<FlightImportStateE>((FlightImportStateE)value);
                }
                if (value instanceof CCP0102MeasurementStateE) {
                    return new StateIndicatorThreeRenderer<CCP0102MeasurementStateE>((CCP0102MeasurementStateE)value);
                }
                if (value instanceof WeeklyPlanStateE) {
                    return new StateIndicatorThreeRenderer<WeeklyPlanStateE>((WeeklyPlanStateE)value);
                }
                if (value instanceof ModificationStateE) {
                    return new CellViewModificationStateERenderer((ModificationStateE)value);
                }
                if (value instanceof ArticleModificationStateE) {
                    return new StateIndicatorThreeRenderer<ArticleModificationStateE>((ArticleModificationStateE)value);
                }
                if (value instanceof TWMModificationStateE) {
                    return new StateIndicatorThreeRenderer<TWMModificationStateE>((TWMModificationStateE)value);
                }
                if (value instanceof ProductType) {
                    return new CellViewProductTypeRenderer((ProductType)value);
                }
                if (value instanceof HandlingCostTypeE) {
                    return new CellViewHandlingCostTypeRenderer((HandlingCostTypeE)value);
                }
                if (selectedClass == FlightReturnsCountStateConverter.class && value instanceof FlightLight) {
                    FlightLight f = (FlightLight)value;
                    ReturnsCountStateE state1 = f.getReturnsCountState();
                    return new CellViewReturnsCountStateERenderer(state1, f);
                }
                if (selectedClass == FlightTypeConverter.class && value instanceof FlightLight) {
                    FlightLight flight = (FlightLight)value;
                    return new CellViewFlightTypeRenderer(flight);
                }
                if (value instanceof PurchaseProposalStateE) {
                    return new CellViewStringRenderer(((PurchaseProposalStateConverter)ConverterRegistry.getConverter(PurchaseProposalStateConverter.class)).convert((PurchaseProposalStateE)value, null, new Object[0]), model.getParentModel().isHeader(), delegate);
                }
                CellViewStringRenderer rend = null;
                rend = value instanceof String ? new CellViewStringRenderer((String)value, model.getParentModel().isHeader(), delegate) : new CellViewStringRenderer("", model.getParentModel().isHeader(), delegate);
                return rend;
            }
        }
        return null;
    }

    public String getCellString(Class<?> selectedClass, Object value) {
        if (value instanceof FlightStateE) {
            return CellViewFlightStateERenderer.getValueString((FlightStateE)value);
        }
        if (value instanceof String[]) {
            if (selectedClass == DateConverter.class || selectedClass == LegInfoListConverter.class) {
                return HyphenSeparatedStringRenderer.getValueString((String[])value);
            }
            return ComaSeparatedStringRenderer.getValueString((String[])value);
        }
        if (selectedClass == Double.class) {
            Double d = 0.0;
            if (value != null) {
                d = (Double)value;
            }
            return CellViewDoubleViewRenderer.getValueString(d);
        }
        if (selectedClass == PeriodComplete.class) {
            return CellViewPeriodRenderer.getValueString((PeriodComplete)value);
        }
        if (selectedClass == SeasonComplete.class) {
            return CellViewSeasonsRenderer.getValueString((SeasonComplete)value);
        }
        if (value instanceof List && selectedClass == CabinClassComplete.class) {
            return CellViewCabinClassRenderer.getValueString((List)value);
        }
        if (value instanceof OrderStateE) {
            return CellViewOrderStateRenderer.getValueString((OrderStateE)value);
        }
        if (selectedClass == Date.class) {
            return DateRenderer.getValueString((Date)value);
        }
        if (selectedClass == Timestamp.class) {
            return CellViewTimeStampRenderer.getValueString((Timestamp)value);
        }
        if (selectedClass == CellViewDateTimeWindowRenderer.class) {
            return CellViewDateTimeWindowRenderer.getValueString((Object[])value);
        }
        if (selectedClass == FileReferenceConverter.class) {
            return CellViewImageChooser.getValueString((PegasusFileComplete)value);
        }
        if (value instanceof ProductType) {
            return CellViewProductTypeRenderer.getStringValue((ProductType)value);
        }
        if (value instanceof HandlingCostTypeE) {
            return CellViewHandlingCostTypeRenderer.getStringValue((HandlingCostTypeE)value);
        }
        if (selectedClass == FlightReturnsCountStateConverter.class) {
            FlightLight f = (FlightLight)value;
            ReturnsCountStateE state1 = f.getReturnsCountState();
            return new CellViewReturnsCountStateERenderer(state1, f).getStringValue();
        }
        if (selectedClass == ModificationStateEConverter.class) {
            String v = ((ModificationStateEConverter)ConverterRegistry.getConverter(ModificationStateEConverter.class)).convert(value, null, new Object[0]);
            return v;
        }
        if (selectedClass == FlightTypeConverter.class) {
            FlightLight flight = (FlightLight)value;
            new CellViewFlightTypeRenderer(flight);
            return CellViewFlightTypeRenderer.getStringValue(flight);
        }
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }
}

