/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.fake;

import ch.icit.pegasus.client.gui.table.CellPanel;
import ch.icit.pegasus.client.gui.table.RowModel;
import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.table.fake.FakeSmartScreenCellPanel;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ExpandIcon;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.gui.utils.skins.BooleanStatesSkin9Field;
import ch.icit.pegasus.client.gui.utils.skins.SkinRegistry;
import ch.icit.pegasus.client.gui.utils.skins.impls.TableRowPanelSkin;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.general.IUniversal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Iterator;

public class FakeSmartScreenTableRow<T extends IUniversal>
extends JPanelKillable
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private ArrayList<FakeSmartScreenCellPanel> cells = new ArrayList();
    private ExpandIcon expandIcon;
    private ArrayList<Integer> prefWidths = new ArrayList();
    private ArrayList<TableColumnInfo> cInfos = new ArrayList();
    private int prefHeight = 0;
    private Node<T> node;
    private BooleanStatesSkin9Field skin;
    private static Color lineColor_up;
    protected static Color overlayColor;
    protected boolean isSelected;

    public FakeSmartScreenTableRow(RowModel<T> model) {
        this.lafAttributeChanged("All attribues changed");
        this.setLayout(null);
        this.prefHeight = model.getColapsedRowHeight(model.getView());
        for (int i = 0; i < model.getParentModel().getColumnCount(); ++i) {
            this.cInfos.add(model.getParentModel().getColumnInfo(i));
            this.prefWidths.add(model.getParentModel().getColumnWidth(i));
        }
        int count = 0;
        for (CellPanel p : model.getView().getCellPanels()) {
            this.addCell(count, new FakeSmartScreenCellPanel(p));
            ++count;
        }
        this.node = model.getNode();
        this.setFocusable(true);
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(TableRowPanelSkin.class);
    }

    public FakeSmartScreenTableRow() {
        this.lafAttributeChanged("All attribues changed");
        this.setLayout(null);
        this.prefHeight = 25;
        this.setFocusable(true);
        this.setOpaque(false);
        this.skin = SkinRegistry.getSkin(TableRowPanelSkin.class);
    }

    public void setPrefHeight(int prefHeight) {
        this.prefHeight = prefHeight;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        for (FakeSmartScreenCellPanel c : this.cells) {
            c.kill();
        }
        this.cells.clear();
        this.cells = null;
        this.skin = null;
    }

    public Node<T> getNode() {
        return this.node;
    }

    public void setNode(Node<T> node) {
        this.node = node;
    }

    public int getPreferredHeight() {
        return this.prefHeight;
    }

    public void addCell(int dx, FakeSmartScreenCellPanel cell) {
        this.cells.add(dx, cell);
        this.add(cell);
        cell.setVisible(true);
    }

    public void relayoutRow(int newWidth) {
        int tw = 0;
        int count = 0;
        for (TableColumnInfo ci : this.cInfos) {
            int o = this.prefWidths.get(count);
            tw += o;
            this.prefWidths.set(count, o);
            ++count;
        }
        int d = newWidth - tw;
        Iterator<TableColumnInfo> it = this.cInfos.iterator();
        count = 0;
        while (it.hasNext()) {
            TableColumnInfo ci = it.next();
            if (ci.getxExpand() > 0.0) {
                int addSpace = (int)((double)d * ci.getxExpand());
                int o = this.prefWidths.get(count);
                this.prefWidths.set(count, o + addSpace);
            }
            ++count;
        }
        this.layoutCells(newWidth, this.getPreferredHeight());
        this.setSize(newWidth, this.getPreferredHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        this.skin.paint((Graphics)g2, this.getWidth(), this.getPreferredHeight(), Button.ButtonState.UP, false, this.isSelected, false, false);
        g2.setColor(lineColor_up);
        int currentX = 0;
        int startY = 1;
        int endY = this.getPreferredHeight() - 2;
        for (int i = 0; i < this.prefWidths.size() - 1; ++i) {
            g2.drawLine(currentX += this.prefWidths.get(i).intValue(), startY, currentX, endY);
        }
        this.paintChildren(g2);
    }

    @Override
    public void setVisible(boolean vis) {
        for (FakeSmartScreenCellPanel aCell : this.cells) {
            aCell.setVisible(vis);
        }
        super.setVisible(vis);
    }

    private void layoutCells(int width, int height) {
        int currentX = 1;
        if (this.expandIcon != null) {
            currentX = (int)(1.0 + this.expandIcon.getPreferredSize().getWidth());
        }
        if (this.expandIcon != null) {
            this.expandIcon.setLocation(1, 1);
            this.expandIcon.setSize(this.expandIcon.getPreferredSize());
        }
        int currentWidth = 0;
        int aHBorder = 3;
        int count = 0;
        for (FakeSmartScreenCellPanel aCell : this.cells) {
            int w;
            currentWidth = w = this.prefWidths.get(count).intValue();
            if (count == 0) {
                if (this.expandIcon != null) {
                    currentWidth -= this.expandIcon.getX();
                    currentWidth -= this.expandIcon.getWidth();
                    currentX = this.expandIcon.getX() + this.expandIcon.getWidth();
                } else {
                    currentX = 0;
                }
            }
            aCell.setLocation(currentX + aHBorder, 1);
            aCell.setSize(currentWidth - 2 * aHBorder, this.getPreferredHeight() - 2);
            currentX += currentWidth;
            ++count;
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void loadImages() {
        if (lineColor_up == null) {
            lineColor_up = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_column_line_color_up"));
            overlayColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("table_row_disabled_overlay_color"));
        }
    }

    @Override
    public void clearImages() {
        lineColor_up = null;
        this.loadImages();
    }
}

