/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.attributes.AttributeListener;
import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.combobox.multiselection.MultiClassSelectionComboBox;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import ch.icit.pegasus.server.core.dtos.masterdata.CabinClassComplete;
import java.awt.Component;
import java.util.List;

public class CellViewCabinClassRenderer
extends CellRenderer
implements LafListener,
AttributeListener {
    private static final long serialVersionUID = 1L;
    private TextLabel labelText = new TextLabel();
    private List<CabinClassComplete> classes;

    public CellViewCabinClassRenderer(List<CabinClassComplete> n, Component delegate) {
        this.labelText.setDelegateComponent(delegate);
        this.classes = n;
        this.lafAttributeChanged("All attribues changed");
        this.attributeChanged("All attributes changed");
        this.createString();
        this.setOpaque(false);
        this.setLayout(null);
        this.add(this.labelText);
    }

    @Override
    public String getStringValue() {
        return this.labelText.getText();
    }

    private void createString() {
        this.labelText.setText(MultiClassSelectionComboBox.getCabinClassSelectionText(this.classes));
        this.labelText.invalidate();
    }

    public List<CabinClassComplete> getCabinClasses() {
        return this.classes;
    }

    @Override
    public void setSize(int w, int h) {
        this.labelText.setSize(w - 2 * this.labelText.getX(), (int)this.labelText.getPreferredSize().getHeight());
        super.setSize(w, h);
    }

    @Override
    public void attributeChanged(String attributeName) {
        if ("All attributes changed".equals(attributeName)) {
            this.labelText.setLocation(AttributesConverter.getInteger4String(AttributeLoader.getAttributeLoader().getAttribute("table_cell_horizontal_padding")), 3);
            this.setSize(this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.labelText.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
    }

    public static String getValueString(List<CabinClassComplete> value) {
        return MultiClassSelectionComboBox.getCabinClassSelectionText(value);
    }
}

