/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.table.renderer;

import ch.icit.pegasus.client.gui.table.CellRenderer;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.skins.Skin1Field;
import ch.icit.pegasus.client.gui.utils.skins.impls.defaults.DefaultSkins;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.client.node.impls.NodeListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

public class CellViewRowModifiedRenderer
extends CellRenderer
implements NodeListener {
    private static final long serialVersionUID = 1L;
    private Skin1Field skin = (Skin1Field)DefaultSkins.EditOrderIcon.createDynamicSkin();
    private Node<Boolean> modifiedNode;

    public CellViewRowModifiedRenderer(Node<Boolean> node) {
        this.modifiedNode = node;
        if (this.modifiedNode != null) {
            this.modifiedNode.addNodeListener((NodeListener)this);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.skin.getImage(Button.ButtonState.UP).getWidth(), this.skin.getImage(Button.ButtonState.UP).getHeight());
    }

    @Override
    public String getStringValue() {
        return CellViewRowModifiedRenderer.getValueString(this.modifiedNode);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int w = this.skin.getImage(Button.ButtonState.UP).getWidth();
        int h = this.skin.getImage(Button.ButtonState.UP).getHeight();
        boolean isSelected = false;
        if (this.modifiedNode != null && this.modifiedNode.getValue() != null) {
            isSelected = (Boolean)this.modifiedNode.getValue();
        }
        this.skin.paint(g2, (this.getWidth() - w) / 2, (this.getHeight() - h) / 2, Button.ButtonState.UP);
    }

    public static int getPreferredWidth() {
        Skin1Field skin1 = (Skin1Field)DefaultSkins.EditOrderIcon.createDynamicSkin();
        int w = skin1.getImage(Button.ButtonState.UP).getWidth();
        return w;
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.modifiedNode != null) {
            this.modifiedNode.addNodeListener((NodeListener)this);
        }
    }

    public void childAdded(Node<?> source, Node<?> child) {
    }

    public void childRemoved(Node<?> source, Node<?> child) {
    }

    public void childrenAdded(Node<?> source, Node<?> ... nodes) {
    }

    public void valueChanged(Node<?> node) {
        this.repaint(32L);
    }

    public static String getValueString(Node<Boolean> n) {
        return n != null && n.getValue() != null && (Boolean)n.getValue() != false ? "true" : "false";
    }

    public boolean isSwingOnly() {
        return true;
    }
}

