/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.ApplicationSettingsLoader;
import ch.icit.pegasus.client.gui.utils.image.converter.ImageConverter;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class GraphicsUtils {
    private static GraphicsConfiguration getConfiguration() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static BufferedImage createCompatibleImage(BufferedImage image) {
        return GraphicsUtils.createCompatibleImage(image, image.getWidth(), image.getHeight());
    }

    public static BufferedImage createCompatibleImage(BufferedImage image, int width, int height) {
        return GraphicsUtils.getConfiguration().createCompatibleImage(width, height, image.getTransparency());
    }

    public static BufferedImage createCompatibleImage(int width, int height) {
        return GraphicsUtils.getConfiguration().createCompatibleImage(width, height);
    }

    public static BufferedImage createCompatibleTranslucentImage(int width, int height) {
        return GraphicsUtils.getConfiguration().createCompatibleImage(width, height, 3);
    }

    public static BufferedImage loadCompatibleImage(URL resource) throws IOException {
        BufferedImage image = ImageIO.read(resource);
        return GraphicsUtils.toCompatibleImage(image);
    }

    public static BufferedImage toCompartibleImage(ImageIcon icon) {
        GraphicsConfiguration gc = GraphicsUtils.getConfiguration();
        BufferedImage compatibleImage = gc.createCompatibleImage(icon.getIconWidth(), icon.getIconHeight(), 3);
        Graphics g = compatibleImage.getGraphics();
        icon.paintIcon(null, g, 0, 0);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage toCompartibleImage(Image icon) {
        GraphicsConfiguration gc = GraphicsUtils.getConfiguration();
        BufferedImage compatibleImage = gc.createCompatibleImage(icon.getWidth(null), icon.getHeight(null), 3);
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(icon, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static BufferedImage scaleImage(BufferedImage source) throws ClientRemoteException {
        String type = ApplicationSettingsLoader.getLoader().getAttribute("default_image_resizer");
        ImageConverter conv = ImageConverter.getConverter(type);
        BufferedImage dest = conv.convertImage(source);
        return dest;
    }

    public static BufferedImage toCompatibleImage(BufferedImage image) {
        GraphicsConfiguration gc = GraphicsUtils.getConfiguration();
        if (image.getColorModel().equals(gc.getColorModel())) {
            return image;
        }
        BufferedImage compatibleImage = gc.createCompatibleImage(image.getWidth(), image.getHeight(), image.getTransparency());
        Graphics g = compatibleImage.getGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return compatibleImage;
    }

    public static void paintWrapedTextEmbossed(Graphics2D g2, int maxWidth, String text, int x, int y, FontMetrics fm, Font f, Color c1, Color c2) {
        g2.translate(x, y);
        int currentW = 0;
        int currentY = 0;
        String[] strings = text.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            String ct = strings[i];
            int strW = fm.stringWidth(ct);
            if (currentW + strW > maxWidth) {
                currentY += f.getSize() + 3;
                currentW = 0;
            }
            DrawToolkit.drawEmbossedString(g2, ct, currentW, currentY, c1, c2);
            currentW += fm.stringWidth(ct + " ");
        }
        g2.translate(-x, -y);
    }

    public static void paintWrapedText(Graphics2D g2, int maxWidth, String text, int x, int y, FontMetrics fm, Font f) {
        g2.translate(x, y);
        int currentW = 0;
        int currentY = 0;
        String[] strings = text.split(" ");
        for (int i = 0; i < strings.length; ++i) {
            String ct = strings[i];
            int strW = fm.stringWidth(ct);
            if (currentW + strW > maxWidth) {
                currentY += f.getSize() + 3;
                currentW = 0;
            }
            g2.drawString(ct, currentW, currentY);
            currentW += fm.stringWidth(ct + " ");
        }
        g2.translate(-x, -y);
    }
}

