/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.IPDFViewer;
import ch.icit.pegasus.client.gui.utils.Killer;
import ch.icit.pegasus.client.gui.utils.PageChooser;
import ch.icit.pegasus.client.gui.utils.ScrollPane;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.DefaultPanel;
import ch.icit.pegasus.client.laf.LafLoader;
import com.sun.pdfview.PDFFile;
import com.sun.pdfview.PDFPage;
import com.sun.pdfview.PagePanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class PDFViewerScrollable
extends DefaultPanel
implements ButtonListener,
IPDFViewer {
    private static final long serialVersionUID = 1L;
    private ScrollPane scrollPane;
    private PagePanel panel;
    private PageChooser pageChooser;
    private File originFile;
    private PDFFile currentFile;

    public PDFViewerScrollable() {
        this.setLayout(new Layout());
        this.scrollPane = new ScrollPane();
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        this.scrollPane.getHorizontalScrollBar().setBackground(this.scrollPane.getBackground());
        this.scrollPane.getVerticalScrollBar().setBackground(this.scrollPane.getBackground());
        this.panel = new PagePanel();
        this.pageChooser = new PageChooser(this);
        this.setInnerBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("innerpopup_extension_background")));
        this.scrollPane.setViewportView((Component)this.panel);
        this.add(this.scrollPane);
        this.add(this.pageChooser);
    }

    public void setInnerBackground(Color c) {
        this.panel.setBackground(c);
    }

    public void showPDF(File file) throws IOException {
        if (file == null) {
            this.showPDF(null, null);
        } else {
            byte[] bytes = FileUtils.readFileToByteArray((File)file);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.showPDF(file, new PDFFile(buffer));
        }
    }

    public void showPDF(File originFile, PDFFile file) {
        this.originFile = originFile;
        this.currentFile = file;
        this.pageChooser.setPDF(this.currentFile);
        if (this.currentFile != null) {
            PDFPage page = this.currentFile.getPage(1);
            this.panel.setPreferredSize(new Dimension((int)page.getWidth(), (int)page.getHeight()));
            this.panel.showPage(page);
            this.pageChooser.setSelectedPage(1);
        } else {
            this.panel.setPreferredSize(new Dimension(0, 0));
            this.panel.showPage(null);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.panel.setEnabled(isEnabled);
        this.pageChooser.setEnabled(isEnabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.remove((Component)this.panel);
        this.panel = null;
        Killer.kill(this.pageChooser);
        this.pageChooser = null;
        this.scrollPane.kill();
        this.scrollPane = null;
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        CheckedListAdder.addToList(a, this.pageChooser);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
        this.pageChooser.setVisibleContainer(pane);
    }

    @Override
    public void requestFocusInWindowNow() {
        this.pageChooser.requestFocusInWindowNow();
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
    }

    @Override
    public void pageChange(int pageNo) {
        PDFPage page = this.currentFile.getPage(pageNo);
        this.panel.showPage(page);
        this.pageChooser.setSelectedPage(pageNo);
        this.revalidate();
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(150, 200);
        }

        @Override
        public void layoutContainer(Container parent) {
            PDFViewerScrollable.this.scrollPane.setLocation(0, 0);
            PDFViewerScrollable.this.scrollPane.setSize(parent.getWidth(), (int)((double)parent.getHeight() - (PDFViewerScrollable.this.pageChooser.getPreferredSize().getHeight() + 5.0)));
            PDFViewerScrollable.this.pageChooser.setLocation((int)(((double)parent.getWidth() - PDFViewerScrollable.this.pageChooser.getPreferredSize().getWidth()) / 2.0), PDFViewerScrollable.this.scrollPane.getHeight() + 5);
            PDFViewerScrollable.this.pageChooser.setSize(parent.getWidth(), (int)PDFViewerScrollable.this.pageChooser.getPreferredSize().getHeight());
        }
    }
}

