/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils;

import ch.icit.pegasus.client.gui.table.TableColumnInfo;
import ch.icit.pegasus.client.gui.utils.TableLayoutConstraint;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;

public class TableLayouter
implements LayoutManager2 {
    private ArrayList<ArrayList<Component>> comps = new ArrayList();
    private int horizontalGap = 5;
    private int titleHeight;
    private boolean isSmooth = false;
    private boolean smoothRequest = false;
    private int rowHeight;
    private ArrayList<TableColumnInfo> columns;
    private Comparator rowComparator;
    public static final int ALIGMENT_CENTER = 3;
    public static final int ALIGMENT_LEFT = 5;
    private int aligment = 3;

    public TableLayouter(int titleHeight, int rowHeight, ArrayList<TableColumnInfo> columns, int alignmet, int horizontalGap) {
        this.titleHeight = titleHeight;
        this.rowHeight = rowHeight;
        this.columns = columns;
        this.aligment = alignmet;
        this.horizontalGap = horizontalGap;
    }

    public TableLayouter(int titleHeight, int rowHeight, ArrayList<TableColumnInfo> columns, int alignmet) {
        this(titleHeight, rowHeight, columns, alignmet, 5);
    }

    public TableLayouter(int titleHeight, int rowHeight, ArrayList<TableColumnInfo> columns) {
        this(titleHeight, rowHeight, columns, 3);
    }

    public ArrayList<ArrayList<Component>> getTableComponents() {
        return this.comps;
    }

    public void setComparator(Comparator comp) {
        this.rowComparator = comp;
    }

    public int getRowCount() {
        int maxRow = 0;
        for (ArrayList<Component> col : this.comps) {
            int row = 0;
            for (Component c1 : col) {
                ++row;
            }
            if (row <= maxRow) continue;
            maxRow = row;
        }
        return maxRow;
    }

    public void setTitleHeight(int titleHeight) {
        this.titleHeight = titleHeight;
    }

    public void setRowHeight(int rowHeight) {
        this.rowHeight = rowHeight;
    }

    protected int getColumnAdd(int width, int colNr) {
        int w = 0;
        for (TableColumnInfo i : this.columns) {
            w += i.getPreferredWidth();
        }
        int d = width - w;
        TableColumnInfo col = this.columns.get(colNr);
        if (col.getxExpand() == -1.0) {
            return d / this.columns.size();
        }
        return (int)((double)d * col.getxExpand());
    }

    public int getColumnWidth(int index, int w) {
        int add = this.getColumnAdd(w, index);
        int totalWidth = this.columns.get(index).getPreferredWidth() + add;
        return totalWidth;
    }

    public Point getRowIndex(Component com) {
        int colNr = 1;
        for (ArrayList<Component> col : this.comps) {
            int row = 1;
            for (Component c1 : col) {
                if (c1 == com) {
                    return new Point(row, colNr);
                }
                ++row;
            }
            ++colNr;
        }
        return null;
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        TableLayoutConstraint cons = (TableLayoutConstraint)constraints;
        while (cons.getColumn() >= this.comps.size()) {
            this.comps.add(new ArrayList());
        }
        ArrayList<Component> col = this.comps.get(cons.getColumn());
        int count = 0;
        while (cons.getRow() >= col.size()) {
            ++count;
            col.add(new DummyElement());
        }
        if (col.get(cons.getRow()) != null && !(col.get(cons.getRow()) instanceof DummyElement)) {
            this.addLayoutComponent(col.get(cons.getRow()), new TableLayoutConstraint(cons.getColumn(), cons.getRow() + 1));
        }
        col.set(cons.getRow(), comp);
        if (this.rowComparator != null) {
            // empty if block
        }
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return null;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    public int getFadeOutComponentsHeight() {
        int fadeOutHeight = 0;
        if (this.comps.size() == 0) {
            return 0;
        }
        ArrayList<Component> col = this.comps.get(0);
        boolean isFadeOut = false;
        for (Component com : col) {
            if (!(com instanceof Fadable) || isFadeOut || !((Fadable)((Object)com)).isAnimating(AlphaFader.FadeType.FadeOut)) continue;
            isFadeOut = true;
            ++fadeOutHeight;
        }
        return fadeOutHeight *= this.rowHeight;
    }

    @Override
    public void layoutContainer(Container parent) {
        int w = parent.getWidth();
        int currentY = this.titleHeight;
        int currentX = 0;
        int colNr = 0;
        for (ArrayList<Component> col : this.comps) {
            int add = this.getColumnAdd(w, colNr);
            for (Component com : col) {
                int totalWidth = this.columns.get(colNr).getPreferredWidth() + add;
                int cW = (int)com.getPreferredSize().getWidth();
                if (cW == 0) {
                    cW = this.columns.get(colNr).getPreferredWidth() + add - 2 * this.horizontalGap;
                }
                if (this.aligment == 3) {
                    com.setLocation(currentX + (totalWidth - cW) / 2, currentY + (this.rowHeight - (int)com.getPreferredSize().getHeight()) / 2);
                } else if (this.aligment == 5) {
                    if (cW > totalWidth - 2 * this.horizontalGap) {
                        cW = totalWidth - 2 * this.horizontalGap;
                    }
                    com.setLocation(currentX + this.horizontalGap, currentY + (this.rowHeight - (int)com.getPreferredSize().getHeight()) / 2);
                }
                com.setSize(cW, (int)com.getPreferredSize().getHeight());
                currentY += this.rowHeight;
            }
            currentY = this.titleHeight;
            currentX += this.columns.get(colNr).getPreferredWidth() + add;
            ++colNr;
        }
        if (this.smoothRequest != this.isSmooth) {
            this.isSmooth = this.smoothRequest;
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return null;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return null;
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        for (ArrayList<Component> col : this.comps) {
            if (!col.contains(comp)) continue;
            col.remove(comp);
            return;
        }
    }

    public void setSmoothAdding(boolean b) {
        this.smoothRequest = b;
    }

    private class DummyElement
    extends Component {
        private DummyElement() {
        }
    }
}

