/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationContainer;
import ch.icit.pegasus.client.gui.utils.animators.AnimationListener;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.util.Invoker;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlphaFader<T extends Component>
implements ActionListener {
    private static final Logger logger = LoggerFactory.getLogger(AlphaFader.class);
    protected T view;
    private Component metaParent;
    private boolean needsRepaint = true;
    protected boolean isDisableWhenHidden = false;
    protected float fadeProgress = 0.0f;
    protected boolean isDestroyAfterFadeOut;
    protected boolean isFadeIn;
    protected boolean isFadeAction = false;
    protected long fadeStartTime;
    protected long animationDurationTime;
    private ArrayList<AnimationListener> listeners = new ArrayList();
    private AnimationContainer animationContainer;
    protected boolean remainsInside;
    protected boolean isKilled;
    private float maxOpacity = 1.0f;

    public AlphaFader(T comp) {
        this(comp, false);
    }

    public AlphaFader(T comp, boolean permanent) {
        this.view = comp;
        this.remainsInside = permanent;
    }

    public long getAnimationDuration() {
        return this.animationDurationTime;
    }

    public boolean isDisableWhenHidden() {
        return this.isDisableWhenHidden;
    }

    public void setDisableWhenHidden(boolean isDisableWhenHidden) {
        this.isDisableWhenHidden = isDisableWhenHidden;
    }

    public void setPermanent(boolean b) {
        this.remainsInside = b;
    }

    public void addAnimationListener(AnimationListener l) {
        this.listeners.add(l);
    }

    public void removeAnimationListener(AnimationListener l) {
        this.listeners.remove(l);
    }

    protected void fireAnimationEvent(boolean wasFadin) {
        for (AnimationListener l : (ArrayList)this.listeners.clone()) {
            l.animationFinished(wasFadin);
        }
    }

    public void setAnimationContainer(AnimationContainer cont) {
        this.animationContainer = cont;
    }

    public void setMetaParent(Component c) {
        this.metaParent = c;
    }

    public AnimationContainer getAnimationContainer() {
        return this.animationContainer;
    }

    public void fadeOut(long animationTime, boolean destroy) {
        if (AnimationProvider.isAnimationActiv) {
            this.isDestroyAfterFadeOut = destroy;
            this.animationDurationTime = animationTime == -1L ? Long.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")) : animationTime;
            this.isFadeAction = true;
            this.isFadeIn = false;
            this.fadeStartTime = System.currentTimeMillis();
            AnimationProvider.registerAnimater(this);
        } else {
            ((Component)this.view).setVisible(false);
            this.setProgress(0.0f);
            this.fireAnimationEvent(false);
            this.kill();
        }
    }

    public void fadeOut(boolean destroy) {
        this.fadeOut(-1L, destroy);
    }

    public void setNeedsRepaint(boolean needsRepaint) {
        this.needsRepaint = needsRepaint;
    }

    public void setProgress(float p) {
        this.fadeProgress = p;
    }

    public boolean isAnimating(FadeType type) {
        switch (type) {
            case Any: {
                return this.isFadeAction;
            }
            case FadeIn: {
                return this.isFadeIn & this.isFadeAction;
            }
            case FadeOut: {
                return !this.isFadeIn & this.isFadeAction;
            }
        }
        return false;
    }

    public void fadeIn(long animationTime) {
        if (AnimationProvider.isAnimationActiv) {
            this.animationDurationTime = animationTime == -1L ? Long.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")) : animationTime;
            if (this.isDisableWhenHidden && ((Component)this.view).getParent() != null) {
                ((Component)this.view).setEnabled(((Component)this.view).getParent().isEnabled());
            }
            this.isFadeAction = true;
            this.fadeProgress = 0.0f;
            if (this.view != null) {
                ((Component)this.view).setVisible(true);
                this.isFadeIn = true;
                this.fadeStartTime = System.currentTimeMillis();
                AnimationProvider.registerAnimater(this);
            }
        } else {
            if (this.isDisableWhenHidden && ((Component)this.view).getParent().isEnabled()) {
                ((Component)this.view).setEnabled(true);
            }
            ((Component)this.view).setVisible(true);
            this.setProgress(1.0f);
            this.repaintParent();
            this.fireAnimationEvent(true);
        }
    }

    public boolean isFaded() {
        return (double)this.fadeProgress != 0.0;
    }

    public void fadeIn() {
        this.fadeIn(-1L);
    }

    public float lookUpComposite(float max) {
        float aComposite = this.fadeProgress;
        Object p = this.view;
        while (((Component)p).getParent() != null) {
            if (!((p = ((Component)p).getParent()) instanceof Fadable) || !(((Fadable)p).getProgress() < aComposite)) continue;
            aComposite = ((Fadable)p).getProgress();
        }
        if (aComposite > max - 0.001f) {
            aComposite = max;
        }
        if (aComposite < 0.001f) {
            aComposite = 0.0f;
        }
        return Math.min(aComposite, this.maxOpacity);
    }

    public float lookUpComposite() {
        return this.lookUpComposite(1.0f);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isFadeAction || this.isKilled) {
            AnimationProvider.deregisterAnimater(this);
            return;
        }
        if (this.isFadeIn) {
            this.fadeProgress = (float)(System.currentTimeMillis() - this.fadeStartTime) / (float)this.animationDurationTime;
            if (this.fadeProgress >= 1.0f) {
                this.fadeProgress = 1.0f;
                AnimationProvider.deregisterAnimater(this);
                this.isFadeAction = false;
                this.fireAnimationEvent(true);
            }
            if (this.view != null && ((Component)this.view).getParent() != null) {
                ((Component)this.view).getParent().repaint(32L);
            }
        } else {
            this.fadeProgress = (float)(System.currentTimeMillis() - this.fadeStartTime) / (float)this.animationDurationTime;
            this.fadeProgress = 1.0f - this.fadeProgress;
            if (this.fadeProgress <= 0.0f) {
                this.isFadeAction = false;
                this.fadeProgress = 0.0f;
                AnimationProvider.deregisterAnimater(this);
                this.fireAnimationEvent(false);
                if (!this.remainsInside) {
                    this.kill();
                }
                if (this.view != null) {
                    ((Component)this.view).setVisible(false);
                }
            } else if (this.view != null && ((Component)this.view).getParent() != null) {
                ((Component)this.view).getParent().repaint(32L);
            }
        }
    }

    public void setFaded() {
        this.isFadeIn = true;
    }

    protected void repaintParent() {
        if (!this.needsRepaint) {
            return;
        }
        if (this.metaParent != null) {
            this.metaParent.repaint(32L);
        } else if (((Component)this.view).getParent() != null) {
            ((Component)this.view).getParent().repaint(32L);
        }
    }

    public float getProgress() {
        return Math.min(this.fadeProgress, this.maxOpacity);
    }

    public void clearListeners() {
        this.listeners.clear();
    }

    public void kill() {
        boolean unable;
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        AnimationProvider.deregisterAnimater(this);
        this.listeners.clear();
        if (this.animationContainer != null) {
            this.animationContainer.removeScheduled((Fadable)this.view);
        } else if (!this.isDestroyAfterFadeOut && !this.remainsInside) {
            unable = false;
            unable = Invoker.excecuteMethod((String)"kill", this.view);
            if (!unable) {
                logger.warn("Unable to kill view of AlphaFader " + this.view.getClass().getName());
            }
            this.view = null;
        }
        if (this.isDestroyAfterFadeOut && this.view != null) {
            this.animationContainer = null;
            unable = false;
            unable = Invoker.excecuteMethod((String)"kill", this.view);
            if (!unable) {
                logger.warn("Unable to kill view of AlphaFader " + this.view.getClass().getName());
            }
            this.view = null;
            this.metaParent = null;
        }
    }

    public void setMaxValue(float maxOpacity) {
        this.maxOpacity = maxOpacity;
    }

    public static enum FadeType {
        Any,
        FadeIn,
        FadeOut;

    }
}

