/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.animators;

import ch.icit.pegasus.client.attributes.AttributeLoader;
import ch.icit.pegasus.client.gui.utils.animators.AnimationProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JScrollBar;

public class Scroller<T extends Component, V extends JScrollBar>
implements ActionListener {
    private V scrollBar;
    private int startValue;
    private int endValue;
    protected float scrollProgress = 0.0f;
    private boolean isScrollAction = false;
    private long scrollStartTime;
    private boolean isKilled;

    public Scroller(T view, V scrollBar) {
        this.scrollBar = scrollBar;
    }

    public void scrollTo(int start, int end) {
        if (AnimationProvider.isAnimationActiv) {
            this.startValue = start;
            this.endValue = end;
            this.scrollProgress = 0.0f;
            this.scrollStartTime = System.currentTimeMillis();
            this.isScrollAction = true;
            AnimationProvider.registerAnimater(this);
        } else {
            ((JScrollBar)this.scrollBar).setValue(end);
        }
    }

    public boolean isScrollAction() {
        return this.isScrollAction;
    }

    public void setProgress(float p) {
        this.scrollProgress = p;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.scrollProgress = (float)(System.currentTimeMillis() - this.scrollStartTime) / Float.valueOf(AttributeLoader.getAttributeLoader().getAttribute("animationTime")).floatValue();
        if (this.scrollProgress >= 1.0f) {
            this.scrollProgress = 1.0f;
            AnimationProvider.deregisterAnimater(this);
            this.isScrollAction = false;
            if (this.scrollBar != null) {
                ((JScrollBar)this.scrollBar).setValue(this.endValue);
            }
        } else {
            this.scrollProgress = (float)Math.sin((double)this.scrollProgress * 1.5707963267948966);
            int diff = this.startValue - this.endValue;
            int nPos = (int)((float)this.startValue - this.scrollProgress * (float)diff);
            if (this.scrollBar != null) {
                ((JScrollBar)this.scrollBar).setValue(nPos);
            }
        }
    }

    public void kill() {
        if (this.isKilled) {
            return;
        }
        this.isKilled = true;
        this.scrollBar = null;
        AnimationProvider.deregisterAnimater(this);
    }
}

