/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.autocompletion;

import ch.icit.pegasus.client.comparators.controller.ComparatorRegistry;
import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.animators.AlphaFader;
import ch.icit.pegasus.client.gui.utils.animators.Fadable;
import ch.icit.pegasus.client.gui.utils.autocompletion.AutoCompletionContainer;
import ch.icit.pegasus.client.gui.utils.autocompletion.AutoCompletionListener;
import ch.icit.pegasus.client.gui.utils.autocompletion.utils.AutoCompletionEntry;
import ch.icit.pegasus.client.gui.utils.autocompletion.utils.ProductComparator;
import ch.icit.pegasus.client.gui.utils.combobox.CustomScrollBarUI;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelKillable;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class AutoCompletionPopUp
extends JPanelKillable
implements LafListener,
Fadable {
    private static final long serialVersionUID = 1L;
    private Container containingContainer;
    private JScrollPane scrollPane;
    private Color selectionBackgroundColor;
    private JPanel viewPort;
    private AWTEventListener mouseListener;
    private Comparator<AutoCompletionEntry> comparator;
    private int maxHeight = 150;
    private boolean isShown;
    private AlphaFader<AutoCompletionPopUp> fader;
    private ArrayList<AutoCompletionEntry> shown_entries = new ArrayList();
    private ArrayList<AutoCompletionEntry> all_entries = new ArrayList();
    private int entryHborder = 5;
    private int entryVborder = 5;
    private AutoCompletionEntry selectedEntry;
    private ArrayList<AutoCompletionListener> listeners = new ArrayList();
    private String filterText = "";
    private boolean isScheduleKill;
    private int preferredWidth;
    private Object invoker;

    public AutoCompletionPopUp(boolean isStrict) {
        this.setLayout(new PanelLayout());
        this.comparator = ComparatorRegistry.getComparator(ProductComparator.class);
        this.fader = new AlphaFader<AutoCompletionPopUp>(this);
        this.scrollPane = new JScrollPane();
        this.scrollPane.getVerticalScrollBar().setUI(new CustomScrollBarUI(1));
        this.scrollPane.getHorizontalScrollBar().setUI(new CustomScrollBarUI(0));
        this.scrollPane.setBorder(BorderFactory.createEmptyBorder());
        this.viewPort = new JPanel(){

            @Override
            public void paint(Graphics g) {
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintChildren(g2);
            }
        };
        this.lafAttributeChanged("All attribues changed");
        this.viewPort.setLayout(new EntriesLayout());
        this.scrollPane.setViewportView(this.viewPort);
        this.add(this.scrollPane);
    }

    @Override
    public void setSize(int w, int h) {
        super.setSize(w, h);
        this.validateTree();
    }

    public boolean isShown() {
        return this.isShown;
    }

    public void setShown(boolean isShown) {
        this.isShown = isShown;
    }

    public void selectUpper() {
        if (this.selectedEntry != null) {
            int i = this.shown_entries.indexOf(this.selectedEntry);
            if (--i < 0) {
                AutoCompletionEntry c = this.shown_entries.get(this.shown_entries.size() - 1);
                this.selectEntry(c);
            } else {
                AutoCompletionEntry c = this.shown_entries.get(i);
                this.selectEntry(c);
            }
        } else {
            AutoCompletionEntry c = this.shown_entries.get(this.shown_entries.size() - 1);
            this.selectEntry(c);
        }
        this.scrollSelectedIntoViewableSpace();
    }

    public void selectLower() {
        if (this.selectedEntry != null) {
            int i = this.shown_entries.indexOf(this.selectedEntry);
            if (++i > this.shown_entries.size() - 1) {
                i = 0;
            }
            AutoCompletionEntry c = this.shown_entries.get(i);
            this.selectEntry(c);
        } else {
            AutoCompletionEntry c = this.shown_entries.get(0);
            this.selectEntry(c);
        }
        this.scrollSelectedIntoViewableSpace();
    }

    private void scrollSelectedIntoViewableSpace() {
        if (this.selectedEntry != null) {
            this.scrollPane.getVerticalScrollBar().scrollRectToVisible(this.selectedEntry.getBounds());
            int cy = this.selectedEntry.getY();
            if ((double)(cy + this.selectedEntry.getHeight()) > (double)this.scrollPane.getVerticalScrollBar().getValue() + this.scrollPane.getViewport().getVisibleRect().getHeight()) {
                int c = (int)((double)this.scrollPane.getVerticalScrollBar().getValue() + this.scrollPane.getViewport().getVisibleRect().getHeight());
                int d = (cy += this.selectedEntry.getHeight()) - c;
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() + d);
            } else if (cy < this.scrollPane.getVerticalScrollBar().getValue()) {
                int d = this.scrollPane.getVerticalScrollBar().getValue() - cy;
                this.scrollPane.getVerticalScrollBar().setValue(this.scrollPane.getVerticalScrollBar().getValue() - d);
            }
        }
    }

    public boolean setFilterText(String text) {
        this.filterText = text;
        return this.validateCompletionList();
    }

    private boolean validateCompletionList() {
        for (AutoCompletionEntry entry : this.all_entries) {
            if (entry.getText() == null) continue;
            if (entry.getText().toLowerCase().contains(this.filterText.toLowerCase())) {
                if (this.shown_entries.contains(entry)) continue;
                this.viewPort.add(entry);
                this.shown_entries.add(entry);
                continue;
            }
            if (!this.shown_entries.contains(entry)) continue;
            this.viewPort.remove(entry);
            this.shown_entries.remove(entry);
        }
        this.viewPort.revalidate();
        this.viewPort.repaint(32L);
        if (this.shown_entries.size() > 0) {
            Collections.sort(this.shown_entries, this.comparator);
            return true;
        }
        return false;
    }

    public void selectCurrentEntry() {
        if (this.selectedEntry != null) {
            this.manualyChoosenEntry(this.selectedEntry);
        }
    }

    public void setPreferredWidth(int w) {
        this.preferredWidth = w;
    }

    public void manualyChoosenEntry(AutoCompletionEntry entry) {
        if (this.selectedEntry != entry) {
            this.selectEntry(entry);
        }
        this.fireSelectionEvent();
        this.fadeOut(false);
    }

    public void selectEntry(AutoCompletionEntry entry) {
        if (this.selectedEntry == entry) {
            return;
        }
        if (this.selectedEntry != null) {
            this.selectedEntry.setSelected(false);
        }
        this.selectedEntry = entry;
        if (this.selectedEntry != null) {
            this.selectedEntry.setSelected(true);
        }
    }

    private void registerAWTListeners() {
        this.mouseListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                MouseEvent e = (MouseEvent)event;
                if (e.getComponent() != null) {
                    Component o;
                    boolean isInside = false;
                    if (o == AutoCompletionPopUp.this) {
                        isInside = true;
                    } else {
                        for (o = e.getComponent(); o != null && o != AutoCompletionPopUp.this; o = o.getParent()) {
                        }
                        if (o == AutoCompletionPopUp.this) {
                            isInside = true;
                        }
                    }
                    if (!isInside && e.getID() == 501) {
                        AutoCompletionPopUp.this.manualyChoosenEntry(null);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mouseListener, 16L);
    }

    public void cancel() {
        this.manualyChoosenEntry(null);
    }

    private void deregisterMouseEvent() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mouseListener);
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(this.getBackground());
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        g2.setColor(this.getForeground());
        g2.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintChildren(g2);
    }

    public void setCompletionEntrys(ArrayList<String> values) {
        for (AutoCompletionEntry c : this.all_entries) {
            this.viewPort.remove(c);
            this.shown_entries.remove(c);
        }
        this.all_entries.clear();
        for (String t : values) {
            AutoCompletionEntry c = new AutoCompletionEntry(t, this);
            c.setFont(this.getFont());
            c.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
            this.all_entries.add(c);
        }
        this.validateCompletionList();
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.containingContainer != null) {
            this.containingContainer.remove(this);
            this.containingContainer.repaint(32L);
            this.containingContainer = null;
        }
        this.listeners.clear();
    }

    public void addAutoCompletionListener(AutoCompletionListener l) {
        this.listeners.add(l);
    }

    public void removeAutoCompletionListener(AutoCompletionListener l) {
        this.listeners.remove(l);
    }

    private void fireSelectionEvent() {
        if (this.selectedEntry != null) {
            String t = null;
            if (this.selectedEntry != null) {
                t = this.selectedEntry.getText();
            }
            for (AutoCompletionListener l : this.listeners) {
                l.selectedText(t, this, this.invoker);
            }
        }
        if (this.isScheduleKill) {
            this.kill();
        }
    }

    public void show(Component comp, Object invoker) {
        Container p;
        this.invoker = invoker;
        int cX = 0;
        int cY = 0;
        for (p = (Container)comp; p != null && !(p instanceof AutoCompletionContainer); p = p.getParent()) {
            if (p instanceof AutoCompletionPopUp) continue;
            cX += p.getX();
            cY += p.getY();
        }
        if (p == null) {
            return;
        }
        this.isShown = true;
        cY = p.getHeight() > cY + this.maxHeight ? (cY += comp.getHeight() + 1) : (cY -= this.maxHeight + 1);
        this.registerAWTListeners();
        this.fader.setProgress(0.0f);
        this.setLocation(cX, cY);
        this.setSize(this.preferredWidth, this.maxHeight);
        this.setVisible(true);
        this.containingContainer = p;
        p.add((Component)this, 0);
        this.fadeIn();
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.scrollPane.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.viewPort.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.scrollPane.getHorizontalScrollBar().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.scrollPane.getVerticalScrollBar().setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.setBackground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_background_color")));
        this.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_line_color")));
        this.setFont(AttributesConverter.getFont4String(LafLoader.getLafLoader().getAttribute("default_font"), LafLoader.getLafLoader().getAttribute("default_font_size"), LafLoader.getLafLoader().getAttribute("default_font_type")));
        for (AutoCompletionEntry entry : this.shown_entries) {
            entry.setFont(this.getFont());
            entry.setForeground(AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_foreground_color")));
        }
        this.selectionBackgroundColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("default_main_selection_color"));
    }

    public void killScheduled() {
        this.isScheduleKill = true;
    }

    @Override
    public void fadeIn() {
        this.fader.fadeIn();
    }

    @Override
    public void fadeIn(long animationTime) {
        this.fader.fadeIn(animationTime);
    }

    @Override
    public void fadeOut(boolean destroy, long animationTime) {
        this.fader.fadeOut(animationTime, destroy);
    }

    @Override
    public void fadeOut(boolean destroy) {
        this.isShown = false;
        this.fader.fadeOut(destroy);
        this.deregisterMouseEvent();
    }

    public AlphaFader<AutoCompletionPopUp> getFader() {
        return this.fader;
    }

    public String getSelectedEntry() {
        if (this.selectedEntry != null) {
            return this.selectedEntry.getText();
        }
        return "";
    }

    @Override
    public float getProgress() {
        return this.fader.getProgress();
    }

    @Override
    public boolean isAnimating(AlphaFader.FadeType fadeIn) {
        return this.fader.isAnimating(fadeIn);
    }

    @Override
    public void setProgress(float progress) {
        this.fader.setProgress(progress);
    }

    public Color getSelectionColor() {
        return this.selectionBackgroundColor;
    }

    public int getEntryHBorder() {
        return this.entryHborder;
    }

    public int getEntryVBorder() {
        return this.entryVborder;
    }

    public AutoCompletionEntry getSelected() {
        return this.selectedEntry;
    }

    private class EntriesLayout
    extends DefaultLayout {
        private EntriesLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int currentY = 0;
            int currentX = 0;
            for (AutoCompletionEntry entry : AutoCompletionPopUp.this.shown_entries) {
                entry.setLocation(currentX, currentY);
                int cw = (int)entry.getPreferredSize().getWidth();
                if (cw < w) {
                    cw = w;
                }
                entry.setSize(cw, (int)entry.getPreferredSize().getHeight());
                currentY += entry.getHeight();
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int currentY = 0;
            int maxWidth = 0;
            for (AutoCompletionEntry entry : AutoCompletionPopUp.this.shown_entries) {
                currentY = (int)((double)currentY + entry.getPreferredSize().getHeight());
                if (!((double)maxWidth < entry.getPreferredSize().getWidth())) continue;
                maxWidth = (int)entry.getPreferredSize().getWidth();
            }
            return new Dimension(maxWidth, currentY);
        }
    }

    private class PanelLayout
    extends DefaultLayout {
        private PanelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            int h = parent.getHeight();
            AutoCompletionPopUp.this.scrollPane.setLocation(1, 1);
            AutoCompletionPopUp.this.scrollPane.setSize(w - 2, h - 2);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return null;
        }
    }
}

