/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.buttons;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.util.DebugToolkit;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class IconButton
extends Button
implements ImageConsumer {
    private static final long serialVersionUID = 1L;
    private BufferedImage image_UP;
    private BufferedImage image_DOWN;
    private BufferedImage image_OVER;
    private BufferedImage image_DISABLED;
    private BufferedImage image_FOCUS;
    private BufferedImage image_ERROR;

    public IconButton(boolean focusable) {
        super(focusable);
    }

    public IconButton() {
        this(true);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        if (this.image_UP != null) {
            this.image_UP.flush();
        }
        if (this.image_DISABLED != null) {
            this.image_DISABLED.flush();
        }
        if (this.image_DOWN != null) {
            this.image_DOWN.flush();
        }
        if (this.image_FOCUS != null) {
            this.image_FOCUS.flush();
        }
        if (this.image_OVER != null) {
            this.image_OVER.flush();
        }
        if (this.image_ERROR != null) {
            this.image_ERROR.flush();
        }
        this.image_UP = null;
        this.image_DISABLED = null;
        this.image_DOWN = null;
        this.image_FOCUS = null;
        this.image_OVER = null;
        this.image_ERROR = null;
    }

    public void loadImages(String up, String down, String over, String disabled, String focus, String error) {
        this.image_UP = AttributesConverter.getBufferedImage4String(up);
        this.image_DOWN = AttributesConverter.getBufferedImage4String(down);
        this.image_OVER = AttributesConverter.getBufferedImage4String(over);
        this.image_DISABLED = disabled == null ? AttributesConverter.getBufferedImage4String(up) : AttributesConverter.getBufferedImage4String(disabled);
        this.image_FOCUS = focus != null ? AttributesConverter.getBufferedImage4String(focus) : AttributesConverter.getBufferedImage4String(up);
        if (focus == null) {
            this.setFocusable(false);
            this.removeFocusListener(this);
        }
        this.setPreferredSize(new Dimension(this.image_UP.getWidth(), this.image_UP.getHeight()));
        this.setSize(this.getPreferredSize());
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.image_UP.getWidth(), this.image_UP.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        switch (this.state) {
            case UP: {
                g2.drawImage(this.image_UP, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
                break;
            }
            case DOWN: {
                g2.drawImage(this.image_DOWN, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
                break;
            }
            case OVER: {
                g2.drawImage(this.image_OVER, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
                break;
            }
            case DISABLED: {
                g2.drawImage(this.image_DISABLED, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
                break;
            }
            case FOCUS: {
                g2.drawImage(this.image_FOCUS, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this);
                break;
            }
            case HORIZONTAL: 
            case LEFT: 
            case RIGHT: 
            case STATE_COLAPSED_OVER: 
            case STATE_COLAPSED_UP: 
            case ERROR: 
            case STATE_EXPANDED: 
            case STATE_FOCUS_LEFT: 
            case STATE_FOCUS_RIGHT: 
            case STATE_NOTSELECTED: 
            case STATE_SELECTED: 
            case STATE_WARRNING: 
            case VERTICAL: {
                DebugToolkit.unsupportedStateException(this.getClass(), this.getName(), (Object)this.state, "paint");
            }
        }
    }

    @Override
    public void loadImages() {
    }

    @Override
    public void clearImages() {
        this.loadImages();
    }
}

