/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.clipboard;

import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.utils.clipboard.TransferableAdapter;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class ClipBoardUtils {
    private static Clipboard currentClipBoard;

    public static void copyToClipboard(Object o, ClipboardOwner owner) {
        ClipBoardUtils.copyToClipboard(ClipBoardUtils.convertIntoTransferable(o), owner);
    }

    public static void copyToClipboard(Transferable o, ClipboardOwner owner) {
        ClipBoardUtils.ensureClipBoard();
        currentClipBoard.setContents(o, owner);
    }

    public static Transferable readClipboard() {
        ClipBoardUtils.ensureClipBoard();
        return currentClipBoard.getContents(null);
    }

    private static void ensureClipBoard() {
        if (currentClipBoard == null) {
            currentClipBoard = new Clipboard("Catit Clipboard");
        }
    }

    public static Transferable convertIntoTransferable(Object o) {
        return new TransferableAdapter(o);
    }

    public static BufferedImage readImageFromSystemClipboard() {
        Transferable t = Toolkit.getDefaultToolkit().getSystemClipboard().getContents(null);
        try {
            if (t != null && t.isDataFlavorSupported(DataFlavor.imageFlavor)) {
                Image text = (Image)t.getTransferData(DataFlavor.imageFlavor);
                BufferedImage b = GraphicsUtils.toCompartibleImage(text);
                return b;
            }
        }
        catch (UnsupportedFlavorException | IOException exception) {
            // empty catch block
        }
        return null;
    }
}

