/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.file;

import ch.icit.pegasus.client.MainFrame;
import ch.icit.pegasus.client.io.FileTransferListener;
import ch.icit.pegasus.client.io.FileTransferUtil;
import ch.icit.pegasus.server.core.dtos.file.PegasusFileComplete;
import ch.icit.pegasus.server.core.dtos.report.ReportingOutputFormatE;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class FileChooserUtil {
    public static File saveFile(PegasusFileComplete file, String ensurePostfix) throws Exception {
        File rfile = FileTransferUtil.download((PegasusFileComplete)file, (FileTransferListener[])new FileTransferListener[0]);
        return FileChooserUtil.saveFile(rfile, ensurePostfix);
    }

    public static File saveFile(File old, String ensurePostfix) throws IOException {
        FileDialog fd = new FileDialog((Frame)null, "Save File", 1);
        if (MainFrame.getDefaultPath() != null) {
            fd.setDirectory(MainFrame.getDefaultPath());
        }
        if (ensurePostfix != null) {
            fd.setFile("*." + ensurePostfix);
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        String fName = fd.getFile();
        if (ensurePostfix != null && !fName.endsWith(ensurePostfix)) {
            fName = fName + ensurePostfix;
        }
        File f = new File(fd.getDirectory() + fName);
        Files.copy(old.toPath(), f.toPath(), StandardCopyOption.REPLACE_EXISTING);
        if (f.getParentFile() != null) {
            MainFrame.setDefaultPath(f.getParentFile().getAbsolutePath());
        }
        return f;
    }

    public static File saveFileToFolder() {
        FileDialog fd = new FileDialog((Frame)null, "Create a File", 1);
        if (MainFrame.getDefaultPath() != null) {
            fd.setDirectory(MainFrame.getDefaultPath());
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        String fName = fd.getFile();
        File f = new File(fd.getDirectory());
        if (f.getParentFile() != null) {
            MainFrame.setDefaultPath(f.getParentFile().getAbsolutePath());
        }
        return f;
    }

    public static File saveFile(String ensurePostfix) {
        File f;
        FileDialog fd = new FileDialog((Frame)null, "Create a File", 1);
        if (MainFrame.getDefaultPath() != null) {
            fd.setDirectory(MainFrame.getDefaultPath());
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        String fName = fd.getFile();
        if (ensurePostfix != null && !fName.endsWith(ensurePostfix)) {
            if (!ensurePostfix.startsWith(".") && !fName.endsWith(".")) {
                fName = fName + ".";
            }
            fName = fName + ensurePostfix;
        }
        if ((f = new File(fd.getDirectory() + fName)).getParentFile() != null) {
            MainFrame.setDefaultPath(f.getParentFile().getAbsolutePath());
        }
        return f;
    }

    public static File loadFile() {
        FileDialog fd = new FileDialog((Frame)null, "Select a File", 0);
        if (MainFrame.getDefaultPath() != null) {
            fd.setDirectory(MainFrame.getDefaultPath());
        }
        fd.setVisible(true);
        if (fd.getFile() == null) {
            return null;
        }
        File f = new File(fd.getDirectory() + fd.getFile());
        if (f.getParentFile() != null) {
            MainFrame.setDefaultPath(f.getParentFile().getAbsolutePath());
        }
        return f;
    }

    public static String ensureFilePath(String path, ReportingOutputFormatE format) {
        String p = path;
        String postFix = "";
        switch (format) {
            case CSV: {
                postFix = ".csv";
                break;
            }
            case HTML: {
                postFix = ".html";
                break;
            }
            case PDF: {
                postFix = ".pdf";
                break;
            }
            case XLS: {
                postFix = ".excel";
                break;
            }
            case XLSX: {
                postFix = ".xlsx";
            }
        }
        if (!p.endsWith(postFix)) {
            p = p + postFix;
        }
        return p;
    }
}

