/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.icons.impl;

import ch.icit.pegasus.client.gui.utils.AttributesConverter;
import ch.icit.pegasus.client.gui.utils.image.ImageConsumer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.toolkit.DrawToolkit;
import ch.icit.pegasus.client.laf.LafListener;
import ch.icit.pegasus.client.laf.LafLoader;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class TableIndentArrow
extends JPanelFadable
implements LafListener,
ImageConsumer {
    private static final long serialVersionUID = 1L;
    private static BufferedImage image_right;
    private Color indentArrowColor = AttributesConverter.getColor4String(LafLoader.getLafLoader().getAttribute("indent_arrow_color"));

    public TableIndentArrow() {
        this.lafAttributeChanged("All attribues changed");
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(image_right.getWidth(), image_right.getHeight());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        DrawToolkit.setAlphaComposite(g2, this.getFader());
        g2.setColor(this.indentArrowColor);
        g2.drawImage(image_right, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, this.getWidth() - image_right.getWidth(), this.getHeight() - image_right.getHeight()), null);
        g2.drawLine(0, this.getHeight() - image_right.getHeight() / 2 - 1, this.getWidth() - image_right.getWidth() + 1, this.getHeight() - image_right.getHeight() / 2 - 1);
        g2.drawLine(0, 1, 0, this.getHeight() - image_right.getHeight() / 2 - 1);
    }

    @Override
    public void lafAttributeChanged(String att) {
        this.loadImages();
    }

    @Override
    public void loadImages() {
        if (image_right != null) {
            return;
        }
        image_right = AttributesConverter.getBufferedImage4String(LafLoader.getLafLoader().getAttribute("arrow_5px_right_up"));
    }

    @Override
    public void clearImages() {
        image_right = null;
        this.loadImages();
    }
}

