/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.image.converter;

import ch.icit.pegasus.client.gui.utils.GraphicsUtils;
import ch.icit.pegasus.client.gui.utils.image.converter.ImageConverter;
import ch.icit.pegasus.server.core.services.exception.ClientRemoteException;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.image.BufferedImage;

public class G2ImageConverter
extends ImageConverter {
    @Override
    public BufferedImage convertImage(BufferedImage image, int w, int h) throws ClientRemoteException {
        int iw = image.getWidth();
        int ih = image.getHeight();
        double fw = (double)w / (double)iw;
        double fh = (double)h / (double)ih;
        double uf = 1.0;
        uf = fw < fh ? fw : fh;
        if (uf > 1.0) {
            uf = 1.0;
        }
        int nw = (int)((double)iw * uf);
        int nh = (int)((double)ih * uf);
        BufferedImage newImage = GraphicsUtils.createCompatibleImage(image, nw, nh);
        ResampleOp imageOp = new ResampleOp(nw, nh);
        try {
            imageOp.filter(image, newImage);
        }
        catch (Exception e) {
            throw new ClientRemoteException("Can't scale image. Please ensure to use a proper data Format.", null, new String[0]);
        }
        return newImage;
    }
}

