/*
 * Decompiled with CFR 0.152.
 */
package ch.icit.pegasus.client.gui.utils.panels;

import ch.icit.pegasus.client.converter.UnitConverter;
import ch.icit.pegasus.client.converter.controller.ConverterRegistry;
import ch.icit.pegasus.client.gui.utils.CheckedListAdder;
import ch.icit.pegasus.client.gui.utils.DefaultLayout;
import ch.icit.pegasus.client.gui.utils.QuantityRenderer;
import ch.icit.pegasus.client.gui.utils.Selectable;
import ch.icit.pegasus.client.gui.utils.TextLabel;
import ch.icit.pegasus.client.gui.utils.buttons.Button;
import ch.icit.pegasus.client.gui.utils.buttons.ButtonListener;
import ch.icit.pegasus.client.gui.utils.buttons.LockButton;
import ch.icit.pegasus.client.gui.utils.focus.Focusable;
import ch.icit.pegasus.client.gui.utils.focus.VisibleContainer;
import ch.icit.pegasus.client.gui.utils.panels.defaults.JPanelFadable;
import ch.icit.pegasus.client.gui.utils.textfield.NumberTextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextField;
import ch.icit.pegasus.client.gui.utils.textfield.TextFieldType;
import ch.icit.pegasus.client.node.impls.Node;
import ch.icit.pegasus.server.core.dtos.masterdata.StoreQuantityComplete_;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;

public class LockableQuantityEditor
extends JPanelFadable
implements ButtonListener,
Focusable {
    private static final long serialVersionUID = 1L;
    private QuantityRenderer read;
    private TextField edit;
    private TextLabel unit;
    private LockButton lock;
    private int minTextFieldWith = 0;
    private int innerGap = 5;
    private boolean isEdit = false;

    public LockableQuantityEditor(Node n) {
        this.read = new QuantityRenderer((Node<?>)n);
        this.edit = new NumberTextField(n.getChildNamed(StoreQuantityComplete_.amount), TextFieldType.INT);
        this.unit = new TextLabel(n.getChildNamed(StoreQuantityComplete_.unit), ConverterRegistry.getConverter(UnitConverter.class));
        this.lock = new LockButton();
        this.minTextFieldWith = this.getFontMetrics(this.edit.getTextField().getFont()).stringWidth("888888");
        this.read.getFader().setPermanent(true);
        this.edit.getFader().setPermanent(true);
        this.unit.getFader().setPermanent(true);
        this.edit.setProgress(0.0f);
        this.unit.setProgress(0.0f);
        this.read.setProgress(0.0f);
        this.lock.setChecked(false);
        this.lock.addButtonListener(this);
        this.setLayout(new Layout());
        this.add(this.edit);
        this.add(this.read);
        this.add(this.unit);
        this.add(this.lock);
    }

    private void switchState(boolean edit) {
        if (this.isEdit != edit) {
            if (edit) {
                this.edit.fadeIn();
                this.unit.fadeIn();
                this.read.fadeOut(false);
            } else {
                this.edit.fadeOut(false);
                this.unit.fadeOut(false);
                this.read.fadeIn();
            }
            this.isEdit = edit;
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.edit.setEnabled(enabled);
        this.unit.setEnabled(enabled);
        this.read.setEnabled(enabled);
    }

    @Override
    public void kill() {
        if (this.isKilled()) {
            return;
        }
        super.kill();
        this.read.kill();
        this.edit.kill();
        this.unit.kill();
        this.lock.kill();
        this.read = null;
        this.edit = null;
        this.unit = null;
        this.lock = null;
    }

    @Override
    public void buttonPressed(Button source, int x, int y) {
        this.switchState(!this.isEdit);
    }

    @Override
    public List<Component> getFocusComponents() {
        ArrayList<Component> a = new ArrayList<Component>();
        if (this.isEdit) {
            CheckedListAdder.addToList(a, this.edit);
        }
        CheckedListAdder.addToList(a, this.lock);
        return a;
    }

    @Override
    public void setVisibleContainer(VisibleContainer pane) {
    }

    @Override
    public Selectable getSelectDelegationComponent() {
        return null;
    }

    @Override
    public void requestFocusInWindowNow() {
        if (!this.isEdit) {
            this.lock.requestFocusInWindowNow();
        }
    }

    private class Layout
    extends DefaultLayout {
        private Layout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int w = parent.getWidth();
            w = (int)((double)w - (LockableQuantityEditor.this.lock.getPreferredSize().getWidth() + (double)LockableQuantityEditor.this.innerGap));
            LockableQuantityEditor.this.read.setLocation(0, (int)(((double)parent.getHeight() - LockableQuantityEditor.this.read.getPreferredSize().getHeight()) / 2.0));
            LockableQuantityEditor.this.read.setSize(w, (int)LockableQuantityEditor.this.read.getPreferredSize().getHeight());
            LockableQuantityEditor.this.edit.setLocation(0, 0);
            LockableQuantityEditor.this.edit.setSize(LockableQuantityEditor.this.minTextFieldWith, (int)LockableQuantityEditor.this.edit.getPreferredSize().getHeight());
            LockableQuantityEditor.this.unit.setLocation(LockableQuantityEditor.this.edit.getX() + LockableQuantityEditor.this.edit.getWidth() + LockableQuantityEditor.this.innerGap, (int)(((double)parent.getHeight() - LockableQuantityEditor.this.unit.getPreferredSize().getHeight()) / 2.0));
            LockableQuantityEditor.this.unit.setSize(LockableQuantityEditor.this.unit.getPreferredSize());
            LockableQuantityEditor.this.lock.setLocation(LockableQuantityEditor.this.unit.getX() + LockableQuantityEditor.this.unit.getWidth() + 5, (int)((double)parent.getHeight() - LockableQuantityEditor.this.lock.getPreferredSize().getHeight()) / 2);
            LockableQuantityEditor.this.lock.setSize(LockableQuantityEditor.this.lock.getPreferredSize());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int w = (int)((double)(LockableQuantityEditor.this.minTextFieldWith + LockableQuantityEditor.this.innerGap) + LockableQuantityEditor.this.unit.getPreferredSize().getWidth() + (double)LockableQuantityEditor.this.innerGap + LockableQuantityEditor.this.lock.getPreferredSize().getWidth());
            int h = (int)LockableQuantityEditor.this.edit.getPreferredSize().getHeight();
            return new Dimension(w, h);
        }
    }
}

